/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerMaster$;
import org.apache.spark.storage.BlockManagerMessages;
import org.apache.spark.storage.BlockManagerMessages$GetMemoryStatus$;
import org.apache.spark.storage.BlockManagerMessages$GetStorageStatus$;
import org.apache.spark.storage.BlockManagerMessages$StopBlockManagerMaster$;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageStatus;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b!B\u0001\u0003\u0001\u0011Q!A\u0005\"m_\u000e\\W*\u00198bO\u0016\u0014X*Y:uKJT!a\u0001\u0003\u0002\u000fM$xN]1hK*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xmE\u0002\u0001\u0017E\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007C\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0005\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\f\u0014\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0002\u0004%\tAG\u0001\u000fIJLg/\u001a:F]\u0012\u0004x.\u001b8u\u0007\u0001)\u0012a\u0007\t\u00039}i\u0011!\b\u0006\u0003=\u0011\t1A\u001d9d\u0013\t\u0001SD\u0001\bSa\u000e,e\u000e\u001a9pS:$(+\u001a4\t\u0011\t\u0002!\u00111A\u0005\u0002\r\n!\u0003\u001a:jm\u0016\u0014XI\u001c3q_&tGo\u0018\u0013fcR\u0011Ae\n\t\u0003\u0019\u0015J!AJ\u0007\u0003\tUs\u0017\u000e\u001e\u0005\bQ\u0005\n\t\u00111\u0001\u001c\u0003\rAH%\r\u0005\tU\u0001\u0011\t\u0011)Q\u00057\u0005yAM]5wKJ,e\u000e\u001a9pS:$\b\u0005\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0003\u0011\u0019wN\u001c4\u0011\u00059zS\"\u0001\u0003\n\u0005A\"!!C*qCJ\\7i\u001c8g\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0014\u0001C5t\tJLg/\u001a:\u0011\u00051!\u0014BA\u001b\u000e\u0005\u001d\u0011un\u001c7fC:DQa\u000e\u0001\u0005\u0002a\na\u0001P5oSRtD\u0003B\u001d<yu\u0002\"A\u000f\u0001\u000e\u0003\tAQ\u0001\u0007\u001cA\u0002mAQ\u0001\f\u001cA\u00025BQA\r\u001cA\u0002MBqa\u0010\u0001C\u0002\u0013\u0005\u0001)A\u0004uS6,w.\u001e;\u0016\u0003\u0005\u0003\"\u0001\b\"\n\u0005\rk\"A\u0003*qGRKW.Z8vi\"1Q\t\u0001Q\u0001\n\u0005\u000b\u0001\u0002^5nK>,H\u000f\t\u0005\u0006\u000f\u0002!\t\u0001S\u0001\u000fe\u0016lwN^3Fq\u0016\u001cW\u000f^8s)\t!\u0013\nC\u0003K\r\u0002\u00071*\u0001\u0004fq\u0016\u001c\u0017\n\u001a\t\u0003\u0019>s!\u0001D'\n\u00059k\u0011A\u0002)sK\u0012,g-\u0003\u0002Q#\n11\u000b\u001e:j]\u001eT!AT\u0007\t\u000bM\u0003A\u0011\u0001+\u0002'I,Wn\u001c<f\u000bb,7-\u001e;pe\u0006\u001b\u0018P\\2\u0015\u0005\u0011*\u0006\"\u0002&S\u0001\u0004Y\u0005\"B,\u0001\t\u0003A\u0016\u0001\u0006:fO&\u001cH/\u001a:CY>\u001c7.T1oC\u001e,'\u000f\u0006\u0003Z9z\u001b\u0007C\u0001\u001e[\u0013\tY&A\u0001\bCY>\u001c7.T1oC\u001e,'/\u00133\t\u000bu3\u0006\u0019A-\u0002\u001d\tdwnY6NC:\fw-\u001a:JI\")qL\u0016a\u0001A\u0006QQ.\u0019=NK6\u001c\u0016N_3\u0011\u00051\t\u0017B\u00012\u000e\u0005\u0011auN\\4\t\u000b\u00114\u0006\u0019A\u000e\u0002\u001bMd\u0017M^3F]\u0012\u0004x.\u001b8u\u0011\u00151\u0007\u0001\"\u0001h\u0003=)\b\u000fZ1uK\ncwnY6J]\u001a|GCB\u001aiS:\u001cX\u000fC\u0003^K\u0002\u0007\u0011\fC\u0003kK\u0002\u00071.A\u0004cY>\u001c7.\u00133\u0011\u0005ib\u0017BA7\u0003\u0005\u001d\u0011En\\2l\u0013\u0012DQa\\3A\u0002A\fAb\u001d;pe\u0006<W\rT3wK2\u0004\"AO9\n\u0005I\u0014!\u0001D*u_J\fw-\u001a'fm\u0016d\u0007\"\u0002;f\u0001\u0004\u0001\u0017aB7f[NK'0\u001a\u0005\u0006m\u0016\u0004\r\u0001Y\u0001\tI&\u001c8nU5{K\")\u0001\u0010\u0001C\u0001s\u0006aq-\u001a;M_\u000e\fG/[8ogR\u0019!0!\u0004\u0011\tm\f9!\u0017\b\u0004y\u0006\rabA?\u0002\u00025\taP\u0003\u0002\u00003\u00051AH]8pizJ\u0011AD\u0005\u0004\u0003\u000bi\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u0013\tYAA\u0002TKFT1!!\u0002\u000e\u0011\u0015Qw\u000f1\u0001l\u0011\u0019A\b\u0001\"\u0001\u0002\u0012Q!\u00111CA\r!\u0011Y\u0018Q\u0003>\n\t\u0005]\u00111\u0002\u0002\u000b\u0013:$W\r_3e'\u0016\f\b\u0002CA\u000e\u0003\u001f\u0001\r!!\b\u0002\u0011\tdwnY6JIN\u0004B\u0001DA\u0010W&\u0019\u0011\u0011E\u0007\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(\u0005A1m\u001c8uC&t7\u000fF\u00024\u0003SAaA[A\u0012\u0001\u0004Y\u0007bBA\u0017\u0001\u0011\u0005\u0011qF\u0001\tO\u0016$\b+Z3sgR\u0019!0!\r\t\ru\u000bY\u00031\u0001Z\u0011\u001d\t)\u0004\u0001C\u0001\u0003o\tacZ3u\u000bb,7-\u001e;pe\u0016sG\r]8j]R\u0014VM\u001a\u000b\u0005\u0003s\ty\u0004\u0005\u0003\r\u0003wY\u0012bAA\u001f\u001b\t1q\n\u001d;j_:Dq!!\u0011\u00024\u0001\u00071*\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012Dq!!\u0012\u0001\t\u0003\t9%A\u0006sK6|g/\u001a\"m_\u000e\\Gc\u0001\u0013\u0002J!1!.a\u0011A\u0002-Dq!!\u0014\u0001\t\u0003\ty%A\u0005sK6|g/\u001a*eIR)A%!\u0015\u0002\\!A\u00111KA&\u0001\u0004\t)&A\u0003sI\u0012LE\rE\u0002\r\u0003/J1!!\u0017\u000e\u0005\rIe\u000e\u001e\u0005\b\u0003;\nY\u00051\u00014\u0003!\u0011Gn\\2lS:<\u0007bBA1\u0001\u0011\u0005\u00111M\u0001\u000ee\u0016lwN^3TQV4g\r\\3\u0015\u000b\u0011\n)'!\u001b\t\u0011\u0005\u001d\u0014q\fa\u0001\u0003+\n\u0011b\u001d5vM\u001adW-\u00133\t\u000f\u0005u\u0013q\fa\u0001g!9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0014a\u0004:f[>4XM\u0011:pC\u0012\u001c\u0017m\u001d;\u0015\u000f\u0011\n\t(!\u001e\u0002z!9\u00111OA6\u0001\u0004\u0001\u0017a\u00032s_\u0006$7-Y:u\u0013\u0012Dq!a\u001e\u0002l\u0001\u00071'\u0001\tsK6|g/\u001a$s_6l\u0015m\u001d;fe\"9\u0011QLA6\u0001\u0004\u0019\u0004bBA?\u0001\u0011\u0005\u0011qP\u0001\u0010O\u0016$X*Z7pef\u001cF/\u0019;vgV\u0011\u0011\u0011\u0011\t\u0007\u0019\u0006\r\u0015,a\"\n\u0007\u0005\u0015\u0015KA\u0002NCB\u0004R\u0001DAEA\u0002L1!a#\u000e\u0005\u0019!V\u000f\u001d7fe!9\u0011q\u0012\u0001\u0005\u0002\u0005E\u0015\u0001E4fiN#xN]1hKN#\u0018\r^;t+\t\t\u0019\nE\u0003\r\u0003?\t)\nE\u0002;\u0003/K1!!'\u0003\u00055\u0019Fo\u001c:bO\u0016\u001cF/\u0019;vg\"9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0015AD4fi\ncwnY6Ti\u0006$Xo\u001d\u000b\u0007\u0003C\u000bI+a+\u0011\r1\u000b\u0019)WAR!\rQ\u0014QU\u0005\u0004\u0003O\u0013!a\u0003\"m_\u000e\\7\u000b^1ukNDaA[AN\u0001\u0004Y\u0007\"CAW\u00037\u0003\n\u00111\u00014\u0003%\t7o[*mCZ,7\u000fC\u0004\u00022\u0002!\t!a-\u0002'\u001d,G/T1uG\"Lgn\u001a\"m_\u000e\\\u0017\nZ:\u0015\r\u0005U\u0016qWAa!\u0011Y\u0018qA6\t\u0011\u0005e\u0016q\u0016a\u0001\u0003w\u000baAZ5mi\u0016\u0014\b#\u0002\u0007\u0002>.\u001c\u0014bAA`\u001b\tIa)\u001e8di&|g.\r\u0005\b\u0003[\u000by\u000b1\u00014\u0011\u001d\t)\r\u0001C\u0001\u0003\u000f\fq\u0002[1t\u0007\u0006\u001c\u0007.\u001a3CY>\u001c7n\u001d\u000b\u0004g\u0005%\u0007bBA!\u0003\u0007\u0004\ra\u0013\u0005\b\u0003\u001b\u0004A\u0011AAh\u0003\u0011\u0019Ho\u001c9\u0015\u0003\u0011Bq!a5\u0001\t\u0013\t).\u0001\u0003uK2dGc\u0001\u0013\u0002X\"A\u0011\u0011\\Ai\u0001\u0004\tY.A\u0004nKN\u001c\u0018mZ3\u0011\u00071\ti.C\u0002\u0002`6\u00111!\u00118z\u0011%\t\u0019\u000fAI\u0001\n\u0003\t)/\u0001\rhKR\u0014En\\2l'R\fG/^:%I\u00164\u0017-\u001e7uII*\"!a:+\u0007M\nIo\u000b\u0002\u0002lB!\u0011Q^A|\u001b\t\tyO\u0003\u0003\u0002r\u0006M\u0018!C;oG\",7m[3e\u0015\r\t)0D\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA}\u0003_\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000f!\tiP\u0001E\u0001\t\u0005}\u0018A\u0005\"m_\u000e\\W*\u00198bO\u0016\u0014X*Y:uKJ\u00042A\u000fB\u0001\r\u001d\t!\u0001#\u0001\u0005\u0005\u0007\u00192A!\u0001\f\u0011\u001d9$\u0011\u0001C\u0001\u0005\u000f!\"!a@\t\u0015\t-!\u0011\u0001b\u0001\n\u0003\u0011i!\u0001\u000bE%&3VIU0F\u001d\u0012\u0003v*\u0013(U?:\u000bU*R\u000b\u0003\u0005\u001f\u0001BA!\u0005\u0003\u001c5\u0011!1\u0003\u0006\u0005\u0005+\u00119\"\u0001\u0003mC:<'B\u0001B\r\u0003\u0011Q\u0017M^1\n\u0007A\u0013\u0019\u0002C\u0005\u0003 \t\u0005\u0001\u0015!\u0003\u0003\u0010\u0005)BIU%W\u000bJ{VI\u0014#Q\u001f&sEk\u0018(B\u001b\u0016\u0003\u0003")
public class BlockManagerMaster
implements Logging {
    private RpcEndpointRef driverEndpoint;
    private final boolean isDriver;
    private final RpcTimeout timeout;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private transient int org$apache$spark$internal$Logging$$levelFlags;

    public static String DRIVER_ENDPOINT_NAME() {
        return BlockManagerMaster$.MODULE$.DRIVER_ENDPOINT_NAME();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public int org$apache$spark$internal$Logging$$levelFlags() {
        return this.org$apache$spark$internal$Logging$$levelFlags;
    }

    @Override
    public void org$apache$spark$internal$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$internal$Logging$$levelFlags = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public final boolean isInfoEnabled() {
        return Logging$class.isInfoEnabled(this);
    }

    @Override
    public final boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public final boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public RpcEndpointRef driverEndpoint() {
        return this.driverEndpoint;
    }

    public void driverEndpoint_$eq(RpcEndpointRef x$1) {
        this.driverEndpoint = x$1;
    }

    public RpcTimeout timeout() {
        return this.timeout;
    }

    public void removeExecutor(String execId) {
        this.tell(new BlockManagerMessages.RemoveExecutor(execId));
        this.logInfo((Function0<String>)new Serializable(this, execId){
            public static final long serialVersionUID = 0L;
            private final String execId$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Removed ").append((Object)this.execId$1).append((Object)" successfully in removeExecutor").toString();
            }
            {
                this.execId$1 = execId$1;
            }
        });
    }

    public void removeExecutorAsync(String execId) {
        this.driverEndpoint().ask(new BlockManagerMessages.RemoveExecutor(execId), ClassTag$.MODULE$.Boolean());
        this.logInfo((Function0<String>)new Serializable(this, execId){
            public static final long serialVersionUID = 0L;
            private final String execId$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Removal of executor ").append((Object)this.execId$2).append((Object)" requested").toString();
            }
            {
                this.execId$2 = execId$2;
            }
        });
    }

    public BlockManagerId registerBlockManager(BlockManagerId blockManagerId, long maxMemSize, RpcEndpointRef slaveEndpoint) {
        this.logInfo((Function0<String>)new Serializable(this, blockManagerId){
            public static final long serialVersionUID = 0L;
            private final BlockManagerId blockManagerId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registering BlockManager ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockManagerId$1}));
            }
            {
                this.blockManagerId$1 = blockManagerId$1;
            }
        });
        BlockManagerId updatedId = (BlockManagerId)this.driverEndpoint().askWithRetry(new BlockManagerMessages.RegisterBlockManager(blockManagerId, maxMemSize, slaveEndpoint), ClassTag$.MODULE$.apply(BlockManagerId.class));
        this.logInfo((Function0<String>)new Serializable(this, updatedId){
            public static final long serialVersionUID = 0L;
            private final BlockManagerId updatedId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registered BlockManager ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.updatedId$1}));
            }
            {
                this.updatedId$1 = updatedId$1;
            }
        });
        return updatedId;
    }

    public boolean updateBlockInfo(BlockManagerId blockManagerId, BlockId blockId, StorageLevel storageLevel, long memSize, long diskSize) {
        boolean res = BoxesRunTime.unboxToBoolean(this.driverEndpoint().askWithRetry(new BlockManagerMessages.UpdateBlockInfo(blockManagerId, blockId, storageLevel, memSize, diskSize), ClassTag$.MODULE$.Boolean()));
        this.logDebug((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final BlockId blockId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated info of block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1}));
            }
            {
                this.blockId$1 = blockId$1;
            }
        });
        return res;
    }

    public Seq<BlockManagerId> getLocations(BlockId blockId) {
        return (Seq)this.driverEndpoint().askWithRetry(new BlockManagerMessages.GetLocations(blockId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public IndexedSeq<Seq<BlockManagerId>> getLocations(BlockId[] blockIds) {
        return (IndexedSeq)this.driverEndpoint().askWithRetry(new BlockManagerMessages.GetLocationsMultipleBlockIds(blockIds), ClassTag$.MODULE$.apply(IndexedSeq.class));
    }

    public boolean contains(BlockId blockId) {
        return !this.getLocations(blockId).isEmpty();
    }

    public Seq<BlockManagerId> getPeers(BlockManagerId blockManagerId) {
        return (Seq)this.driverEndpoint().askWithRetry(new BlockManagerMessages.GetPeers(blockManagerId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public Option<RpcEndpointRef> getExecutorEndpointRef(String executorId) {
        return (Option)this.driverEndpoint().askWithRetry(new BlockManagerMessages.GetExecutorEndpointRef(executorId), ClassTag$.MODULE$.apply(Option.class));
    }

    public void removeBlock(BlockId blockId) {
        this.driverEndpoint().askWithRetry(new BlockManagerMessages.RemoveBlock(blockId), ClassTag$.MODULE$.Boolean());
    }

    public void removeRdd(int rddId, boolean blocking) {
        Future future = (Future)this.driverEndpoint().askWithRetry(new BlockManagerMessages.RemoveRdd(rddId), ClassTag$.MODULE$.apply(Future.class));
        future.onFailure((PartialFunction)new Serializable(this, rddId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockManagerMaster $outer;
            public final int rddId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception2 = (Exception)A1;
                    this.$outer.logWarning((Function0<String>)new Serializable(this, exception2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$removeRdd$1 $outer;
                        private final Exception x2$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to remove RDD ", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.rddId$1), this.x2$1.getMessage()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x2$1 = x2$1;
                        }
                    }, exception2);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rddId$1 = rddId$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        if (blocking) {
            this.timeout().awaitResult(future);
        }
    }

    public void removeShuffle(int shuffleId, boolean blocking) {
        Future future = (Future)this.driverEndpoint().askWithRetry(new BlockManagerMessages.RemoveShuffle(shuffleId), ClassTag$.MODULE$.apply(Future.class));
        future.onFailure((PartialFunction)new Serializable(this, shuffleId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockManagerMaster $outer;
            public final int shuffleId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof Exception) {
                    Exception exception2 = (Exception)A1;
                    this.$outer.logWarning((Function0<String>)new Serializable(this, exception2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$removeShuffle$1 $outer;
                        private final Exception x2$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to remove shuffle ", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.shuffleId$1), this.x2$2.getMessage()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x2$2 = x2$2;
                        }
                    }, exception2);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.shuffleId$1 = shuffleId$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        if (blocking) {
            this.timeout().awaitResult(future);
        }
    }

    public void removeBroadcast(long broadcastId, boolean removeFromMaster, boolean blocking) {
        Future future = (Future)this.driverEndpoint().askWithRetry(new BlockManagerMessages.RemoveBroadcast(broadcastId, removeFromMaster), ClassTag$.MODULE$.apply(Future.class));
        future.onFailure((PartialFunction)new Serializable(this, broadcastId, removeFromMaster){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockManagerMaster $outer;
            public final long broadcastId$1;
            public final boolean removeFromMaster$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof Exception) {
                    Exception exception2 = (Exception)A1;
                    this.$outer.logWarning((Function0<String>)new Serializable(this, exception2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$removeBroadcast$1 $outer;
                        private final Exception x2$3;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to remove broadcast ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.broadcastId$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" with removeFromMaster = ", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)this.$outer.removeFromMaster$1), this.x2$3.getMessage()}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x2$3 = x2$3;
                        }
                    }, exception2);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x3) {
                Throwable throwable = x3;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.broadcastId$1 = broadcastId$1;
                this.removeFromMaster$1 = removeFromMaster$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        if (blocking) {
            this.timeout().awaitResult(future);
        }
    }

    public Map<BlockManagerId, Tuple2<Object, Object>> getMemoryStatus() {
        return (Map)this.driverEndpoint().askWithRetry(BlockManagerMessages$GetMemoryStatus$.MODULE$, ClassTag$.MODULE$.apply(Map.class));
    }

    public StorageStatus[] getStorageStatus() {
        return (StorageStatus[])this.driverEndpoint().askWithRetry(BlockManagerMessages$GetStorageStatus$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(StorageStatus.class)));
    }

    public Map<BlockManagerId, BlockStatus> getBlockStatus(BlockId blockId, boolean askSlaves) {
        BlockManagerMessages.GetBlockStatus msg = new BlockManagerMessages.GetBlockStatus(blockId, askSlaves);
        Map response = (Map)this.driverEndpoint().askWithRetry(msg, ClassTag$.MODULE$.apply(Map.class));
        Tuple2 tuple2 = response.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.immutable.Iterable blockManagerIds = (scala.collection.immutable.Iterable)tuple2._1();
            scala.collection.immutable.Iterable futures = (scala.collection.immutable.Iterable)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)blockManagerIds, (Object)futures);
            scala.collection.immutable.Iterable blockManagerIds2 = (scala.collection.immutable.Iterable)tuple23._1();
            scala.collection.immutable.Iterable futures2 = (scala.collection.immutable.Iterable)tuple23._2();
            ExecutionContextExecutor sameThread = ThreadUtils$.MODULE$.sameThread();
            CanBuildFrom cbf = (CanBuildFrom)Predef$.MODULE$.implicitly((Object)scala.collection.Iterable$.MODULE$.canBuildFrom());
            Iterable blockStatus2 = (Iterable)this.timeout().awaitResult(Future$.MODULE$.sequence((TraversableOnce)futures2, cbf, (ExecutionContext)ThreadUtils$.MODULE$.sameThread()));
            if (blockStatus2 == null) {
                throw new SparkException(new StringBuilder().append((Object)"BlockManager returned null for BlockStatus query: ").append((Object)blockId).toString());
            }
            return ((TraversableOnce)((TraversableLike)blockManagerIds2.zip((GenIterable)blockStatus2, Iterable$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<Tuple2<BlockManagerId, BlockStatus>> apply(Tuple2<BlockManagerId, Option<BlockStatus>> x0$1) {
                    Tuple2<BlockManagerId, Option<BlockStatus>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
                        Option status = (Option)tuple2._2();
                        Iterable iterable = Option$.MODULE$.option2Iterable(status.map((Function1)new Serializable(this, blockManagerId){
                            public static final long serialVersionUID = 0L;
                            private final BlockManagerId blockManagerId$2;

                            public final Tuple2<BlockManagerId, BlockStatus> apply(BlockStatus s) {
                                return new Tuple2((Object)this.blockManagerId$2, (Object)s);
                            }
                            {
                                this.blockManagerId$2 = blockManagerId$2;
                            }
                        }));
                        return iterable;
                    }
                    throw new MatchError(tuple2);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean getBlockStatus$default$2() {
        return true;
    }

    public Seq<BlockId> getMatchingBlockIds(Function1<BlockId, Object> filter2, boolean askSlaves) {
        BlockManagerMessages.GetMatchingBlockIds msg = new BlockManagerMessages.GetMatchingBlockIds(filter2, askSlaves);
        Future future = (Future)this.driverEndpoint().askWithRetry(msg, ClassTag$.MODULE$.apply(Future.class));
        return (Seq)this.timeout().awaitResult(future);
    }

    public boolean hasCachedBlocks(String executorId) {
        return BoxesRunTime.unboxToBoolean(this.driverEndpoint().askWithRetry(new BlockManagerMessages.HasCachedBlocks(executorId), ClassTag$.MODULE$.Boolean()));
    }

    public void stop() {
        if (this.driverEndpoint() != null && this.isDriver) {
            this.tell(BlockManagerMessages$StopBlockManagerMaster$.MODULE$);
            this.driverEndpoint_$eq(null);
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "BlockManagerMaster stopped";
                }
            });
        }
    }

    private void tell(Object message) {
        if (BoxesRunTime.unboxToBoolean(this.driverEndpoint().askWithRetry(message, ClassTag$.MODULE$.Boolean()))) {
            return;
        }
        throw new SparkException("BlockManagerMasterEndpoint returned false, expected true.");
    }

    public BlockManagerMaster(RpcEndpointRef driverEndpoint, SparkConf conf, boolean isDriver) {
        this.driverEndpoint = driverEndpoint;
        this.isDriver = isDriver;
        Logging$class.$init$(this);
        this.timeout = RpcUtils$.MODULE$.askRpcTimeout(conf);
    }
}

