/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mapred;

import java.io.IOException;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext$;
import org.apache.spark.executor.CommitDeniedException;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.scheduler.OutputCommitCoordinator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.TraitSetter;

public final class SparkHadoopMapRedUtil$
implements Logging {
    public static final SparkHadoopMapRedUtil$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private transient int org$apache$spark$internal$Logging$$levelFlags;

    static {
        new SparkHadoopMapRedUtil$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public int org$apache$spark$internal$Logging$$levelFlags() {
        return this.org$apache$spark$internal$Logging$$levelFlags;
    }

    @Override
    public void org$apache$spark$internal$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$internal$Logging$$levelFlags = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public final boolean isInfoEnabled() {
        return Logging$class.isInfoEnabled(this);
    }

    @Override
    public final boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public final boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void commitTask(OutputCommitter committer, TaskAttemptContext mrTaskContext, int jobId, int splitId) {
        int taskAttemptNumber;
        TaskAttemptID mrTaskAttemptID = mrTaskContext.getTaskAttemptID();
        if (!committer.needsTaskCommit(mrTaskContext)) {
            this.logInfo((Function0<String>)new Serializable(mrTaskAttemptID){
                public static final long serialVersionUID = 0L;
                private final TaskAttemptID mrTaskAttemptID$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No need to commit output of task because needsTaskCommit=false: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.mrTaskAttemptID$1}));
                }
                {
                    this.mrTaskAttemptID$1 = mrTaskAttemptID$1;
                }
            });
            return;
        }
        SparkConf sparkConf = SparkEnv$.MODULE$.get().conf();
        boolean shouldCoordinateWithDriver = sparkConf.getBoolean("spark.hadoop.outputCommitCoordination.enabled", true);
        if (!shouldCoordinateWithDriver) {
            this.performCommit$1(committer, mrTaskContext, mrTaskAttemptID);
            return;
        }
        OutputCommitCoordinator outputCommitCoordinator = SparkEnv$.MODULE$.get().outputCommitCoordinator();
        boolean canCommit2 = outputCommitCoordinator.canCommit(jobId, splitId, taskAttemptNumber = TaskContext$.MODULE$.get().attemptNumber());
        if (canCommit2) {
            this.performCommit$1(committer, mrTaskContext, mrTaskAttemptID);
            return;
        }
        String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Not committed because the driver did not authorize commit"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mrTaskAttemptID}));
        this.logInfo((Function0<String>)new Serializable(message){
            public static final long serialVersionUID = 0L;
            private final String message$1;

            public final String apply() {
                return this.message$1;
            }
            {
                this.message$1 = message$1;
            }
        });
        committer.abortTask(mrTaskContext);
        throw new CommitDeniedException(message, jobId, splitId, taskAttemptNumber);
    }

    private final void performCommit$1(OutputCommitter committer$1, TaskAttemptContext mrTaskContext$1, TaskAttemptID mrTaskAttemptID$1) {
        try {
            committer$1.commitTask(mrTaskContext$1);
            this.logInfo((Function0<String>)new Serializable(mrTaskAttemptID$1){
                public static final long serialVersionUID = 0L;
                private final TaskAttemptID mrTaskAttemptID$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Committed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.mrTaskAttemptID$1}));
                }
                {
                    this.mrTaskAttemptID$1 = mrTaskAttemptID$1;
                }
            });
            return;
        }
        catch (IOException iOException) {
            this.logError((Function0<String>)new Serializable(mrTaskAttemptID$1){
                public static final long serialVersionUID = 0L;
                private final TaskAttemptID mrTaskAttemptID$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error committing the output of task: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.mrTaskAttemptID$1}));
                }
                {
                    this.mrTaskAttemptID$1 = mrTaskAttemptID$1;
                }
            }, iOException);
            committer$1.abortTask(mrTaskContext$1);
            throw iOException;
        }
    }

    private SparkHadoopMapRedUtil$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

