/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import com.google.common.primitives.Longs;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\t\u0015g\u0001B\u0001\u0003\u0001-\u0011qb\u00159be.D\u0015\rZ8paV#\u0018\u000e\u001c\u0006\u0003\u0007\u0011\ta\u0001Z3qY>L(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0005j]R,'O\\1m\u0013\t9BCA\u0004M_\u001e<\u0017N\\4\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%IaH\u0001\ngB\f'o[\"p]\u001a,\u0012\u0001\t\t\u0003C\tj\u0011\u0001B\u0005\u0003G\u0011\u0011\u0011b\u00159be.\u001cuN\u001c4\t\r\u0015\u0002\u0001\u0015!\u0003!\u0003)\u0019\b/\u0019:l\u0007>tg\r\t\u0005\bO\u0001\u0011\r\u0011\"\u0001)\u0003\u0011\u0019wN\u001c4\u0016\u0003%\u0002\"A\u000b\u0018\u000e\u0003-R!a\n\u0017\u000b\u000552\u0011A\u00025bI>|\u0007/\u0003\u00020W\ti1i\u001c8gS\u001e,(/\u0019;j_:Da!\r\u0001!\u0002\u0013I\u0013!B2p]\u001a\u0004\u0003\"B\u001a\u0001\t\u0003!\u0014A\u0004:v]\u0006\u001b8\u000b]1sWV\u001bXM\u001d\u000b\u0003ka\u0002\"!\u0004\u001c\n\u0005]r!\u0001B+oSRDQ!\u000f\u001aA\u0002i\nAAZ;oGB\u0019QbO\u001b\n\u0005qr!!\u0003$v]\u000e$\u0018n\u001c81\u0011\u0015q\u0004\u0001\"\u0001@\u0003M!(/\u00198tM\u0016\u00148I]3eK:$\u0018.\u00197t)\r)\u0004\t\u0013\u0005\u0006\u0003v\u0002\rAQ\u0001\u0007g>,(oY3\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015c\u0013\u0001C:fGV\u0014\u0018\u000e^=\n\u0005\u001d#%\u0001F+tKJ<%o\\;q\u0013:4wN]7bi&|g\u000eC\u0003J{\u0001\u0007!)\u0001\u0003eKN$\b\"B&\u0001\t\u0003a\u0015\u0001J1qa\u0016tGmU\u001aB]\u0012\u001c\u0006/\u0019:l\u0011\u0006$wn\u001c9D_:4\u0017nZ;sCRLwN\\:\u0015\u0007Uje\nC\u0003(\u0015\u0002\u0007\u0001\u0005C\u0003P\u0015\u0002\u0007\u0011&\u0001\u0006iC\u0012|w\u000e]\"p]\u001aDQ!\u0015\u0001\u0005\u0002I\u000b\u0001C\\3x\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0005%\u001a\u0006\"B\u0014Q\u0001\u0004\u0001\u0003\"B+\u0001\t\u00031\u0016AD1eI\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0003k]CQa\n+A\u0002a\u0003\"!\u0017/\u000e\u0003iS!a\u0017\u0017\u0002\r5\f\u0007O]3e\u0013\ti&LA\u0004K_\n\u001cuN\u001c4\t\u000b}\u0003A\u0011\u00011\u0002\u0015%\u001c\u0018,\u0019:o\u001b>$W\rF\u0001b!\ti!-\u0003\u0002d\u001d\t9!i\\8mK\u0006t\u0007\"B3\u0001\t\u00031\u0017!G4fi\u000e+(O]3oiV\u001bXM]\"sK\u0012,g\u000e^5bYN$\u0012a\u001a\t\u0003\u0007\"L!!\u001b#\u0003\u0017\r\u0013X\rZ3oi&\fGn\u001d\u0005\u0006W\u0002!\t\u0001\\\u0001\u001aC\u0012$7)\u001e:sK:$Xk]3s\u0007J,G-\u001a8uS\u0006d7\u000f\u0006\u00026[\")aN\u001ba\u0001O\u0006)1M]3eg\")\u0001\u000f\u0001C\u0001c\u0006i\u0012\r\u001a3TK\u000e\u0014X\r^&fsR{Wk]3s\u0007J,G-\u001a8uS\u0006d7\u000fF\u00026enDQa]8A\u0002Q\f1a[3z!\t)\bP\u0004\u0002\u000em&\u0011qOD\u0001\u0007!J,G-\u001a4\n\u0005eT(AB*ue&twM\u0003\u0002x\u001d!)Ap\u001ca\u0001i\u000611/Z2sKRDQA \u0001\u0005\u0002}\fqdZ3u'\u0016\u001c'/\u001a;LKf4%o\\7Vg\u0016\u00148I]3eK:$\u0018.\u00197t)\u0011\t\t!!\u0004\u0011\u000b5\t\u0019!a\u0002\n\u0007\u0005\u0015aBA\u0003BeJ\f\u0017\u0010E\u0002\u000e\u0003\u0013I1!a\u0003\u000f\u0005\u0011\u0011\u0015\u0010^3\t\u000bMl\b\u0019\u0001;\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014\u0005\u0019Bn\\4j]V\u001bXM\u001d$s_6\\U-\u001f;bER)Q'!\u0006\u0002\u001a!9\u0011qCA\b\u0001\u0004!\u0018!\u00049sS:\u001c\u0017\u000e]1m\u001d\u0006lW\rC\u0004\u0002\u001c\u0005=\u0001\u0019\u0001;\u0002\u001d-,\u0017\u0010^1c\r&dWM\\1nK\"A\u0011q\u0004\u0001\u0005\u0002\u0011\t\t#\u0001\u0010hKR45KQ=uKN\u0014V-\u00193P]RC'/Z1e\u0007\u0006dGNY1dWR\u0011\u00111\u0005\t\u0006\u001b\u0005\u0015\u0012\u0011F\u0005\u0004\u0003Oq!AB(qi&|g\u000e\u0005\u0003\u000ew\u0005-\u0002cA\u0007\u0002.%\u0019\u0011q\u0006\b\u0003\t1{gn\u001a\u0005\t\u0003g\u0001A\u0011\u0001\u0003\u0002\"\u0005\ts-\u001a;G'\nKH/Z:Xe&$H/\u001a8P]RC'/Z1e\u0007\u0006dGNY1dW\"9\u0011q\u0007\u0001\u0005\n\u0005e\u0012!H4fi\u001aKG.Z*zgR,W\u000e\u00165sK\u0006$7\u000b^1uSN$\u0018nY:\u0015\u0005\u0005m\u0002#BA\u001f\u0003\u001bba\u0002BA \u0003\u0013rA!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000bR\u0011A\u0002\u001fs_>$h(C\u0001\u0010\u0013\r\tYED\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty%!\u0015\u0003\u0007M+\u0017OC\u0002\u0002L9Aq!!\u0016\u0001\t\u0013\t9&A\u0012hKR4\u0015\u000e\\3TsN$X-\u001c+ie\u0016\fGm\u0015;bi&\u001cH/[2t\u001b\u0016$\bn\u001c3\u0015\t\u0005e\u0013Q\u000e\t\u0005\u00037\nI'\u0004\u0002\u0002^)!\u0011qLA1\u0003\u001d\u0011XM\u001a7fGRTA!a\u0019\u0002f\u0005!A.\u00198h\u0015\t\t9'\u0001\u0003kCZ\f\u0017\u0002BA6\u0003;\u0012a!T3uQ>$\u0007bBA8\u0003'\u0002\r\u0001^\u0001\u000b[\u0016$\bn\u001c3OC6,\u0007bBA:\u0001\u0011\u0005\u0011QO\u0001\u0011Y&\u001cH\u000fT3bMN#\u0018\r^;tKN$b!a\u001e\u0002\u0006\u00065\u0005CBA\u001f\u0003\u001b\nI\b\u0005\u0003\u0002|\u0005\u0005UBAA?\u0015\r\ty\bL\u0001\u0003MNLA!a!\u0002~\tQa)\u001b7f'R\fG/^:\t\u0011\u0005}\u0014\u0011\u000fa\u0001\u0003\u000f\u0003B!a\u001f\u0002\n&!\u00111RA?\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0005\t\u0003\u001f\u000b\t\b1\u0001\u0002\u0012\u0006A!-Y:f!\u0006$\b\u000e\u0005\u0003\u0002|\u0005M\u0015\u0002BAK\u0003{\u0012A\u0001U1uQ\"9\u00111\u000f\u0001\u0005\u0002\u0005eECBA<\u00037\u000bi\n\u0003\u0005\u0002\u0000\u0005]\u0005\u0019AAD\u0011!\ty*a&A\u0002\u0005e\u0014A\u00032bg\u0016\u001cF/\u0019;vg\"9\u00111\u0015\u0001\u0005\u0002\u0005\u0015\u0016a\u00057jgRdU-\u00194ESJ\u001cF/\u0019;vg\u0016\u001cHCBA<\u0003O\u000bI\u000b\u0003\u0005\u0002\u0000\u0005\u0005\u0006\u0019AAD\u0011!\ty)!)A\u0002\u0005E\u0005bBAR\u0001\u0011\u0005\u0011Q\u0016\u000b\u0007\u0003o\ny+!-\t\u0011\u0005}\u00141\u0016a\u0001\u0003\u000fC\u0001\"a(\u0002,\u0002\u0007\u0011\u0011\u0010\u0005\b\u0003k\u0003A\u0011AA\\\u0003)I7o\u00127pEB\u000bG\u000f\u001b\u000b\u0004C\u0006e\u0006\u0002CA^\u0003g\u0003\r!!%\u0002\u000fA\fG\u000f^3s]\"9\u0011q\u0018\u0001\u0005\u0002\u0005\u0005\u0017\u0001C4m_\n\u0004\u0016\r\u001e5\u0015\t\u0005\r\u0017Q\u0019\t\u0007\u0003{\ti%!%\t\u0011\u0005m\u0016Q\u0018a\u0001\u0003#Cq!!3\u0001\t\u0003\tY-A\nhY>\u0014\u0007+\u0019;i\u0013\u001atUmY3tg\u0006\u0014\u0018\u0010\u0006\u0003\u0002D\u00065\u0007\u0002CA^\u0003\u000f\u0004\r!!%\t\u000f\u0005E\u0007\u0001\"\u0001\u0002T\u0006yA.[:u\r&dWm]*peR,G\r\u0006\u0006\u0002V\u0006]\u00171\\Ap\u0003G\u0004R!DA\u0002\u0003sB\u0001\"!7\u0002P\u0002\u0007\u0011qQ\u0001\te\u0016lw\u000e^3Gg\"A\u0011Q\\Ah\u0001\u0004\t\t*A\u0002eSJDq!!9\u0002P\u0002\u0007A/\u0001\u0004qe\u00164\u0017\u000e\u001f\u0005\b\u0003K\fy\r1\u0001u\u0003=)\u0007p\u00197vg&|gnU;gM&D\b\u0002CAu\u0001\u0011\u0005A!a;\u00027\u001d,GoU;gM&Dhi\u001c:De\u0016$WM\u001c;jC2\u001c\b+\u0019;i)\u0011\ti/a=\u0011\u00075\ty/C\u0002\u0002r:\u00111!\u00138u\u0011!\t)0a:A\u0002\u0005E\u0015aD2sK\u0012,g\u000e^5bYN\u0004\u0016\r\u001e5\t\u0013\u0005e\bA1A\u0005\n\u0005m\u0018a\u0005%B\t>{\u0005kX\"P\u001d\u001a{\u0006+\u0011+U\u000bJsUCAA\u007f!\u0011\tyP!\u0003\u000e\u0005\t\u0005!\u0002\u0002B\u0002\u0005\u000b\t\u0001\"\\1uG\"Lgn\u001a\u0006\u0004\u0005\u000fq\u0011\u0001B;uS2LAAa\u0003\u0003\u0002\tyQK\\1oG\"|'/\u001a3SK\u001e,\u0007\u0010\u0003\u0005\u0003\u0010\u0001\u0001\u000b\u0011BA\u007f\u0003QA\u0015\tR(P!~\u001buJ\u0014$`!\u0006#F+\u0012*OA!9!1\u0003\u0001\u0005\u0002\tU\u0011!G:vEN$\u0018\u000e^;uK\"\u000bGm\\8q-\u0006\u0014\u0018.\u00192mKN$R\u0001\u001eB\f\u00057AqA!\u0007\u0003\u0012\u0001\u0007A/\u0001\u0003uKb$\bBB(\u0003\u0012\u0001\u0007\u0011\u0006\u0003\u0005\u0003 \u0001!\t\u0001\u0002B\u0011\u0003Y\u0019H/\u0019:u\u0007J,G-\u001a8uS\u0006dW\u000b\u001d3bi\u0016\u0014HcA\u001b\u0003$!1qE!\bA\u0002\u0001B\u0001Ba\n\u0001\t\u0003!!\u0011F\u0001\u0016gR|\u0007o\u0011:fI\u0016tG/[1m+B$\u0017\r^3s)\u0005)\u0004\u0002\u0003B\u0017\u0001\u0011\u0005AAa\f\u0002/\u001d,GoQ8oM\nK\b/Y:tS:<giU\"bG\",G#B\u0015\u00032\tM\u0002BB(\u0003,\u0001\u0007\u0011\u0006C\u0004\u00036\t-\u0002\u0019\u0001;\u0002\rM\u001c\u0007.Z7f\u0011!\u0011I\u0004\u0001C\u0001\t\tm\u0012A\u00033v[B$vn[3ogR!!Q\bB\"!\u0015\tiDa\u0010u\u0013\u0011\u0011\t%!\u0015\u0003\u0011%#XM]1cY\u0016DqA!\u0012\u00038\u0001\u0007q-A\u0006de\u0016$WM\u001c;jC2\u001c\b\u0002\u0003B%\u0001\u0011\u0005AAa\u0013\u0002\u001bQ|7.\u001a8U_N#(/\u001b8h)\r!(Q\n\u0005\t\u0005\u001f\u00129\u00051\u0001\u0003R\u0005)Ao\\6f]B\"!1\u000bB1!\u0019\u0011)F!\u0017\u0003^5\u0011!q\u000b\u0006\u0004\u0005\u001f\"\u0015\u0002\u0002B.\u0005/\u0012Q\u0001V8lK:\u0004BAa\u0018\u0003b1\u0001A\u0001\u0004B2\u0005\u001b\n\t\u0011!A\u0003\u0002\t\u0015$aA0%cE!!q\rB7!\ri!\u0011N\u0005\u0004\u0005Wr!a\u0002(pi\"Lgn\u001a\t\u0005\u0005+\u0012y'\u0003\u0003\u0003r\t]#a\u0004+pW\u0016t\u0017\nZ3oi&4\u0017.\u001a:)\u0007\u0001\u0011)\b\u0005\u0003\u0003x\tuTB\u0001B=\u0015\r\u0011Y\bB\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B@\u0005s\u0012A\u0002R3wK2|\u0007/\u001a:Ba&<qAa!\u0003\u0011\u0003\u0011))A\bTa\u0006\u00148\u000eS1e_>\u0004X\u000b^5m!\ra\"q\u0011\u0004\u0007\u0003\tA\tA!#\u0014\u0007\t\u001dE\u0002C\u0004\u001a\u0005\u000f#\tA!$\u0015\u0005\t\u0015\u0005BC\u0017\u0003\b\"\u0015\r\u0011\"\u0003\u0003\u0012V\t1\u0004\u0003\u0006\u0003\u0016\n\u001d\u0005\u0012!Q!\nm\tq\u0001[1e_>\u0004\b\u0005C\u0006\u0003\u001a\n\u001d\u0005R1A\u0005\n\tE\u0015\u0001B=be:D!B!(\u0003\b\"\u0005\t\u0015)\u0003\u001c\u0003\u0015I\u0018M\u001d8!\u0011)\u0011\tKa\"C\u0002\u0013\u0005!1U\u0001 'B\u000b%kS0Z\u0003Jsul\u0011*F\tN{F+R'Q?\u0016CF+\u0012(T\u0013>sUC\u0001BS!\u0011\u00119K!+\u000e\u0005\u0005\u0005\u0014bA=\u0002b!I!Q\u0016BDA\u0003%!QU\u0001!'B\u000b%kS0Z\u0003Jsul\u0011*F\tN{F+R'Q?\u0016CF+\u0012(T\u0013>s\u0005\u0005\u0003\u0006\u00032\n\u001d%\u0019!C\u0001\u0005G\u000bad\u0015)B%.{\u0016,\u0011*O?\u000e\u0013V\tR*`\u0007>+f\nV#S?\u0012+E*S'\t\u0013\tU&q\u0011Q\u0001\n\t\u0015\u0016aH*Q\u0003J[u,W!S\u001d~\u001b%+\u0012#T?\u000e{UK\u0014+F%~#U\tT%NA!Y!\u0011\u0018BD\u0005\u0004%\t\u0001\u0002B^\u0003\u0015*\u0006\u000bR!U\u000b~Ke\nU+U?6+EKU%D'~Ke\nV#S-\u0006cuLU#D\u001fJ#5+\u0006\u0002\u0002n\"I!q\u0018BDA\u0003%\u0011Q^\u0001'+B#\u0015\tV#`\u0013:\u0003V\u000bV0N\u000bR\u0013\u0016jQ*`\u0013:#VI\u0015,B\u0019~\u0013ViQ(S\tN\u0003\u0003\u0002\u0003Bb\u0005\u000f#\tA!%\u0002\u0007\u001d,G\u000f")
public class SparkHadoopUtil
implements Logging {
    private final SparkConf sparkConf;
    private final Configuration conf;
    private final UnanchoredRegex org$apache$spark$deploy$SparkHadoopUtil$$HADOOP_CONF_PATTERN;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private transient int org$apache$spark$internal$Logging$$levelFlags;

    public static SparkHadoopUtil get() {
        return SparkHadoopUtil$.MODULE$.get();
    }

    public static String SPARK_YARN_CREDS_COUNTER_DELIM() {
        return SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM();
    }

    public static String SPARK_YARN_CREDS_TEMP_EXTENSION() {
        return SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public int org$apache$spark$internal$Logging$$levelFlags() {
        return this.org$apache$spark$internal$Logging$$levelFlags;
    }

    @Override
    public void org$apache$spark$internal$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$internal$Logging$$levelFlags = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public final boolean isInfoEnabled() {
        return Logging$class.isInfoEnabled(this);
    }

    @Override
    public final boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public final boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    public Configuration conf() {
        return this.conf;
    }

    public void runAsSparkUser(Function0<BoxedUnit> func) {
        String user = Utils$.MODULE$.getCurrentUserName();
        this.logDebug((Function0<String>)new Serializable(this, user){
            public static final long serialVersionUID = 0L;
            private final String user$1;

            public final String apply() {
                return new StringBuilder().append((Object)"running as user: ").append((Object)this.user$1).toString();
            }
            {
                this.user$1 = user$1;
            }
        });
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
        this.transferCredentials(UserGroupInformation.getCurrentUser(), ugi);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<BoxedUnit>(this, func){
            private final Function0 func$1;

            public void run() {
                this.func$1.apply$mcV$sp();
            }
            {
                this.func$1 = func$1;
            }
        });
    }

    public void transferCredentials(UserGroupInformation source, UserGroupInformation dest) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(source.getTokens()).asScala()).foreach((Function1)new Serializable(this, dest){
            public static final long serialVersionUID = 0L;
            private final UserGroupInformation dest$1;

            public final boolean apply(Token<? extends TokenIdentifier> token) {
                return this.dest$1.addToken(token);
            }
            {
                this.dest$1 = dest$1;
            }
        });
    }

    public void appendS3AndSparkHadoopConfigurations(SparkConf conf, Configuration hadoopConf) {
        if (conf != null) {
            if (System.getenv("AWS_ACCESS_KEY_ID") != null && System.getenv("AWS_SECRET_ACCESS_KEY") != null) {
                String keyId = System.getenv("AWS_ACCESS_KEY_ID");
                String accessKey = System.getenv("AWS_SECRET_ACCESS_KEY");
                hadoopConf.set("fs.s3.awsAccessKeyId", keyId);
                hadoopConf.set("fs.s3n.awsAccessKeyId", keyId);
                hadoopConf.set("fs.s3a.access.key", keyId);
                hadoopConf.set("fs.s3.awsSecretAccessKey", accessKey);
                hadoopConf.set("fs.s3n.awsSecretAccessKey", accessKey);
                hadoopConf.set("fs.s3a.secret.key", accessKey);
            }
            Predef$.MODULE$.refArrayOps((Object[])conf.getAll()).foreach((Function1)new Serializable(this, hadoopConf){
                public static final long serialVersionUID = 0L;
                private final Configuration hadoopConf$1;

                public final void apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        String key = (String)tuple2._1();
                        String value2 = (String)tuple2._2();
                        if (key.startsWith("spark.hadoop.")) {
                            this.hadoopConf$1.set(key.substring("spark.hadoop.".length()), value2);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.hadoopConf$1 = hadoopConf$1;
                }
            });
            String bufferSize = conf.get("spark.buffer.size", "65536");
            hadoopConf.set("io.file.buffer.size", bufferSize);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Configuration newConfiguration(SparkConf conf) {
        void var2_2;
        Configuration hadoopConf = new Configuration();
        this.appendS3AndSparkHadoopConfigurations(conf, hadoopConf);
        return var2_2;
    }

    public void addCredentials(JobConf conf) {
    }

    public boolean isYarnMode() {
        return false;
    }

    public Credentials getCurrentUserCredentials() {
        return null;
    }

    public void addCurrentUserCredentials(Credentials creds) {
    }

    public void addSecretKeyToUserCredentials(String key, String secret) {
    }

    public byte[] getSecretKeyFromUserCredentials(String key) {
        return null;
    }

    public void loginUserFromKeytab(String principalName, String keytabFilename) {
        UserGroupInformation.loginUserFromKeytab((String)principalName, (String)keytabFilename);
    }

    public Option<Function0<Object>> getFSBytesReadOnThreadCallback() {
        Throwable throwable2;
        block2: {
            Some some;
            try {
                Seq<Object> threadStats = this.getFileSystemThreadStatistics();
                Method getBytesReadMethod = this.getFileSystemThreadStatisticsMethod("getBytesRead");
                Serializable f = new Serializable(this, threadStats, getBytesReadMethod){
                    public static final long serialVersionUID = 0L;
                    private final Seq threadStats$1;
                    public final Method getBytesReadMethod$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.threadStats$1.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1 $outer;

                            public final long apply(Object x$1) {
                                return BoxesRunTime.unboxToLong((Object)this.$outer.getBytesReadMethod$1.invoke(x$1, new Object[0]));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    }
                    {
                        this.threadStats$1 = threadStats$1;
                        this.getBytesReadMethod$1 = getBytesReadMethod$1;
                    }
                };
                long baselineBytesRead = f.apply$mcJ$sp();
                some = new Some((Object)new Serializable(this, (Function0)f, baselineBytesRead){
                    public static final long serialVersionUID = 0L;
                    private final Function0 f$1;
                    private final long baselineBytesRead$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.f$1.apply$mcJ$sp() - this.baselineBytesRead$1;
                    }
                    {
                        this.f$1 = f$1;
                        this.baselineBytesRead$1 = baselineBytesRead$1;
                    }
                });
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                boolean bl = throwable3 instanceof NoSuchMethodException ? true : throwable3 instanceof ClassNotFoundException;
                if (!bl) break block2;
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Couldn't find method for retrieving thread-level FileSystem input data";
                    }
                }, throwable3);
                None$ none$ = None$.MODULE$;
                some = none$;
            }
            return some;
        }
        throw throwable2;
    }

    public Option<Function0<Object>> getFSBytesWrittenOnThreadCallback() {
        Throwable throwable2;
        block2: {
            Some some;
            try {
                Seq<Object> threadStats = this.getFileSystemThreadStatistics();
                Method getBytesWrittenMethod = this.getFileSystemThreadStatisticsMethod("getBytesWritten");
                Serializable f = new Serializable(this, threadStats, getBytesWrittenMethod){
                    public static final long serialVersionUID = 0L;
                    private final Seq threadStats$2;
                    public final Method getBytesWrittenMethod$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.threadStats$2.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2 $outer;

                            public final long apply(Object x$2) {
                                return BoxesRunTime.unboxToLong((Object)this.$outer.getBytesWrittenMethod$1.invoke(x$2, new Object[0]));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    }
                    {
                        this.threadStats$2 = threadStats$2;
                        this.getBytesWrittenMethod$1 = getBytesWrittenMethod$1;
                    }
                };
                long baselineBytesWritten = f.apply$mcJ$sp();
                some = new Some((Object)new Serializable(this, (Function0)f, baselineBytesWritten){
                    public static final long serialVersionUID = 0L;
                    private final Function0 f$2;
                    private final long baselineBytesWritten$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.f$2.apply$mcJ$sp() - this.baselineBytesWritten$1;
                    }
                    {
                        this.f$2 = f$2;
                        this.baselineBytesWritten$1 = baselineBytesWritten$1;
                    }
                });
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                boolean bl = throwable3 instanceof NoSuchMethodException ? true : throwable3 instanceof ClassNotFoundException;
                if (!bl) break block2;
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Couldn't find method for retrieving thread-level FileSystem output data";
                    }
                }, throwable3);
                None$ none$ = None$.MODULE$;
                some = none$;
            }
            return some;
        }
        throw throwable2;
    }

    private Seq<Object> getFileSystemThreadStatistics() {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(FileSystem.getAllStatistics()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(FileSystem.Statistics x$3) {
                return Utils$.MODULE$.invoke(FileSystem.Statistics.class, x$3, "getThreadStatistics", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    private Method getFileSystemThreadStatisticsMethod(String methodName) {
        Class<?> statisticsDataClass = Utils$.MODULE$.classForName("org.apache.hadoop.fs.FileSystem$Statistics$StatisticsData");
        return statisticsDataClass.getDeclaredMethod(methodName, new Class[0]);
    }

    public Seq<FileStatus> listLeafStatuses(FileSystem fs, Path basePath) {
        return this.listLeafStatuses(fs, fs.getFileStatus(basePath));
    }

    public Seq<FileStatus> listLeafStatuses(FileSystem fs, FileStatus baseStatus) {
        return baseStatus.isDirectory() ? this.recurse$1(baseStatus, fs) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{baseStatus}));
    }

    public Seq<FileStatus> listLeafDirStatuses(FileSystem fs, Path basePath) {
        return this.listLeafDirStatuses(fs, fs.getFileStatus(basePath));
    }

    public Seq<FileStatus> listLeafDirStatuses(FileSystem fs, FileStatus baseStatus) {
        Predef$.MODULE$.assert(baseStatus.isDirectory());
        return this.recurse$2(baseStatus, fs);
    }

    public boolean isGlobPath(Path pattern) {
        Set set = new StringOps(Predef$.MODULE$.augmentString("{}[]*?\\")).toSet();
        return new StringOps(Predef$.MODULE$.augmentString(pattern.toString())).exists((Function1)new Serializable(this, set){
            public static final long serialVersionUID = 0L;
            private final Set eta$0$1$1;

            public final boolean apply(Object elem) {
                return this.eta$0$1$1.contains(elem);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
    }

    public Seq<Path> globPath(Path pattern) {
        FileSystem fs = pattern.getFileSystem(this.conf());
        return (Seq)Option$.MODULE$.apply((Object)fs.globStatus(pattern)).map((Function1)new Serializable(this, fs){
            public static final long serialVersionUID = 0L;
            public final FileSystem fs$3;

            public final Seq<Path> apply(FileStatus[] statuses) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])statuses).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$globPath$1 $outer;

                    public final Path apply(FileStatus x$8) {
                        return x$8.getPath().makeQualified(this.$outer.fs$3.getUri(), this.$outer.fs$3.getWorkingDirectory());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).toSeq();
            }
            {
                this.fs$3 = fs$3;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Path> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
    }

    public Seq<Path> globPathIfNecessary(Path pattern) {
        return this.isGlobPath(pattern) ? this.globPath(pattern) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{pattern}));
    }

    public FileStatus[] listFilesSorted(FileSystem remoteFs, Path dir, String prefix, String exclusionSuffix) {
        FileStatus[] fileStatusArray;
        try {
            FileStatus[] fileStatuses = remoteFs.listStatus(dir, new PathFilter(this, prefix, exclusionSuffix){
                private final String prefix$1;
                private final String exclusionSuffix$1;

                public boolean accept(Path path) {
                    String name = path.getName();
                    return name.startsWith(this.prefix$1) && !name.endsWith(this.exclusionSuffix$1);
                }
                {
                    this.prefix$1 = prefix$1;
                    this.exclusionSuffix$1 = exclusionSuffix$1;
                }
            });
            Arrays.sort((Object[])fileStatuses, new Comparator<FileStatus>(this){

                public int compare(FileStatus o1, FileStatus o2) {
                    return Longs.compare((long)o1.getModificationTime(), (long)o2.getModificationTime());
                }
            });
            fileStatusArray = fileStatuses;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while attempting to list files from application staging dir";
                }
            }, e);
            FileStatus[] fileStatusArray2 = (FileStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStatus.class));
            fileStatusArray = fileStatusArray2;
        }
        return fileStatusArray;
    }

    public int getSuffixForCredentialsPath(Path credentialsPath) {
        String fileName = credentialsPath.getName();
        return new StringOps(Predef$.MODULE$.augmentString(fileName.substring(fileName.lastIndexOf(SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM()) + 1))).toInt();
    }

    public UnanchoredRegex org$apache$spark$deploy$SparkHadoopUtil$$HADOOP_CONF_PATTERN() {
        return this.org$apache$spark$deploy$SparkHadoopUtil$$HADOOP_CONF_PATTERN;
    }

    public String substituteHadoopVariables(String text, Configuration hadoopConf) {
        String string;
        String string2 = text;
        Option option = ((Regex)this.org$apache$spark$deploy$SparkHadoopUtil$$HADOOP_CONF_PATTERN()).unapplySeq((CharSequence)string2);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String matched = (String)((LinearSeqOptimized)option.get()).apply(0);
            this.logDebug((Function0<String>)new Serializable(this, text){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkHadoopUtil $outer;
                private final String text$1;

                public final String apply() {
                    return new StringBuilder().append((Object)this.text$1).append((Object)" matched ").append((Object)this.$outer.org$apache$spark$deploy$SparkHadoopUtil$$HADOOP_CONF_PATTERN()).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.text$1 = text$1;
                }
            });
            String key = matched.substring(13, matched.length() - 1);
            Option eval = Option$.MODULE$.apply((Object)hadoopConf.get(key)).map((Function1)new Serializable(this, text, matched){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkHadoopUtil $outer;
                private final String text$1;
                public final String matched$1;

                public final String apply(String value2) {
                    this.$outer.logDebug((Function0<String>)new Serializable(this, value2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$5 $outer;
                        private final String value$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Substituted ").append((Object)this.$outer.matched$1).append((Object)" with ").append((Object)this.value$1).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.value$1 = value$1;
                        }
                    });
                    return this.text$1.replace(this.matched$1, value2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.text$1 = text$1;
                    this.matched$1 = matched$1;
                }
            });
            string = eval.isEmpty() ? text : this.substituteHadoopVariables((String)eval.get(), hadoopConf);
        } else {
            this.logDebug((Function0<String>)new Serializable(this, text){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkHadoopUtil $outer;
                private final String text$1;

                public final String apply() {
                    return new StringBuilder().append((Object)this.text$1).append((Object)" didn't match ").append((Object)this.$outer.org$apache$spark$deploy$SparkHadoopUtil$$HADOOP_CONF_PATTERN()).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.text$1 = text$1;
                }
            });
            string = text;
        }
        return string;
    }

    public void startCredentialUpdater(SparkConf conf) {
    }

    public void stopCredentialUpdater() {
    }

    /*
     * WARNING - void declaration
     */
    public Configuration getConfBypassingFSCache(Configuration hadoopConf, String scheme) {
        void var3_3;
        Configuration newConf = new Configuration(hadoopConf);
        String confKey = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fs.", ".impl.disable.cache"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scheme}));
        newConf.setBoolean(confKey, true);
        return var3_3;
    }

    public Iterable<String> dumpTokens(Credentials credentials) {
        return credentials == null ? (Iterable)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(credentials.getAllTokens()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkHadoopUtil $outer;

            public final String apply(Token<? extends TokenIdentifier> token) {
                return this.$outer.tokenToString(token);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public String tokenToString(Token<? extends TokenIdentifier> token) {
        BoxedUnit boxedUnit;
        DateFormat df = DateFormat.getDateTimeInstance(3, 3, Locale.US);
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(token.toString());
        try {
            BoxedUnit boxedUnit2;
            TokenIdentifier ti = token.decodeIdentifier();
            buffer.append("; ").append((Object)ti);
            TokenIdentifier tokenIdentifier = ti;
            if (tokenIdentifier instanceof AbstractDelegationTokenIdentifier) {
                AbstractDelegationTokenIdentifier abstractDelegationTokenIdentifier = (AbstractDelegationTokenIdentifier)tokenIdentifier;
                buffer.append("; Renewer: ").append((Object)abstractDelegationTokenIdentifier.getRenewer());
                buffer.append("; Issued: ").append(df.format(new Date(abstractDelegationTokenIdentifier.getIssueDate())));
                boxedUnit2 = buffer.append("; Max Date: ").append(df.format(new Date(abstractDelegationTokenIdentifier.getMaxDate())));
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            boxedUnit = boxedUnit2;
        }
        catch (IOException iOException) {
            this.logDebug((Function0<String>)new Serializable(this, token, iOException){
                public static final long serialVersionUID = 0L;
                private final Token token$1;
                private final IOException e$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to decode ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.token$1, this.e$1}));
                }
                {
                    this.token$1 = token$1;
                    this.e$1 = e$1;
                }
            }, iOException);
            boxedUnit = BoxedUnit.UNIT;
        }
        return buffer.toString();
    }

    private final Seq recurse$1(FileStatus status, FileSystem fs$1) {
        Tuple2 tuple2 = Predef$.MODULE$.refArrayOps((Object[])fs$1.listStatus(status.getPath())).partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$4) {
                return x$4.isDirectory();
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            FileStatus[] directories = (FileStatus[])tuple2._1();
            FileStatus[] leaves = (FileStatus[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)directories, (Object)leaves);
            FileStatus[] directories2 = (FileStatus[])tuple23._1();
            FileStatus[] leaves2 = (FileStatus[])tuple23._2();
            return (Seq)Predef$.MODULE$.refArrayOps((Object[])leaves2).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])directories2).flatMap((Function1)new Serializable(this, fs$1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkHadoopUtil $outer;
                private final FileSystem fs$1;

                public final Seq<FileStatus> apply(FileStatus f) {
                    return this.$outer.listLeafStatuses(this.fs$1, f);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fs$1 = fs$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)))), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        throw new MatchError((Object)tuple2);
    }

    private final Seq recurse$2(FileStatus status, FileSystem fs$2) {
        Tuple2 tuple2 = Predef$.MODULE$.refArrayOps((Object[])fs$2.listStatus(status.getPath())).partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$6) {
                return x$6.isDirectory();
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            FileStatus[] directories = (FileStatus[])tuple2._1();
            FileStatus[] files = (FileStatus[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)directories, (Object)files);
            FileStatus[] directories2 = (FileStatus[])tuple23._1();
            FileStatus[] files2 = (FileStatus[])tuple23._2();
            Seq leaves = Predef$.MODULE$.refArrayOps((Object[])directories2).isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{status})) : (Seq)Seq$.MODULE$.empty();
            return (Seq)leaves.$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])directories2).flatMap((Function1)new Serializable(this, fs$2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkHadoopUtil $outer;
                private final FileSystem fs$2;

                public final Seq<FileStatus> apply(FileStatus dir) {
                    return this.$outer.listLeafDirStatuses(this.fs$2, dir);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fs$2 = fs$2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)))), Seq$.MODULE$.canBuildFrom());
        }
        throw new MatchError((Object)tuple2);
    }

    public SparkHadoopUtil() {
        Logging$class.$init$(this);
        this.sparkConf = new SparkConf(false).loadFromSystemProperties(true);
        this.conf = this.newConfiguration(this.sparkConf());
        UserGroupInformation.setConfiguration((Configuration)this.conf());
        this.org$apache$spark$deploy$SparkHadoopUtil$$HADOOP_CONF_PATTERN = new StringOps(Predef$.MODULE$.augmentString("(\\$\\{hadoopconf-[^\\}\\$\\s]+\\})")).r().unanchored();
    }
}

