/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.scheduler.EventLoggingListener$;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.scheduler.SparkListenerEnvironmentUpdate;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorMetricsUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskGettingResult;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD;
import org.apache.spark.util.JsonProtocol$;
import org.apache.spark.util.Utils$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\rec!B\u0001\u0003\u0001\u0011Q!\u0001F#wK:$Hj\\4hS:<G*[:uK:,'O\u0003\u0002\u0004\t\u0005I1o\u00195fIVdWM\u001d\u0006\u0003\u000b\u0019\tQa\u001d9be.T!a\u0002\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0011aA8sON\u0019\u0001aC\b\u0011\u00051iQ\"\u0001\u0002\n\u00059\u0011!!D*qCJ\\G*[:uK:,'\u000f\u0005\u0002\u0011'5\t\u0011C\u0003\u0002\u0013\t\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u0015#\t9Aj\\4hS:<\u0007\u0002\u0003\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\u000b\u0005\u0004\b/\u00133\u0004\u0001A\u0011\u0011d\b\b\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011adG\u0001\u0007!J,G-\u001a4\n\u0005\u0001\n#AB*ue&twM\u0003\u0002\u001f7!A1\u0005\u0001B\u0001B\u0003%A%\u0001\u0007baB\fE\u000f^3naRLE\rE\u0002\u001bKaI!AJ\u000e\u0003\r=\u0003H/[8o\u0011!A\u0003A!A!\u0002\u0013I\u0013A\u00037pO\n\u000b7/\u001a#jeB\u0011!fL\u0007\u0002W)\u0011A&L\u0001\u0004]\u0016$(\"\u0001\u0018\u0002\t)\fg/Y\u0005\u0003a-\u00121!\u0016*J\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0014!C:qCJ\\7i\u001c8g!\t!T'D\u0001\u0005\u0013\t1DAA\u0005Ta\u0006\u00148nQ8oM\"A\u0001\b\u0001B\u0001B\u0003%\u0011(\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\"AO \u000e\u0003mR!\u0001P\u001f\u0002\t\r|gN\u001a\u0006\u0003}\u0019\ta\u0001[1e_>\u0004\u0018B\u0001!<\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")!\t\u0001C\u0001\u0007\u00061A(\u001b8jiz\"b\u0001R#G\u000f\"K\u0005C\u0001\u0007\u0001\u0011\u00151\u0012\t1\u0001\u0019\u0011\u0015\u0019\u0013\t1\u0001%\u0011\u0015A\u0013\t1\u0001*\u0011\u0015\u0011\u0014\t1\u00014\u0011\u0015A\u0014\t1\u0001:\u0011\u0015\u0011\u0005\u0001\"\u0001L)\u0015!E*\u0014(P\u0011\u00151\"\n1\u0001\u0019\u0011\u0015\u0019#\n1\u0001%\u0011\u0015A#\n1\u0001*\u0011\u0015\u0011$\n1\u00014\u0011\u001d\t\u0006A1A\u0005\nI\u000bab\u001d5pk2$7i\\7qe\u0016\u001c8/F\u0001T!\tQB+\u0003\u0002V7\t9!i\\8mK\u0006t\u0007BB,\u0001A\u0003%1+A\btQ>,H\u000eZ\"p[B\u0014Xm]:!\u0011\u001dI\u0006A1A\u0005\nI\u000bqb\u001d5pk2$wJ^3soJLG/\u001a\u0005\u00077\u0002\u0001\u000b\u0011B*\u0002!MDw.\u001e7e\u001fZ,'o\u001e:ji\u0016\u0004\u0003bB/\u0001\u0005\u0004%IAU\u0001\bi\u0016\u001cH/\u001b8h\u0011\u0019y\u0006\u0001)A\u0005'\u0006AA/Z:uS:<\u0007\u0005C\u0004b\u0001\t\u0007I\u0011\u00022\u0002!=,H\u000f];u\u0005V4g-\u001a:TSj,W#A2\u0011\u0005i!\u0017BA3\u001c\u0005\rIe\u000e\u001e\u0005\u0007O\u0002\u0001\u000b\u0011B2\u0002#=,H\u000f];u\u0005V4g-\u001a:TSj,\u0007\u0005C\u0004j\u0001\t\u0007I\u0011\u00026\u0002\u0015\u0019LG.Z*zgR,W.F\u0001l!\taw.D\u0001n\u0015\tqW(\u0001\u0002gg&\u0011\u0001/\u001c\u0002\u000b\r&dWmU=ti\u0016l\u0007B\u0002:\u0001A\u0003%1.A\u0006gS2,7+_:uK6\u0004\u0003b\u0002;\u0001\u0005\u0004%I!^\u0001\u0011G>l\u0007O]3tg&|gnQ8eK\u000e,\u0012A\u001e\t\u00045\u0015:\bC\u0001=|\u001b\u0005I(B\u0001>\u0005\u0003\tIw.\u0003\u0002}s\n\u00012i\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0005\u0007}\u0002\u0001\u000b\u0011\u0002<\u0002#\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007\u0005C\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0003\u0002\u0004\u0005!2m\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019(b[\u0016,\u0012\u0001\n\u0005\b\u0003\u000f\u0001\u0001\u0015!\u0003%\u0003U\u0019w.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7MT1nK\u0002B\u0011\"a\u0003\u0001\u0001\u0004%I!!\u0004\u0002!!\fGm\\8q\t\u0006$\u0018m\u0015;sK\u0006lWCAA\b!\u0011QR%!\u0005\u0011\u00071\f\u0019\"C\u0002\u0002\u00165\u0014!CR*ECR\fw*\u001e;qkR\u001cFO]3b[\"I\u0011\u0011\u0004\u0001A\u0002\u0013%\u00111D\u0001\u0015Q\u0006$wn\u001c9ECR\f7\u000b\u001e:fC6|F%Z9\u0015\t\u0005u\u00111\u0005\t\u00045\u0005}\u0011bAA\u00117\t!QK\\5u\u0011)\t)#a\u0006\u0002\u0002\u0003\u0007\u0011qB\u0001\u0004q\u0012\n\u0004\u0002CA\u0015\u0001\u0001\u0006K!a\u0004\u0002#!\fGm\\8q\t\u0006$\u0018m\u0015;sK\u0006l\u0007\u0005C\u0005\u0002.\u0001\u0001\r\u0011\"\u0003\u00020\u00051qO]5uKJ,\"!!\r\u0011\ti)\u00131\u0007\t\u0005\u0003k\tI$\u0004\u0002\u00028)\u0011!0L\u0005\u0005\u0003w\t9DA\u0006Qe&tGo\u0016:ji\u0016\u0014\b\"CA \u0001\u0001\u0007I\u0011BA!\u0003)9(/\u001b;fe~#S-\u001d\u000b\u0005\u0003;\t\u0019\u0005\u0003\u0006\u0002&\u0005u\u0012\u0011!a\u0001\u0003cA\u0001\"a\u0012\u0001A\u0003&\u0011\u0011G\u0001\boJLG/\u001a:!\u0011)\tY\u0005\u0001b\u0001\n\u0003\u0011\u0011QJ\u0001\rY><w-\u001a3Fm\u0016tGo]\u000b\u0003\u0003\u001f\u0002b!!\u0015\u0002\\\u0005}SBAA*\u0015\u0011\t)&a\u0016\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011L\u000e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002^\u0005M#aC!se\u0006L()\u001e4gKJ\u0004B!!\u0019\u0002z9!\u00111MA:\u001d\u0011\t)'a\u001c\u000f\t\u0005\u001d\u0014QN\u0007\u0003\u0003SR1!a\u001b\u0018\u0003\u0019a$o\\8u}%\t\u0011\"C\u0002\u0002r!\taA[:p]R\u001a\u0018\u0002BA;\u0003o\nqAS:p]\u0006\u001bFKC\u0002\u0002r!IA!a\u001f\u0002~\t1!JV1mk\u0016TA!!\u001e\u0002x!A\u0011\u0011\u0011\u0001!\u0002\u0013\ty%A\u0007m_\u001e<W\rZ#wK:$8\u000f\t\u0005\u000b\u0003\u000b\u0003!\u0019!C\u0001\u0005\u0005\u001d\u0015a\u00027pOB\u000bG\u000f[\u000b\u00021!9\u00111\u0012\u0001!\u0002\u0013A\u0012\u0001\u00037pOB\u000bG\u000f\u001b\u0011\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\u0006)1\u000f^1siR\u0011\u0011Q\u0004\u0005\b\u0003+\u0003A\u0011BAL\u0003!awnZ#wK:$HCBA\u000f\u00033\u000b\u0019\u000b\u0003\u0005\u0002\u001c\u0006M\u0005\u0019AAO\u0003\u0015)g/\u001a8u!\ra\u0011qT\u0005\u0004\u0003C\u0013!AE*qCJ\\G*[:uK:,'/\u0012<f]RD\u0011\"!*\u0002\u0014B\u0005\t\u0019A*\u0002\u0017\u0019dWo\u001d5M_\u001e<WM\u001d\u0005\b\u0003S\u0003A\u0011IAV\u0003Aygn\u0015;bO\u0016\u001cVOY7jiR,G\r\u0006\u0003\u0002\u001e\u00055\u0006\u0002CAN\u0003O\u0003\r!a,\u0011\u00071\t\t,C\u0002\u00024\n\u00111d\u00159be.d\u0015n\u001d;f]\u0016\u00148\u000b^1hKN+(-\\5ui\u0016$\u0007bBA\\\u0001\u0011\u0005\u0013\u0011X\u0001\f_:$\u0016m]6Ti\u0006\u0014H\u000f\u0006\u0003\u0002\u001e\u0005m\u0006\u0002CAN\u0003k\u0003\r!!0\u0011\u00071\ty,C\u0002\u0002B\n\u0011ac\u00159be.d\u0015n\u001d;f]\u0016\u0014H+Y:l'R\f'\u000f\u001e\u0005\b\u0003\u000b\u0004A\u0011IAd\u0003Myg\u000eV1tW\u001e+G\u000f^5oOJ+7/\u001e7u)\u0011\ti\"!3\t\u0011\u0005m\u00151\u0019a\u0001\u0003\u0017\u00042\u0001DAg\u0013\r\tyM\u0001\u0002\u001f'B\f'o\u001b'jgR,g.\u001a:UCN\\w)\u001a;uS:<'+Z:vYRDq!a5\u0001\t\u0003\n).A\u0005p]R\u000b7o[#oIR!\u0011QDAl\u0011!\tY*!5A\u0002\u0005e\u0007c\u0001\u0007\u0002\\&\u0019\u0011Q\u001c\u0002\u0003)M\u0003\u0018M]6MSN$XM\\3s)\u0006\u001c8.\u00128e\u0011\u001d\t\t\u000f\u0001C!\u0003G\f1c\u001c8F]ZL'o\u001c8nK:$X\u000b\u001d3bi\u0016$B!!\b\u0002f\"A\u00111TAp\u0001\u0004\t9\u000fE\u0002\r\u0003SL1!a;\u0003\u0005y\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe\u0016sg/\u001b:p]6,g\u000e^+qI\u0006$X\rC\u0004\u0002p\u0002!\t%!=\u0002!=t7\u000b^1hK\u000e{W\u000e\u001d7fi\u0016$G\u0003BA\u000f\u0003gD\u0001\"a'\u0002n\u0002\u0007\u0011Q\u001f\t\u0004\u0019\u0005]\u0018bAA}\u0005\tY2\u000b]1sW2K7\u000f^3oKJ\u001cF/Y4f\u0007>l\u0007\u000f\\3uK\u0012Dq!!@\u0001\t\u0003\ny0\u0001\u0006p]*{'m\u0015;beR$B!!\b\u0003\u0002!A\u00111TA~\u0001\u0004\u0011\u0019\u0001E\u0002\r\u0005\u000bI1Aa\u0002\u0003\u0005U\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe*{'m\u0015;beRDqAa\u0003\u0001\t\u0003\u0012i!\u0001\u0005p]*{'-\u00128e)\u0011\tiBa\u0004\t\u0011\u0005m%\u0011\u0002a\u0001\u0005#\u00012\u0001\u0004B\n\u0013\r\u0011)B\u0001\u0002\u0014'B\f'o\u001b'jgR,g.\u001a:K_\n,e\u000e\u001a\u0005\b\u00053\u0001A\u0011\tB\u000e\u0003MygN\u00117pG.l\u0015M\\1hKJ\fE\rZ3e)\u0011\tiB!\b\t\u0011\u0005m%q\u0003a\u0001\u0005?\u00012\u0001\u0004B\u0011\u0013\r\u0011\u0019C\u0001\u0002\u001f'B\f'o\u001b'jgR,g.\u001a:CY>\u001c7.T1oC\u001e,'/\u00113eK\u0012DqAa\n\u0001\t\u0003\u0012I#A\u000bp]\ncwnY6NC:\fw-\u001a:SK6|g/\u001a3\u0015\t\u0005u!1\u0006\u0005\t\u00037\u0013)\u00031\u0001\u0003.A\u0019ABa\f\n\u0007\tE\"A\u0001\u0011Ta\u0006\u00148\u000eT5ti\u0016tWM\u001d\"m_\u000e\\W*\u00198bO\u0016\u0014(+Z7pm\u0016$\u0007b\u0002B\u001b\u0001\u0011\u0005#qG\u0001\u000f_:,f\u000e]3sg&\u001cHO\u0015#E)\u0011\tiB!\u000f\t\u0011\u0005m%1\u0007a\u0001\u0005w\u00012\u0001\u0004B\u001f\u0013\r\u0011yD\u0001\u0002\u001a'B\f'o\u001b'jgR,g.\u001a:V]B,'o]5tiJ#E\tC\u0004\u0003D\u0001!\tE!\u0012\u0002%=t\u0017\t\u001d9mS\u000e\fG/[8o'R\f'\u000f\u001e\u000b\u0005\u0003;\u00119\u0005\u0003\u0005\u0002\u001c\n\u0005\u0003\u0019\u0001B%!\ra!1J\u0005\u0004\u0005\u001b\u0012!!H*qCJ\\G*[:uK:,'/\u00119qY&\u001c\u0017\r^5p]N#\u0018M\u001d;\t\u000f\tE\u0003\u0001\"\u0011\u0003T\u0005\u0001rN\\!qa2L7-\u0019;j_:,e\u000e\u001a\u000b\u0005\u0003;\u0011)\u0006\u0003\u0005\u0002\u001c\n=\u0003\u0019\u0001B,!\ra!\u0011L\u0005\u0004\u00057\u0012!aG*qCJ\\G*[:uK:,'/\u00119qY&\u001c\u0017\r^5p]\u0016sG\rC\u0004\u0003`\u0001!\tE!\u0019\u0002\u001f=tW\t_3dkR|'/\u00113eK\u0012$B!!\b\u0003d!A\u00111\u0014B/\u0001\u0004\u0011)\u0007E\u0002\r\u0005OJ1A!\u001b\u0003\u0005i\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe\u0016CXmY;u_J\fE\rZ3e\u0011\u001d\u0011i\u0007\u0001C!\u0005_\n\u0011c\u001c8Fq\u0016\u001cW\u000f^8s%\u0016lwN^3e)\u0011\tiB!\u001d\t\u0011\u0005m%1\u000ea\u0001\u0005g\u00022\u0001\u0004B;\u0013\r\u00119H\u0001\u0002\u001d'B\f'o\u001b'jgR,g.\u001a:Fq\u0016\u001cW\u000f^8s%\u0016lwN^3e\u0011\u001d\u0011Y\b\u0001C!\u0005{\nab\u001c8CY>\u001c7.\u00169eCR,G\r\u0006\u0003\u0002\u001e\t}\u0004\u0002CAN\u0005s\u0002\rA!!\u0011\u00071\u0011\u0019)C\u0002\u0003\u0006\n\u0011\u0011d\u00159be.d\u0015n\u001d;f]\u0016\u0014(\t\\8dWV\u0003H-\u0019;fI\"9!\u0011\u0012\u0001\u0005B\t-\u0015aF8o\u000bb,7-\u001e;pe6+GO]5dgV\u0003H-\u0019;f)\u0011\tiB!$\t\u0011\u0005m%q\u0011a\u0001\u0005\u001f\u00032\u0001\u0004BI\u0013\r\u0011\u0019J\u0001\u0002#'B\f'o\u001b'jgR,g.\u001a:Fq\u0016\u001cW\u000f^8s\u001b\u0016$(/[2t+B$\u0017\r^3\t\u000f\t]\u0005\u0001\"\u0011\u0003\u001a\u0006aqN\\(uQ\u0016\u0014XI^3oiR!\u0011Q\u0004BN\u0011!\tYJ!&A\u0002\u0005u\u0005b\u0002BP\u0001\u0011\u0005\u0011\u0011S\u0001\u0005gR|\u0007\u000fC\u0005\u0003$\u0002\t\n\u0011\"\u0003\u0003&\u0006\u0011Bn\\4Fm\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u00119KK\u0002T\u0005S[#Aa+\u0011\t\t5&qW\u0007\u0003\u0005_SAA!-\u00034\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005k[\u0012AC1o]>$\u0018\r^5p]&!!\u0011\u0018BX\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0004\t\u0005{\u0013\u0001\u0012\u0001\u0003\u0003@\u0006!RI^3oi2{wmZ5oO2K7\u000f^3oKJ\u00042\u0001\u0004Ba\r\u001d\t!\u0001#\u0001\u0005\u0005\u0007\u001cRA!1\u0003F>\u00012A\u0007Bd\u0013\r\u0011Im\u0007\u0002\u0007\u0003:L(+\u001a4\t\u000f\t\u0013\t\r\"\u0001\u0003NR\u0011!q\u0018\u0005\u000b\u0005#\u0014\tM1A\u0005\u0002\tM\u0017aC%O?B\u0013vj\u0012*F'N+\"A!6\u0011\t\t]'Q\\\u0007\u0003\u00053T1Aa7.\u0003\u0011a\u0017M\\4\n\u0007\u0001\u0012I\u000eC\u0005\u0003b\n\u0005\u0007\u0015!\u0003\u0003V\u0006a\u0011JT0Q%>;%+R*TA!Q!Q\u001dBa\u0005\u0004%\tAa5\u0002\u001f\u0011+e)Q+M)~cujR0E\u0013JC\u0011B!;\u0003B\u0002\u0006IA!6\u0002!\u0011+e)Q+M)~cujR0E\u0013J\u0003\u0003B\u0003Bw\u0005\u0003\u0014\r\u0011\"\u0003\u0003p\u0006!BjT$`\r&cUi\u0018)F%6K5kU%P\u001dN+\"A!=\u0011\t\tM(\u0011`\u0007\u0003\u0005kT1Aa>n\u0003)\u0001XM]7jgNLwN\\\u0005\u0005\u0005w\u0014)P\u0001\u0007GgB+'/\\5tg&|g\u000eC\u0005\u0003\u0000\n\u0005\u0007\u0015!\u0003\u0003r\u0006)BjT$`\r&cUi\u0018)F%6K5kU%P\u001dN\u0003\u0003BCB\u0002\u0005\u0003\u0014\r\u0011\"\u0003\u0004\u0006\u0005A1m\u001c3fG6\u000b\u0007/\u0006\u0002\u0004\bA1\u0011\u0011KB\u00051]LAaa\u0003\u0002T\t9\u0001*Y:i\u001b\u0006\u0004\b\"CB\b\u0005\u0003\u0004\u000b\u0011BB\u0004\u0003%\u0019w\u000eZ3d\u001b\u0006\u0004\b\u0005\u0003\u0005\u0004\u0014\t\u0005G\u0011AB\u000b\u00031Ig.\u001b;Fm\u0016tG\u000fT8h)\u0011\tiba\u0006\t\u0011\re1\u0011\u0003a\u0001\u00077\t\u0011\u0002\\8h'R\u0014X-Y7\u0011\t\u0005U2QD\u0005\u0005\u0007?\t9D\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0005\u0004$\t\u0005G\u0011AB\u0013\u0003)9W\r\u001e'pOB\u000bG\u000f\u001b\u000b\n1\r\u001d2\u0011FB\u0016\u0007[Aa\u0001KB\u0011\u0001\u0004I\u0003B\u0002\f\u0004\"\u0001\u0007\u0001\u0004\u0003\u0004$\u0007C\u0001\r\u0001\n\u0005\n\u0003\u0003\u0019\t\u0003%AA\u0002\u0011B\u0001b!\r\u0003B\u0012%11G\u0001\tg\u0006t\u0017\u000e^5{KR\u0019\u0001d!\u000e\t\u000f\r]2q\u0006a\u00011\u0005\u00191\u000f\u001e:\t\u0011\rm\"\u0011\u0019C\u0001\u0007{\tAb\u001c9f]\u00163XM\u001c;M_\u001e$baa\u0010\u0004F\r=\u0003\u0003BA\u001b\u0007\u0003JAaa\u0011\u00028\tY\u0011J\u001c9viN#(/Z1n\u0011!\u00199e!\u000fA\u0002\r%\u0013a\u00017pOB\u0019Ana\u0013\n\u0007\r5SN\u0001\u0003QCRD\u0007B\u00028\u0004:\u0001\u00071\u000e\u0003\u0006\u0004T\t\u0005\u0017\u0013!C\u0001\u0007+\nAcZ3u\u0019><\u0007+\u0019;iI\u0011,g-Y;mi\u0012\"TCAB,U\r!#\u0011\u0016")
public class EventLoggingListener
extends SparkListener
implements Logging {
    private final URI logBaseDir;
    private final Configuration hadoopConf;
    private final boolean shouldCompress;
    private final boolean shouldOverwrite;
    private final boolean testing;
    private final int outputBufferSize;
    private final FileSystem fileSystem;
    private final Option<CompressionCodec> compressionCodec;
    private final Option<String> compressionCodecName;
    private Option<FSDataOutputStream> hadoopDataStream;
    private Option<PrintWriter> writer;
    private final ArrayBuffer<JsonAST.JValue> loggedEvents;
    private final String logPath;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private transient int org$apache$spark$internal$Logging$$levelFlags;

    public static Option<String> getLogPath$default$4() {
        return EventLoggingListener$.MODULE$.getLogPath$default$4();
    }

    public static InputStream openEventLog(Path path, FileSystem fileSystem) {
        return EventLoggingListener$.MODULE$.openEventLog(path, fileSystem);
    }

    public static String getLogPath(URI uRI, String string, Option<String> option, Option<String> option2) {
        return EventLoggingListener$.MODULE$.getLogPath(uRI, string, option, option2);
    }

    public static void initEventLog(OutputStream outputStream) {
        EventLoggingListener$.MODULE$.initEventLog(outputStream);
    }

    public static String DEFAULT_LOG_DIR() {
        return EventLoggingListener$.MODULE$.DEFAULT_LOG_DIR();
    }

    public static String IN_PROGRESS() {
        return EventLoggingListener$.MODULE$.IN_PROGRESS();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public int org$apache$spark$internal$Logging$$levelFlags() {
        return this.org$apache$spark$internal$Logging$$levelFlags;
    }

    @Override
    public void org$apache$spark$internal$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$internal$Logging$$levelFlags = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public final boolean isInfoEnabled() {
        return Logging$class.isInfoEnabled(this);
    }

    @Override
    public final boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public final boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    private boolean shouldCompress() {
        return this.shouldCompress;
    }

    private boolean shouldOverwrite() {
        return this.shouldOverwrite;
    }

    private boolean testing() {
        return this.testing;
    }

    private int outputBufferSize() {
        return this.outputBufferSize;
    }

    private FileSystem fileSystem() {
        return this.fileSystem;
    }

    private Option<CompressionCodec> compressionCodec() {
        return this.compressionCodec;
    }

    private Option<String> compressionCodecName() {
        return this.compressionCodecName;
    }

    private Option<FSDataOutputStream> hadoopDataStream() {
        return this.hadoopDataStream;
    }

    private void hadoopDataStream_$eq(Option<FSDataOutputStream> x$1) {
        this.hadoopDataStream = x$1;
    }

    private Option<PrintWriter> writer() {
        return this.writer;
    }

    private void writer_$eq(Option<PrintWriter> x$1) {
        this.writer = x$1;
    }

    public ArrayBuffer<JsonAST.JValue> loggedEvents() {
        return this.loggedEvents;
    }

    public String logPath() {
        return this.logPath;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void start() {
        block8: {
            if (!this.fileSystem().getFileStatus(new Path(this.logBaseDir)).isDirectory()) break block8;
            workingPath = new StringBuilder().append((Object)this.logPath()).append((Object)EventLoggingListener$.MODULE$.IN_PROGRESS()).toString();
            uri = new URI(workingPath);
            path = new Path(workingPath);
            defaultFs = FileSystem.getDefaultUri((Configuration)this.hadoopConf).getScheme();
            if (defaultFs == null) ** GOTO lbl-1000
            v0 = defaultFs;
            var6_5 = "file";
            if (!(v0 != null ? v0.equals(var6_5) == false : var6_5 != null)) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = isDefaultLocal = false;
            }
            if (this.shouldOverwrite() && this.fileSystem().exists(path)) {
                this.logWarning((Function0<String>)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final Path path$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Event log ", " already exists. Overwriting..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                    }
                    {
                        this.path$1 = path$1;
                    }
                });
                if (!this.fileSystem().delete(path, true)) {
                    this.logWarning((Function0<String>)new Serializable(this, path){
                        public static final long serialVersionUID = 0L;
                        private final Path path$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                        }
                        {
                            this.path$1 = path$1;
                        }
                    });
                }
            }
            if (isDefaultLocal && uri.getScheme() == null) ** GOTO lbl-1000
            v2 = uri.getScheme();
            var8_7 = "file";
            if (!(v2 != null ? v2.equals(var8_7) == false : var8_7 != null)) lbl-1000:
            // 2 sources

            {
                v3 /* !! */  = new FileOutputStream(uri.getPath());
            } else {
                this.hadoopDataStream_$eq((Option<FSDataOutputStream>)new Some((Object)this.fileSystem().create(path)));
                v3 /* !! */  = (OutputStream)this.hadoopDataStream().get();
            }
            dstream = v3 /* !! */ ;
            try {
                cstream = (OutputStream)this.compressionCodec().map((Function1)new Serializable(this, dstream){
                    public static final long serialVersionUID = 0L;
                    private final OutputStream dstream$1;

                    public final OutputStream apply(CompressionCodec x$1) {
                        return x$1.compressedOutputStream(this.dstream$1);
                    }
                    {
                        this.dstream$1 = dstream$1;
                    }
                }).getOrElse((Function0)new Serializable(this, dstream){
                    public static final long serialVersionUID = 0L;
                    private final OutputStream dstream$1;

                    public final OutputStream apply() {
                        return this.dstream$1;
                    }
                    {
                        this.dstream$1 = dstream$1;
                    }
                });
                bstream = new BufferedOutputStream(cstream, this.outputBufferSize());
                EventLoggingListener$.MODULE$.initEventLog(bstream);
                this.fileSystem().setPermission(path, EventLoggingListener$.MODULE$.org$apache$spark$scheduler$EventLoggingListener$$LOG_FILE_PERMISSIONS());
                this.writer_$eq((Option<PrintWriter>)new Some((Object)new PrintWriter(bstream)));
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ EventLoggingListener $outer;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Logging events to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.logPath()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return;
            }
            catch (Exception var9_11) {
                dstream.close();
                throw var9_11;
            }
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log directory ", " does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logBaseDir})));
    }

    private void logEvent(SparkListenerEvent event, boolean flushLogger) {
        JsonAST.JValue eventJson = JsonProtocol$.MODULE$.sparkEventToJson(event);
        this.writer().foreach((Function1)new Serializable(this, eventJson){
            public static final long serialVersionUID = 0L;
            private final JsonAST.JValue eventJson$1;

            public final void apply(PrintWriter x$2) {
                JsonAST.JValue x$8 = this.eventJson$1;
                Formats x$9 = JsonMethods$.MODULE$.render$default$2(x$8);
                x$2.println(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$8, x$9)));
            }
            {
                this.eventJson$1 = eventJson$1;
            }
        });
        if (flushLogger) {
            this.writer().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(PrintWriter x$3) {
                    x$3.flush();
                }
            });
            this.hadoopDataStream().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(FSDataOutputStream x$4) {
                    x$4.hflush();
                }
            });
        }
        if (this.testing()) {
            this.loggedEvents().$plus$eq((Object)eventJson);
        }
    }

    private boolean logEvent$default$2() {
        return false;
    }

    @Override
    public void onStageSubmitted(SparkListenerStageSubmitted event) {
        this.logEvent(event, this.logEvent$default$2());
    }

    @Override
    public void onTaskStart(SparkListenerTaskStart event) {
        this.logEvent(event, this.logEvent$default$2());
    }

    @Override
    public void onTaskGettingResult(SparkListenerTaskGettingResult event) {
        this.logEvent(event, this.logEvent$default$2());
    }

    @Override
    public void onTaskEnd(SparkListenerTaskEnd event) {
        this.logEvent(event, this.logEvent$default$2());
    }

    @Override
    public void onEnvironmentUpdate(SparkListenerEnvironmentUpdate event) {
        this.logEvent(event, this.logEvent$default$2());
    }

    @Override
    public void onStageCompleted(SparkListenerStageCompleted event) {
        this.logEvent(event, true);
    }

    @Override
    public void onJobStart(SparkListenerJobStart event) {
        this.logEvent(event, true);
    }

    @Override
    public void onJobEnd(SparkListenerJobEnd event) {
        this.logEvent(event, true);
    }

    @Override
    public void onBlockManagerAdded(SparkListenerBlockManagerAdded event) {
        this.logEvent(event, true);
    }

    @Override
    public void onBlockManagerRemoved(SparkListenerBlockManagerRemoved event) {
        this.logEvent(event, true);
    }

    @Override
    public void onUnpersistRDD(SparkListenerUnpersistRDD event) {
        this.logEvent(event, true);
    }

    @Override
    public void onApplicationStart(SparkListenerApplicationStart event) {
        this.logEvent(event, true);
    }

    @Override
    public void onApplicationEnd(SparkListenerApplicationEnd event) {
        this.logEvent(event, true);
    }

    @Override
    public void onExecutorAdded(SparkListenerExecutorAdded event) {
        this.logEvent(event, true);
    }

    @Override
    public void onExecutorRemoved(SparkListenerExecutorRemoved event) {
        this.logEvent(event, true);
    }

    @Override
    public void onBlockUpdated(SparkListenerBlockUpdated event) {
    }

    @Override
    public void onExecutorMetricsUpdate(SparkListenerExecutorMetricsUpdate event) {
    }

    @Override
    public void onOtherEvent(SparkListenerEvent event) {
        if (event.logEvent()) {
            this.logEvent(event, true);
        }
    }

    public void stop() {
        this.writer().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(PrintWriter x$5) {
                x$5.close();
            }
        });
        Path target = new Path(this.logPath());
        if (this.fileSystem().exists(target)) {
            if (this.shouldOverwrite()) {
                this.logWarning((Function0<String>)new Serializable(this, target){
                    public static final long serialVersionUID = 0L;
                    private final Path target$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Event log ", " already exists. Overwriting..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.target$1}));
                    }
                    {
                        this.target$1 = target$1;
                    }
                });
                if (!this.fileSystem().delete(target, true)) {
                    this.logWarning((Function0<String>)new Serializable(this, target){
                        public static final long serialVersionUID = 0L;
                        private final Path target$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.target$1}));
                        }
                        {
                            this.target$1 = target$1;
                        }
                    });
                }
            } else {
                throw new IOException(new StringOps(Predef$.MODULE$.augmentString("Target log file already exists (%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logPath()})));
            }
        }
        this.fileSystem().rename(new Path(new StringBuilder().append((Object)this.logPath()).append((Object)EventLoggingListener$.MODULE$.IN_PROGRESS()).toString()), target);
        try {
            this.fileSystem().setTimes(target, System.currentTimeMillis(), -1L);
        }
        catch (Exception exception2) {
            this.logDebug((Function0<String>)new Serializable(this, target){
                public static final long serialVersionUID = 0L;
                private final Path target$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed to set time of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.target$1}));
                }
                {
                    this.target$1 = target$1;
                }
            }, exception2);
        }
    }

    public EventLoggingListener(String appId, Option<String> appAttemptId, URI logBaseDir, SparkConf sparkConf, Configuration hadoopConf) {
        this.logBaseDir = logBaseDir;
        this.hadoopConf = hadoopConf;
        Logging$class.$init$(this);
        this.shouldCompress = sparkConf.getBoolean("spark.eventLog.compress", false);
        this.shouldOverwrite = sparkConf.getBoolean("spark.eventLog.overwrite", false);
        this.testing = sparkConf.getBoolean("spark.eventLog.testing", false);
        this.outputBufferSize = sparkConf.getInt("spark.eventLog.buffer.kb", 100) * 1024;
        this.fileSystem = Utils$.MODULE$.getHadoopFileSystem(logBaseDir, hadoopConf);
        this.compressionCodec = this.shouldCompress() ? new Some((Object)CompressionCodec$.MODULE$.createCodec(sparkConf)) : None$.MODULE$;
        this.compressionCodecName = this.compressionCodec().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(CompressionCodec c) {
                return CompressionCodec$.MODULE$.getShortName(c.getClass().getName());
            }
        });
        this.hadoopDataStream = None$.MODULE$;
        this.writer = None$.MODULE$;
        this.loggedEvents = new ArrayBuffer();
        this.logPath = EventLoggingListener$.MODULE$.getLogPath(logBaseDir, appId, appAttemptId, this.compressionCodecName());
    }

    public EventLoggingListener(String appId, Option<String> appAttemptId, URI logBaseDir, SparkConf sparkConf) {
        this(appId, appAttemptId, logBaseDir, sparkConf, SparkHadoopUtil$.MODULE$.get().newConfiguration(sparkConf));
    }
}

