/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import org.apache.spark.SparkConf;
import org.apache.spark.memory.ExecutionMemoryPool;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.StorageMemoryPool;
import org.apache.spark.memory.UnifiedMemoryManager$;
import org.apache.spark.storage.BlockId;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4Q!\u0001\u0002\u0001\t)\u0011A#\u00168jM&,G-T3n_JLX*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003\u0019iW-\\8ss*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0005\u0002\u0001\u0017A\u0011A\"D\u0007\u0002\u0005%\u0011aB\u0001\u0002\u000e\u001b\u0016lwN]=NC:\fw-\u001a:\t\u0011A\u0001!\u0011!Q\u0001\nI\tAaY8oM\u000e\u0001\u0001CA\n\u0015\u001b\u0005!\u0011BA\u000b\u0005\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u0005\u0018\u0001\t\u0015\r\u0011\"\u0001\u0019\u00035i\u0017\r\u001f%fCBlU-\\8ssV\t\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0003M_:<\u0007\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\r\u0002\u001d5\f\u0007\u0010S3ba6+Wn\u001c:zA!A!\u0005\u0001B\u0001B\u0003%\u0011$A\fp]\"+\u0017\r]*u_J\fw-\u001a*fO&|gnU5{K\"AA\u0005\u0001B\u0001B\u0003%Q%\u0001\u0005ok6\u001cuN]3t!\tQb%\u0003\u0002(7\t\u0019\u0011J\u001c;\t\r%\u0002A\u0011\u0001\u0002+\u0003\u0019a\u0014N\\5u}Q)1\u0006L\u0017/_A\u0011A\u0002\u0001\u0005\u0006!!\u0002\rA\u0005\u0005\u0006/!\u0002\r!\u0007\u0005\u0006E!\u0002\r!\u0007\u0005\u0006I!\u0002\r!\n\u0005\u0006c\u0001!IAM\u0001\u0011CN\u001cXM\u001d;J]Z\f'/[1oiN$\u0012a\r\t\u00035QJ!!N\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006o\u0001!\t\u0005G\u0001\u0017[\u0006DxJ\u001c%fCB\u001cFo\u001c:bO\u0016lU-\\8ss\"1\u0011\b\u0001C!\u0005i\na#Y2rk&\u0014X-\u0012=fGV$\u0018n\u001c8NK6|'/\u001f\u000b\u00053mjt\bC\u0003=q\u0001\u0007\u0011$\u0001\u0005ok6\u0014\u0015\u0010^3t\u0011\u0015q\u0004\b1\u0001\u001a\u00035!\u0018m]6BiR,W\u000e\u001d;JI\")\u0001\t\u000fa\u0001\u0003\u0006QQ.Z7peflu\u000eZ3\u0011\u00051\u0011\u0015BA\"\u0003\u0005)iU-\\8ss6{G-\u001a\u0005\u0006\u000b\u0002!\tER\u0001\u0015C\u000e\fX/\u001b:f'R|'/Y4f\u001b\u0016lwN]=\u0015\t\u001dS%k\u0015\t\u00035!K!!S\u000e\u0003\u000f\t{w\u000e\\3b]\")1\n\u0012a\u0001\u0019\u00069!\r\\8dW&#\u0007CA'Q\u001b\u0005q%BA(\u0005\u0003\u001d\u0019Ho\u001c:bO\u0016L!!\u0015(\u0003\u000f\tcwnY6JI\")A\b\u0012a\u00013!)\u0001\t\u0012a\u0001\u0003\")Q\u000b\u0001C!-\u0006\u0019\u0012mY9vSJ,WK\u001c:pY2lU-\\8ssR!qi\u0016-Z\u0011\u0015YE\u000b1\u0001M\u0011\u0015aD\u000b1\u0001\u001a\u0011\u0015\u0001E\u000b1\u0001B\u000f\u0015Y&\u0001#\u0001]\u0003Q)f.\u001b4jK\u0012lU-\\8ss6\u000bg.Y4feB\u0011A\"\u0018\u0004\u0006\u0003\tA\tAX\n\u0003;~\u0003\"A\u00071\n\u0005\u0005\\\"AB!osJ+g\rC\u0003*;\u0012\u00051\rF\u0001]\u0011\u001d)WL1A\u0005\n\u0019\fADU#T\u000bJ3V\tR0T3N#V)T0N\u000b6{%+W0C3R+5+F\u0001&\u0011\u0019AW\f)A\u0005K\u0005i\"+R*F%Z+EiX*Z'R+UjX'F\u001b>\u0013\u0016l\u0018\"Z)\u0016\u001b\u0006\u0005C\u0003k;\u0012\u00051.A\u0003baBd\u0017\u0010F\u0002,Y6DQ\u0001E5A\u0002IAQ\u0001J5A\u0002\u0015BQa\\/\u0005\nA\fAbZ3u\u001b\u0006DX*Z7pef$\"!G9\t\u000bAq\u0007\u0019\u0001\n")
public class UnifiedMemoryManager
extends MemoryManager {
    private final long maxHeapMemory;
    private final long onHeapStorageRegionSize;

    public static UnifiedMemoryManager apply(SparkConf sparkConf, int n) {
        return UnifiedMemoryManager$.MODULE$.apply(sparkConf, n);
    }

    public long maxHeapMemory() {
        return this.maxHeapMemory;
    }

    private void assertInvariants() {
        Predef$.MODULE$.assert(this.onHeapExecutionMemoryPool().poolSize() + this.onHeapStorageMemoryPool().poolSize() == this.maxHeapMemory());
        Predef$.MODULE$.assert(this.offHeapExecutionMemoryPool().poolSize() + this.offHeapStorageMemoryPool().poolSize() == this.maxOffHeapMemory());
    }

    @Override
    public synchronized long maxOnHeapStorageMemory() {
        return this.maxHeapMemory() - this.onHeapExecutionMemoryPool().memoryUsed();
    }

    @Override
    public synchronized long acquireExecutionMemory(long numBytes, long taskAttemptId, MemoryMode memoryMode) {
        MemoryMode memoryMode2;
        block6: {
            Tuple4 tuple4;
            block5: {
                block4: {
                    this.assertInvariants();
                    Predef$.MODULE$.assert(numBytes >= 0L);
                    memoryMode2 = memoryMode;
                    if (!((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) break block4;
                    tuple4 = new Tuple4((Object)this.onHeapExecutionMemoryPool(), (Object)this.onHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.onHeapStorageRegionSize), (Object)BoxesRunTime.boxToLong((long)this.maxHeapMemory()));
                    break block5;
                }
                if (!((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) break block6;
                tuple4 = new Tuple4((Object)this.offHeapExecutionMemoryPool(), (Object)this.offHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.offHeapStorageMemory()), (Object)BoxesRunTime.boxToLong((long)this.maxOffHeapMemory()));
            }
            Tuple4 tuple42 = tuple4;
            if (tuple42 != null) {
                Tuple4 tuple43;
                ExecutionMemoryPool executionPool = (ExecutionMemoryPool)tuple42._1();
                StorageMemoryPool storagePool = (StorageMemoryPool)tuple42._2();
                long storageRegionSize = BoxesRunTime.unboxToLong((Object)tuple42._3());
                long maxMemory = BoxesRunTime.unboxToLong((Object)tuple42._4());
                Tuple4 tuple44 = tuple43 = new Tuple4((Object)executionPool, (Object)storagePool, (Object)BoxesRunTime.boxToLong((long)storageRegionSize), (Object)BoxesRunTime.boxToLong((long)maxMemory));
                ExecutionMemoryPool executionPool2 = (ExecutionMemoryPool)tuple44._1();
                StorageMemoryPool storagePool2 = (StorageMemoryPool)tuple44._2();
                long storageRegionSize2 = BoxesRunTime.unboxToLong((Object)tuple44._3());
                long maxMemory2 = BoxesRunTime.unboxToLong((Object)tuple44._4());
                return executionPool2.acquireMemory(numBytes, taskAttemptId, (Function1<Object, BoxedUnit>)new Serializable(this, executionPool2, storagePool2, storageRegionSize2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ UnifiedMemoryManager $outer;
                    private final ExecutionMemoryPool executionPool$1;
                    private final StorageMemoryPool storagePool$1;
                    private final long storageRegionSize$1;

                    public final void apply(long extraMemoryNeeded) {
                        this.apply$mcVJ$sp(extraMemoryNeeded);
                    }

                    public void apply$mcVJ$sp(long extraMemoryNeeded) {
                        this.$outer.org$apache$spark$memory$UnifiedMemoryManager$$maybeGrowExecutionPool$1(extraMemoryNeeded, this.executionPool$1, this.storagePool$1, this.storageRegionSize$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionPool$1 = executionPool$1;
                        this.storagePool$1 = storagePool$1;
                        this.storageRegionSize$1 = storageRegionSize$1;
                    }
                }, (Function0<Object>)new Serializable(this, storagePool2, storageRegionSize2, maxMemory2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ UnifiedMemoryManager $outer;
                    private final StorageMemoryPool storagePool$1;
                    private final long storageRegionSize$1;
                    private final long maxMemory$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.$outer.org$apache$spark$memory$UnifiedMemoryManager$$computeMaxExecutionPoolSize$1(this.storagePool$1, this.storageRegionSize$1, this.maxMemory$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.storagePool$1 = storagePool$1;
                        this.storageRegionSize$1 = storageRegionSize$1;
                        this.maxMemory$1 = maxMemory$1;
                    }
                });
            }
            throw new MatchError((Object)tuple42);
        }
        throw new MatchError((Object)memoryMode2);
    }

    @Override
    public synchronized boolean acquireStorageMemory(BlockId blockId, long numBytes, MemoryMode memoryMode) {
        MemoryMode memoryMode2;
        block8: {
            Tuple3 tuple3;
            block7: {
                block6: {
                    this.assertInvariants();
                    Predef$.MODULE$.assert(numBytes >= 0L);
                    memoryMode2 = memoryMode;
                    if (!((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) break block6;
                    tuple3 = new Tuple3((Object)this.onHeapExecutionMemoryPool(), (Object)this.onHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.maxOnHeapStorageMemory()));
                    break block7;
                }
                if (!((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) break block8;
                tuple3 = new Tuple3((Object)this.offHeapExecutionMemoryPool(), (Object)this.offHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.maxOffHeapMemory()));
            }
            Tuple3 tuple32 = tuple3;
            if (tuple32 != null) {
                Tuple3 tuple33;
                ExecutionMemoryPool executionPool = (ExecutionMemoryPool)tuple32._1();
                StorageMemoryPool storagePool = (StorageMemoryPool)tuple32._2();
                long maxMemory = BoxesRunTime.unboxToLong((Object)tuple32._3());
                Tuple3 tuple34 = tuple33 = new Tuple3((Object)executionPool, (Object)storagePool, (Object)BoxesRunTime.boxToLong((long)maxMemory));
                ExecutionMemoryPool executionPool2 = (ExecutionMemoryPool)tuple34._1();
                StorageMemoryPool storagePool2 = (StorageMemoryPool)tuple34._2();
                long maxMemory2 = BoxesRunTime.unboxToLong((Object)tuple34._3());
                if (numBytes > maxMemory2) {
                    this.logInfo((Function0<String>)new Serializable(this, blockId, numBytes, maxMemory2){
                        public static final long serialVersionUID = 0L;
                        private final BlockId blockId$1;
                        private final long numBytes$1;
                        private final long maxMemory$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will not store ", " as the required space (", " bytes) exceeds our "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1, BoxesRunTime.boxToLong((long)this.numBytes$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory limit (", " bytes)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.maxMemory$2)}))).toString();
                        }
                        {
                            this.blockId$1 = blockId$1;
                            this.numBytes$1 = numBytes$1;
                            this.maxMemory$2 = maxMemory$2;
                        }
                    });
                    return false;
                }
                if (numBytes > storagePool2.memoryFree()) {
                    long memoryBorrowedFromExecution = Math.min(executionPool2.memoryFree(), numBytes);
                    executionPool2.decrementPoolSize(memoryBorrowedFromExecution);
                    storagePool2.incrementPoolSize(memoryBorrowedFromExecution);
                }
                return storagePool2.acquireMemory(blockId, numBytes);
            }
            throw new MatchError((Object)tuple32);
        }
        throw new MatchError((Object)memoryMode2);
    }

    @Override
    public synchronized boolean acquireUnrollMemory(BlockId blockId, long numBytes, MemoryMode memoryMode) {
        return this.acquireStorageMemory(blockId, numBytes, memoryMode);
    }

    public final void org$apache$spark$memory$UnifiedMemoryManager$$maybeGrowExecutionPool$1(long extraMemoryNeeded, ExecutionMemoryPool executionPool$1, StorageMemoryPool storagePool$1, long storageRegionSize$1) {
        long memoryReclaimableFromStorage;
        if (extraMemoryNeeded > 0L && (memoryReclaimableFromStorage = package$.MODULE$.max(storagePool$1.memoryFree(), storagePool$1.poolSize() - storageRegionSize$1)) > 0L) {
            long spaceToReclaim = storagePool$1.freeSpaceToShrinkPool(package$.MODULE$.min(extraMemoryNeeded, memoryReclaimableFromStorage));
            storagePool$1.decrementPoolSize(spaceToReclaim);
            executionPool$1.incrementPoolSize(spaceToReclaim);
        }
    }

    public final long org$apache$spark$memory$UnifiedMemoryManager$$computeMaxExecutionPoolSize$1(StorageMemoryPool storagePool$1, long storageRegionSize$1, long maxMemory$1) {
        return maxMemory$1 - package$.MODULE$.min(storagePool$1.memoryUsed(), storageRegionSize$1);
    }

    public UnifiedMemoryManager(SparkConf conf, long maxHeapMemory, long onHeapStorageRegionSize, int numCores) {
        this.maxHeapMemory = maxHeapMemory;
        this.onHeapStorageRegionSize = onHeapStorageRegionSize;
        super(conf, numCores, onHeapStorageRegionSize, maxHeapMemory - onHeapStorageRegionSize);
        this.assertInvariants();
    }
}

