/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.apache.spark.SparkContext;
import org.apache.spark.SpillListener;
import org.apache.spark.TestUtils;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class TestUtils$ {
    public static final TestUtils$ MODULE$;
    private final JavaFileObject.Kind org$apache$spark$TestUtils$$SOURCE;

    static {
        new TestUtils$();
    }

    public URL createJarWithClasses(Seq<String> classNames, String toStringValue, Seq<Tuple2<String, String>> classNamesWithBase, Seq<URL> classpathUrls) {
        File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        Seq files1 = (Seq)classNames.map((Function1)new Serializable(toStringValue, classpathUrls, tempDir){
            public static final long serialVersionUID = 0L;
            private final String toStringValue$1;
            private final Seq classpathUrls$1;
            private final File tempDir$1;

            public final File apply(String name) {
                String x$4 = name;
                File x$5 = this.tempDir$1;
                String x$6 = this.toStringValue$1;
                Seq x$7 = this.classpathUrls$1;
                String x$8 = TestUtils$.MODULE$.createCompiledClass$default$4();
                return TestUtils$.MODULE$.createCompiledClass(x$4, x$5, x$6, x$8, (Seq<URL>)x$7);
            }
            {
                this.toStringValue$1 = toStringValue$1;
                this.classpathUrls$1 = classpathUrls$1;
                this.tempDir$1 = tempDir$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq files2 = (Seq)classNamesWithBase.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(toStringValue, classpathUrls, tempDir){
            public static final long serialVersionUID = 0L;
            private final String toStringValue$1;
            private final Seq classpathUrls$1;
            private final File tempDir$1;

            public final File apply(Tuple2<String, String> x$1) {
                Tuple2<String, String> tuple2 = x$1;
                if (tuple2 != null) {
                    String childName = (String)tuple2._1();
                    String baseName = (String)tuple2._2();
                    File file = TestUtils$.MODULE$.createCompiledClass(childName, this.tempDir$1, this.toStringValue$1, baseName, (Seq<URL>)this.classpathUrls$1);
                    return file;
                }
                throw new MatchError(tuple2);
            }
            {
                this.toStringValue$1 = toStringValue$1;
                this.classpathUrls$1 = classpathUrls$1;
                this.tempDir$1 = tempDir$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        File jarFile = new File(tempDir, new StringOps(Predef$.MODULE$.augmentString("testJar-%s.jar")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)System.currentTimeMillis())})));
        return this.createJar((Seq<File>)((Seq)files1.$plus$plus((GenTraversableOnce)files2, Seq$.MODULE$.canBuildFrom())), jarFile, this.createJar$default$3());
    }

    public URL createJarWithFiles(Map<String, String> files, File dir) {
        File tempDir = (File)Option$.MODULE$.apply((Object)dir).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply() {
                return Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            }
        });
        File jarFile = File.createTempFile("testJar", ".jar", tempDir);
        JarOutputStream jarStream = new JarOutputStream(new FileOutputStream(jarFile));
        files.foreach((Function1)new Serializable(jarStream){
            public static final long serialVersionUID = 0L;
            private final JarOutputStream jarStream$1;

            public final long apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    JarEntry entry = new JarEntry(k);
                    this.jarStream$1.putNextEntry(entry);
                    long l = ByteStreams.copy((InputStream)new ByteArrayInputStream(v.getBytes(StandardCharsets.UTF_8)), (OutputStream)this.jarStream$1);
                    return l;
                }
                throw new MatchError(tuple2);
            }
            {
                this.jarStream$1 = jarStream$1;
            }
        });
        jarStream.close();
        return jarFile.toURI().toURL();
    }

    public URL createJar(Seq<File> files, File jarFile, Option<String> directoryPrefix) {
        FileOutputStream jarFileStream = new FileOutputStream(jarFile);
        JarOutputStream jarStream = new JarOutputStream((OutputStream)jarFileStream, new Manifest());
        files.foreach((Function1)new Serializable(directoryPrefix, jarStream){
            public static final long serialVersionUID = 0L;
            private final Option directoryPrefix$1;
            private final JarOutputStream jarStream$2;

            public final void apply(File file) {
                JarEntry jarEntry = new JarEntry(((Object)Paths.get((String)this.directoryPrefix$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }), file.getName())).toString());
                this.jarStream$2.putNextEntry(jarEntry);
                FileInputStream in = new FileInputStream(file);
                ByteStreams.copy((InputStream)in, (OutputStream)this.jarStream$2);
                in.close();
            }
            {
                this.directoryPrefix$1 = directoryPrefix$1;
                this.jarStream$2 = jarStream$2;
            }
        });
        jarStream.close();
        jarFileStream.close();
        return jarFile.toURI().toURL();
    }

    public String createJarWithClasses$default$2() {
        return "";
    }

    public Seq<Tuple2<String, String>> createJarWithClasses$default$3() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Seq<URL> createJarWithClasses$default$4() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Option<String> createJar$default$3() {
        return None$.MODULE$;
    }

    public File createJarWithFiles$default$2() {
        return null;
    }

    public JavaFileObject.Kind org$apache$spark$TestUtils$$SOURCE() {
        return this.org$apache$spark$TestUtils$$SOURCE;
    }

    public URI org$apache$spark$TestUtils$$createURI(String name) {
        return URI.create(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string:///", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name.replace(".", "/"), this.org$apache$spark$TestUtils$$SOURCE().extension})));
    }

    public File createCompiledClass(String className, File destDir, TestUtils.JavaSourceFromString sourceFile, Seq<URL> classpathUrls) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        Seq options = classpathUrls.nonEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-classpath", ((TraversableOnce)classpathUrls.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(URL x$2) {
                return x$2.getFile();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(File.pathSeparator)})) : (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        compiler.getTask(null, null, null, (Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(options).asJava(), null, Arrays.asList((Object[])new TestUtils.JavaSourceFromString[]{sourceFile})).call();
        String fileName = new StringBuilder().append((Object)className).append((Object)".class").toString();
        File result2 = new File(fileName);
        Predef$.MODULE$.assert(result2.exists(), (Function0)new Serializable(result2){
            public static final long serialVersionUID = 0L;
            private final File result$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Compiled file not found: ").append((Object)this.result$1.getAbsolutePath()).toString();
            }
            {
                this.result$1 = result$1;
            }
        });
        File out = new File(destDir, fileName);
        Files.move((File)result2, (File)out);
        Predef$.MODULE$.assert(out.exists(), (Function0)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final File out$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Destination file not moved: ").append((Object)this.out$1.getAbsolutePath()).toString();
            }
            {
                this.out$1 = out$1;
            }
        });
        return out;
    }

    public File createCompiledClass(String className, File destDir, String toStringValue, String baseClass, Seq<URL> classpathUrls) {
        String extendsText = (String)Option$.MODULE$.apply((Object)baseClass).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String c) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" extends ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c}));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        TestUtils.JavaSourceFromString sourceFile = new TestUtils.JavaSourceFromString(className, new StringBuilder().append((Object)"public class ").append((Object)className).append((Object)extendsText).append((Object)" implements java.io.Serializable {").append((Object)"  @Override public String toString() { return \"").append((Object)toStringValue).append((Object)"\"; }}").toString());
        return this.createCompiledClass(className, destDir, sourceFile, classpathUrls);
    }

    public String createCompiledClass$default$3() {
        return "";
    }

    public String createCompiledClass$default$4() {
        return null;
    }

    public Seq<URL> createCompiledClass$default$5() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public <T> void assertSpilled(SparkContext sc, String identifier, Function0<T> body2) {
        SpillListener spillListener = new SpillListener();
        sc.addSparkListener(spillListener);
        body2.apply();
        Predef$.MODULE$.assert(spillListener.numSpilledStages() > 0, (Function0)new Serializable(identifier){
            public static final long serialVersionUID = 0L;
            private final String identifier$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected ", " to spill, but did not"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.identifier$1}));
            }
            {
                this.identifier$1 = identifier$1;
            }
        });
    }

    public <T> void assertNotSpilled(SparkContext sc, String identifier, Function0<T> body2) {
        SpillListener spillListener = new SpillListener();
        sc.addSparkListener(spillListener);
        body2.apply();
        Predef$.MODULE$.assert(spillListener.numSpilledStages() == 0, (Function0)new Serializable(identifier){
            public static final long serialVersionUID = 0L;
            private final String identifier$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected ", " to not spill, but did"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.identifier$2}));
            }
            {
                this.identifier$2 = identifier$2;
            }
        });
    }

    private TestUtils$() {
        MODULE$ = this;
        this.org$apache$spark$TestUtils$$SOURCE = JavaFileObject.Kind.SOURCE;
    }
}

