/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection.unsafe.sort;

import java.io.File;
import java.io.IOException;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.serializer.DummySerializerInstance;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.DiskBlockObjectWriter;
import org.apache.spark.storage.TempLocalBlockId;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterSpillReader;
import scala.Tuple2;

public final class UnsafeSorterSpillWriter {
    static final int DISK_WRITE_BUFFER_SIZE = 0x100000;
    private byte[] writeBuffer = new byte[0x100000];
    private final File file;
    private final BlockId blockId;
    private final int numRecordsToWrite;
    private DiskBlockObjectWriter writer;
    private int numRecordsSpilled = 0;

    public UnsafeSorterSpillWriter(BlockManager blockManager2, int fileBufferSize, ShuffleWriteMetrics writeMetrics, int numRecordsToWrite) throws IOException {
        Tuple2<TempLocalBlockId, File> spilledFileInfo = blockManager2.diskBlockManager().createTempLocalBlock();
        this.file = (File)spilledFileInfo._2();
        this.blockId = (BlockId)spilledFileInfo._1();
        this.numRecordsToWrite = numRecordsToWrite;
        this.writer = blockManager2.getDiskWriter(this.blockId, this.file, DummySerializerInstance.INSTANCE, fileBufferSize, writeMetrics);
        this.writeIntToBuffer(numRecordsToWrite, 0);
        this.writer.write(this.writeBuffer, 0, 4);
    }

    private void writeLongToBuffer(long v, int offset) throws IOException {
        this.writeBuffer[offset + 0] = (byte)(v >>> 56);
        this.writeBuffer[offset + 1] = (byte)(v >>> 48);
        this.writeBuffer[offset + 2] = (byte)(v >>> 40);
        this.writeBuffer[offset + 3] = (byte)(v >>> 32);
        this.writeBuffer[offset + 4] = (byte)(v >>> 24);
        this.writeBuffer[offset + 5] = (byte)(v >>> 16);
        this.writeBuffer[offset + 6] = (byte)(v >>> 8);
        this.writeBuffer[offset + 7] = (byte)(v >>> 0);
    }

    private void writeIntToBuffer(int v, int offset) throws IOException {
        this.writeBuffer[offset + 0] = (byte)(v >>> 24);
        this.writeBuffer[offset + 1] = (byte)(v >>> 16);
        this.writeBuffer[offset + 2] = (byte)(v >>> 8);
        this.writeBuffer[offset + 3] = (byte)(v >>> 0);
    }

    public void write(Object baseObject, long baseOffset, int recordLength, long keyPrefix) throws IOException {
        int toTransfer;
        if (this.numRecordsSpilled == this.numRecordsToWrite) {
            throw new IllegalStateException("Number of records written exceeded numRecordsToWrite = " + this.numRecordsToWrite);
        }
        ++this.numRecordsSpilled;
        this.writeIntToBuffer(recordLength, 0);
        this.writeLongToBuffer(keyPrefix, 4);
        int freeSpaceInWriteBuffer = 1048564;
        long recordReadPosition = baseOffset;
        for (int dataRemaining = recordLength; dataRemaining > 0; dataRemaining -= toTransfer) {
            toTransfer = Math.min(freeSpaceInWriteBuffer, dataRemaining);
            Platform.copyMemory((Object)baseObject, (long)recordReadPosition, (Object)this.writeBuffer, (long)(Platform.BYTE_ARRAY_OFFSET + (0x100000 - freeSpaceInWriteBuffer)), (long)toTransfer);
            this.writer.write(this.writeBuffer, 0, 0x100000 - freeSpaceInWriteBuffer + toTransfer);
            recordReadPosition += (long)toTransfer;
            freeSpaceInWriteBuffer = 0x100000;
        }
        if (freeSpaceInWriteBuffer < 0x100000) {
            this.writer.write(this.writeBuffer, 0, 0x100000 - freeSpaceInWriteBuffer);
        }
        this.writer.recordWritten();
    }

    public void close() throws IOException {
        this.writer.commitAndClose();
        this.writer = null;
        this.writeBuffer = null;
    }

    public File getFile() {
        return this.file;
    }

    public UnsafeSorterSpillReader getReader(SerializerManager serializerManager) throws IOException {
        return new UnsafeSorterSpillReader(serializerManager, this.file, this.blockId);
    }
}

