/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection.unsafe.sort;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterIterator;

public final class UnsafeSorterSpillReader
extends UnsafeSorterIterator
implements Closeable {
    private InputStream in;
    private DataInputStream din;
    private int recordLength;
    private long keyPrefix;
    private int numRecords;
    private int numRecordsRemaining;
    private byte[] arr = new byte[0x100000];
    private Object baseObject = this.arr;
    private final long baseOffset = Platform.BYTE_ARRAY_OFFSET;

    public UnsafeSorterSpillReader(SerializerManager serializerManager, File file, BlockId blockId) throws IOException {
        assert (file.length() > 0L);
        BufferedInputStream bs = new BufferedInputStream(new FileInputStream(file));
        try {
            this.in = serializerManager.wrapForCompression(blockId, bs);
            this.din = new DataInputStream(this.in);
            this.numRecords = this.numRecordsRemaining = this.din.readInt();
        }
        catch (IOException e) {
            Closeables.close((Closeable)bs, (boolean)true);
            throw e;
        }
    }

    @Override
    public int getNumRecords() {
        return this.numRecords;
    }

    @Override
    public boolean hasNext() {
        return this.numRecordsRemaining > 0;
    }

    @Override
    public void loadNext() throws IOException {
        this.recordLength = this.din.readInt();
        this.keyPrefix = this.din.readLong();
        if (this.recordLength > this.arr.length) {
            this.arr = new byte[this.recordLength];
            this.baseObject = this.arr;
        }
        ByteStreams.readFully((InputStream)this.in, (byte[])this.arr, (int)0, (int)this.recordLength);
        --this.numRecordsRemaining;
        if (this.numRecordsRemaining == 0) {
            this.close();
        }
    }

    @Override
    public Object getBaseObject() {
        return this.baseObject;
    }

    @Override
    public long getBaseOffset() {
        return this.baseOffset;
    }

    @Override
    public int getRecordLength() {
        return this.recordLength;
    }

    @Override
    public long getKeyPrefix() {
        return this.keyPrefix;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
                this.din = null;
            }
        }
    }
}

