/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.DiskBlockManager;
import org.apache.spark.storage.DiskStore$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-4Q!\u0001\u0002\u0001\t)\u0011\u0011\u0002R5tWN#xN]3\u000b\u0005\r!\u0011aB:u_J\fw-\u001a\u0006\u0003\u000b\u0019\tQa\u001d9be.T!a\u0002\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0011aA8sON\u0019\u0001aC\t\u0011\u00051yQ\"A\u0007\u000b\u00039\tQa]2bY\u0006L!\u0001E\u0007\u0003\r\u0005s\u0017PU3g!\t\u0011R#D\u0001\u0014\u0015\t!B!\u0001\u0005j]R,'O\\1m\u0013\t12CA\u0004M_\u001e<\u0017N\\4\t\u0011a\u0001!\u0011!Q\u0001\ni\tAaY8oM\u000e\u0001\u0001CA\u000e\u001d\u001b\u0005!\u0011BA\u000f\u0005\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0003-!\u0017n]6NC:\fw-\u001a:\u0011\u0005\u0005\u0012S\"\u0001\u0002\n\u0005\r\u0012!\u0001\u0005#jg.\u0014En\\2l\u001b\u0006t\u0017mZ3s\u0011\u0015)\u0003\u0001\"\u0001'\u0003\u0019a\u0014N\\5u}Q\u0019q\u0005K\u0015\u0011\u0005\u0005\u0002\u0001\"\u0002\r%\u0001\u0004Q\u0002\"B\u0010%\u0001\u0004\u0001\u0003bB\u0016\u0001\u0005\u0004%I\u0001L\u0001\u0012[&tW*Z7pefl\u0015\r\u001d\"zi\u0016\u001cX#A\u0017\u0011\u00051q\u0013BA\u0018\u000e\u0005\u0011auN\\4\t\rE\u0002\u0001\u0015!\u0003.\u0003Ii\u0017N\\'f[>\u0014\u00180T1q\u0005f$Xm\u001d\u0011\t\u000bM\u0002A\u0011\u0001\u001b\u0002\u000f\u001d,GoU5{KR\u0011Q&\u000e\u0005\u0006mI\u0002\raN\u0001\bE2|7m[%e!\t\t\u0003(\u0003\u0002:\u0005\t9!\t\\8dW&#\u0007\"B\u001e\u0001\t\u0003a\u0014a\u00019viR\u0011QH\u0014\u000b\u0003}\u0005\u0003\"\u0001D \n\u0005\u0001k!\u0001B+oSRDQA\u0011\u001eA\u0002\r\u000b\u0011b\u001e:ji\u00164UO\\2\u0011\t1!eIP\u0005\u0003\u000b6\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015AA5p\u0015\u0005Y\u0015\u0001\u00026bm\u0006L!!\u0014%\u0003!\u0019KG.Z(viB,Ho\u0015;sK\u0006l\u0007\"\u0002\u001c;\u0001\u00049\u0004\"\u0002)\u0001\t\u0003\t\u0016\u0001\u00039vi\nKH/Z:\u0015\u0007y\u00126\u000bC\u00037\u001f\u0002\u0007q\u0007C\u0003U\u001f\u0002\u0007Q+A\u0003csR,7\u000f\u0005\u0002W56\tqK\u0003\u0002J1*\u0011\u0011\fB\u0001\u0005kRLG.\u0003\u0002\\/\n\t2\t[;oW\u0016$')\u001f;f\u0005V4g-\u001a:\t\u000bu\u0003A\u0011\u00010\u0002\u0011\u001d,GOQ=uKN$\"!V0\t\u000bYb\u0006\u0019A\u001c\t\u000b\u0005\u0004A\u0011\u00012\u0002\rI,Wn\u001c<f)\t\u0019g\r\u0005\u0002\rI&\u0011Q-\u0004\u0002\b\u0005>|G.Z1o\u0011\u00151\u0004\r1\u00018\u0011\u0015A\u0007\u0001\"\u0001j\u0003!\u0019wN\u001c;bS:\u001cHCA2k\u0011\u00151t\r1\u00018\u0001")
public class DiskStore
implements Logging {
    private final DiskBlockManager diskManager;
    private final long org$apache$spark$storage$DiskStore$$minMemoryMapBytes;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private transient int org$apache$spark$internal$Logging$$levelFlags;

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public int org$apache$spark$internal$Logging$$levelFlags() {
        return this.org$apache$spark$internal$Logging$$levelFlags;
    }

    @Override
    public void org$apache$spark$internal$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$internal$Logging$$levelFlags = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public final boolean isInfoEnabled() {
        return Logging$class.isInfoEnabled(this);
    }

    @Override
    public final boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public final boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public long org$apache$spark$storage$DiskStore$$minMemoryMapBytes() {
        return this.org$apache$spark$storage$DiskStore$$minMemoryMapBytes;
    }

    public long getSize(BlockId blockId) {
        return this.diskManager.getFile(blockId.name()).length();
    }

    /*
     * WARNING - void declaration
     */
    public void put(BlockId blockId, Function1<FileOutputStream, BoxedUnit> writeFunc) {
        if (this.contains(blockId)) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Block ", " is already present in the disk store"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{blockId})));
        }
        this.logDebug((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final BlockId blockId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to put block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1}));
            }
            {
                this.blockId$1 = blockId$1;
            }
        });
        long startTime = this.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        File file = this.diskManager.getFile(blockId);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        boolean threwException = true;
        try {
            writeFunc.apply((Object)fileOutputStream);
            threwException = false;
        }
        catch (Throwable throwable) {
            void var7_6;
            try {
                void var6_5;
                Closeables.close((Closeable)var6_5, (boolean)var7_6);
                throw throwable;
            }
            finally {
                if (var7_6 != false) {
                    this.remove(blockId);
                }
            }
        }
        try {
            Closeables.close((Closeable)fileOutputStream, (boolean)threwException);
            this.logDebug((Function0<String>)new Serializable(this, startTime, file){
                public static final long serialVersionUID = 0L;
                private final long startTime$1;
                private final File file$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Block %s stored as %s file on disk in %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1.getName(), Utils$.MODULE$.bytesToString(this.file$1.length()), BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.startTime$1))}));
                }
                {
                    this.startTime$1 = startTime$1;
                    this.file$1 = file$1;
                }
            });
            return;
        }
        finally {
            if (threwException) {
                this.remove(blockId);
            }
        }
    }

    public void putBytes(BlockId blockId, ChunkedByteBuffer bytes) {
        this.put(blockId, (Function1<FileOutputStream, BoxedUnit>)new Serializable(this, bytes){
            public static final long serialVersionUID = 0L;
            public final ChunkedByteBuffer bytes$1;

            public final void apply(FileOutputStream fileOutputStream) {
                FileChannel channel = fileOutputStream.getChannel();
                Utils$.MODULE$.tryWithSafeFinally(new Serializable(this, channel){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$putBytes$1 $outer;
                    private final FileChannel channel$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.bytes$1.writeFully(this.channel$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.channel$1 = channel$1;
                    }
                }, (Function0<BoxedUnit>)new Serializable(this, channel){
                    public static final long serialVersionUID = 0L;
                    private final FileChannel channel$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.channel$1.close();
                    }
                    {
                        this.channel$1 = channel$1;
                    }
                });
            }
            {
                this.bytes$1 = bytes$1;
            }
        });
    }

    public ChunkedByteBuffer getBytes(BlockId blockId) {
        File file = this.diskManager.getFile(blockId.name());
        FileChannel channel = new RandomAccessFile(file, "r").getChannel();
        return (ChunkedByteBuffer)Utils$.MODULE$.tryWithSafeFinally(new Serializable(this, file, channel){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DiskStore $outer;
            private final File file$2;
            private final FileChannel channel$2;

            public final ChunkedByteBuffer apply() {
                ChunkedByteBuffer chunkedByteBuffer;
                if (this.file$2.length() < this.$outer.org$apache$spark$storage$DiskStore$$minMemoryMapBytes()) {
                    ByteBuffer buf = ByteBuffer.allocate((int)this.file$2.length());
                    this.channel$2.position(0L);
                    while (buf.remaining() != 0) {
                        if (this.channel$2.read(buf) != -1) continue;
                        throw new IOException(new StringBuilder().append((Object)"Reached EOF before filling buffer\n").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset=0\\nfile=", "\\nbuf.remaining=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2.getAbsolutePath(), BoxesRunTime.boxToInteger((int)buf.remaining())}))).toString());
                    }
                    buf.flip();
                    chunkedByteBuffer = new ChunkedByteBuffer(buf);
                } else {
                    chunkedByteBuffer = new ChunkedByteBuffer(this.channel$2.map(FileChannel.MapMode.READ_ONLY, 0L, this.file$2.length()));
                }
                return chunkedByteBuffer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.file$2 = file$2;
                this.channel$2 = channel$2;
            }
        }, (Function0<BoxedUnit>)new Serializable(this, channel){
            public static final long serialVersionUID = 0L;
            private final FileChannel channel$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.channel$2.close();
            }
            {
                this.channel$2 = channel$2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(BlockId blockId) {
        boolean bl;
        File file = this.diskManager.getFile(blockId.name());
        if (file.exists()) {
            void var3_3;
            boolean ret = file.delete();
            if (!ret) {
                this.logWarning((Function0<String>)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final File file$3;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$3.getPath()}));
                    }
                    {
                        this.file$3 = file$3;
                    }
                });
            }
            bl = var3_3;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean contains(BlockId blockId) {
        File file = this.diskManager.getFile(blockId.name());
        return file.exists();
    }

    public DiskStore(SparkConf conf, DiskBlockManager diskManager) {
        this.diskManager = diskManager;
        Logging$class.$init$(this);
        this.org$apache$spark$storage$DiskStore$$minMemoryMapBytes = conf.getSizeAsBytes("spark.storage.memoryMapThreshold", "2m");
    }
}

