/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.netty;

import java.nio.ByteBuffer;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.network.BlockDataManager;
import org.apache.spark.network.BlockTransferService;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.netty.NettyBlockRpcServer;
import org.apache.spark.network.netty.NettyBlockTransferService$;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SaslClientBootstrap;
import org.apache.spark.network.sasl.SaslServerBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.OneForOneBlockFetcher;
import org.apache.spark.network.shuffle.RetryingBlockFetcher;
import org.apache.spark.network.shuffle.protocol.UploadBlock;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mf!B\u0001\u0003\u0001\u0019a!!\u0007(fiRL(\t\\8dWR\u0013\u0018M\\:gKJ\u001cVM\u001d<jG\u0016T!a\u0001\u0003\u0002\u000b9,G\u000f^=\u000b\u0005\u00151\u0011a\u00028fi^|'o\u001b\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0003\u001d=i\u0011\u0001B\u0005\u0003!\u0011\u0011AC\u00117pG.$&/\u00198tM\u0016\u00148+\u001a:wS\u000e,\u0007\u0002\u0003\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\t\r|gNZ\u0002\u0001!\t)b#D\u0001\u0007\u0013\t9bAA\u0005Ta\u0006\u00148nQ8oM\"A\u0011\u0004\u0001B\u0001B\u0003%!$A\btK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s!\t)2$\u0003\u0002\u001d\r\ty1+Z2ve&$\u00180T1oC\u001e,'\u000f\u0003\u0005\u001f\u0001\t\u0015\r\u0011\"\u0011 \u0003!Awn\u001d;OC6,W#\u0001\u0011\u0011\u0005\u0005:cB\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a\u0013A\u0002)sK\u0012,g-\u0003\u0002)S\t11\u000b\u001e:j]\u001eT!AJ\u0012\t\u0011-\u0002!\u0011!Q\u0001\n\u0001\n\u0011\u0002[8ti:\u000bW.\u001a\u0011\t\u00115\u0002!\u0011!Q\u0001\n9\n\u0001B\\;n\u0007>\u0014Xm\u001d\t\u0003E=J!\u0001M\u0012\u0003\u0007%sG\u000fC\u00033\u0001\u0011\u00051'\u0001\u0004=S:LGO\u0010\u000b\u0006iY:\u0004(\u000f\t\u0003k\u0001i\u0011A\u0001\u0005\u0006%E\u0002\r\u0001\u0006\u0005\u00063E\u0002\rA\u0007\u0005\u0006=E\u0002\r\u0001\t\u0005\u0006[E\u0002\rA\f\u0005\bw\u0001\u0011\r\u0011\"\u0003=\u0003)\u0019XM]5bY&TXM]\u000b\u0002{A\u0011a\bQ\u0007\u0002\u007f)\u00111HB\u0005\u0003\u0003~\u0012!bU3sS\u0006d\u0017N_3s\u0011\u0019\u0019\u0005\u0001)A\u0005{\u0005Y1/\u001a:jC2L'0\u001a:!\u0011\u001d)\u0005A1A\u0005\n\u0019\u000b1\"Y;uQ\u0016s\u0017M\u00197fIV\tq\t\u0005\u0002#\u0011&\u0011\u0011j\t\u0002\b\u0005>|G.Z1o\u0011\u0019Y\u0005\u0001)A\u0005\u000f\u0006a\u0011-\u001e;i\u000b:\f'\r\\3eA!9Q\n\u0001b\u0001\n\u0013q\u0015!\u0004;sC:\u001c\bo\u001c:u\u0007>tg-F\u0001P!\t\u00016+D\u0001R\u0015\t\u0011F!\u0001\u0003vi&d\u0017B\u0001+R\u00055!&/\u00198ta>\u0014HoQ8oM\"1a\u000b\u0001Q\u0001\n=\u000ba\u0002\u001e:b]N\u0004xN\u001d;D_:4\u0007\u0005C\u0005Y\u0001\u0001\u0007\t\u0011)Q\u00053\u0006\u0001BO]1ogB|'\u000f^\"p]R,\u0007\u0010\u001e\t\u0003\u001diK!a\u0017\u0003\u0003!Q\u0013\u0018M\\:q_J$8i\u001c8uKb$\b\"C/\u0001\u0001\u0004\u0005\t\u0015)\u0003_\u0003\u0019\u0019XM\u001d<feB\u0011q,Y\u0007\u0002A*\u0011Q\fB\u0005\u0003E\u0002\u0014q\u0002\u0016:b]N\u0004xN\u001d;TKJ4XM\u001d\u0005\nI\u0002\u0001\r\u0011!Q!\n\u0015\fQb\u00197jK:$h)Y2u_JL\bC\u00014j\u001b\u00059'B\u00015\u0005\u0003\u0019\u0019G.[3oi&\u0011!n\u001a\u0002\u0017)J\fgn\u001d9peR\u001cE.[3oi\u001a\u000b7\r^8ss\"IA\u000e\u0001a\u0001\u0002\u0003\u0006K\u0001I\u0001\u0006CB\u0004\u0018\n\u001a\u0005\u0006]\u0002!\te\\\u0001\u0005S:LG\u000f\u0006\u0002qgB\u0011!%]\u0005\u0003e\u000e\u0012A!\u00168ji\")A/\u001ca\u0001k\u0006\u0001\"\r\\8dW\u0012\u000bG/Y'b]\u0006<WM\u001d\t\u0003\u001dYL!a\u001e\u0003\u0003!\tcwnY6ECR\fW*\u00198bO\u0016\u0014\b\"B=\u0001\t\u0013Q\u0018\u0001D2sK\u0006$XmU3sm\u0016\u0014HC\u00010|\u0011\u0015a\b\u00101\u0001~\u0003)\u0011wn\u001c;tiJ\f\u0007o\u001d\t\u0006}\u00065\u00111\u0003\b\u0004\u007f\u0006%a\u0002BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u00151#\u0001\u0004=e>|GOP\u0005\u0002I%\u0019\u00111B\u0012\u0002\u000fA\f7m[1hK&!\u0011qBA\t\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005-1\u0005E\u0002`\u0003+I1!a\u0006a\u0005a!&/\u00198ta>\u0014HoU3sm\u0016\u0014(i\\8ugR\u0014\u0018\r\u001d\u0005\b\u00037\u0001A\u0011IA\u000f\u0003-1W\r^2i\u00052|7m[:\u0015\u0017A\fy\"a\t\u0002(\u0005-\u0012Q\u0007\u0005\b\u0003C\tI\u00021\u0001!\u0003\u0011Awn\u001d;\t\u000f\u0005\u0015\u0012\u0011\u0004a\u0001]\u0005!\u0001o\u001c:u\u0011\u001d\tI#!\u0007A\u0002\u0001\na!\u001a=fG&#\u0007\u0002CA\u0017\u00033\u0001\r!a\f\u0002\u0011\tdwnY6JIN\u0004BAIA\u0019A%\u0019\u00111G\u0012\u0003\u000b\u0005\u0013(/Y=\t\u0011\u0005]\u0012\u0011\u0004a\u0001\u0003s\t\u0001\u0002\\5ti\u0016tWM\u001d\t\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011q\b\u0003\u0002\u000fMDWO\u001a4mK&!\u00111IA\u001f\u0005U\u0011En\\2l\r\u0016$8\r[5oO2K7\u000f^3oKJDq!!\n\u0001\t\u0003\n9%F\u0001/\u0011\u001d\tY\u0005\u0001C!\u0003\u001b\n1\"\u001e9m_\u0006$'\t\\8dWR\u0001\u0012qJA.\u0003?\n\t'a\u0019\u0002t\u0005\r\u0015Q\u0012\t\u0006\u0003#\n9\u0006]\u0007\u0003\u0003'R1!!\u0016$\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u00033\n\u0019F\u0001\u0004GkR,(/\u001a\u0005\b\u0003;\nI\u00051\u0001!\u0003!Awn\u001d;oC6,\u0007bBA\u0013\u0003\u0013\u0002\rA\f\u0005\b\u0003S\tI\u00051\u0001!\u0011!\t)'!\u0013A\u0002\u0005\u001d\u0014a\u00022m_\u000e\\\u0017\n\u001a\t\u0005\u0003S\ny'\u0004\u0002\u0002l)\u0019\u0011Q\u000e\u0004\u0002\u000fM$xN]1hK&!\u0011\u0011OA6\u0005\u001d\u0011En\\2l\u0013\u0012D\u0001\"!\u001e\u0002J\u0001\u0007\u0011qO\u0001\nE2|7m\u001b#bi\u0006\u0004B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0004\u0003{\"\u0011A\u00022vM\u001a,'/\u0003\u0003\u0002\u0002\u0006m$!D'b]\u0006<W\r\u001a\"vM\u001a,'\u000f\u0003\u0005\u0002\u0006\u0006%\u0003\u0019AAD\u0003\u0015aWM^3m!\u0011\tI'!#\n\t\u0005-\u00151\u000e\u0002\r'R|'/Y4f\u0019\u00164X\r\u001c\u0005\t\u0003\u001f\u000bI\u00051\u0001\u0002\u0012\u0006A1\r\\1tgR\u000bw\r\r\u0003\u0002\u0014\u0006\r\u0006CBAK\u00037\u000by*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011T\u0012\u0002\u000fI,g\r\\3di&!\u0011QTAL\u0005!\u0019E.Y:t)\u0006<\u0007\u0003BAQ\u0003Gc\u0001\u0001\u0002\u0007\u0002&\u00065\u0015\u0011!A\u0001\u0006\u0003\t9KA\u0002`IE\nB!!+\u00020B\u0019!%a+\n\u0007\u000556EA\u0004O_RD\u0017N\\4\u0011\u0007\t\n\t,C\u0002\u00024\u000e\u00121!\u00118z\u0011\u001d\t9\f\u0001C!\u0003s\u000bQa\u00197pg\u0016$\u0012\u0001\u001d")
public class NettyBlockTransferService
extends BlockTransferService {
    private final SparkConf conf;
    private final SecurityManager securityManager;
    private final String hostName;
    private final Serializer serializer;
    private final boolean authEnabled;
    private final TransportConf transportConf;
    private TransportContext transportContext;
    public TransportServer org$apache$spark$network$netty$NettyBlockTransferService$$server;
    public TransportClientFactory org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory;
    public String org$apache$spark$network$netty$NettyBlockTransferService$$appId;

    @Override
    public String hostName() {
        return this.hostName;
    }

    private Serializer serializer() {
        return this.serializer;
    }

    private boolean authEnabled() {
        return this.authEnabled;
    }

    private TransportConf transportConf() {
        return this.transportConf;
    }

    @Override
    public void init(BlockDataManager blockDataManager) {
        NettyBlockRpcServer rpcHandler = new NettyBlockRpcServer(this.conf.getAppId(), this.serializer(), blockDataManager);
        None$ serverBootstrap = None$.MODULE$;
        None$ clientBootstrap = None$.MODULE$;
        if (this.authEnabled()) {
            serverBootstrap = new Some((Object)new SaslServerBootstrap(this.transportConf(), (SecretKeyHolder)this.securityManager));
            clientBootstrap = new Some((Object)new SaslClientBootstrap(this.transportConf(), this.conf.getAppId(), (SecretKeyHolder)this.securityManager, this.securityManager.isSaslEncryptionEnabled()));
        }
        this.transportContext = new TransportContext(this.transportConf(), (RpcHandler)rpcHandler);
        this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory = this.transportContext.createClientFactory((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(Option$.MODULE$.option2Iterable((Option)clientBootstrap).toSeq()).asJava());
        this.org$apache$spark$network$netty$NettyBlockTransferService$$server = this.createServer((List<TransportServerBootstrap>)serverBootstrap.toList());
        this.org$apache$spark$network$netty$NettyBlockTransferService$$appId = this.conf.getAppId();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyBlockTransferService $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Server created on ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.hostName(), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private TransportServer createServer(List<TransportServerBootstrap> bootstraps) {
        int portToTry = this.conf.getInt("spark.blockManager.port", 0);
        return (TransportServer)Utils$.MODULE$.startServiceOnPort(portToTry, new Serializable(this, bootstraps){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyBlockTransferService $outer;
            private final List bootstraps$1;

            public final Tuple2<TransportServer, Object> apply(int port) {
                return this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$startService$1(port, this.bootstraps$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bootstraps$1 = bootstraps$1;
            }
        }, this.conf, this.getClass().getName())._1();
    }

    @Override
    public void fetchBlocks(String host, int port, String execId, String[] blockIds, BlockFetchingListener listener) {
        this.logTrace((Function0<String>)new Serializable(this, host, port, execId){
            public static final long serialVersionUID = 0L;
            private final String host$1;
            private final int port$1;
            private final String execId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetch blocks from ", ":", " (executor id ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host$1, BoxesRunTime.boxToInteger((int)this.port$1), this.execId$1}));
            }
            {
                this.host$1 = host$1;
                this.port$1 = port$1;
                this.execId$1 = execId$1;
            }
        });
        try {
            RetryingBlockFetcher.BlockFetchStarter blockFetchStarter = new RetryingBlockFetcher.BlockFetchStarter(this, host, port, execId){
                private final /* synthetic */ NettyBlockTransferService $outer;
                private final String host$1;
                private final int port$1;
                private final String execId$1;

                public void createAndStart(String[] blockIds, BlockFetchingListener listener) {
                    TransportClient client = this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.createClient(this.host$1, this.port$1);
                    new OneForOneBlockFetcher(client, this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$appId, this.execId$1, (String[])Predef$.MODULE$.refArrayOps((Object[])blockIds).toArray(ClassTag$.MODULE$.apply(String.class)), listener).start();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.host$1 = host$1;
                    this.port$1 = port$1;
                    this.execId$1 = execId$1;
                }
            };
            int maxRetries = this.transportConf().maxIORetries();
            if (maxRetries > 0) {
                new RetryingBlockFetcher(this.transportConf(), blockFetchStarter, blockIds, listener).start();
            } else {
                blockFetchStarter.createAndStart(blockIds, listener);
            }
        }
        catch (Exception exception2) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exception while beginning fetchBlocks";
                }
            }, exception2);
            Predef$.MODULE$.refArrayOps((Object[])blockIds).foreach((Function1)new Serializable(this, listener, exception2){
                public static final long serialVersionUID = 0L;
                private final BlockFetchingListener listener$1;
                private final Exception e$1;

                public final void apply(String x$1) {
                    this.listener$1.onBlockFetchFailure(x$1, (Throwable)this.e$1);
                }
                {
                    this.listener$1 = listener$1;
                    this.e$1 = e$1;
                }
            });
        }
    }

    @Override
    public int port() {
        return this.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort();
    }

    @Override
    public Future<BoxedUnit> uploadBlock(String hostname, int port, String execId, BlockId blockId, ManagedBuffer blockData, StorageLevel level, ClassTag<?> classTag) {
        Promise result2 = Promise$.MODULE$.apply();
        TransportClient client = this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.createClient(hostname, port);
        byte[] metadata = JavaUtils.bufferToArray((ByteBuffer)this.serializer().newInstance().serialize(new Tuple2((Object)level, classTag), ClassTag$.MODULE$.apply(Tuple2.class)));
        byte[] array = JavaUtils.bufferToArray((ByteBuffer)blockData.nioByteBuffer());
        client.sendRpc(new UploadBlock(this.org$apache$spark$network$netty$NettyBlockTransferService$$appId, execId, blockId.toString(), metadata, array).toByteBuffer(), new RpcResponseCallback(this, blockId, result2){
            private final /* synthetic */ NettyBlockTransferService $outer;
            public final BlockId blockId$1;
            private final Promise result$1;

            public void onSuccess(ByteBuffer response) {
                this.$outer.logTrace((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully uploaded block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blockId$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.result$1.success((Object)BoxedUnit.UNIT);
            }

            public void onFailure(Throwable e) {
                this.$outer.logError((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while uploading block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blockId$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, e);
                this.result$1.failure(e);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$1 = blockId$1;
                this.result$1 = result$1;
            }
        });
        return result2.future();
    }

    @Override
    public void close() {
        if (this.org$apache$spark$network$netty$NettyBlockTransferService$$server != null) {
            this.org$apache$spark$network$netty$NettyBlockTransferService$$server.close();
        }
        if (this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory != null) {
            this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.close();
        }
    }

    public final Tuple2 org$apache$spark$network$netty$NettyBlockTransferService$$startService$1(int port, List bootstraps$1) {
        TransportServer server = this.transportContext.createServer(this.hostName(), port, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstraps$1).asJava());
        return new Tuple2((Object)server, (Object)BoxesRunTime.boxToInteger((int)server.getPort()));
    }

    public NettyBlockTransferService(SparkConf conf, SecurityManager securityManager, String hostName, int numCores) {
        this.conf = conf;
        this.securityManager = securityManager;
        this.hostName = hostName;
        this.serializer = SparkEnv$.MODULE$.getClosureSerializer(conf, SparkEnv$.MODULE$.getClosureSerializer$default$2());
        this.authEnabled = securityManager.isAuthenticationEnabled();
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, "shuffle", numCores);
    }
}

