/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.nio.ByteBuffer;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.BlockStatus$;
import org.apache.spark.storage.BlockStore;
import org.apache.spark.storage.ExternalBlockManager;
import org.apache.spark.storage.ExternalBlockStore$;
import org.apache.spark.storage.PutResult;
import org.apache.spark.storage.PutResult$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00055f!B\u0001\u0003\u0001\u0011Q!AE#yi\u0016\u0014h.\u00197CY>\u001c7n\u0015;pe\u0016T!a\u0001\u0003\u0002\u000fM$xN]1hK*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xmE\u0002\u0001\u0017=\u0001\"\u0001D\u0007\u000e\u0003\tI!A\u0004\u0002\u0003\u0015\tcwnY6Ti>\u0014X\r\u0005\u0002\u0011#5\tA!\u0003\u0002\u0013\t\t9Aj\\4hS:<\u0007\u0002\u0003\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0019\tdwnY6NC:\fw-\u001a:\u0004\u0001A\u0011AbF\u0005\u00031\t\u0011AB\u00117pG.l\u0015M\\1hKJD\u0001B\u0007\u0001\u0003\u0002\u0003\u0006IaG\u0001\u000bKb,7-\u001e;pe&#\u0007C\u0001\u000f#\u001d\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0003\u0019\u0001&/\u001a3fM&\u00111\u0005\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005r\u0002\"\u0002\u0014\u0001\t\u00039\u0013A\u0002\u001fj]&$h\bF\u0002)S)\u0002\"\u0001\u0004\u0001\t\u000bQ)\u0003\u0019\u0001\f\t\u000bi)\u0003\u0019A\u000e\t\u00111\u0002\u0001R1A\u0005\u00025\nA#\u001a=uKJt\u0017\r\u001c\"m_\u000e\\W*\u00198bO\u0016\u0014X#\u0001\u0018\u0011\u0007uy\u0013'\u0003\u00021=\t1q\n\u001d;j_:\u0004\"\u0001\u0004\u001a\n\u0005M\u0012!\u0001F#yi\u0016\u0014h.\u00197CY>\u001c7.T1oC\u001e,'\u000f\u0003\u00056\u0001!\u0005\t\u0015)\u0003/\u0003U)\u0007\u0010^3s]\u0006d'\t\\8dW6\u000bg.Y4fe\u0002BQa\u000e\u0001\u0005Ba\nqaZ3u'&TX\r\u0006\u0002:yA\u0011QDO\u0005\u0003wy\u0011A\u0001T8oO\")QH\u000ea\u0001}\u00059!\r\\8dW&#\u0007C\u0001\u0007@\u0013\t\u0001%AA\u0004CY>\u001c7.\u00133\t\u000b\t\u0003A\u0011I\"\u0002\u0011A,HOQ=uKN$B\u0001R$I%B\u0011A\"R\u0005\u0003\r\n\u0011\u0011\u0002U;u%\u0016\u001cX\u000f\u001c;\t\u000bu\n\u0005\u0019\u0001 \t\u000b%\u000b\u0005\u0019\u0001&\u0002\u000b\tLH/Z:\u0011\u0005-\u0003V\"\u0001'\u000b\u00055s\u0015a\u00018j_*\tq*\u0001\u0003kCZ\f\u0017BA)M\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006'\u0006\u0003\r\u0001V\u0001\u0006Y\u00164X\r\u001c\t\u0003\u0019UK!A\u0016\u0002\u0003\u0019M#xN]1hK2+g/\u001a7\t\u000ba\u0003A\u0011I-\u0002\u0011A,H/\u0011:sCf$R\u0001\u0012.\\G\u0012DQ!P,A\u0002yBQ\u0001X,A\u0002u\u000baA^1mk\u0016\u001c\bcA\u000f_A&\u0011qL\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003;\u0005L!A\u0019\u0010\u0003\u0007\u0005s\u0017\u0010C\u0003T/\u0002\u0007A\u000bC\u0003f/\u0002\u0007a-\u0001\u0007sKR,(O\u001c,bYV,7\u000f\u0005\u0002\u001eO&\u0011\u0001N\b\u0002\b\u0005>|G.Z1o\u0011\u0015Q\u0007\u0001\"\u0011l\u0003-\u0001X\u000f^%uKJ\fGo\u001c:\u0015\u000b\u0011cWN_>\t\u000buJ\u0007\u0019\u0001 \t\u000bqK\u0007\u0019\u00018\u0011\u0007=<\bM\u0004\u0002qk:\u0011\u0011\u000f^\u0007\u0002e*\u00111/F\u0001\u0007yI|w\u000e\u001e \n\u0003}I!A\u001e\u0010\u0002\u000fA\f7m[1hK&\u0011\u00010\u001f\u0002\t\u0013R,'/\u0019;pe*\u0011aO\b\u0005\u0006'&\u0004\r\u0001\u0016\u0005\u0006K&\u0004\rA\u001a\u0005\u0006{\u0002!IA`\u0001\u001aaV$\u0018J\u001c;p\u000bb$XM\u001d8bY\ncwnY6Ti>\u0014X\r\u0006\u0004E\u007f\u0006\u0005\u0011q\u0003\u0005\u0006{q\u0004\rA\u0010\u0005\u00079r\u0004\r!a\u00011\t\u0005\u0015\u00111\u0002\t\u0005_^\f9\u0001\u0005\u0003\u0002\n\u0005-A\u0002\u0001\u0003\r\u0003\u001b\t\t!!A\u0001\u0002\u000b\u0005\u0011q\u0002\u0002\u0004?\u0012\n\u0014cAA\tAB\u0019Q$a\u0005\n\u0007\u0005UaDA\u0004O_RD\u0017N\\4\t\u000b\u0015d\b\u0019\u00014\t\ru\u0004A\u0011BA\u000e)\u001d!\u0015QDA\u0010\u0003CAa!PA\r\u0001\u0004q\u0004BB%\u0002\u001a\u0001\u0007!\n\u0003\u0004f\u00033\u0001\rA\u001a\u0005\b\u0003K\u0001A\u0011IA\u0014\u0003\u0019\u0011X-\\8wKR\u0019a-!\u000b\t\ru\n\u0019\u00031\u0001?\u0011\u001d\ti\u0003\u0001C!\u0003_\t\u0011bZ3u-\u0006dW/Z:\u0015\t\u0005E\u00121\u0007\t\u0004;=r\u0007BB\u001f\u0002,\u0001\u0007a\bC\u0004\u00028\u0001!\t%!\u000f\u0002\u0011\u001d,GOQ=uKN$B!a\u000f\u0002>A\u0019Qd\f&\t\ru\n)\u00041\u0001?\u0011\u001d\t\t\u0005\u0001C!\u0003\u0007\n\u0001bY8oi\u0006Lgn\u001d\u000b\u0004M\u0006\u0015\u0003BB\u001f\u0002@\u0001\u0007a\bC\u0004\u0002J\u0001!I!a\u0013\u0002!\r\u0014X-\u0019;f\u00052\\W*\u00198bO\u0016\u0014H#\u0001\u0018\b\u0011\u0005=#\u0001#\u0001\u0005\u0003#\n!#\u0012=uKJt\u0017\r\u001c\"m_\u000e\\7\u000b^8sKB\u0019A\"a\u0015\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0003\u0002VM)\u00111KA,\u001fA\u0019Q$!\u0017\n\u0007\u0005mcD\u0001\u0004B]f\u0014VM\u001a\u0005\bM\u0005MC\u0011AA0)\t\t\t\u0006\u0003\u0006\u0002d\u0005M#\u0019!C\u0001\u0003K\n\u0011$T!Y?\u0012K%kX\"S\u000b\u0006#\u0016j\u0014(`\u0003R#V)\u0014)U'V\u0011\u0011q\r\t\u0004;\u0005%\u0014bAA6=\t\u0019\u0011J\u001c;\t\u0013\u0005=\u00141\u000bQ\u0001\n\u0005\u001d\u0014AG'B1~#\u0015JU0D%\u0016\u000bE+S(O?\u0006#F+R'Q)N\u0003\u0003BCA:\u0003'\u0012\r\u0011\"\u0001\u0002v\u0005\u00012+\u0016\"`\t&\u00136k\u0018)F%~#\u0015JU\u000b\u0003\u0003o\u0002B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0004\u0003{r\u0015\u0001\u00027b]\u001eL1aIA>\u0011%\t\u0019)a\u0015!\u0002\u0013\t9(A\tT+\n{F)\u0013*T?B+%k\u0018#J%\u0002B!\"a\"\u0002T\t\u0007I\u0011AA;\u0003!\u0011\u0015iU#`\t&\u0013\u0006\"CAF\u0003'\u0002\u000b\u0011BA<\u0003%\u0011\u0015iU#`\t&\u0013\u0006\u0005\u0003\u0006\u0002\u0010\u0006M#\u0019!C\u0001\u0003k\n\u0011BR(M\t~s\u0015)T#\t\u0013\u0005M\u00151\u000bQ\u0001\n\u0005]\u0014A\u0003$P\u0019\u0012{f*Q'FA!Q\u0011qSA*\u0005\u0004%\t!!\u001e\u0002\u00155\u000b5\u000bV#S?V\u0013F\nC\u0005\u0002\u001c\u0006M\u0003\u0015!\u0003\u0002x\u0005YQ*Q*U\u000bJ{VK\u0015'!\u0011)\ty*a\u0015C\u0002\u0013\u0005\u0011QO\u0001\u0013\u00052{5iS0N\u0003:\u000bu)\u0012*`\u001d\u0006kU\tC\u0005\u0002$\u0006M\u0003\u0015!\u0003\u0002x\u0005\u0019\"\tT(D\u0017~k\u0015IT!H\u000bJ{f*Q'FA!Q\u0011qUA*\u0005\u0004%\t!!\u001e\u00025\u0011+e)Q+M)~\u0013EjT\"L?6\u000be*Q$F%~s\u0015)T#\t\u0013\u0005-\u00161\u000bQ\u0001\n\u0005]\u0014a\u0007#F\r\u0006+F\nV0C\u0019>\u001b5jX'B\u001d\u0006;UIU0O\u00036+\u0005\u0005")
public class ExternalBlockStore
extends BlockStore {
    private final BlockManager blockManager;
    private final String executorId;
    private Option<ExternalBlockManager> externalBlockManager;
    private volatile boolean bitmap$0;

    public static String DEFAULT_BLOCK_MANAGER_NAME() {
        return ExternalBlockStore$.MODULE$.DEFAULT_BLOCK_MANAGER_NAME();
    }

    public static String BLOCK_MANAGER_NAME() {
        return ExternalBlockStore$.MODULE$.BLOCK_MANAGER_NAME();
    }

    public static String MASTER_URL() {
        return ExternalBlockStore$.MODULE$.MASTER_URL();
    }

    public static String FOLD_NAME() {
        return ExternalBlockStore$.MODULE$.FOLD_NAME();
    }

    public static String BASE_DIR() {
        return ExternalBlockStore$.MODULE$.BASE_DIR();
    }

    public static String SUB_DIRS_PER_DIR() {
        return ExternalBlockStore$.MODULE$.SUB_DIRS_PER_DIR();
    }

    public static int MAX_DIR_CREATION_ATTEMPTS() {
        return ExternalBlockStore$.MODULE$.MAX_DIR_CREATION_ATTEMPTS();
    }

    private Option externalBlockManager$lzycompute() {
        ExternalBlockStore externalBlockStore = this;
        synchronized (externalBlockStore) {
            if (!this.bitmap$0) {
                this.externalBlockManager = this.createBlkManager();
                this.bitmap$0 = true;
            }
            return this.externalBlockManager;
        }
    }

    public Option<ExternalBlockManager> externalBlockManager() {
        return this.bitmap$0 ? this.externalBlockManager : this.externalBlockManager$lzycompute();
    }

    @Override
    public long getSize(BlockId blockId) {
        long l;
        try {
            l = BoxesRunTime.unboxToLong((Object)this.externalBlockManager().map((Function1)new Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$2;

                public final long apply(ExternalBlockManager x$1) {
                    return x$1.getSize(this.blockId$2);
                }
                {
                    this.blockId$2 = blockId$2;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 0L;
                }
            }));
        }
        catch (Throwable throwable) {
            long l2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            this.logError((Function0<String>)new Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error in getSize(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$2}));
                }
                {
                    this.blockId$2 = blockId$2;
                }
            }, t);
            l = l2 = 0L;
        }
        return l;
    }

    @Override
    public PutResult putBytes(BlockId blockId, ByteBuffer bytes, StorageLevel level) {
        return this.putIntoExternalBlockStore(blockId, bytes, true);
    }

    @Override
    public PutResult putArray(BlockId blockId, Object[] values2, StorageLevel level, boolean returnValues) {
        return this.putIntoExternalBlockStore(blockId, (Iterator<Object>)Predef$.MODULE$.genericArrayOps((Object)values2).toIterator(), returnValues);
    }

    @Override
    public PutResult putIterator(BlockId blockId, Iterator<Object> values2, StorageLevel level, boolean returnValues) {
        return this.putIntoExternalBlockStore(blockId, values2, returnValues);
    }

    private PutResult putIntoExternalBlockStore(BlockId blockId, Iterator<Object> values2, boolean returnValues) {
        PutResult putResult;
        this.logTrace((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final BlockId blockId$7;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to put block ", " into ExternalBlockStore"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$7}));
            }
            {
                this.blockId$7 = blockId$7;
            }
        });
        try {
            long startTime = System.currentTimeMillis();
            if (this.externalBlockManager().isDefined()) {
                ((ExternalBlockManager)this.externalBlockManager().get()).putValues(blockId, values2);
                long size = this.getSize(blockId);
                Left data = returnValues ? package$.MODULE$.Left().apply(this.getValues(blockId).get()) : null;
                long finishTime = System.currentTimeMillis();
                this.logDebug((Function0<String>)new Serializable(this, blockId, startTime, size, finishTime){
                    public static final long serialVersionUID = 0L;
                    private final BlockId blockId$7;
                    private final long startTime$1;
                    private final long size$1;
                    private final long finishTime$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Block %s stored as %s file in ExternalBlockStore in %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$7, Utils$.MODULE$.bytesToString(this.size$1), BoxesRunTime.boxToLong((long)(this.finishTime$1 - this.startTime$1))}));
                    }
                    {
                        this.blockId$7 = blockId$7;
                        this.startTime$1 = startTime$1;
                        this.size$1 = size$1;
                        this.finishTime$1 = finishTime$1;
                    }
                });
                putResult = new PutResult(size, (Either<Iterator<Object>, ByteBuffer>)data, PutResult$.MODULE$.apply$default$3());
            } else {
                this.logError((Function0<String>)new Serializable(this, blockId){
                    public static final long serialVersionUID = 0L;
                    private final BlockId blockId$7;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error in putValues(", "): no ExternalBlockManager has been configured"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$7}));
                    }
                    {
                        this.blockId$7 = blockId$7;
                    }
                });
                putResult = new PutResult(-1L, null, (Seq<Tuple2<BlockId, BlockStatus>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)blockId, (Object)BlockStatus$.MODULE$.empty())}))));
            }
        }
        catch (Throwable throwable) {
            PutResult putResult2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            this.logError((Function0<String>)new Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$7;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error in putValues(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$7}));
                }
                {
                    this.blockId$7 = blockId$7;
                }
            }, t);
            putResult = putResult2 = new PutResult(-1L, null, (Seq<Tuple2<BlockId, BlockStatus>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)blockId, (Object)BlockStatus$.MODULE$.empty())}))));
        }
        return putResult;
    }

    private PutResult putIntoExternalBlockStore(BlockId blockId, ByteBuffer bytes, boolean returnValues) {
        PutResult putResult;
        this.logTrace((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final BlockId blockId$6;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to put block ", " into ExternalBlockStore"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$6}));
            }
            {
                this.blockId$6 = blockId$6;
            }
        });
        try {
            long startTime = System.currentTimeMillis();
            if (this.externalBlockManager().isDefined()) {
                ByteBuffer byteBuffer = bytes.duplicate();
                byteBuffer.rewind();
                ((ExternalBlockManager)this.externalBlockManager().get()).putBytes(blockId, byteBuffer);
                int size = bytes.limit();
                Right data = returnValues ? package$.MODULE$.Right().apply((Object)bytes) : null;
                long finishTime = System.currentTimeMillis();
                this.logDebug((Function0<String>)new Serializable(this, blockId, startTime, size, finishTime){
                    public static final long serialVersionUID = 0L;
                    private final BlockId blockId$6;
                    private final long startTime$2;
                    private final int size$2;
                    private final long finishTime$2;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Block %s stored as %s file in ExternalBlockStore in %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$6, Utils$.MODULE$.bytesToString(this.size$2), BoxesRunTime.boxToLong((long)(this.finishTime$2 - this.startTime$2))}));
                    }
                    {
                        this.blockId$6 = blockId$6;
                        this.startTime$2 = startTime$2;
                        this.size$2 = size$2;
                        this.finishTime$2 = finishTime$2;
                    }
                });
                putResult = new PutResult(size, (Either<Iterator<Object>, ByteBuffer>)data, PutResult$.MODULE$.apply$default$3());
            } else {
                this.logError((Function0<String>)new Serializable(this, blockId){
                    public static final long serialVersionUID = 0L;
                    private final BlockId blockId$6;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error in putBytes(", "): no ExternalBlockManager has been configured"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$6}));
                    }
                    {
                        this.blockId$6 = blockId$6;
                    }
                });
                putResult = new PutResult(-1L, null, (Seq<Tuple2<BlockId, BlockStatus>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)blockId, (Object)BlockStatus$.MODULE$.empty())}))));
            }
        }
        catch (Throwable throwable) {
            PutResult putResult2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            this.logError((Function0<String>)new Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$6;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error in putBytes(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$6}));
                }
                {
                    this.blockId$6 = blockId$6;
                }
            }, t);
            putResult = putResult2 = new PutResult(-1L, null, (Seq<Tuple2<BlockId, BlockStatus>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)blockId, (Object)BlockStatus$.MODULE$.empty())}))));
        }
        return putResult;
    }

    @Override
    public boolean remove(BlockId blockId) {
        boolean bl;
        try {
            bl = BoxesRunTime.unboxToBoolean((Object)this.externalBlockManager().map((Function1)new Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$5;

                public final boolean apply(ExternalBlockManager x$2) {
                    return x$2.removeBlock(this.blockId$5);
                }
                {
                    this.blockId$5 = blockId$5;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return true;
                }
            }));
        }
        catch (Throwable throwable) {
            boolean bl2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            this.logError((Function0<String>)new Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$5;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error in removeBlock(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$5}));
                }
                {
                    this.blockId$5 = blockId$5;
                }
            }, t);
            bl = bl2 = true;
        }
        return bl;
    }

    @Override
    public Option<Iterator<Object>> getValues(BlockId blockId) {
        Option option;
        try {
            option = this.externalBlockManager().flatMap((Function1)new Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$3;

                public final Option<Iterator<Object>> apply(ExternalBlockManager x$3) {
                    return x$3.getValues(this.blockId$3);
                }
                {
                    this.blockId$3 = blockId$3;
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option2 = NonFatal$.MODULE$.unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option2.get();
            this.logError((Function0<String>)new Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$3;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error in getValues(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$3}));
                }
                {
                    this.blockId$3 = blockId$3;
                }
            }, t);
            None$ none$ = None$.MODULE$;
            option = none$;
        }
        return option;
    }

    @Override
    public Option<ByteBuffer> getBytes(BlockId blockId) {
        Option option;
        try {
            option = this.externalBlockManager().flatMap((Function1)new Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$4;

                public final Option<ByteBuffer> apply(ExternalBlockManager x$4) {
                    return x$4.getBytes(this.blockId$4);
                }
                {
                    this.blockId$4 = blockId$4;
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option2 = NonFatal$.MODULE$.unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option2.get();
            this.logError((Function0<String>)new Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$4;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error in getBytes(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$4}));
                }
                {
                    this.blockId$4 = blockId$4;
                }
            }, t);
            None$ none$ = None$.MODULE$;
            option = none$;
        }
        return option;
    }

    @Override
    public boolean contains(BlockId blockId) {
        boolean bl;
        try {
            boolean ret = BoxesRunTime.unboxToBoolean((Object)this.externalBlockManager().map((Function1)new Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$1;

                public final boolean apply(ExternalBlockManager x$5) {
                    return x$5.blockExists(this.blockId$1);
                }
                {
                    this.blockId$1 = blockId$1;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }));
            if (!ret) {
                this.logInfo((Function0<String>)new Serializable(this, blockId){
                    public static final long serialVersionUID = 0L;
                    private final BlockId blockId$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Remove block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1}));
                    }
                    {
                        this.blockId$1 = blockId$1;
                    }
                });
                this.blockManager.removeBlock(blockId, true);
            }
            bl = ret;
        }
        catch (Throwable throwable) {
            boolean bl2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            this.logError((Function0<String>)new Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error in getBytes(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1}));
                }
                {
                    this.blockId$1 = blockId$1;
                }
            }, t);
            bl = bl2 = false;
        }
        return bl;
    }

    private Option<ExternalBlockManager> createBlkManager() {
        Some some;
        String clsName = (String)this.blockManager.conf().getOption(ExternalBlockStore$.MODULE$.BLOCK_MANAGER_NAME()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ExternalBlockStore$.MODULE$.DEFAULT_BLOCK_MANAGER_NAME();
            }
        });
        try {
            ExternalBlockManager instance = (ExternalBlockManager)Utils$.MODULE$.classForName(clsName).newInstance();
            instance.init(this.blockManager, this.executorId);
            ShutdownHookManager$.MODULE$.addShutdownHook((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ExternalBlockStore $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Shutdown hook called";
                        }
                    });
                    this.$outer.externalBlockManager().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ExternalBlockManager x$6) {
                            x$6.shutdown();
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            some = new Some((Object)instance);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Cannot initialize external block store";
                }
            }, t);
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public ExternalBlockStore(BlockManager blockManager2, String executorId) {
        this.blockManager = blockManager2;
        this.executorId = executorId;
        super(blockManager2);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "ExternalBlockStore started";
            }
        });
    }
}

