/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.local;

import java.io.File;
import java.net.URL;
import java.nio.ByteBuffer;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.executor.ExecutorBackend;
import org.apache.spark.launcher.LauncherBackend;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.SchedulerBackend$class;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.ExecutorInfo;
import org.apache.spark.scheduler.local.KillTask;
import org.apache.spark.scheduler.local.LocalBackend$;
import org.apache.spark.scheduler.local.LocalEndpoint;
import org.apache.spark.scheduler.local.ReviveOffers$;
import org.apache.spark.scheduler.local.StatusUpdate;
import org.apache.spark.scheduler.local.StopExecutor$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf!B\u0001\u0003\u0001\u0019a!\u0001\u0004'pG\u0006d')Y2lK:$'BA\u0002\u0005\u0003\u0015awnY1m\u0015\t)a!A\u0005tG\",G-\u001e7fe*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0003\u0001\u001bM9R\u0004\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)Ui\u0011\u0001B\u0005\u0003-\u0011\u0011\u0001cU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0011\u0005aYR\"A\r\u000b\u0005i1\u0011\u0001C3yK\u000e,Ho\u001c:\n\u0005qI\"aD#yK\u000e,Ho\u001c:CC\u000e\\WM\u001c3\u0011\u0005yyR\"\u0001\u0004\n\u0005\u00012!a\u0002'pO\u001eLgn\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005I\u0005!1m\u001c8g\u0007\u0001\u0001\"AH\u0013\n\u0005\u00192!!C*qCJ\\7i\u001c8g\u0011!)\u0001A!A!\u0002\u0013A\u0003C\u0001\u000b*\u0013\tQCAA\tUCN\\7k\u00195fIVdWM]%na2D\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!L\u0001\u000bi>$\u0018\r\\\"pe\u0016\u001cX#\u0001\u0018\u0011\u00059y\u0013B\u0001\u0019\u0010\u0005\rIe\u000e\u001e\u0005\te\u0001\u0011\t\u0011)A\u0005]\u0005YAo\u001c;bY\u000e{'/Z:!\u0011\u0015!\u0004\u0001\"\u00016\u0003\u0019a\u0014N\\5u}Q!a\u0007O\u001d;!\t9\u0004!D\u0001\u0003\u0011\u0015\u00113\u00071\u0001%\u0011\u0015)1\u00071\u0001)\u0011\u0015a3\u00071\u0001/\u0011\u001da\u0004A1A\u0005\nu\nQ!\u00199q\u0013\u0012,\u0012A\u0010\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bA\u0001\\1oO*\t1)\u0001\u0003kCZ\f\u0017BA#A\u0005\u0019\u0019FO]5oO\"1q\t\u0001Q\u0001\ny\na!\u00199q\u0013\u0012\u0004\u0003bB%\u0001\u0001\u0004%IAS\u0001\u000eY>\u001c\u0017\r\\#oIB|\u0017N\u001c;\u0016\u0003-\u0003\"\u0001T(\u000e\u00035S!A\u0014\u0004\u0002\u0007I\u00048-\u0003\u0002Q\u001b\nq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0007b\u0002*\u0001\u0001\u0004%IaU\u0001\u0012Y>\u001c\u0017\r\\#oIB|\u0017N\u001c;`I\u0015\fHC\u0001+X!\tqQ+\u0003\u0002W\u001f\t!QK\\5u\u0011\u001dA\u0016+!AA\u0002-\u000b1\u0001\u001f\u00132\u0011\u0019Q\u0006\u0001)Q\u0005\u0017\u0006qAn\\2bY\u0016sG\r]8j]R\u0004\u0003b\u0002/\u0001\u0005\u0004%I!X\u0001\u000ekN,'o\u00117bgN\u0004\u0016\r\u001e5\u0016\u0003y\u00032aX4k\u001d\t\u0001WM\u0004\u0002bI6\t!M\u0003\u0002dG\u00051AH]8pizJ\u0011\u0001E\u0005\u0003M>\tq\u0001]1dW\u0006<W-\u0003\u0002iS\n\u00191+Z9\u000b\u0005\u0019|\u0001CA6o\u001b\u0005a'BA7C\u0003\rqW\r^\u0005\u0003_2\u00141!\u0016*M\u0011\u0019\t\b\u0001)A\u0005=\u0006qQo]3s\u00072\f7o\u001d)bi\"\u0004\u0003bB:\u0001\u0005\u0004%I\u0001^\u0001\fY&\u001cH/\u001a8fe\n+8/F\u0001v!\t!b/\u0003\u0002x\t\tyA*\u001b<f\u0019&\u001cH/\u001a8fe\n+8\u000f\u0003\u0004z\u0001\u0001\u0006I!^\u0001\rY&\u001cH/\u001a8fe\n+8\u000f\t\u0005\bw\u0002\u0011\r\u0011\"\u0003}\u0003=a\u0017-\u001e8dQ\u0016\u0014()Y2lK:$W#A?\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\tAB\u0001\tY\u0006,hn\u00195fe&\u0019\u0011QA@\u0003\u001f1\u000bWO\\2iKJ\u0014\u0015mY6f]\u0012Dq!!\u0003\u0001A\u0003%Q0\u0001\tmCVt7\r[3s\u0005\u0006\u001c7.\u001a8eA!9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0011\u0001E4fiV\u001bXM]\"mCN\u001c\b/\u0019;i)\rq\u0016\u0011\u0003\u0005\u0007E\u0005-\u0001\u0019\u0001\u0013\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018\u0005)1\u000f^1siR\tA\u000bC\u0004\u0002\u001c\u0001!\t%a\u0006\u0002\tM$x\u000e\u001d\u0005\b\u0003?\u0001A\u0011IA\f\u00031\u0011XM^5wK>3g-\u001a:t\u0011\u001d\t\u0019\u0003\u0001C!\u0003K\t!\u0003Z3gCVdG\u000fU1sC2dW\r\\5t[R\ta\u0006C\u0004\u0002*\u0001!\t%a\u000b\u0002\u0011-LG\u000e\u001c+bg.$r\u0001VA\u0017\u0003o\t9\u0005\u0003\u0005\u00020\u0005\u001d\u0002\u0019AA\u0019\u0003\u0019!\u0018m]6JIB\u0019a\"a\r\n\u0007\u0005UrB\u0001\u0003M_:<\u0007\u0002CA\u001d\u0003O\u0001\r!a\u000f\u0002\u0015\u0015DXmY;u_JLE\r\u0005\u0003\u0002>\u0005\rcb\u0001\b\u0002@%\u0019\u0011\u0011I\b\u0002\rA\u0013X\rZ3g\u0013\r)\u0015Q\t\u0006\u0004\u0003\u0003z\u0001\u0002CA%\u0003O\u0001\r!a\u0013\u0002\u001f%tG/\u001a:skB$H\u000b\u001b:fC\u0012\u00042ADA'\u0013\r\tye\u0004\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019\u0006\u0001C!\u0003+\nAb\u001d;biV\u001cX\u000b\u001d3bi\u0016$r\u0001VA,\u00033\n9\b\u0003\u0005\u00020\u0005E\u0003\u0019AA\u0019\u0011!\tY&!\u0015A\u0002\u0005u\u0013!B:uCR,\u0007\u0003BA0\u0003crA!!\u0019\u0002n9!\u00111MA6\u001d\u0011\t)'!\u001b\u000f\u0007\u0005\f9'C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0019\u0011q\u000e\u0004\u0002\u0013Q\u000b7o[*uCR,\u0017\u0002BA:\u0003k\u0012\u0011\u0002V1tWN#\u0018\r^3\u000b\u0007\u0005=d\u0001\u0003\u0005\u0002z\u0005E\u0003\u0019AA>\u00039\u0019XM]5bY&TX\r\u001a#bi\u0006\u0004B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0004\u0003\u0003\u0013\u0015a\u00018j_&!\u0011QQA@\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\b\u0003\u0013\u0003A\u0011IAF\u00035\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8JIR\u0011\u00111\b\u0005\b\u00037\u0001A\u0011BAH)\r!\u0016\u0011\u0013\u0005\t\u0003'\u000bi\t1\u0001\u0002\u0016\u0006Qa-\u001b8bYN#\u0018\r^3\u0011\t\u0005]\u0015Q\u0014\b\u0004}\u0006e\u0015bAAN\u007f\u0006q1\u000b]1sW\u0006\u0003\b\u000fS1oI2,\u0017\u0002BAP\u0003C\u0013Qa\u0015;bi\u0016T1!a'\u0000\u0001")
public class LocalBackend
implements SchedulerBackend,
ExecutorBackend,
Logging {
    private final TaskSchedulerImpl scheduler;
    private final int totalCores;
    private final String appId;
    private RpcEndpointRef localEndpoint;
    private final Seq<URL> userClassPath;
    private final LiveListenerBus listenerBus;
    private final LauncherBackend launcherBackend;
    private transient Logger org$apache$spark$Logging$$log_;
    private final String org$apache$spark$scheduler$SchedulerBackend$$appId;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public String org$apache$spark$scheduler$SchedulerBackend$$appId() {
        return this.org$apache$spark$scheduler$SchedulerBackend$$appId;
    }

    @Override
    public void org$apache$spark$scheduler$SchedulerBackend$_setter_$org$apache$spark$scheduler$SchedulerBackend$$appId_$eq(String x$1) {
        this.org$apache$spark$scheduler$SchedulerBackend$$appId = x$1;
    }

    @Override
    public boolean isReady() {
        return SchedulerBackend$class.isReady(this);
    }

    @Override
    public Option<String> applicationAttemptId() {
        return SchedulerBackend$class.applicationAttemptId(this);
    }

    @Override
    public Option<Map<String, String>> getDriverLogUrls() {
        return SchedulerBackend$class.getDriverLogUrls(this);
    }

    public int totalCores() {
        return this.totalCores;
    }

    private String appId() {
        return this.appId;
    }

    private RpcEndpointRef localEndpoint() {
        return this.localEndpoint;
    }

    private void localEndpoint_$eq(RpcEndpointRef x$1) {
        this.localEndpoint = x$1;
    }

    private Seq<URL> userClassPath() {
        return this.userClassPath;
    }

    private LiveListenerBus listenerBus() {
        return this.listenerBus;
    }

    private LauncherBackend launcherBackend() {
        return this.launcherBackend;
    }

    public Seq<URL> getUserClasspath(SparkConf conf) {
        Option<String> userClassPathStr = conf.getOption("spark.executor.extraClassPath");
        return (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(userClassPathStr.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$1) {
                return x$1.split(File.pathSeparator);
            }
        })).toSeq().flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String[] xs) {
                return Predef$.MODULE$.refArrayOps((Object[])xs);
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final URL apply(String x$2) {
                return new File(x$2).toURI().toURL();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public void start() {
        RpcEnv rpcEnv = SparkEnv$.MODULE$.get().rpcEnv();
        LocalEndpoint executorEndpoint = new LocalEndpoint(rpcEnv, this.userClassPath(), this.scheduler, this, this.totalCores());
        this.localEndpoint_$eq(rpcEnv.setupEndpoint("LocalBackendEndpoint", executorEndpoint));
        this.listenerBus().post(new SparkListenerExecutorAdded(System.currentTimeMillis(), executorEndpoint.localExecutorId(), new ExecutorInfo(executorEndpoint.localExecutorHostname(), this.totalCores(), (Map<String, String>)Predef$.MODULE$.Map().empty())));
        this.launcherBackend().setAppId(this.appId());
        this.launcherBackend().setState(SparkAppHandle.State.RUNNING);
    }

    @Override
    public void stop() {
        this.org$apache$spark$scheduler$local$LocalBackend$$stop(SparkAppHandle.State.FINISHED);
    }

    @Override
    public void reviveOffers() {
        this.localEndpoint().send((Object)ReviveOffers$.MODULE$);
    }

    @Override
    public int defaultParallelism() {
        return this.scheduler.conf().getInt("spark.default.parallelism", this.totalCores());
    }

    @Override
    public void killTask(long taskId, String executorId, boolean interruptThread) {
        this.localEndpoint().send(new KillTask(taskId, interruptThread));
    }

    @Override
    public void statusUpdate(long taskId, Enumeration.Value state, ByteBuffer serializedData) {
        this.localEndpoint().send(new StatusUpdate(taskId, state, serializedData));
    }

    @Override
    public String applicationId() {
        return this.appId();
    }

    public void org$apache$spark$scheduler$local$LocalBackend$$stop(SparkAppHandle.State finalState) {
        this.localEndpoint().ask((Object)StopExecutor$.MODULE$, ClassTag$.MODULE$.Nothing());
        try {
            this.launcherBackend().setState(finalState);
            return;
        }
        finally {
            this.launcherBackend().close();
        }
    }

    public LocalBackend(SparkConf conf, TaskSchedulerImpl scheduler, int totalCores) {
        this.scheduler = scheduler;
        this.totalCores = totalCores;
        SchedulerBackend$class.$init$(this);
        Logging$class.$init$(this);
        this.appId = new StringBuilder().append((Object)"local-").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString();
        this.localEndpoint = null;
        this.userClassPath = this.getUserClasspath(conf);
        this.listenerBus = scheduler.sc().listenerBus();
        this.launcherBackend = new $anon$1(this);
        this.launcherBackend().connect();
    }
}

