/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.mesos;

import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkCuratorUtil$;
import org.apache.spark.scheduler.cluster.mesos.MesosClusterPersistenceEngine;
import org.apache.spark.util.Utils$;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da!B\u0001\u0003\u0001!q!A\n.p_.,W\r]3s\u001b\u0016\u001cxn]\"mkN$XM\u001d)feNL7\u000f^3oG\u0016,enZ5oK*\u00111\u0001B\u0001\u0006[\u0016\u001cxn\u001d\u0006\u0003\u000b\u0019\tqa\u00197vgR,'O\u0003\u0002\b\u0011\u0005I1o\u00195fIVdWM\u001d\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON!\u0001aD\u000b\u001a!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fMB\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u001e\u001b\u0016\u001cxn]\"mkN$XM\u001d)feNL7\u000f^3oG\u0016,enZ5oKB\u0011!dG\u0007\u0002\u0011%\u0011A\u0004\u0003\u0002\b\u0019><w-\u001b8h\u0011!q\u0002A!A!\u0002\u0013\u0001\u0013a\u00022bg\u0016$\u0015N]\u0002\u0001!\t\tCE\u0004\u0002\u0011E%\u00111%E\u0001\u0007!J,G-\u001a4\n\u0005\u00152#AB*ue&twM\u0003\u0002$#!A\u0001\u0006\u0001B\u0001B\u0003%\u0011&\u0001\u0002{WB\u0011!fL\u0007\u0002W)\u0011A&L\u0001\nMJ\fW.Z<pe.T!A\f\u0006\u0002\u000f\r,(/\u0019;pe&\u0011\u0001g\u000b\u0002\u0011\u0007V\u0014\u0018\r^8s\rJ\fW.Z<pe.D\u0001B\r\u0001\u0003\u0002\u0003\u0006IaM\u0001\u0005G>tg\r\u0005\u0002\u001bi%\u0011Q\u0007\u0003\u0002\n'B\f'o[\"p]\u001aDQa\u000e\u0001\u0005\u0002a\na\u0001P5oSRtD\u0003B\u001d;wq\u0002\"A\u0006\u0001\t\u000by1\u0004\u0019\u0001\u0011\t\u000b!2\u0004\u0019A\u0015\t\u000bI2\u0004\u0019A\u001a\t\u000fy\u0002!\u0019!C\u0005\u007f\u0005Yqk\u0014*L\u0013:;u\fR%S+\u0005\u0001\u0005CA!G\u001b\u0005\u0011%BA\"E\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\u000bAA[1wC&\u0011QE\u0011\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002!\u0002\u0019]{%kS%O\u000f~#\u0015J\u0015\u0011\t\u000b)\u0003A\u0011A&\u0002\tA\fG\u000f\u001b\u000b\u0003A1CQ!T%A\u0002\u0001\nAA\\1nK\")q\n\u0001C!!\u00069Q\r\u001f9v]\u001e,GCA)U!\t\u0001\"+\u0003\u0002T#\t!QK\\5u\u0011\u0015ie\n1\u0001!\u0011\u00151\u0006\u0001\"\u0011X\u0003\u001d\u0001XM]:jgR$2!\u0015-Z\u0011\u0015iU\u000b1\u0001!\u0011\u0015QV\u000b1\u0001\\\u0003\ry'M\u001b\t\u0003\u0003rK!!\u0018\"\u0003\r=\u0013'.Z2u\u0011\u0015y\u0006\u0001\"\u0011a\u0003\u00151W\r^2i+\t\tw\r\u0006\u0002caB\u0019\u0001cY3\n\u0005\u0011\f\"AB(qi&|g\u000e\u0005\u0002gO2\u0001A!\u00025_\u0005\u0004I'!\u0001+\u0012\u0005)l\u0007C\u0001\tl\u0013\ta\u0017CA\u0004O_RD\u0017N\\4\u0011\u0005Aq\u0017BA8\u0012\u0005\r\te.\u001f\u0005\u0006\u001bz\u0003\r\u0001\t\u0005\u0006e\u0002!\te]\u0001\tM\u0016$8\r[!mYV\u0019A/!\u0002\u0015\u0003U\u0004BA\u001e@\u0002\u00049\u0011q\u000f \b\u0003qnl\u0011!\u001f\u0006\u0003u~\ta\u0001\u0010:p_Rt\u0014\"\u0001\n\n\u0005u\f\u0012a\u00029bG.\fw-Z\u0005\u0004\u007f\u0006\u0005!\u0001C%uKJ\f'\r\\3\u000b\u0005u\f\u0002c\u00014\u0002\u0006\u0011)\u0001.\u001db\u0001S\u0002")
public class ZookeeperMesosClusterPersistenceEngine
implements MesosClusterPersistenceEngine,
Logging {
    private final CuratorFramework zk;
    private final String WORKING_DIR;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private String WORKING_DIR() {
        return this.WORKING_DIR;
    }

    public String path(String name) {
        return new StringBuilder().append((Object)this.WORKING_DIR()).append((Object)"/").append((Object)name).toString();
    }

    @Override
    public void expunge(String name) {
        this.zk.delete().forPath(this.path(name));
    }

    @Override
    public void persist(String name, Object obj) {
        byte[] serialized = Utils$.MODULE$.serialize(obj);
        String zkPath = this.path(name);
        ((PathAndBytesable)this.zk.create().withMode(CreateMode.PERSISTENT)).forPath(zkPath, serialized);
    }

    @Override
    public <T> Option<T> fetch(String name) {
        None$ none$;
        String zkPath = this.path(name);
        try {
            byte[] fileData = (byte[])this.zk.getData().forPath(zkPath);
            none$ = new Some(Utils$.MODULE$.deserialize(fileData));
        }
        catch (Exception exception2) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exception while reading persisted file, deleting";
                }
            }, exception2);
            this.zk.delete().forPath(zkPath);
            none$ = None$.MODULE$;
        }
        catch (KeeperException.NoNodeException noNodeException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public <T> Iterable<T> fetchAll() {
        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.zk.getChildren().forPath(this.WORKING_DIR())).asScala()).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZookeeperMesosClusterPersistenceEngine $outer;

            public final Iterable<T> apply(String name) {
                return Option$.MODULE$.option2Iterable(this.$outer.fetch(name));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public ZookeeperMesosClusterPersistenceEngine(String baseDir, CuratorFramework zk, SparkConf conf) {
        this.zk = zk;
        Logging$class.$init$(this);
        this.WORKING_DIR = new StringBuilder().append((Object)conf.get("spark.deploy.zookeeper.dir", "/spark_mesos_dispatcher")).append((Object)"/").append((Object)baseDir).toString();
        SparkCuratorUtil$.MODULE$.mkdir(zk, this.WORKING_DIR());
    }
}

