/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.broadcast;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.broadcast.BroadcastFactory;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma!B\u0001\u0003\u0001\u0011Q!\u0001\u0005\"s_\u0006$7-Y:u\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0005ce>\fGmY1ti*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xmE\u0002\u0001\u0017E\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007C\u0001\n\u0014\u001b\u0005!\u0011B\u0001\u000b\u0005\u0005\u001daunZ4j]\u001eD\u0001B\u0006\u0001\u0003\u0006\u0004%\t\u0001G\u0001\tSN$%/\u001b<fe\u000e\u0001Q#A\r\u0011\u00051Q\u0012BA\u000e\u000e\u0005\u001d\u0011un\u001c7fC:D\u0001\"\b\u0001\u0003\u0002\u0003\u0006I!G\u0001\nSN$%/\u001b<fe\u0002B\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0005G>tg\r\u0005\u0002\u0013C%\u0011!\u0005\u0002\u0002\n'B\f'o[\"p]\u001aD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0010g\u0016\u001cWO]5us6\u000bg.Y4feB\u0011!CJ\u0005\u0003O\u0011\u0011qbU3dkJLG/_'b]\u0006<WM\u001d\u0005\u0006S\u0001!\tAK\u0001\u0007y%t\u0017\u000e\u001e \u0015\t-jcf\f\t\u0003Y\u0001i\u0011A\u0001\u0005\u0006-!\u0002\r!\u0007\u0005\u0006?!\u0002\r\u0001\t\u0005\u0006I!\u0002\r!\n\u0005\bc\u0001\u0001\r\u0011\"\u0003\u0019\u0003-Ig.\u001b;jC2L'0\u001a3\t\u000fM\u0002\u0001\u0019!C\u0005i\u0005y\u0011N\\5uS\u0006d\u0017N_3e?\u0012*\u0017\u000f\u0006\u00026qA\u0011ABN\u0005\u0003o5\u0011A!\u00168ji\"9\u0011HMA\u0001\u0002\u0004I\u0012a\u0001=%c!11\b\u0001Q!\ne\tA\"\u001b8ji&\fG.\u001b>fI\u0002Bq!\u0010\u0001A\u0002\u0013%a(\u0001\tce>\fGmY1ti\u001a\u000b7\r^8ssV\tq\b\u0005\u0002-\u0001&\u0011\u0011I\u0001\u0002\u0011\u0005J|\u0017\rZ2bgR4\u0015m\u0019;pefDqa\u0011\u0001A\u0002\u0013%A)\u0001\u000bce>\fGmY1ti\u001a\u000b7\r^8ss~#S-\u001d\u000b\u0003k\u0015Cq!\u000f\"\u0002\u0002\u0003\u0007q\b\u0003\u0004H\u0001\u0001\u0006KaP\u0001\u0012EJ|\u0017\rZ2bgR4\u0015m\u0019;pef\u0004\u0003\"B%\u0001\t\u0013Q\u0015AC5oSRL\u0017\r\\5{KR\tQ\u0007C\u0003M\u0001\u0011\u0005!*\u0001\u0003ti>\u0004\bb\u0002(\u0001\u0005\u0004%IaT\u0001\u0010]\u0016DHO\u0011:pC\u0012\u001c\u0017m\u001d;JIV\t\u0001\u000b\u0005\u0002R56\t!K\u0003\u0002T)\u00061\u0011\r^8nS\u000eT!!\u0016,\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002X1\u0006!Q\u000f^5m\u0015\u0005I\u0016\u0001\u00026bm\u0006L!a\u0017*\u0003\u0015\u0005#x.\\5d\u0019>tw\r\u0003\u0004^\u0001\u0001\u0006I\u0001U\u0001\u0011]\u0016DHO\u0011:pC\u0012\u001c\u0017m\u001d;JI\u0002BQa\u0018\u0001\u0005\u0002\u0001\fAB\\3x\u0005J|\u0017\rZ2bgR,\"!\u00195\u0015\u0007\tL8\u0010\u0006\u0002dcB\u0019A\u0006\u001a4\n\u0005\u0015\u0014!!\u0003\"s_\u0006$7-Y:u!\t9\u0007\u000e\u0004\u0001\u0005\u000b%t&\u0019\u00016\u0003\u0003Q\u000b\"a\u001b8\u0011\u00051a\u0017BA7\u000e\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001D8\n\u0005Al!aA!os\"9!OXA\u0001\u0002\b\u0019\u0018AC3wS\u0012,gnY3%cA\u0019Ao\u001e4\u000e\u0003UT!A^\u0007\u0002\u000fI,g\r\\3di&\u0011\u00010\u001e\u0002\t\u00072\f7o\u001d+bO\")!P\u0018a\u0001M\u00061a/\u00197vK~CQ\u0001 0A\u0002e\tq![:M_\u000e\fG\u000eC\u0003\u007f\u0001\u0011\u0005q0A\u0006v]\n\u0014x.\u00193dCN$HcB\u001b\u0002\u0002\u0005-\u0011q\u0002\u0005\b\u0003\u0007i\b\u0019AA\u0003\u0003\tIG\rE\u0002\r\u0003\u000fI1!!\u0003\u000e\u0005\u0011auN\\4\t\r\u00055Q\u00101\u0001\u001a\u0003A\u0011X-\\8wK\u001a\u0013x.\u001c#sSZ,'\u000f\u0003\u0004\u0002\u0012u\u0004\r!G\u0001\tE2|7m[5oO\u0002")
public class BroadcastManager
implements Logging {
    private final boolean isDriver;
    private final SparkConf conf;
    private final SecurityManager securityManager;
    private boolean initialized;
    private BroadcastFactory broadcastFactory;
    private final AtomicLong nextBroadcastId;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public boolean isDriver() {
        return this.isDriver;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private BroadcastFactory broadcastFactory() {
        return this.broadcastFactory;
    }

    private void broadcastFactory_$eq(BroadcastFactory x$1) {
        this.broadcastFactory = x$1;
    }

    private synchronized void initialize() {
        if (!this.initialized()) {
            String broadcastFactoryClass = this.conf.get("spark.broadcast.factory", "org.apache.spark.broadcast.TorrentBroadcastFactory");
            this.broadcastFactory_$eq((BroadcastFactory)Utils$.MODULE$.classForName(broadcastFactoryClass).newInstance());
            this.broadcastFactory().initialize(this.isDriver(), this.conf, this.securityManager);
            this.initialized_$eq(true);
        }
    }

    public void stop() {
        this.broadcastFactory().stop();
    }

    private AtomicLong nextBroadcastId() {
        return this.nextBroadcastId;
    }

    public <T> Broadcast<T> newBroadcast(T value_, boolean isLocal, ClassTag<T> evidence$1) {
        return this.broadcastFactory().newBroadcast(value_, isLocal, this.nextBroadcastId().getAndIncrement(), evidence$1);
    }

    public void unbroadcast(long id, boolean removeFromDriver, boolean blocking) {
        this.broadcastFactory().unbroadcast(id, removeFromDriver, blocking);
    }

    public BroadcastManager(boolean isDriver, SparkConf conf, SecurityManager securityManager) {
        this.isDriver = isDriver;
        this.conf = conf;
        this.securityManager = securityManager;
        Logging$class.$init$(this);
        this.initialized = false;
        this.broadcastFactory = null;
        this.initialize();
        this.nextBroadcastId = new AtomicLong(0L);
    }
}

