/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import com.google.common.io.Files;
import java.io.File;
import org.apache.spark.HttpFileServer$;
import org.apache.spark.HttpServer;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.StringAdd$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db!B\u0001\u0003\u0001\tA!A\u0004%uiB4\u0015\u000e\\3TKJ4XM\u001d\u0006\u0003\u0007\u0011\tQa\u001d9be.T!!\u0002\u0004\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0011aA8sON\u0019\u0001!C\b\u0011\u0005)iQ\"A\u0006\u000b\u00031\tQa]2bY\u0006L!AD\u0006\u0003\r\u0005s\u0017PU3g!\t\u0001\u0012#D\u0001\u0003\u0013\t\u0011\"AA\u0004M_\u001e<\u0017N\\4\t\u0011Q\u0001!\u0011!Q\u0001\nY\tAaY8oM\u000e\u0001\u0001C\u0001\t\u0018\u0013\tA\"AA\u0005Ta\u0006\u00148nQ8oM\"A!\u0004\u0001B\u0001B\u0003%1$A\btK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s!\t\u0001B$\u0003\u0002\u001e\u0005\ty1+Z2ve&$\u00180T1oC\u001e,'\u000f\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u00035\u0011X-];fgR,G\rU8siB\u0011!\"I\u0005\u0003E-\u00111!\u00138u\u0011\u0015!\u0003\u0001\"\u0001&\u0003\u0019a\u0014N\\5u}Q!ae\n\u0015*!\t\u0001\u0002\u0001C\u0003\u0015G\u0001\u0007a\u0003C\u0003\u001bG\u0001\u00071\u0004C\u0004 GA\u0005\t\u0019\u0001\u0011\t\u000f-\u0002\u0001\u0019!C\u0001Y\u00059!-Y:f\t&\u0014X#A\u0017\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014AA5p\u0015\u0005\u0011\u0014\u0001\u00026bm\u0006L!\u0001N\u0018\u0003\t\u0019KG.\u001a\u0005\bm\u0001\u0001\r\u0011\"\u00018\u0003-\u0011\u0017m]3ESJ|F%Z9\u0015\u0005aZ\u0004C\u0001\u0006:\u0013\tQ4B\u0001\u0003V]&$\bb\u0002\u001f6\u0003\u0003\u0005\r!L\u0001\u0004q\u0012\n\u0004B\u0002 \u0001A\u0003&Q&\u0001\u0005cCN,G)\u001b:!\u0011\u001d\u0001\u0005\u00011A\u0005\u00021\nqAZ5mK\u0012K'\u000fC\u0004C\u0001\u0001\u0007I\u0011A\"\u0002\u0017\u0019LG.\u001a#je~#S-\u001d\u000b\u0003q\u0011Cq\u0001P!\u0002\u0002\u0003\u0007Q\u0006\u0003\u0004G\u0001\u0001\u0006K!L\u0001\tM&dW\rR5sA!9\u0001\n\u0001a\u0001\n\u0003a\u0013A\u00026be\u0012K'\u000fC\u0004K\u0001\u0001\u0007I\u0011A&\u0002\u0015)\f'\u000fR5s?\u0012*\u0017\u000f\u0006\u00029\u0019\"9A(SA\u0001\u0002\u0004i\u0003B\u0002(\u0001A\u0003&Q&A\u0004kCJ$\u0015N\u001d\u0011\t\u000fA\u0003\u0001\u0019!C\u0001#\u0006Q\u0001\u000e\u001e;q'\u0016\u0014h/\u001a:\u0016\u0003I\u0003\"\u0001E*\n\u0005Q\u0013!A\u0003%uiB\u001cVM\u001d<fe\"9a\u000b\u0001a\u0001\n\u00039\u0016A\u00045uiB\u001cVM\u001d<fe~#S-\u001d\u000b\u0003qaCq\u0001P+\u0002\u0002\u0003\u0007!\u000b\u0003\u0004[\u0001\u0001\u0006KAU\u0001\fQR$\boU3sm\u0016\u0014\b\u0005C\u0004]\u0001\u0001\u0007I\u0011A/\u0002\u0013M,'O^3s+JLW#\u00010\u0011\u0005}\u0013gB\u0001\u0006a\u0013\t\t7\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0012\u0014aa\u0015;sS:<'BA1\f\u0011\u001d1\u0007\u00011A\u0005\u0002\u001d\fQb]3sm\u0016\u0014XK]5`I\u0015\fHC\u0001\u001di\u0011\u001daT-!AA\u0002yCaA\u001b\u0001!B\u0013q\u0016AC:feZ,'/\u0016:jA!)A\u000e\u0001C\u0001[\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0003aBQa\u001c\u0001\u0005\u00025\fAa\u001d;pa\")\u0011\u000f\u0001C\u0001e\u00069\u0011\r\u001a3GS2,GC\u00010t\u0011\u0015!\b\u000f1\u0001.\u0003\u00111\u0017\u000e\\3\t\u000bY\u0004A\u0011A<\u0002\r\u0005$GMS1s)\tq\u0006\u0010C\u0003uk\u0002\u0007Q\u0006C\u0003{\u0001\u0011\u000510\u0001\u0007bI\u00124\u0015\u000e\\3U_\u0012K'\u000fF\u0002_yvDQ\u0001^=A\u00025BQA`=A\u00025\n1\u0001Z5s\u000f)\t\tAAA\u0001\u0012\u0003\u0011\u00111A\u0001\u000f\u0011R$\bOR5mKN+'O^3s!\r\u0001\u0012Q\u0001\u0004\n\u0003\t\t\t\u0011#\u0001\u0003\u0003\u000f\u00192!!\u0002\n\u0011\u001d!\u0013Q\u0001C\u0001\u0003\u0017!\"!a\u0001\t\u0015\u0005=\u0011QAI\u0001\n\u0003\t\t\"A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003'Q3\u0001IA\u000bW\t\t9\u0002\u0005\u0003\u0002\u001a\u0005\rRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0011\u0017\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00121\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class HttpFileServer
implements Logging {
    private final SparkConf conf;
    private final SecurityManager securityManager;
    private final int requestedPort;
    private File baseDir;
    private File fileDir;
    private File jarDir;
    private HttpServer httpServer;
    private String serverUri;
    private transient Logger org$apache$spark$Logging$$log_;

    public static int $lessinit$greater$default$3() {
        return HttpFileServer$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public File baseDir() {
        return this.baseDir;
    }

    public void baseDir_$eq(File x$1) {
        this.baseDir = x$1;
    }

    public File fileDir() {
        return this.fileDir;
    }

    public void fileDir_$eq(File x$1) {
        this.fileDir = x$1;
    }

    public File jarDir() {
        return this.jarDir;
    }

    public void jarDir_$eq(File x$1) {
        this.jarDir = x$1;
    }

    public HttpServer httpServer() {
        return this.httpServer;
    }

    public void httpServer_$eq(HttpServer x$1) {
        this.httpServer = x$1;
    }

    public String serverUri() {
        return this.serverUri;
    }

    public void serverUri_$eq(String x$1) {
        this.serverUri = x$1;
    }

    public void initialize() {
        this.baseDir_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.getLocalDir(this.conf), "httpd"));
        this.fileDir_$eq(new File(this.baseDir(), "files"));
        this.jarDir_$eq(new File(this.baseDir(), "jars"));
        this.fileDir().mkdir();
        this.jarDir().mkdir();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFileServer $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"HTTP File server directory is ").append((Object)this.$outer.baseDir()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.httpServer_$eq(new HttpServer(this.conf, this.baseDir(), this.securityManager, this.requestedPort, "HTTP file server"));
        this.httpServer().start();
        this.serverUri_$eq(this.httpServer().uri());
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFileServer $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"HTTP file server started at: ").append((Object)this.$outer.serverUri()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void stop() {
        this.httpServer().stop();
        try {
            Utils$.MODULE$.deleteRecursively(this.baseDir());
        }
        catch (Exception exception2) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HttpFileServer $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while deleting Spark temp dir: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.baseDir().getAbsolutePath()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, exception2);
        }
    }

    public String addFile(File file) {
        this.addFileToDir(file, this.fileDir());
        return new StringBuilder().append((Object)this.serverUri()).append((Object)"/files/").append((Object)Utils$.MODULE$.encodeFileNameToURIRawPath(file.getName())).toString();
    }

    public String addJar(File file) {
        this.addFileToDir(file, this.jarDir());
        return new StringBuilder().append((Object)this.serverUri()).append((Object)"/jars/").append((Object)Utils$.MODULE$.encodeFileNameToURIRawPath(file.getName())).toString();
    }

    public String addFileToDir(File file, File dir) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " cannot be a directory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
        }
        Files.copy((File)file, (File)new File(dir, file.getName()));
        return new StringBuilder().append((Object)StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)dir), "/")).append((Object)Utils$.MODULE$.encodeFileNameToURIRawPath(file.getName())).toString();
    }

    public HttpFileServer(SparkConf conf, SecurityManager securityManager, int requestedPort) {
        this.conf = conf;
        this.securityManager = securityManager;
        this.requestedPort = requestedPort;
        Logging$class.$init$(this);
        this.baseDir = null;
        this.fileDir = null;
        this.jarDir = null;
        this.httpServer = null;
        this.serverUri = null;
    }
}

