/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection.unsafe.sort;

import com.google.common.primitives.UnsignedLongs;
import org.apache.spark.annotation.Private;
import org.apache.spark.unsafe.types.ByteArray;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;

@Private
public class PrefixComparators {
    public static final StringPrefixComparator STRING = new StringPrefixComparator();
    public static final StringPrefixComparatorDesc STRING_DESC = new StringPrefixComparatorDesc();
    public static final BinaryPrefixComparator BINARY = new BinaryPrefixComparator();
    public static final BinaryPrefixComparatorDesc BINARY_DESC = new BinaryPrefixComparatorDesc();
    public static final LongPrefixComparator LONG = new LongPrefixComparator();
    public static final LongPrefixComparatorDesc LONG_DESC = new LongPrefixComparatorDesc();
    public static final DoublePrefixComparator DOUBLE = new DoublePrefixComparator();
    public static final DoublePrefixComparatorDesc DOUBLE_DESC = new DoublePrefixComparatorDesc();

    private PrefixComparators() {
    }

    public static final class DoublePrefixComparatorDesc
    extends PrefixComparator {
        @Override
        public int compare(long bPrefix, long aPrefix) {
            double a = Double.longBitsToDouble(aPrefix);
            double b = Double.longBitsToDouble(bPrefix);
            return Utils.nanSafeCompareDoubles(a, b);
        }

        public static long computePrefix(double value) {
            return Double.doubleToLongBits(value);
        }
    }

    public static final class DoublePrefixComparator
    extends PrefixComparator {
        @Override
        public int compare(long aPrefix, long bPrefix) {
            double a = Double.longBitsToDouble(aPrefix);
            double b = Double.longBitsToDouble(bPrefix);
            return Utils.nanSafeCompareDoubles(a, b);
        }

        public static long computePrefix(double value) {
            return Double.doubleToLongBits(value);
        }
    }

    public static final class LongPrefixComparatorDesc
    extends PrefixComparator {
        @Override
        public int compare(long b, long a) {
            return a < b ? -1 : (a > b ? 1 : 0);
        }
    }

    public static final class LongPrefixComparator
    extends PrefixComparator {
        @Override
        public int compare(long a, long b) {
            return a < b ? -1 : (a > b ? 1 : 0);
        }
    }

    public static final class BinaryPrefixComparatorDesc
    extends PrefixComparator {
        @Override
        public int compare(long bPrefix, long aPrefix) {
            return UnsignedLongs.compare((long)aPrefix, (long)bPrefix);
        }
    }

    public static final class BinaryPrefixComparator
    extends PrefixComparator {
        @Override
        public int compare(long aPrefix, long bPrefix) {
            return UnsignedLongs.compare((long)aPrefix, (long)bPrefix);
        }

        public static long computePrefix(byte[] bytes) {
            return ByteArray.getPrefix((byte[])bytes);
        }
    }

    public static final class StringPrefixComparatorDesc
    extends PrefixComparator {
        @Override
        public int compare(long bPrefix, long aPrefix) {
            return UnsignedLongs.compare((long)aPrefix, (long)bPrefix);
        }
    }

    public static final class StringPrefixComparator
    extends PrefixComparator {
        @Override
        public int compare(long aPrefix, long bPrefix) {
            return UnsignedLongs.compare((long)aPrefix, (long)bPrefix);
        }

        public static long computePrefix(UTF8String value) {
            return value == null ? 0L : value.getPrefix();
        }
    }
}

