/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection;

import org.apache.spark.SparkEnv$;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.collection.Spillable;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public abstract class Spillable$class {
    public static long elementsRead(Spillable $this) {
        return $this.org$apache$spark$util$collection$Spillable$$_elementsRead();
    }

    public static void addElementsRead(Spillable $this) {
        $this.org$apache$spark$util$collection$Spillable$$_elementsRead_$eq($this.org$apache$spark$util$collection$Spillable$$_elementsRead() + 1L);
    }

    public static boolean maybeSpill(Spillable $this, Object collection, long currentMemory) {
        boolean shouldSpill = false;
        if ($this.elementsRead() % 32L == 0L && currentMemory >= $this.org$apache$spark$util$collection$Spillable$$myMemoryThreshold()) {
            long amountToRequest = 2L * currentMemory - $this.org$apache$spark$util$collection$Spillable$$myMemoryThreshold();
            long granted = $this.taskMemoryManager().acquireExecutionMemory(amountToRequest, MemoryMode.ON_HEAP, null);
            $this.org$apache$spark$util$collection$Spillable$$myMemoryThreshold_$eq($this.org$apache$spark$util$collection$Spillable$$myMemoryThreshold() + granted);
            shouldSpill = currentMemory >= $this.org$apache$spark$util$collection$Spillable$$myMemoryThreshold();
        }
        boolean bl = shouldSpill = shouldSpill || $this.org$apache$spark$util$collection$Spillable$$_elementsRead() > $this.org$apache$spark$util$collection$Spillable$$numElementsForceSpillThreshold();
        if (shouldSpill) {
            $this.org$apache$spark$util$collection$Spillable$$_spillCount_$eq($this.org$apache$spark$util$collection$Spillable$$_spillCount() + 1);
            Spillable$class.logSpillage($this, currentMemory);
            $this.spill(collection);
            $this.org$apache$spark$util$collection$Spillable$$_elementsRead_$eq(0L);
            $this.org$apache$spark$util$collection$Spillable$$_memoryBytesSpilled_$eq($this.org$apache$spark$util$collection$Spillable$$_memoryBytesSpilled() + currentMemory);
            $this.releaseMemory();
        }
        return shouldSpill;
    }

    public static long memoryBytesSpilled(Spillable $this) {
        return $this.org$apache$spark$util$collection$Spillable$$_memoryBytesSpilled();
    }

    public static void releaseMemory(Spillable $this) {
        $this.taskMemoryManager().releaseExecutionMemory($this.org$apache$spark$util$collection$Spillable$$myMemoryThreshold() - $this.org$apache$spark$util$collection$Spillable$$initialMemoryThreshold(), MemoryMode.ON_HEAP, null);
        $this.org$apache$spark$util$collection$Spillable$$myMemoryThreshold_$eq($this.org$apache$spark$util$collection$Spillable$$initialMemoryThreshold());
    }

    private static void logSpillage(Spillable $this, long size) {
        long threadId = Thread.currentThread().getId();
        $this.logInfo((Function0<String>)new Serializable($this, size, threadId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Spillable $outer;
            private final long size$1;
            private final long threadId$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Thread %d spilling in-memory map of %s to disk (%d time%s so far)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.threadId$1), Utils$.MODULE$.bytesToString(this.size$1), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$util$collection$Spillable$$_spillCount()), this.$outer.org$apache$spark$util$collection$Spillable$$_spillCount() > 1 ? "s" : ""}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.size$1 = size$1;
                this.threadId$1 = threadId$1;
            }
        });
    }

    public static void $init$(Spillable $this) {
        $this.org$apache$spark$util$collection$Spillable$_setter_$org$apache$spark$util$collection$Spillable$$initialMemoryThreshold_$eq(SparkEnv$.MODULE$.get().conf().getLong("spark.shuffle.spill.initialMemoryThreshold", 0x500000L));
        $this.org$apache$spark$util$collection$Spillable$_setter_$org$apache$spark$util$collection$Spillable$$numElementsForceSpillThreshold_$eq(SparkEnv$.MODULE$.get().conf().getLong("spark.shuffle.spill.numElementsForceSpillThreshold", Long.MAX_VALUE));
        $this.org$apache$spark$util$collection$Spillable$$myMemoryThreshold_$eq($this.org$apache$spark$util$collection$Spillable$$initialMemoryThreshold());
        $this.org$apache$spark$util$collection$Spillable$$_elementsRead_$eq(0L);
        $this.org$apache$spark$util$collection$Spillable$$_memoryBytesSpilled_$eq(0L);
        $this.org$apache$spark$util$collection$Spillable$$_spillCount_$eq(0);
    }
}

