/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.partial;

import java.util.HashMap;
import java.util.Map;
import org.apache.spark.partial.ApproximateEvaluator;
import org.apache.spark.partial.BoundedDouble;
import org.apache.spark.partial.StudentTCacher;
import org.apache.spark.util.StatCounter;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!4Q!\u0001\u0002\u0001\t)\u0011Ac\u0012:pkB,G-T3b]\u00163\u0018\r\\;bi>\u0014(BA\u0002\u0005\u0003\u001d\u0001\u0018M\u001d;jC2T!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011AB1qC\u000eDWMC\u0001\n\u0003\ry'oZ\u000b\u0003\u0017\u0001\u001a2\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB!1\u0003\u0006\f0\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005Q\t\u0005\u000f\u001d:pq&l\u0017\r^3Fm\u0006dW/\u0019;peB!q\u0003\b\u0010+\u001b\u0005A\"BA\r\u001b\u0003\u0011)H/\u001b7\u000b\u0003m\tAA[1wC&\u0011Q\u0004\u0007\u0002\b\u0011\u0006\u001c\b.T1q!\ty\u0002\u0005\u0004\u0001\u0005\u000b\u0005\u0002!\u0019A\u0012\u0003\u0003Q\u001b\u0001!\u0005\u0002%OA\u0011Q\"J\u0005\u0003M9\u0011qAT8uQ&tw\r\u0005\u0002\u000eQ%\u0011\u0011F\u0004\u0002\u0004\u0003:L\bCA\u0016.\u001b\u0005a#BA\r\u0005\u0013\tqCFA\u0006Ti\u0006$8i\\;oi\u0016\u0014\b\u0003\u0002\u00194=Uj\u0011!\r\u0006\u0003e9\t!bY8mY\u0016\u001cG/[8o\u0013\t!\u0014GA\u0002NCB\u0004\"a\u0005\u001c\n\u0005]\u0012!!\u0004\"pk:$W\r\u001a#pk\ndW\r\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u00031!x\u000e^1m\u001fV$\b/\u001e;t!\ti1(\u0003\u0002=\u001d\t\u0019\u0011J\u001c;\t\u0011y\u0002!\u0011!Q\u0001\n}\n!bY8oM&$WM\\2f!\ti\u0001)\u0003\u0002B\u001d\t1Ai\\;cY\u0016DQa\u0011\u0001\u0005\u0002\u0011\u000ba\u0001P5oSRtDcA#G\u000fB\u00191\u0003\u0001\u0010\t\u000be\u0012\u0005\u0019\u0001\u001e\t\u000by\u0012\u0005\u0019A \t\u000f%\u0003\u0001\u0019!C\u0001\u0015\u0006iq.\u001e;qkR\u001cX*\u001a:hK\u0012,\u0012A\u000f\u0005\b\u0019\u0002\u0001\r\u0011\"\u0001N\u0003EyW\u000f\u001e9viNlUM]4fI~#S-\u001d\u000b\u0003\u001dF\u0003\"!D(\n\u0005As!\u0001B+oSRDqAU&\u0002\u0002\u0003\u0007!(A\u0002yIEBa\u0001\u0016\u0001!B\u0013Q\u0014AD8viB,Ho]'fe\u001e,G\r\t\u0005\b-\u0002\u0001\r\u0011\"\u0001X\u0003\u0011\u0019X/\\:\u0016\u0003YAq!\u0017\u0001A\u0002\u0013\u0005!,\u0001\u0005tk6\u001cx\fJ3r)\tq5\fC\u0004S1\u0006\u0005\t\u0019\u0001\f\t\ru\u0003\u0001\u0015)\u0003\u0017\u0003\u0015\u0019X/\\:!\u0011\u0015y\u0006\u0001\"\u0011a\u0003\u0015iWM]4f)\rq\u0015m\u0019\u0005\u0006Ez\u0003\rAO\u0001\t_V$\b/\u001e;JI\")AM\u0018a\u0001-\u0005QA/Y:l%\u0016\u001cX\u000f\u001c;\t\u000b\u0019\u0004A\u0011I4\u0002\u001b\r,(O]3oiJ+7/\u001e7u)\u0005y\u0003")
public class GroupedMeanEvaluator<T>
implements ApproximateEvaluator<HashMap<T, StatCounter>, Map<T, BoundedDouble>> {
    private final int totalOutputs;
    private final double confidence;
    private int outputsMerged;
    private HashMap<T, StatCounter> sums;

    public int outputsMerged() {
        return this.outputsMerged;
    }

    public void outputsMerged_$eq(int x$1) {
        this.outputsMerged = x$1;
    }

    public HashMap<T, StatCounter> sums() {
        return this.sums;
    }

    public void sums_$eq(HashMap<T, StatCounter> x$1) {
        this.sums = x$1;
    }

    @Override
    public void merge(int outputId, HashMap<T, StatCounter> taskResult) {
        this.outputsMerged_$eq(this.outputsMerged() + 1);
        for (Map.Entry<T, StatCounter> entry : taskResult.entrySet()) {
            StatCounter old = this.sums().get(entry.getKey());
            StatCounter statCounter = old == null ? this.sums().put(entry.getKey(), entry.getValue()) : old.merge(entry.getValue());
        }
    }

    @Override
    public Map<T, BoundedDouble> currentResult() {
        scala.collection.mutable.HashMap hashMap;
        if (this.outputsMerged() == this.totalOutputs) {
            HashMap<T, BoundedDouble> result = new HashMap<T, BoundedDouble>(this.sums().size());
            for (Map.Entry<T, StatCounter> entry : this.sums().entrySet()) {
                double mean2 = entry.getValue().mean();
                result.put(entry.getKey(), new BoundedDouble(mean2, 1.0, mean2, mean2));
            }
            hashMap = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(result).asScala();
        } else if (this.outputsMerged() == 0) {
            hashMap = new scala.collection.mutable.HashMap();
        } else {
            StudentTCacher studentTCacher = new StudentTCacher(this.confidence);
            HashMap<T, BoundedDouble> result = new HashMap<T, BoundedDouble>(this.sums().size());
            for (Map.Entry<T, StatCounter> entry : this.sums().entrySet()) {
                StatCounter counter = entry.getValue();
                double mean3 = counter.mean();
                double stdev2 = package$.MODULE$.sqrt(counter.sampleVariance() / (double)counter.count());
                double confFactor = studentTCacher.get(counter.count());
                double low = mean3 - confFactor * stdev2;
                double high = mean3 + confFactor * stdev2;
                result.put(entry.getKey(), new BoundedDouble(mean3, this.confidence, low, high));
            }
            hashMap = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(result).asScala();
        }
        return hashMap;
    }

    public GroupedMeanEvaluator(int totalOutputs, double confidence) {
        this.totalOutputs = totalOutputs;
        this.confidence = confidence;
        this.outputsMerged = 0;
        this.sums = new HashMap();
    }
}

