/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import org.apache.spark.SparkConf;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.UnifiedMemoryManager$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockStatus;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m4Q!\u0001\u0002\u0001\t)\u0011A#\u00168jM&,G-T3n_JLX*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003\u0019iW-\\8ss*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0005\u0002\u0001\u0017A\u0011A\"D\u0007\u0002\u0005%\u0011aB\u0001\u0002\u000e\u001b\u0016lwN]=NC:\fw-\u001a:\t\u0011A\u0001!\u0011!Q\u0001\nI\tAaY8oM\u000e\u0001\u0001CA\n\u0015\u001b\u0005!\u0011BA\u000b\u0005\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u0005\u0018\u0001\t\u0015\r\u0011\"\u0001\u0019\u0003%i\u0017\r_'f[>\u0014\u00180F\u0001\u001a!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0011auN\\4\t\u0011\u0001\u0002!\u0011!Q\u0001\ne\t!\"\\1y\u001b\u0016lwN]=!\u0011!\u0011\u0003A!A!\u0002\u0013I\u0012!E:u_J\fw-\u001a*fO&|gnU5{K\"AA\u0005\u0001B\u0001B\u0003%Q%\u0001\u0005ok6\u001cuN]3t!\tQb%\u0003\u0002(7\t\u0019\u0011J\u001c;\t\r%\u0002A\u0011\u0001\u0002+\u0003\u0019a\u0014N\\5u}Q)1\u0006L\u0017/_A\u0011A\u0002\u0001\u0005\u0006!!\u0002\rA\u0005\u0005\u0006/!\u0002\r!\u0007\u0005\u0006E!\u0002\r!\u0007\u0005\u0006I!\u0002\r!\n\u0005\u0006c\u0001!\t\u0005G\u0001\u0011[\u0006D8\u000b^8sC\u001e,W*Z7pefDaa\r\u0001\u0005B\t!\u0014AF1dcVL'/Z#yK\u000e,H/[8o\u001b\u0016lwN]=\u0015\te)t'\u000f\u0005\u0006mI\u0002\r!G\u0001\t]Vl')\u001f;fg\")\u0001H\ra\u00013\u0005iA/Y:l\u0003R$X-\u001c9u\u0013\u0012DQA\u000f\u001aA\u0002m\n!\"\\3n_JLXj\u001c3f!\taA(\u0003\u0002>\u0005\tQQ*Z7peflu\u000eZ3\t\u000b}\u0002A\u0011\t!\u0002)\u0005\u001c\u0017/^5sKN#xN]1hK6+Wn\u001c:z)\u0011\tE\tT'\u0011\u0005i\u0011\u0015BA\"\u001c\u0005\u001d\u0011un\u001c7fC:DQ!\u0012 A\u0002\u0019\u000bqA\u00197pG.LE\r\u0005\u0002H\u00156\t\u0001J\u0003\u0002J\t\u000591\u000f^8sC\u001e,\u0017BA&I\u0005\u001d\u0011En\\2l\u0013\u0012DQA\u000e A\u0002eAQA\u0014 A\u0002=\u000bQ\"\u001a<jGR,GM\u00117pG.\u001c\bc\u0001)V/6\t\u0011K\u0003\u0002S'\u00069Q.\u001e;bE2,'B\u0001+\u001c\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003-F\u0013aAQ;gM\u0016\u0014\b\u0003\u0002\u000eY\rjK!!W\u000e\u0003\rQ+\b\u000f\\33!\t95,\u0003\u0002]\u0011\nY!\t\\8dWN#\u0018\r^;t\u0011\u0015q\u0006\u0001\"\u0011`\u0003M\t7-];je\u0016,fN]8mY6+Wn\u001c:z)\u0011\t\u0005-\u00192\t\u000b\u0015k\u0006\u0019\u0001$\t\u000bYj\u0006\u0019A\r\t\u000b9k\u0006\u0019A(\b\u000b\u0011\u0014\u0001\u0012A3\u0002)Us\u0017NZ5fI6+Wn\u001c:z\u001b\u0006t\u0017mZ3s!\taaMB\u0003\u0002\u0005!\u0005qm\u0005\u0002gQB\u0011!$[\u0005\u0003Un\u0011a!\u00118z%\u00164\u0007\"B\u0015g\t\u0003aG#A3\t\u000f94'\u0019!C\u0005_\u0006a\"+R*F%Z+EiX*Z'R+UjX'F\u001b>\u0013\u0016l\u0018\"Z)\u0016\u001bV#A\u0013\t\rE4\u0007\u0015!\u0003&\u0003u\u0011ViU#S-\u0016#ulU-T)\u0016ku,T#N\u001fJKvLQ-U\u000bN\u0003\u0003\"B:g\t\u0003!\u0018!B1qa2LHcA\u0016vm\")\u0001C\u001da\u0001%!)AE\u001da\u0001K!)\u0001P\u001aC\u0005s\u0006aq-\u001a;NCblU-\\8ssR\u0011\u0011D\u001f\u0005\u0006!]\u0004\rA\u0005")
public class UnifiedMemoryManager
extends MemoryManager {
    private final long maxMemory;
    private final long storageRegionSize;

    public static UnifiedMemoryManager apply(SparkConf sparkConf, int n) {
        return UnifiedMemoryManager$.MODULE$.apply(sparkConf, n);
    }

    public long maxMemory() {
        return this.maxMemory;
    }

    @Override
    public synchronized long maxStorageMemory() {
        return this.maxMemory() - this.onHeapExecutionMemoryPool().memoryUsed();
    }

    @Override
    public synchronized long acquireExecutionMemory(long numBytes, long taskAttemptId, MemoryMode memoryMode) {
        MemoryMode memoryMode2;
        block4: {
            long l;
            block3: {
                block2: {
                    Predef$.MODULE$.assert(this.onHeapExecutionMemoryPool().poolSize() + this.storageMemoryPool().poolSize() == this.maxMemory());
                    Predef$.MODULE$.assert(numBytes >= 0L);
                    memoryMode2 = memoryMode;
                    MemoryMode memoryMode3 = MemoryMode.ON_HEAP;
                    MemoryMode memoryMode4 = memoryMode2;
                    if (memoryMode3 != null ? !((Object)((Object)memoryMode3)).equals((Object)memoryMode4) : memoryMode4 != null) break block2;
                    l = this.onHeapExecutionMemoryPool().acquireMemory(numBytes, taskAttemptId, (Function1<Object, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ UnifiedMemoryManager $outer;

                        public final void apply(long extraMemoryNeeded) {
                            this.apply$mcVJ$sp(extraMemoryNeeded);
                        }

                        public void apply$mcVJ$sp(long extraMemoryNeeded) {
                            this.$outer.org$apache$spark$memory$UnifiedMemoryManager$$maybeGrowExecutionPool$1(extraMemoryNeeded);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, (Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ UnifiedMemoryManager $outer;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return this.$outer.org$apache$spark$memory$UnifiedMemoryManager$$computeMaxExecutionPoolSize$1();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    break block3;
                }
                MemoryMode memoryMode5 = MemoryMode.OFF_HEAP;
                MemoryMode memoryMode6 = memoryMode2;
                if (memoryMode5 != null ? !((Object)((Object)memoryMode5)).equals((Object)memoryMode6) : memoryMode6 != null) break block4;
                l = this.offHeapExecutionMemoryPool().acquireMemory(numBytes, taskAttemptId, this.offHeapExecutionMemoryPool().acquireMemory$default$3(), this.offHeapExecutionMemoryPool().acquireMemory$default$4());
            }
            return l;
        }
        throw new MatchError((Object)memoryMode2);
    }

    @Override
    public synchronized boolean acquireStorageMemory(BlockId blockId, long numBytes, Buffer<Tuple2<BlockId, BlockStatus>> evictedBlocks) {
        Predef$.MODULE$.assert(this.onHeapExecutionMemoryPool().poolSize() + this.storageMemoryPool().poolSize() == this.maxMemory());
        Predef$.MODULE$.assert(numBytes >= 0L);
        if (numBytes > this.maxStorageMemory()) {
            this.logInfo((Function0<String>)new Serializable(this, blockId, numBytes){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ UnifiedMemoryManager $outer;
                private final BlockId blockId$1;
                private final long numBytes$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will not store ", " as the required space (", " bytes) exceeds our "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1, BoxesRunTime.boxToLong((long)this.numBytes$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory limit (", " bytes)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.maxStorageMemory())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.blockId$1 = blockId$1;
                    this.numBytes$1 = numBytes$1;
                }
            });
            return false;
        }
        if (numBytes > this.storageMemoryPool().memoryFree()) {
            long memoryBorrowedFromExecution = Math.min(this.onHeapExecutionMemoryPool().memoryFree(), numBytes);
            this.onHeapExecutionMemoryPool().decrementPoolSize(memoryBorrowedFromExecution);
            this.storageMemoryPool().incrementPoolSize(memoryBorrowedFromExecution);
        }
        return this.storageMemoryPool().acquireMemory(blockId, numBytes, evictedBlocks);
    }

    @Override
    public synchronized boolean acquireUnrollMemory(BlockId blockId, long numBytes, Buffer<Tuple2<BlockId, BlockStatus>> evictedBlocks) {
        return this.acquireStorageMemory(blockId, numBytes, evictedBlocks);
    }

    public final void org$apache$spark$memory$UnifiedMemoryManager$$maybeGrowExecutionPool$1(long extraMemoryNeeded) {
        long memoryReclaimableFromStorage;
        if (extraMemoryNeeded > 0L && (memoryReclaimableFromStorage = package$.MODULE$.max(this.storageMemoryPool().memoryFree(), this.storageMemoryPool().poolSize() - this.storageRegionSize)) > 0L) {
            long spaceReclaimed = this.storageMemoryPool().shrinkPoolToFreeSpace(package$.MODULE$.min(extraMemoryNeeded, memoryReclaimableFromStorage));
            this.onHeapExecutionMemoryPool().incrementPoolSize(spaceReclaimed);
        }
    }

    public final long org$apache$spark$memory$UnifiedMemoryManager$$computeMaxExecutionPoolSize$1() {
        return this.maxMemory() - package$.MODULE$.min(this.storageMemoryUsed(), this.storageRegionSize);
    }

    public UnifiedMemoryManager(SparkConf conf, long maxMemory, long storageRegionSize, int numCores) {
        this.maxMemory = maxMemory;
        this.storageRegionSize = storageRegionSize;
        super(conf, numCores, storageRegionSize, maxMemory - storageRegionSize);
        Predef$.MODULE$.assert(this.onHeapExecutionMemoryPool().poolSize() + this.storageMemoryPool().poolSize() == maxMemory);
    }
}

