/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.random;

import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.hashing.MurmurHash3$;

public final class XORShiftRandom$
implements Serializable {
    public static final XORShiftRandom$ MODULE$;

    static {
        new XORShiftRandom$();
    }

    public long hashSeed(long seed) {
        byte[] bytes = ByteBuffer.allocate(64).putLong(seed).array();
        int lowBits = MurmurHash3$.MODULE$.bytesHash(bytes);
        int highBits = MurmurHash3$.MODULE$.bytesHash(bytes, lowBits);
        return (long)highBits << 32 | (long)lowBits & 0xFFFFFFFFL;
    }

    public void main(String[] args) {
        if (args.length != 1) {
            Predef$.MODULE$.println((Object)"Benchmark of XORShiftRandom vis-a-vis java.util.Random");
            Predef$.MODULE$.println((Object)"Usage: XORShiftRandom number_of_random_numbers_to_generate");
            System.exit(1);
        }
        Predef$.MODULE$.println(this.benchmark(new StringOps(Predef$.MODULE$.augmentString(args[0])).toInt()));
    }

    public Map<String, Object> benchmark(int numIters) {
        long seed = 1L;
        int million = (int)1000000.0;
        Random javaRand = new Random(seed);
        XORShiftRandom xorRand = new XORShiftRandom(seed);
        int x$1 = million;
        Serializable x$2 = new Serializable(javaRand, xorRand){
            public static final long serialVersionUID = 0L;
            private final Random javaRand$1;
            private final XORShiftRandom xorRand$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.javaRand$1.nextInt();
                this.xorRand$1.nextInt();
            }
            {
                this.javaRand$1 = javaRand$1;
                this.xorRand$1 = xorRand$1;
            }
        };
        Option<Function0<BoxedUnit>> x$3 = Utils$.MODULE$.timeIt$default$3(x$1);
        Utils$.MODULE$.timeIt(x$1, (Function0<BoxedUnit>)x$2, x$3);
        Tuple2[] tuple2Array = new Tuple2[2];
        int x$4 = numIters;
        Serializable x$5 = new Serializable(javaRand){
            public static final long serialVersionUID = 0L;
            private final Random javaRand$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.javaRand$1.nextInt();
            }
            {
                this.javaRand$1 = javaRand$1;
            }
        };
        Option<Function0<BoxedUnit>> x$6 = Utils$.MODULE$.timeIt$default$3(x$4);
        tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"javaTime"), (Object)BoxesRunTime.boxToLong((long)Utils$.MODULE$.timeIt(x$4, (Function0<BoxedUnit>)x$5, x$6)));
        int x$7 = numIters;
        Serializable x$8 = new Serializable(xorRand){
            public static final long serialVersionUID = 0L;
            private final XORShiftRandom xorRand$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.xorRand$1.nextInt();
            }
            {
                this.xorRand$1 = xorRand$1;
            }
        };
        Option<Function0<BoxedUnit>> x$9 = Utils$.MODULE$.timeIt$default$3(x$7);
        tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"xorTime"), (Object)BoxesRunTime.boxToLong((long)Utils$.MODULE$.timeIt(x$7, (Function0<BoxedUnit>)x$8, x$9)));
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private XORShiftRandom$() {
        MODULE$ = this;
    }
}

