/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.map;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.apache.spark.SparkEnv;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.unsafe.map.HashMapGrowthStrategy;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.unsafe.memory.MemoryLocation;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterSpillReader;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterSpillWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BytesToBytesMap
extends MemoryConsumer {
    private final Logger logger = LoggerFactory.getLogger(BytesToBytesMap.class);
    private static final Murmur3_x86_32 HASHER = new Murmur3_x86_32(0);
    private static final HashMapGrowthStrategy growthStrategy = HashMapGrowthStrategy.DOUBLING;
    private final TaskMemoryManager taskMemoryManager;
    private final LinkedList<MemoryBlock> dataPages = new LinkedList();
    private MemoryBlock currentPage = null;
    private long pageCursor = 0L;
    @VisibleForTesting
    static final int MAX_CAPACITY = 0x20000000;
    @Nullable
    private LongArray longArray;
    private boolean canGrowArray = true;
    private final double loadFactor;
    private final long pageSizeBytes;
    private int numElements;
    private int growthThreshold;
    private int mask;
    private final Location loc;
    private final boolean enablePerfMetrics;
    private long timeSpentResizingNs = 0L;
    private long numProbes = 0L;
    private long numKeyLookups = 0L;
    private long numHashCollisions = 0L;
    private long peakMemoryUsedBytes = 0L;
    private final BlockManager blockManager;
    private volatile MapIterator destructiveIterator = null;
    private LinkedList<UnsafeSorterSpillWriter> spillWriters = new LinkedList();

    public BytesToBytesMap(TaskMemoryManager taskMemoryManager, BlockManager blockManager2, int initialCapacity, double loadFactor, long pageSizeBytes, boolean enablePerfMetrics) {
        super(taskMemoryManager, pageSizeBytes);
        this.taskMemoryManager = taskMemoryManager;
        this.blockManager = blockManager2;
        this.loadFactor = loadFactor;
        this.loc = new Location();
        this.pageSizeBytes = pageSizeBytes;
        this.enablePerfMetrics = enablePerfMetrics;
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("Initial capacity must be greater than 0");
        }
        if (initialCapacity > 0x20000000) {
            throw new IllegalArgumentException("Initial capacity " + initialCapacity + " exceeds maximum capacity of " + 0x20000000);
        }
        if (pageSizeBytes > 0x3FFFFFFF8L) {
            throw new IllegalArgumentException("Page size " + pageSizeBytes + " cannot exceed " + 0x3FFFFFFF8L);
        }
        this.allocate(initialCapacity);
    }

    public BytesToBytesMap(TaskMemoryManager taskMemoryManager, int initialCapacity, long pageSizeBytes) {
        this(taskMemoryManager, initialCapacity, pageSizeBytes, false);
    }

    public BytesToBytesMap(TaskMemoryManager taskMemoryManager, int initialCapacity, long pageSizeBytes, boolean enablePerfMetrics) {
        this(taskMemoryManager, SparkEnv.get() != null ? SparkEnv.get().blockManager() : null, initialCapacity, 0.7, pageSizeBytes, enablePerfMetrics);
    }

    public int numElements() {
        return this.numElements;
    }

    public MapIterator iterator() {
        return new MapIterator(this.numElements, this.loc, false);
    }

    public MapIterator destructiveIterator() {
        return new MapIterator(this.numElements, this.loc, true);
    }

    public Location lookup(Object keyBase, long keyOffset, int keyLength) {
        this.safeLookup(keyBase, keyOffset, keyLength, this.loc);
        return this.loc;
    }

    public void safeLookup(Object keyBase, long keyOffset, int keyLength, Location loc) {
        assert (this.longArray != null);
        if (this.enablePerfMetrics) {
            ++this.numKeyLookups;
        }
        int hashcode = HASHER.hashUnsafeWords(keyBase, keyOffset, keyLength);
        int pos = hashcode & this.mask;
        int step = 1;
        while (true) {
            if (this.enablePerfMetrics) {
                ++this.numProbes;
            }
            if (this.longArray.get(pos * 2) == 0L) {
                loc.with(pos, hashcode, false);
                return;
            }
            long stored = this.longArray.get(pos * 2 + 1);
            if ((int)stored == hashcode) {
                loc.with(pos, hashcode, true);
                if (loc.getKeyLength() == keyLength) {
                    long storedkeyOffset;
                    MemoryLocation keyAddress = loc.getKeyAddress();
                    Object storedkeyBase = keyAddress.getBaseObject();
                    boolean areEqual = ByteArrayMethods.arrayEquals((Object)keyBase, (long)keyOffset, (Object)storedkeyBase, (long)(storedkeyOffset = keyAddress.getBaseOffset()), (long)keyLength);
                    if (areEqual) {
                        return;
                    }
                    if (this.enablePerfMetrics) {
                        ++this.numHashCollisions;
                    }
                }
            }
            pos = pos + step & this.mask;
            ++step;
        }
    }

    private boolean acquireNewPage(long required) {
        try {
            this.currentPage = this.allocatePage(required);
        }
        catch (OutOfMemoryError e) {
            return false;
        }
        this.dataPages.add(this.currentPage);
        Platform.putInt((Object)this.currentPage.getBaseObject(), (long)this.currentPage.getBaseOffset(), (int)0);
        this.pageCursor = 4L;
        return true;
    }

    @Override
    public long spill(long size, MemoryConsumer trigger) throws IOException {
        if (trigger != this && this.destructiveIterator != null) {
            return this.destructiveIterator.spill(size);
        }
        return 0L;
    }

    private void allocate(int capacity) {
        assert (capacity >= 0);
        capacity = Math.max((int)Math.min(0x20000000L, ByteArrayMethods.nextPowerOf2((long)capacity)), 64);
        assert (capacity <= 0x20000000);
        this.longArray = this.allocateArray(capacity * 2);
        this.longArray.zeroOut();
        this.growthThreshold = (int)((double)capacity * this.loadFactor);
        this.mask = capacity - 1;
    }

    public void free() {
        this.updatePeakMemoryUsed();
        if (this.longArray != null) {
            this.freeArray(this.longArray);
            this.longArray = null;
        }
        Iterator dataPagesIterator = this.dataPages.iterator();
        while (dataPagesIterator.hasNext()) {
            MemoryBlock dataPage = (MemoryBlock)dataPagesIterator.next();
            dataPagesIterator.remove();
            this.freePage(dataPage);
        }
        assert (this.dataPages.isEmpty());
        while (!this.spillWriters.isEmpty()) {
            File file = this.spillWriters.removeFirst().getFile();
            if (file == null || !file.exists() || file.delete()) continue;
            this.logger.error("Was unable to delete spill file {}", (Object)file.getAbsolutePath());
        }
    }

    public TaskMemoryManager getTaskMemoryManager() {
        return this.taskMemoryManager;
    }

    public long getPageSizeBytes() {
        return this.pageSizeBytes;
    }

    public long getTotalMemoryConsumption() {
        long totalDataPagesSize = 0L;
        for (MemoryBlock dataPage : this.dataPages) {
            totalDataPagesSize += dataPage.size();
        }
        return totalDataPagesSize + (this.longArray != null ? this.longArray.memoryBlock().size() : 0L);
    }

    private void updatePeakMemoryUsed() {
        long mem = this.getTotalMemoryConsumption();
        if (mem > this.peakMemoryUsedBytes) {
            this.peakMemoryUsedBytes = mem;
        }
    }

    public long getPeakMemoryUsedBytes() {
        this.updatePeakMemoryUsed();
        return this.peakMemoryUsedBytes;
    }

    public long getTimeSpentResizingNs() {
        if (!this.enablePerfMetrics) {
            throw new IllegalStateException();
        }
        return this.timeSpentResizingNs;
    }

    public double getAverageProbesPerLookup() {
        if (!this.enablePerfMetrics) {
            throw new IllegalStateException();
        }
        return 1.0 * (double)this.numProbes / (double)this.numKeyLookups;
    }

    public long getNumHashCollisions() {
        if (!this.enablePerfMetrics) {
            throw new IllegalStateException();
        }
        return this.numHashCollisions;
    }

    @VisibleForTesting
    public int getNumDataPages() {
        return this.dataPages.size();
    }

    public LongArray getArray() {
        assert (this.longArray != null);
        return this.longArray;
    }

    public void reset() {
        this.numElements = 0;
        this.longArray.zeroOut();
        while (this.dataPages.size() > 0) {
            MemoryBlock dataPage = this.dataPages.removeLast();
            this.freePage(dataPage);
        }
        this.currentPage = null;
        this.pageCursor = 0L;
    }

    @VisibleForTesting
    void growAndRehash() {
        assert (this.longArray != null);
        long resizeStartTime = -1L;
        if (this.enablePerfMetrics) {
            resizeStartTime = System.nanoTime();
        }
        LongArray oldLongArray = this.longArray;
        int oldCapacity = (int)oldLongArray.size() / 2;
        this.allocate(Math.min(growthStrategy.nextCapacity(oldCapacity), 0x20000000));
        int i = 0;
        while ((long)i < oldLongArray.size()) {
            long keyPointer = oldLongArray.get(i);
            if (keyPointer != 0L) {
                int hashcode = (int)oldLongArray.get(i + 1);
                int newPos = hashcode & this.mask;
                int step = 1;
                while (this.longArray.get(newPos * 2) != 0L) {
                    newPos = newPos + step & this.mask;
                    ++step;
                }
                this.longArray.set(newPos * 2, keyPointer);
                this.longArray.set(newPos * 2 + 1, (long)hashcode);
            }
            i += 2;
        }
        this.freeArray(oldLongArray);
        if (this.enablePerfMetrics) {
            this.timeSpentResizingNs += System.nanoTime() - resizeStartTime;
        }
    }

    public final class Location {
        private int pos;
        private boolean isDefined;
        private int keyHashcode;
        private final MemoryLocation keyMemoryLocation = new MemoryLocation();
        private final MemoryLocation valueMemoryLocation = new MemoryLocation();
        private int keyLength;
        private int valueLength;
        @Nullable
        private MemoryBlock memoryPage;

        private void updateAddressesAndSizes(long fullKeyAddress) {
            this.updateAddressesAndSizes(BytesToBytesMap.this.taskMemoryManager.getPage(fullKeyAddress), BytesToBytesMap.this.taskMemoryManager.getOffsetInPage(fullKeyAddress));
        }

        private void updateAddressesAndSizes(Object base, long offset) {
            long position = offset;
            int totalLength = Platform.getInt((Object)base, (long)position);
            this.keyLength = Platform.getInt((Object)base, (long)(position += 4L));
            this.valueLength = totalLength - this.keyLength - 4;
            this.keyMemoryLocation.setObjAndOffset(base, position += 4L);
            this.valueMemoryLocation.setObjAndOffset(base, position += (long)this.keyLength);
        }

        private Location with(int pos, int keyHashcode, boolean isDefined) {
            assert (BytesToBytesMap.this.longArray != null);
            this.pos = pos;
            this.isDefined = isDefined;
            this.keyHashcode = keyHashcode;
            if (isDefined) {
                long fullKeyAddress = BytesToBytesMap.this.longArray.get(pos * 2);
                this.updateAddressesAndSizes(fullKeyAddress);
            }
            return this;
        }

        private Location with(MemoryBlock page, long offsetInPage) {
            this.isDefined = true;
            this.memoryPage = page;
            this.updateAddressesAndSizes(page.getBaseObject(), offsetInPage);
            return this;
        }

        private Location with(Object base, long offset, int length) {
            this.isDefined = true;
            this.memoryPage = null;
            this.keyLength = Platform.getInt((Object)base, (long)offset);
            this.valueLength = length - 4 - this.keyLength;
            this.keyMemoryLocation.setObjAndOffset(base, offset + 4L);
            this.valueMemoryLocation.setObjAndOffset(base, offset + 4L + (long)this.keyLength);
            return this;
        }

        public MemoryBlock getMemoryPage() {
            return this.memoryPage;
        }

        public boolean isDefined() {
            return this.isDefined;
        }

        public MemoryLocation getKeyAddress() {
            assert (this.isDefined);
            return this.keyMemoryLocation;
        }

        public int getKeyLength() {
            assert (this.isDefined);
            return this.keyLength;
        }

        public MemoryLocation getValueAddress() {
            assert (this.isDefined);
            return this.valueMemoryLocation;
        }

        public int getValueLength() {
            assert (this.isDefined);
            return this.valueLength;
        }

        public boolean putNewKey(Object keyBase, long keyOffset, int keyLength, Object valueBase, long valueOffset, int valueLength) {
            long offset;
            assert (!this.isDefined) : "Can only set value once for a key";
            assert (keyLength % 8 == 0);
            assert (valueLength % 8 == 0);
            assert (BytesToBytesMap.this.longArray != null);
            if (BytesToBytesMap.this.numElements == 0x20000000 || !BytesToBytesMap.this.canGrowArray && BytesToBytesMap.this.numElements > BytesToBytesMap.this.growthThreshold) {
                return false;
            }
            long recordLength = 8 + keyLength + valueLength;
            if (!(BytesToBytesMap.this.currentPage != null && BytesToBytesMap.this.currentPage.size() - BytesToBytesMap.this.pageCursor >= recordLength || BytesToBytesMap.this.acquireNewPage(recordLength + 4L))) {
                return false;
            }
            Object base = BytesToBytesMap.this.currentPage.getBaseObject();
            long recordOffset = offset = BytesToBytesMap.this.currentPage.getBaseOffset() + BytesToBytesMap.this.pageCursor;
            Platform.putInt((Object)base, (long)offset, (int)(keyLength + valueLength + 4));
            Platform.putInt((Object)base, (long)(offset + 4L), (int)keyLength);
            Platform.copyMemory((Object)keyBase, (long)keyOffset, (Object)base, (long)(offset += 8L), (long)keyLength);
            Platform.copyMemory((Object)valueBase, (long)valueOffset, (Object)base, (long)(offset += (long)keyLength), (long)valueLength);
            offset = BytesToBytesMap.this.currentPage.getBaseOffset();
            Platform.putInt((Object)base, (long)offset, (int)(Platform.getInt((Object)base, (long)offset) + 1));
            BytesToBytesMap.this.pageCursor += recordLength;
            BytesToBytesMap.this.numElements++;
            long storedKeyAddress = BytesToBytesMap.this.taskMemoryManager.encodePageNumberAndOffset(BytesToBytesMap.this.currentPage, recordOffset);
            BytesToBytesMap.this.longArray.set(this.pos * 2, storedKeyAddress);
            BytesToBytesMap.this.longArray.set(this.pos * 2 + 1, (long)this.keyHashcode);
            this.updateAddressesAndSizes(storedKeyAddress);
            this.isDefined = true;
            if (BytesToBytesMap.this.numElements > BytesToBytesMap.this.growthThreshold && BytesToBytesMap.this.longArray.size() < 0x20000000L) {
                try {
                    BytesToBytesMap.this.growAndRehash();
                }
                catch (OutOfMemoryError oom) {
                    BytesToBytesMap.this.canGrowArray = false;
                }
            }
            return true;
        }
    }

    public final class MapIterator
    implements Iterator<Location> {
        private int numRecords;
        private final Location loc;
        private MemoryBlock currentPage = null;
        private int recordsInPage = 0;
        private Object pageBaseObject;
        private long offsetInPage;
        private boolean destructive = false;
        private UnsafeSorterSpillReader reader = null;

        private MapIterator(int numRecords, Location loc, boolean destructive) {
            this.numRecords = numRecords;
            this.loc = loc;
            this.destructive = destructive;
            if (destructive) {
                BytesToBytesMap.this.destructiveIterator = this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void advanceToNextPage() {
            MapIterator mapIterator = this;
            synchronized (mapIterator) {
                int nextIdx = BytesToBytesMap.this.dataPages.indexOf(this.currentPage) + 1;
                if (this.destructive && this.currentPage != null) {
                    BytesToBytesMap.this.dataPages.remove(this.currentPage);
                    BytesToBytesMap.this.freePage(this.currentPage);
                    --nextIdx;
                }
                if (BytesToBytesMap.this.dataPages.size() > nextIdx) {
                    this.currentPage = (MemoryBlock)BytesToBytesMap.this.dataPages.get(nextIdx);
                    this.pageBaseObject = this.currentPage.getBaseObject();
                    this.offsetInPage = this.currentPage.getBaseOffset();
                    this.recordsInPage = Platform.getInt((Object)this.pageBaseObject, (long)this.offsetInPage);
                    this.offsetInPage += 4L;
                } else {
                    File file;
                    this.currentPage = null;
                    if (this.reader != null && (file = ((UnsafeSorterSpillWriter)BytesToBytesMap.this.spillWriters.removeFirst()).getFile()) != null && file.exists() && !file.delete()) {
                        BytesToBytesMap.this.logger.error("Was unable to delete spill file {}", (Object)file.getAbsolutePath());
                    }
                    try {
                        Closeables.close((Closeable)this.reader, (boolean)false);
                        this.reader = ((UnsafeSorterSpillWriter)BytesToBytesMap.this.spillWriters.getFirst()).getReader(BytesToBytesMap.this.blockManager);
                        this.recordsInPage = -1;
                    }
                    catch (IOException e) {
                        Platform.throwException((Throwable)e);
                    }
                }
            }
        }

        @Override
        public boolean hasNext() {
            File file;
            if (this.numRecords == 0 && this.reader != null && (file = ((UnsafeSorterSpillWriter)BytesToBytesMap.this.spillWriters.removeFirst()).getFile()) != null && file.exists() && !file.delete()) {
                BytesToBytesMap.this.logger.error("Was unable to delete spill file {}", (Object)file.getAbsolutePath());
            }
            return this.numRecords > 0;
        }

        @Override
        public Location next() {
            if (this.recordsInPage == 0) {
                this.advanceToNextPage();
            }
            --this.numRecords;
            if (this.currentPage != null) {
                int totalLength = Platform.getInt((Object)this.pageBaseObject, (long)this.offsetInPage);
                this.loc.with(this.currentPage, this.offsetInPage);
                this.offsetInPage += (long)(4 + totalLength);
                --this.recordsInPage;
                return this.loc;
            }
            assert (this.reader != null);
            if (!this.reader.hasNext()) {
                this.advanceToNextPage();
            }
            try {
                this.reader.loadNext();
            }
            catch (IOException e) {
                try {
                    this.reader.close();
                }
                catch (IOException e2) {
                    BytesToBytesMap.this.logger.error("Error while closing spill reader", (Throwable)e2);
                }
                Platform.throwException((Throwable)e);
            }
            this.loc.with(this.reader.getBaseObject(), this.reader.getBaseOffset(), this.reader.getRecordLength());
            return this.loc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long spill(long numBytes) throws IOException {
            MapIterator mapIterator = this;
            synchronized (mapIterator) {
                MemoryBlock block;
                if (!this.destructive || BytesToBytesMap.this.dataPages.size() == 1) {
                    return 0L;
                }
                ShuffleWriteMetrics writeMetrics = new ShuffleWriteMetrics();
                long released = 0L;
                while (BytesToBytesMap.this.dataPages.size() > 0 && (block = (MemoryBlock)BytesToBytesMap.this.dataPages.getLast()) != this.currentPage) {
                    Object base = block.getBaseObject();
                    long offset = block.getBaseOffset();
                    int numRecords = Platform.getInt((Object)base, (long)offset);
                    offset += 4L;
                    UnsafeSorterSpillWriter writer = new UnsafeSorterSpillWriter(BytesToBytesMap.this.blockManager, 32768, writeMetrics, numRecords);
                    while (numRecords > 0) {
                        int length = Platform.getInt((Object)base, (long)offset);
                        writer.write(base, offset + 4L, length, 0L);
                        offset += (long)(4 + length);
                        --numRecords;
                    }
                    writer.close();
                    BytesToBytesMap.this.spillWriters.add(writer);
                    BytesToBytesMap.this.dataPages.removeLast();
                    BytesToBytesMap.this.freePage(block);
                    if ((released += block.size()) < numBytes) continue;
                    break;
                }
                return released;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

