/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.BlockStore;
import org.apache.spark.storage.MemoryEntry;
import org.apache.spark.storage.PutResult;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.SizeEstimator$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.collection.SizeTrackingVector;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t-d!B\u0001\u0003\u0001\u0011Q!aC'f[>\u0014\u0018p\u0015;pe\u0016T!a\u0001\u0003\u0002\u000fM$xN]1hK*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0005\u0002\u0001\u0017A\u0011A\"D\u0007\u0002\u0005%\u0011aB\u0001\u0002\u000b\u00052|7m[*u_J,\u0007\"\u0003\t\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n\u0016\u00031\u0011Gn\\2l\u001b\u0006t\u0017mZ3s\u0007\u0001\u0001\"\u0001D\n\n\u0005Q\u0011!\u0001\u0004\"m_\u000e\\W*\u00198bO\u0016\u0014\u0018B\u0001\t\u000e\u0011!9\u0002A!A!\u0002\u0013A\u0012!D7f[>\u0014\u00180T1oC\u001e,'\u000f\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\t\u00051Q.Z7pefL!!\b\u000e\u0003\u001b5+Wn\u001c:z\u001b\u0006t\u0017mZ3s\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0019a\u0014N\\5u}Q\u0019\u0011EI\u0012\u0011\u00051\u0001\u0001\"\u0002\t\u001f\u0001\u0004\u0011\u0002\"B\f\u001f\u0001\u0004A\u0002bB\u0013\u0001\u0005\u0004%IAJ\u0001\u0005G>tg-F\u0001(!\tA\u0013&D\u0001\u0005\u0013\tQCAA\u0005Ta\u0006\u00148nQ8oM\"1A\u0006\u0001Q\u0001\n\u001d\nQaY8oM\u0002BqA\f\u0001C\u0002\u0013%q&A\u0004f]R\u0014\u0018.Z:\u0016\u0003A\u0002B!\r\u001c9w5\t!G\u0003\u00024i\u0005!Q\u000f^5m\u0015\u0005)\u0014\u0001\u00026bm\u0006L!a\u000e\u001a\u0003\u001b1Kgn[3e\u0011\u0006\u001c\b.T1q!\ta\u0011(\u0003\u0002;\u0005\t9!\t\\8dW&#\u0007C\u0001\u0007=\u0013\ti$AA\u0006NK6|'/_#oiJL\bBB \u0001A\u0003%\u0001'\u0001\u0005f]R\u0014\u0018.Z:!\u0011\u001d\t\u0005A1A\u0005\n\t\u000bq\"\u001e8s_2dW*Z7pefl\u0015\r]\u000b\u0002\u0007B!AiS'N\u001b\u0005)%B\u0001$H\u0003\u001diW\u000f^1cY\u0016T!\u0001S%\u0002\u0015\r|G\u000e\\3di&|gNC\u0001K\u0003\u0015\u00198-\u00197b\u0013\taUIA\u0004ICNDW*\u00199\u0011\u00059{U\"A%\n\u0005AK%\u0001\u0002'p]\u001eDaA\u0015\u0001!\u0002\u0013\u0019\u0015\u0001E;oe>dG.T3n_JLX*\u00199!\u0011\u001d!\u0006A1A\u0005\n\t\u000ba\u0003]3oI&tw-\u00168s_2dW*Z7pefl\u0015\r\u001d\u0005\u0007-\u0002\u0001\u000b\u0011B\"\u0002/A,g\u000eZ5oOVs'o\u001c7m\u001b\u0016lwN]=NCB\u0004\u0003b\u0002-\u0001\u0005\u0004%I!W\u0001\u0016k:\u0014x\u000e\u001c7NK6|'/\u001f+ie\u0016\u001c\bn\u001c7e+\u0005i\u0005BB.\u0001A\u0003%Q*\u0001\fv]J|G\u000e\\'f[>\u0014\u0018\u0010\u00165sKNDw\u000e\u001c3!\u0011\u0015i\u0006\u0001\"\u0003Z\u0003%i\u0017\r_'f[>\u0014\u0018\u0010C\u0003`\u0001\u0011%\u0011,\u0001\u0006nK6|'/_+tK\u0012DQ!\u0019\u0001\u0005\ne\u000b\u0001C\u00197pG.\u001cX*Z7pef,6/\u001a3\t\u000b\r\u0004A\u0011\t3\u0002\u000f\u001d,GoU5{KR\u0011Q*\u001a\u0005\u0006M\n\u0004\r\u0001O\u0001\bE2|7m[%e\u0011\u0015A\u0007\u0001\"\u0011j\u0003!\u0001X\u000f\u001e\"zi\u0016\u001cH\u0003\u00026n]Z\u0004\"\u0001D6\n\u00051\u0014!!\u0003)viJ+7/\u001e7u\u0011\u00151w\r1\u00019\u0011\u0015yw\r1\u0001q\u0003\u0019y&-\u001f;fgB\u0011\u0011\u000f^\u0007\u0002e*\u00111\u000fN\u0001\u0004]&|\u0017BA;s\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006o\u001e\u0004\r\u0001_\u0001\u0006Y\u00164X\r\u001c\t\u0003\u0019eL!A\u001f\u0002\u0003\u0019M#xN]1hK2+g/\u001a7\t\u000b!\u0004A\u0011\u0001?\u0015\u000b)lh0!\u0001\t\u000b\u0019\\\b\u0019\u0001\u001d\t\u000b}\\\b\u0019A'\u0002\tML'0\u001a\u0005\u0007_n\u0004\r!a\u0001\u0011\t9\u000b)\u0001]\u0005\u0004\u0003\u000fI%!\u0003$v]\u000e$\u0018n\u001c81\u0011\u001d\tY\u0001\u0001C!\u0003\u001b\t\u0001\u0002];u\u0003J\u0014\u0018-\u001f\u000b\nU\u0006=\u0011\u0011CA\u0011\u0003GAaAZA\u0005\u0001\u0004A\u0004\u0002CA\n\u0003\u0013\u0001\r!!\u0006\u0002\rY\fG.^3t!\u0015q\u0015qCA\u000e\u0013\r\tI\"\u0013\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u001d\u0006u\u0011bAA\u0010\u0013\n\u0019\u0011I\\=\t\r]\fI\u00011\u0001y\u0011!\t)#!\u0003A\u0002\u0005\u001d\u0012\u0001\u0004:fiV\u0014hNV1mk\u0016\u001c\bc\u0001(\u0002*%\u0019\u00111F%\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\u0006\u0001\u0005B\u0005E\u0012a\u00039vi&#XM]1u_J$\u0012B[A\u001a\u0003k\ty%!\u0015\t\r\u0019\fi\u00031\u00019\u0011!\t\u0019\"!\fA\u0002\u0005]\u0002CBA\u001d\u0003\u0013\nYB\u0004\u0003\u0002<\u0005\u0015c\u0002BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005\u0013#\u0001\u0004=e>|GOP\u0005\u0002\u0015&\u0019\u0011qI%\u0002\u000fA\f7m[1hK&!\u00111JA'\u0005!IE/\u001a:bi>\u0014(bAA$\u0013\"1q/!\fA\u0002aD\u0001\"!\n\u0002.\u0001\u0007\u0011q\u0005\u0005\t\u0003_\u0001A\u0011\u0001\u0002\u0002VQY!.a\u0016\u0002Z\u0005m\u0013QLA0\u0011\u00191\u00171\u000ba\u0001q!A\u00111CA*\u0001\u0004\t9\u0004\u0003\u0004x\u0003'\u0002\r\u0001\u001f\u0005\t\u0003K\t\u0019\u00061\u0001\u0002(!A\u0011\u0011MA*\u0001\u0004\t9#\u0001\nbY2|w\u000fU3sg&\u001cH\u000fV8ESN\\\u0007bBA3\u0001\u0011\u0005\u0013qM\u0001\tO\u0016$()\u001f;fgR!\u0011\u0011NA8!\u0011q\u00151\u000e9\n\u0007\u00055\u0014J\u0001\u0004PaRLwN\u001c\u0005\u0007M\u0006\r\u0004\u0019\u0001\u001d\t\u000f\u0005M\u0004\u0001\"\u0011\u0002v\u0005Iq-\u001a;WC2,Xm\u001d\u000b\u0005\u0003o\nI\bE\u0003O\u0003W\n9\u0004\u0003\u0004g\u0003c\u0002\r\u0001\u000f\u0005\b\u0003{\u0002A\u0011IA@\u0003\u0019\u0011X-\\8wKR!\u0011qEAA\u0011\u00191\u00171\u0010a\u0001q!9\u0011Q\u0011\u0001\u0005B\u0005\u001d\u0015!B2mK\u0006\u0014HCAAE!\rq\u00151R\u0005\u0004\u0003\u001bK%\u0001B+oSRDq!!%\u0001\t\u0003\t\u0019*\u0001\u0007v]J|G\u000e\\*bM\u0016d\u0017\u0010\u0006\u0005\u0002\u0016\u0006m\u0015QTAP!!\tI$a&\u0002\u0016\u0005]\u0012\u0002BAM\u0003\u001b\u0012a!R5uQ\u0016\u0014\bB\u00024\u0002\u0010\u0002\u0007\u0001\b\u0003\u0005\u0002\u0014\u0005=\u0005\u0019AA\u001c\u0011!\t\t+a$A\u0002\u0005\r\u0016!\u00043s_B\u0004X\r\u001a\"m_\u000e\\7\u000fE\u0003E\u0003K\u000bI+C\u0002\u0002(\u0016\u00131\"\u0011:sCf\u0014UO\u001a4feB1a*a+9\u0003_K1!!,J\u0005\u0019!V\u000f\u001d7feA\u0019A\"!-\n\u0007\u0005M&AA\u0006CY>\u001c7n\u0015;biV\u001c\bbBA\\\u0001\u0011%\u0011\u0011X\u0001\tO\u0016$(\u000b\u001a3JIR!\u00111XAb!\u0015q\u00151NA_!\rq\u0015qX\u0005\u0004\u0003\u0003L%aA%oi\"1a-!.A\u0002aBq!a2\u0001\t\u0013\tI-\u0001\u0005uef$v\u000eU;u)1\t9#a3\u0002N\u0006E\u00171[Al\u0011\u00191\u0017Q\u0019a\u0001q!A\u0011qZAc\u0001\u0004\tY\"A\u0003wC2,X\r\u0003\u0004\u0000\u0003\u000b\u0004\r!\u0014\u0005\t\u0003+\f)\r1\u0001\u0002(\u0005aA-Z:fe&\fG.\u001b>fI\"A\u0011\u0011UAc\u0001\u0004\tI\u000eE\u0003E\u00037\fI+C\u0002\u0002^\u0016\u0013aAQ;gM\u0016\u0014\bbBAd\u0001\u0011%\u0011\u0011\u001d\u000b\r\u0003O\t\u0019/!:\u0002j\u0006-\u0018Q\u001e\u0005\u0007M\u0006}\u0007\u0019\u0001\u001d\t\u0011\u0005=\u0017q\u001ca\u0001\u0003O\u0004RATA\u0003\u00037Aaa`Ap\u0001\u0004i\u0005\u0002CAk\u0003?\u0004\r!a\n\t\u0011\u0005\u0005\u0016q\u001ca\u0001\u00033D\u0001\"!=\u0001\t\u0003!\u00111_\u0001\u0017KZL7\r\u001e\"m_\u000e\\7\u000fV8Ge\u0016,7\u000b]1dKRA\u0011qEA{\u0003s\fi\u0010C\u0004g\u0003_\u0004\r!a>\u0011\t9\u000bY\u0007\u000f\u0005\b\u0003w\fy\u000f1\u0001N\u0003\u0015\u0019\b/Y2f\u0011!\t\t+a<A\u0002\u0005e\u0007b\u0002B\u0001\u0001\u0011\u0005#1A\u0001\tG>tG/Y5ogR!\u0011q\u0005B\u0003\u0011\u00191\u0017q a\u0001q!9!\u0011\u0002\u0001\u0005\n\t-\u0011\u0001F2veJ,g\u000e\u001e+bg.\fE\u000f^3naRLE\rF\u0001N\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005#\taD]3tKJ4X-\u00168s_2dW*Z7pef4uN\u001d+iSN$\u0016m]6\u0015\u0011\u0005\u001d\"1\u0003B\u000b\u0005/AaA\u001aB\u0007\u0001\u0004A\u0004BB\u000e\u0003\u000e\u0001\u0007Q\n\u0003\u0005\u0002\"\n5\u0001\u0019AAm\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0005;\taD]3mK\u0006\u001cX-\u00168s_2dW*Z7pef4uN\u001d+iSN$\u0016m]6\u0015\t\u0005%%q\u0004\u0005\t7\te\u0001\u0013!a\u0001\u001b\"9!1\u0005\u0001\u0005\u0002\t\u0015\u0012!\n:fY\u0016\f7/\u001a)f]\u0012LgnZ+oe>dG.T3n_JLhi\u001c:UQ&\u001cH+Y:l)\u0011\tIIa\n\t\u0011m\u0011\t\u0003%AA\u00025CaAa\u000b\u0001\t\u0003I\u0016aE2veJ,g\u000e^+oe>dG.T3n_JL\bB\u0002B\u0018\u0001\u0011\u0005\u0011,\u0001\u0010dkJ\u0014XM\u001c;V]J|G\u000e\\'f[>\u0014\u0018PR8s)\"L7\u000fV1tW\"9!1\u0007\u0001\u0005\n\tU\u0012!\u00058v[R\u000b7o[:V]J|G\u000e\\5oOV\u0011\u0011Q\u0018\u0005\b\u0005s\u0001A\u0011BAD\u00039awnZ'f[>\u0014\u00180V:bO\u0016DqA!\u0010\u0001\t\u0013\u0011y$A\fm_\u001e,fN]8mY\u001a\u000b\u0017\u000e\\;sK6+7o]1hKR1\u0011\u0011\u0012B!\u0005\u0007BaA\u001aB\u001e\u0001\u0004A\u0004b\u0002B#\u0005w\u0001\r!T\u0001\u0010M&t\u0017\r\u001c,fGR|'oU5{K\"I!\u0011\n\u0001\u0012\u0002\u0013\u0005!1J\u0001)e\u0016dW-Y:f+:\u0014x\u000e\u001c7NK6|'/\u001f$peRC\u0017n\u001d+bg.$C-\u001a4bk2$H%M\u000b\u0003\u0005\u001bR3!\u0014B(W\t\u0011\t\u0006\u0005\u0003\u0003T\tuSB\u0001B+\u0015\u0011\u00119F!\u0017\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B.\u0013\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t}#Q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B2\u0001E\u0005I\u0011\u0001B&\u0003=\u0012X\r\\3bg\u0016\u0004VM\u001c3j]\u001e,fN]8mY6+Wn\u001c:z\r>\u0014H\u000b[5t)\u0006\u001c8\u000e\n3fM\u0006,H\u000e\u001e\u00132\u0011-\u00119\u0007AA\u0001\u0002\u0013%!\u0011N\u000b\u0002%M,\b/\u001a:%E2|7m['b]\u0006<WM]\u000b\u0002%\u0001")
public class MemoryStore
extends BlockStore {
    private final MemoryManager memoryManager;
    private final SparkConf conf;
    private final LinkedHashMap<BlockId, MemoryEntry> org$apache$spark$storage$MemoryStore$$entries;
    private final HashMap<Object, Object> unrollMemoryMap;
    private final HashMap<Object, Object> pendingUnrollMemoryMap;
    private final long org$apache$spark$storage$MemoryStore$$unrollMemoryThreshold;

    public BlockManager org$apache$spark$storage$MemoryStore$$super$blockManager() {
        return super.blockManager();
    }

    private SparkConf conf() {
        return this.conf;
    }

    public LinkedHashMap<BlockId, MemoryEntry> org$apache$spark$storage$MemoryStore$$entries() {
        return this.org$apache$spark$storage$MemoryStore$$entries;
    }

    private HashMap<Object, Object> unrollMemoryMap() {
        return this.unrollMemoryMap;
    }

    private HashMap<Object, Object> pendingUnrollMemoryMap() {
        return this.pendingUnrollMemoryMap;
    }

    public long org$apache$spark$storage$MemoryStore$$unrollMemoryThreshold() {
        return this.org$apache$spark$storage$MemoryStore$$unrollMemoryThreshold;
    }

    public long org$apache$spark$storage$MemoryStore$$maxMemory() {
        return this.memoryManager.maxStorageMemory();
    }

    public long org$apache$spark$storage$MemoryStore$$memoryUsed() {
        return this.memoryManager.storageMemoryUsed();
    }

    public long org$apache$spark$storage$MemoryStore$$blocksMemoryUsed() {
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            Long l = BoxesRunTime.boxToLong((long)(this.org$apache$spark$storage$MemoryStore$$memoryUsed() - this.currentUnrollMemory()));
            return BoxesRunTime.unboxToLong((Object)l);
        }
    }

    @Override
    public long getSize(BlockId blockId) {
        LinkedHashMap<BlockId, MemoryEntry> linkedHashMap = this.org$apache$spark$storage$MemoryStore$$entries();
        synchronized (linkedHashMap) {
            Long l = BoxesRunTime.boxToLong((long)this.org$apache$spark$storage$MemoryStore$$entries().get(blockId).size());
            return BoxesRunTime.unboxToLong((Object)l);
        }
    }

    @Override
    public PutResult putBytes(BlockId blockId, ByteBuffer _bytes, StorageLevel level) {
        PutResult putResult;
        ByteBuffer bytes = _bytes.duplicate();
        bytes.rewind();
        if (level.deserialized()) {
            Iterator<Object> values2 = super.blockManager().dataDeserialize(blockId, bytes);
            putResult = this.putIterator(blockId, values2, level, true);
        } else {
            ArrayBuffer droppedBlocks = new ArrayBuffer();
            this.tryToPut(blockId, bytes, (long)bytes.limit(), false, (Buffer<Tuple2<BlockId, BlockStatus>>)droppedBlocks);
            putResult = new PutResult(bytes.limit(), (Either<Iterator<Object>, ByteBuffer>)package$.MODULE$.Right().apply((Object)bytes.duplicate()), (Seq<Tuple2<BlockId, BlockStatus>>)droppedBlocks);
        }
        return putResult;
    }

    public PutResult putBytes(BlockId blockId, long size, Function0<ByteBuffer> _bytes) {
        Right right;
        ObjectRef bytes$lzy = new ObjectRef(null);
        VolatileByteRef bitmap$0 = new VolatileByteRef(0);
        ArrayBuffer droppedBlocks = new ArrayBuffer();
        boolean putSuccess = this.tryToPut(blockId, (Function0<Object>)new Serializable(this, _bytes, bytes$lzy, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryStore $outer;
            private final Function0 _bytes$1;
            private final ObjectRef bytes$lzy$1;
            private final VolatileByteRef bitmap$0$1;

            public final ByteBuffer apply() {
                return this.$outer.org$apache$spark$storage$MemoryStore$$bytes$1(this._bytes$1, this.bytes$lzy$1, this.bitmap$0$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this._bytes$1 = _bytes$1;
                this.bytes$lzy$1 = bytes$lzy$1;
                this.bitmap$0$1 = bitmap$0$1;
            }
        }, size, false, (Buffer<Tuple2<BlockId, BlockStatus>>)droppedBlocks);
        if (putSuccess) {
            Predef$.MODULE$.assert((long)this.org$apache$spark$storage$MemoryStore$$bytes$1(_bytes, bytes$lzy, bitmap$0).limit() == size);
            right = package$.MODULE$.Right().apply((Object)this.org$apache$spark$storage$MemoryStore$$bytes$1(_bytes, bytes$lzy, bitmap$0).duplicate());
        } else {
            right = null;
        }
        Right data = right;
        return new PutResult(size, (Either<Iterator<Object>, ByteBuffer>)data, (Seq<Tuple2<BlockId, BlockStatus>>)droppedBlocks);
    }

    @Override
    public PutResult putArray(BlockId blockId, Object[] values2, StorageLevel level, boolean returnValues) {
        PutResult putResult;
        ArrayBuffer droppedBlocks = new ArrayBuffer();
        if (level.deserialized()) {
            long sizeEstimate = SizeEstimator$.MODULE$.estimate(values2);
            this.tryToPut(blockId, values2, sizeEstimate, true, (Buffer<Tuple2<BlockId, BlockStatus>>)droppedBlocks);
            putResult = new PutResult(sizeEstimate, (Either<Iterator<Object>, ByteBuffer>)package$.MODULE$.Left().apply((Object)Predef$.MODULE$.genericArrayOps((Object)values2).iterator()), (Seq<Tuple2<BlockId, BlockStatus>>)droppedBlocks);
        } else {
            ByteBuffer bytes = super.blockManager().dataSerialize(blockId, (Iterator<Object>)Predef$.MODULE$.genericArrayOps((Object)values2).iterator());
            this.tryToPut(blockId, bytes, (long)bytes.limit(), false, (Buffer<Tuple2<BlockId, BlockStatus>>)droppedBlocks);
            putResult = new PutResult(bytes.limit(), (Either<Iterator<Object>, ByteBuffer>)package$.MODULE$.Right().apply((Object)bytes.duplicate()), (Seq<Tuple2<BlockId, BlockStatus>>)droppedBlocks);
        }
        return putResult;
    }

    @Override
    public PutResult putIterator(BlockId blockId, Iterator<Object> values2, StorageLevel level, boolean returnValues) {
        return this.putIterator(blockId, values2, level, returnValues, true);
    }

    public PutResult putIterator(BlockId blockId, Iterator<Object> values2, StorageLevel level, boolean returnValues, boolean allowPersistToDisk) {
        Either<Object[], Iterator<Object>> either;
        block7: {
            PutResult putResult;
            block6: {
                PutResult putResult2;
                ArrayBuffer droppedBlocks;
                block5: {
                    droppedBlocks = new ArrayBuffer();
                    Either<Object[], Iterator<Object>> unrolledValues = this.unrollSafely(blockId, values2, (ArrayBuffer<Tuple2<BlockId, BlockStatus>>)droppedBlocks);
                    either = unrolledValues;
                    if (!(either instanceof Left)) break block5;
                    Left left = (Left)either;
                    Object[] arrayValues = (Object[])left.a();
                    PutResult res = this.putArray(blockId, arrayValues, level, returnValues);
                    droppedBlocks.$plus$plus$eq(res.droppedBlocks());
                    putResult = new PutResult(res.size(), res.data(), (Seq<Tuple2<BlockId, BlockStatus>>)droppedBlocks);
                    break block6;
                }
                if (!(either instanceof Right)) break block7;
                Right right = (Right)either;
                Iterator iteratorValues = (Iterator)right.b();
                if (level.useDisk() && allowPersistToDisk) {
                    this.logWarning((Function0<String>)new Serializable(this, blockId){
                        public static final long serialVersionUID = 0L;
                        private final BlockId blockId$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Persisting block ", " to disk instead."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$2}));
                        }
                        {
                            this.blockId$2 = blockId$2;
                        }
                    });
                    PutResult res = super.blockManager().diskStore().putIterator(blockId, (Iterator<Object>)iteratorValues, level, returnValues);
                    putResult2 = new PutResult(res.size(), res.data(), (Seq<Tuple2<BlockId, BlockStatus>>)droppedBlocks);
                } else {
                    putResult2 = new PutResult(0L, (Either<Iterator<Object>, ByteBuffer>)package$.MODULE$.Left().apply((Object)iteratorValues), (Seq<Tuple2<BlockId, BlockStatus>>)droppedBlocks);
                }
                putResult = putResult2;
            }
            return putResult;
        }
        throw new MatchError(either);
    }

    @Override
    public Option<ByteBuffer> getBytes(BlockId blockId) {
        LinkedHashMap<BlockId, MemoryEntry> linkedHashMap = this.org$apache$spark$storage$MemoryStore$$entries();
        synchronized (linkedHashMap) {
            MemoryEntry memoryEntry = this.org$apache$spark$storage$MemoryStore$$entries().get(blockId);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : var3_2
            MemoryEntry entry = memoryEntry;
            return entry == null ? None$.MODULE$ : (entry.deserialized() ? new Some((Object)super.blockManager().dataSerialize(blockId, (Iterator<Object>)Predef$.MODULE$.genericArrayOps((Object)((Object[])entry.value())).iterator())) : new Some((Object)((ByteBuffer)entry.value()).duplicate()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Option<Iterator<Object>> getValues(BlockId blockId) {
        None$ none$;
        MemoryEntry entry;
        block4: {
            LinkedHashMap<BlockId, MemoryEntry> linkedHashMap = this.org$apache$spark$storage$MemoryStore$$entries();
            synchronized (linkedHashMap) {
                MemoryEntry memoryEntry = this.org$apache$spark$storage$MemoryStore$$entries().get(blockId);
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : linkedHashMap
                entry = memoryEntry;
                if (entry == null) {
                    none$ = None$.MODULE$;
                    return none$;
                }
                if (!entry.deserialized()) break block4;
            }
            none$ = new Some((Object)Predef$.MODULE$.genericArrayOps((Object)((Object[])entry.value())).iterator());
            return none$;
        }
        ByteBuffer buffer = ((ByteBuffer)entry.value()).duplicate();
        none$ = new Some(super.blockManager().dataDeserialize(blockId, buffer));
        return none$;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean remove(BlockId blockId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    @Override
    public void clear() {
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            LinkedHashMap<BlockId, MemoryEntry> linkedHashMap = this.org$apache$spark$storage$MemoryStore$$entries();
            synchronized (linkedHashMap) {
                this.org$apache$spark$storage$MemoryStore$$entries().clear();
            }
            this.unrollMemoryMap().clear();
            this.pendingUnrollMemoryMap().clear();
            this.memoryManager.releaseAllStorageMemory();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "MemoryStore cleared";
                }
            });
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<Object[], Iterator<Object>> unrollSafely(BlockId blockId, Iterator<Object> values2, ArrayBuffer<Tuple2<BlockId, BlockStatus>> droppedBlocks) {
        MemoryManager memoryManager;
        long taskAttemptId2;
        Left left;
        int elementsUnrolled = 0;
        boolean keepUnrolling = true;
        long initialMemoryThreshold = this.org$apache$spark$storage$MemoryStore$$unrollMemoryThreshold();
        int memoryCheckPeriod = 16;
        long memoryThreshold = initialMemoryThreshold;
        double memoryGrowthFactor = 1.5;
        long pendingMemoryReserved = 0L;
        SizeTrackingVector<Object> vector = new SizeTrackingVector<Object>(ClassTag$.MODULE$.Any());
        keepUnrolling = this.reserveUnrollMemoryForThisTask(blockId, initialMemoryThreshold, (Buffer<Tuple2<BlockId, BlockStatus>>)droppedBlocks);
        if (keepUnrolling) {
            pendingMemoryReserved += initialMemoryThreshold;
        } else {
            this.logWarning((Function0<String>)new Serializable(this, blockId, initialMemoryThreshold){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$1;
                private final long initialMemoryThreshold$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to reserve initial memory threshold of "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " for computing block ", " in memory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.initialMemoryThreshold$1), this.blockId$1}))).toString();
                }
                {
                    this.blockId$1 = blockId$1;
                    this.initialMemoryThreshold$1 = initialMemoryThreshold$1;
                }
            });
        }
        try {
            while (values2.hasNext() && keepUnrolling) {
                long currentSize;
                vector.$plus$eq(values2.next());
                if (elementsUnrolled % memoryCheckPeriod == 0 && (currentSize = vector.estimateSize()) >= memoryThreshold) {
                    long amountToRequest = (long)((double)currentSize * memoryGrowthFactor - (double)memoryThreshold);
                    keepUnrolling = this.reserveUnrollMemoryForThisTask(blockId, amountToRequest, (Buffer<Tuple2<BlockId, BlockStatus>>)droppedBlocks);
                    if (keepUnrolling) {
                        pendingMemoryReserved += amountToRequest;
                    }
                    memoryThreshold += amountToRequest;
                }
                ++elementsUnrolled;
            }
            if (keepUnrolling) {
                left = package$.MODULE$.Left().apply(vector.toArray());
            } else {
                this.logUnrollFailureMessage(blockId, vector.estimateSize());
                left = package$.MODULE$.Right().apply((Object)vector.iterator().$plus$plus((Function0)new Serializable(this, values2){
                    public static final long serialVersionUID = 0L;
                    private final Iterator values$1;

                    public final Iterator<Object> apply() {
                        return this.values$1;
                    }
                    {
                        this.values$1 = values$1;
                    }
                }));
            }
            if (!keepUnrolling) return left;
            taskAttemptId2 = this.currentTaskAttemptId();
            memoryManager = this.memoryManager;
        }
        catch (Throwable throwable) {
            if (!keepUnrolling) throw throwable;
            long taskAttemptId2 = this.currentTaskAttemptId();
            MemoryManager memoryManager2 = this.memoryManager;
            synchronized (memoryManager2) {
                this.unrollMemoryMap().update((Object)BoxesRunTime.boxToLong((long)taskAttemptId2), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.unrollMemoryMap().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId2))) - pendingMemoryReserved)));
                this.pendingUnrollMemoryMap().update((Object)BoxesRunTime.boxToLong((long)taskAttemptId2), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.pendingUnrollMemoryMap().getOrElse((Object)BoxesRunTime.boxToLong((long)taskAttemptId2), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })) + pendingMemoryReserved)));
                throw throwable;
            }
        }
        synchronized (memoryManager) {
            this.unrollMemoryMap().update((Object)BoxesRunTime.boxToLong((long)taskAttemptId2), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.unrollMemoryMap().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId2))) - pendingMemoryReserved)));
            this.pendingUnrollMemoryMap().update((Object)BoxesRunTime.boxToLong((long)taskAttemptId2), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.pendingUnrollMemoryMap().getOrElse((Object)BoxesRunTime.boxToLong((long)taskAttemptId2), (Function0)new /* invalid duplicate definition of identical inner class */)) + pendingMemoryReserved)));
            return left;
        }
    }

    public Option<Object> org$apache$spark$storage$MemoryStore$$getRddId(BlockId blockId) {
        return blockId.asRDDId().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(RDDBlockId x$1) {
                return x$1.rddId();
            }
        });
    }

    private boolean tryToPut(BlockId blockId, Object value, long size, boolean deserialized, Buffer<Tuple2<BlockId, BlockStatus>> droppedBlocks) {
        return this.tryToPut(blockId, (Function0<Object>)new Serializable(this, value){
            public static final long serialVersionUID = 0L;
            private final Object value$2;

            public final Object apply() {
                return this.value$2;
            }
            {
                this.value$2 = value$2;
            }
        }, size, deserialized, droppedBlocks);
    }

    /*
     * Exception decompiling
     */
    private boolean tryToPut(BlockId blockId, Function0<Object> value, long size, boolean deserialized, Buffer<Tuple2<BlockId, BlockStatus>> droppedBlocks) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean evictBlocksToFreeSpace(Option<BlockId> blockId, long space, Buffer<Tuple2<BlockId, BlockStatus>> droppedBlocks) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean contains(BlockId blockId) {
        LinkedHashMap<BlockId, MemoryEntry> linkedHashMap = this.org$apache$spark$storage$MemoryStore$$entries();
        synchronized (linkedHashMap) {
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.org$apache$spark$storage$MemoryStore$$entries().containsKey(blockId));
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    private long currentTaskAttemptId() {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(TaskContext x$2) {
                return x$2.taskAttemptId();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
    }

    public boolean reserveUnrollMemoryForThisTask(BlockId blockId, long memory, Buffer<Tuple2<BlockId, BlockStatus>> droppedBlocks) {
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            boolean success = this.memoryManager.acquireUnrollMemory(blockId, memory, droppedBlocks);
            if (success) {
                long taskAttemptId = this.currentTaskAttemptId();
                this.unrollMemoryMap().update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.unrollMemoryMap().getOrElse((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })) + memory)));
            }
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)success);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public void releaseUnrollMemoryForThisTask(long memory) {
        long taskAttemptId = this.currentTaskAttemptId();
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            BoxedUnit boxedUnit;
            if (this.unrollMemoryMap().contains((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) {
                long memoryToRelease = scala.math.package$.MODULE$.min(memory, BoxesRunTime.unboxToLong((Object)this.unrollMemoryMap().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))));
                if (memoryToRelease > 0L) {
                    this.unrollMemoryMap().update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.unrollMemoryMap().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) - memoryToRelease)));
                    Object object = BoxesRunTime.unboxToLong((Object)this.unrollMemoryMap().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) == 0L ? this.unrollMemoryMap().remove((Object)BoxesRunTime.boxToLong((long)taskAttemptId)) : BoxedUnit.UNIT;
                    this.memoryManager.releaseUnrollMemory(memoryToRelease);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public long releaseUnrollMemoryForThisTask$default$1() {
        return Long.MAX_VALUE;
    }

    public void releasePendingUnrollMemoryForThisTask(long memory) {
        long taskAttemptId = this.currentTaskAttemptId();
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            BoxedUnit boxedUnit;
            if (this.pendingUnrollMemoryMap().contains((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) {
                long memoryToRelease = scala.math.package$.MODULE$.min(memory, BoxesRunTime.unboxToLong((Object)this.pendingUnrollMemoryMap().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))));
                if (memoryToRelease > 0L) {
                    this.pendingUnrollMemoryMap().update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.pendingUnrollMemoryMap().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) - memoryToRelease)));
                    Object object = BoxesRunTime.unboxToLong((Object)this.pendingUnrollMemoryMap().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) == 0L ? this.pendingUnrollMemoryMap().remove((Object)BoxesRunTime.boxToLong((long)taskAttemptId)) : BoxedUnit.UNIT;
                    this.memoryManager.releaseUnrollMemory(memoryToRelease);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public long releasePendingUnrollMemoryForThisTask$default$1() {
        return Long.MAX_VALUE;
    }

    public long currentUnrollMemory() {
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            Long l = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.unrollMemoryMap().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) + BoxesRunTime.unboxToLong((Object)this.pendingUnrollMemoryMap().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
            return BoxesRunTime.unboxToLong((Object)l);
        }
    }

    public long currentUnrollMemoryForThisTask() {
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            Object object = this.unrollMemoryMap().getOrElse((Object)BoxesRunTime.boxToLong((long)this.currentTaskAttemptId()), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 0L;
                }
            });
            return BoxesRunTime.unboxToLong((Object)object);
        }
    }

    public int org$apache$spark$storage$MemoryStore$$numTasksUnrolling() {
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            Integer n = BoxesRunTime.boxToInteger((int)this.unrollMemoryMap().keys().size());
            return BoxesRunTime.unboxToInt((Object)n);
        }
    }

    private void logMemoryUsage() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryStore $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Memory use = ", " (blocks) + "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$MemoryStore$$blocksMemoryUsed())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (scratch space shared across "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.$outer.currentUnrollMemory())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " tasks(s)) = ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$storage$MemoryStore$$numTasksUnrolling()), Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$MemoryStore$$memoryUsed())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Storage limit = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$MemoryStore$$maxMemory())}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private void logUnrollFailureMessage(BlockId blockId, long finalVectorSize) {
        this.logWarning((Function0<String>)new Serializable(this, blockId, finalVectorSize){
            public static final long serialVersionUID = 0L;
            private final BlockId blockId$5;
            private final long finalVectorSize$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not enough space to cache ", " in memory! "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$5}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(computed ", " so far)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.finalVectorSize$1)}))).toString();
            }
            {
                this.blockId$5 = blockId$5;
                this.finalVectorSize$1 = finalVectorSize$1;
            }
        });
        this.logMemoryUsage();
    }

    private final ByteBuffer bytes$lzycompute$1(Function0 _bytes$1, ObjectRef bytes$lzy$1, VolatileByteRef bitmap$0$1) {
        MemoryStore memoryStore = this;
        synchronized (memoryStore) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                bytes$lzy$1.elem = (ByteBuffer)((ByteBuffer)_bytes$1.apply()).duplicate().rewind();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (ByteBuffer)bytes$lzy$1.elem;
        }
    }

    public final ByteBuffer org$apache$spark$storage$MemoryStore$$bytes$1(Function0 _bytes$1, ObjectRef bytes$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.bytes$lzycompute$1(_bytes$1, bytes$lzy$1, bitmap$0$1) : (ByteBuffer)bytes$lzy$1.elem;
    }

    private final Either data$lzycompute$1(Function0 value$1, boolean deserialized$1, ObjectRef data$lzy$1, VolatileByteRef bitmap$0$2) {
        MemoryStore memoryStore = this;
        synchronized (memoryStore) {
            if ((byte)(bitmap$0$2.elem & 1) == 0) {
                data$lzy$1.elem = deserialized$1 ? package$.MODULE$.Left().apply((Object)((Object[])value$1.apply())) : package$.MODULE$.Right().apply((Object)((ByteBuffer)value$1.apply()).duplicate());
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 1);
            }
            return (Either)data$lzy$1.elem;
        }
    }

    public final Either org$apache$spark$storage$MemoryStore$$data$1(Function0 value$1, boolean deserialized$1, ObjectRef data$lzy$1, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 1) == 0 ? this.data$lzycompute$1(value$1, deserialized$1, data$lzy$1, bitmap$0$2) : (Either)data$lzy$1.elem;
    }

    public MemoryStore(BlockManager blockManager2, MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
        super(blockManager2);
        this.conf = super.blockManager().conf();
        this.org$apache$spark$storage$MemoryStore$$entries = new LinkedHashMap(32, 0.75f, true);
        this.unrollMemoryMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.pendingUnrollMemoryMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.org$apache$spark$storage$MemoryStore$$unrollMemoryThreshold = this.conf().getLong("spark.storage.unrollMemoryThreshold", 0x100000L);
        if (this.org$apache$spark$storage$MemoryStore$$maxMemory() < this.org$apache$spark$storage$MemoryStore$$unrollMemoryThreshold()) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MemoryStore $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max memory ", " is less than the initial memory "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$MemoryStore$$maxMemory())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"threshold ", " needed to store a block in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$MemoryStore$$unrollMemoryThreshold())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory. Please configure Spark with more memory."})).s((Seq)Nil$.MODULE$)).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryStore $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("MemoryStore started with capacity %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$MemoryStore$$maxMemory())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

