/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.ExecutorAllocationClient$class;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskState$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint$class;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.LossReasonPending$;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.SchedulerBackend$class;
import org.apache.spark.scheduler.SlaveLost;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.TaskDescription;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.TaskSetManager;
import org.apache.spark.scheduler.WorkerOffer;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$RetrieveSparkProps$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$ReviveOffers$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$StopDriver$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$StopExecutor$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$StopExecutors$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$DriverEndpoint$;
import org.apache.spark.scheduler.cluster.ExecutorData;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.util.AkkaUtils$;
import org.apache.spark.util.SerializableBuffer;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\r\u001dd!B\u0001\u0003\u0001\u0019a!!H\"pCJ\u001cXm\u0012:bS:,GmU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u000b\u0005\r!\u0011aB2mkN$XM\u001d\u0006\u0003\u000b\u0019\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001cR\u0001A\u0007\u0014/m\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0016\u001b\u00051\u0011B\u0001\f\u0007\u0005a)\u00050Z2vi>\u0014\u0018\t\u001c7pG\u0006$\u0018n\u001c8DY&,g\u000e\u001e\t\u00031ei\u0011\u0001B\u0005\u00035\u0011\u0011\u0001cU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0011\u0005Qa\u0012BA\u000f\u0007\u0005\u001daunZ4j]\u001eD\u0001\"\u0002\u0001\u0003\u0002\u0003\u0006I\u0001I\u0002\u0001!\tA\u0012%\u0003\u0002#\t\t\tB+Y:l'\u000eDW\rZ;mKJLU\u000e\u001d7\t\u0011\u0011\u0002!Q1A\u0005\u0002\u0015\naA\u001d9d\u000b:4X#\u0001\u0014\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%2\u0011a\u0001:qG&\u00111\u0006\u000b\u0002\u0007%B\u001cWI\u001c<\t\u00115\u0002!\u0011!Q\u0001\n\u0019\nqA\u001d9d\u000b:4\b\u0005C\u00030\u0001\u0011\u0005\u0001'\u0001\u0004=S:LGO\u0010\u000b\u0004cM\"\u0004C\u0001\u001a\u0001\u001b\u0005\u0011\u0001\"B\u0003/\u0001\u0004\u0001\u0003\"\u0002\u0013/\u0001\u00041\u0003b\u0002\u001c\u0001\u0001\u0004%\taN\u0001\u000fi>$\u0018\r\\\"pe\u0016\u001cu.\u001e8u+\u0005A\u0004CA\u001dC\u001b\u0005Q$BA\u001e=\u0003\u0019\tGo\\7jG*\u0011QHP\u0001\u000bG>t7-\u001e:sK:$(BA A\u0003\u0011)H/\u001b7\u000b\u0003\u0005\u000bAA[1wC&\u00111I\u000f\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\t\u000f\u0015\u0003\u0001\u0019!C\u0001\r\u0006\u0011Bo\u001c;bY\u000e{'/Z\"pk:$x\fJ3r)\t9%\n\u0005\u0002\u000f\u0011&\u0011\u0011j\u0004\u0002\u0005+:LG\u000fC\u0004L\t\u0006\u0005\t\u0019\u0001\u001d\u0002\u0007a$\u0013\u0007\u0003\u0004N\u0001\u0001\u0006K\u0001O\u0001\u0010i>$\u0018\r\\\"pe\u0016\u001cu.\u001e8uA!9q\n\u0001a\u0001\n\u00039\u0014\u0001\u0007;pi\u0006d'+Z4jgR,'/\u001a3Fq\u0016\u001cW\u000f^8sg\"9\u0011\u000b\u0001a\u0001\n\u0003\u0011\u0016\u0001\b;pi\u0006d'+Z4jgR,'/\u001a3Fq\u0016\u001cW\u000f^8sg~#S-\u001d\u000b\u0003\u000fNCqa\u0013)\u0002\u0002\u0003\u0007\u0001\b\u0003\u0004V\u0001\u0001\u0006K\u0001O\u0001\u001ai>$\u0018\r\u001c*fO&\u001cH/\u001a:fI\u0016CXmY;u_J\u001c\b\u0005C\u0004X\u0001\t\u0007I\u0011\u0001-\u0002\t\r|gNZ\u000b\u00023B\u0011ACW\u0005\u00037\u001a\u0011\u0011b\u00159be.\u001cuN\u001c4\t\ru\u0003\u0001\u0015!\u0003Z\u0003\u0015\u0019wN\u001c4!\u0011\u001dy\u0006A1A\u0005\n\u0001\fQ\"Y6lC\u001a\u0013\u0018-\\3TSj,W#A1\u0011\u00059\u0011\u0017BA2\u0010\u0005\rIe\u000e\u001e\u0005\u0007K\u0002\u0001\u000b\u0011B1\u0002\u001d\u0005\\7.\u0019$sC6,7+\u001b>fA!9q\r\u0001a\u0001\n\u0003A\u0017AE7j]J+w-[:uKJ,GMU1uS>,\u0012!\u001b\t\u0003\u001d)L!a[\b\u0003\r\u0011{WO\u00197f\u0011\u001di\u0007\u00011A\u0005\u00029\fa#\\5o%\u0016<\u0017n\u001d;fe\u0016$'+\u0019;j_~#S-\u001d\u000b\u0003\u000f>Dqa\u00137\u0002\u0002\u0003\u0007\u0011\u000e\u0003\u0004r\u0001\u0001\u0006K![\u0001\u0014[&t'+Z4jgR,'/\u001a3SCRLw\u000e\t\u0005\bg\u0002\u0011\r\u0011\"\u0001u\u0003ii\u0017\r\u001f*fO&\u001cH/\u001a:fI^\u000b\u0017\u000e^5oORKW.Z't+\u0005)\bC\u0001\bw\u0013\t9xB\u0001\u0003M_:<\u0007BB=\u0001A\u0003%Q/A\u000enCb\u0014VmZ5ti\u0016\u0014X\rZ,bSRLgn\u001a+j[\u0016l5\u000f\t\u0005\bw\u0002\u0011\r\u0011\"\u0001u\u0003)\u0019'/Z1uKRKW.\u001a\u0005\u0007{\u0002\u0001\u000b\u0011B;\u0002\u0017\r\u0014X-\u0019;f)&lW\r\t\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002\u0005yQ\r_3dkR|'\u000fR1uC6\u000b\u0007/\u0006\u0002\u0002\u0004AA\u0011QAA\b\u0003'\t\t#\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003\u001diW\u000f^1cY\u0016T1!!\u0004\u0010\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003#\t9AA\u0004ICNDW*\u00199\u0011\t\u0005U\u00111\u0004\b\u0004\u001d\u0005]\u0011bAA\r\u001f\u00051\u0001K]3eK\u001aLA!!\b\u0002 \t11\u000b\u001e:j]\u001eT1!!\u0007\u0010!\r\u0011\u00141E\u0005\u0004\u0003K\u0011!\u0001D#yK\u000e,Ho\u001c:ECR\f\u0007\u0002CA\u0015\u0001\u0001\u0006I!a\u0001\u0002!\u0015DXmY;u_J$\u0015\r^1NCB\u0004\u0003\u0002CA\u0017\u0001\u0001\u0007I\u0011\u00021\u0002'9,X\u000eU3oI&tw-\u0012=fGV$xN]:\t\u0013\u0005E\u0002\u00011A\u0005\n\u0005M\u0012a\u00068v[B+g\u000eZ5oO\u0016CXmY;u_J\u001cx\fJ3r)\r9\u0015Q\u0007\u0005\t\u0017\u0006=\u0012\u0011!a\u0001C\"9\u0011\u0011\b\u0001!B\u0013\t\u0017\u0001\u00068v[B+g\u000eZ5oO\u0016CXmY;u_J\u001c\b\u0005C\u0005\u0002>\u0001\u0011\r\u0011\"\u0003\u0002@\u0005YA.[:uK:,'OQ;t+\t\t\t\u0005E\u0002\u0019\u0003\u0007J1!!\u0012\u0005\u0005=a\u0015N^3MSN$XM\\3s\u0005V\u001c\b\u0002CA%\u0001\u0001\u0006I!!\u0011\u0002\u00191L7\u000f^3oKJ\u0014Uo\u001d\u0011\t\u0013\u00055\u0003A1A\u0005\n\u0005=\u0013\u0001G3yK\u000e,Ho\u001c:t!\u0016tG-\u001b8h)>\u0014V-\\8wKV\u0011\u0011\u0011\u000b\t\t\u0003\u000b\ty!a\u0005\u0002TA\u0019a\"!\u0016\n\u0007\u0005]sBA\u0004C_>dW-\u00198\t\u0011\u0005m\u0003\u0001)A\u0005\u0003#\n\u0011$\u001a=fGV$xN]:QK:$\u0017N\\4U_J+Wn\u001c<fA!I\u0011q\f\u0001A\u0002\u0013E\u0011\u0011M\u0001\u0015Q>\u001cH\u000fV8M_\u000e\fG\u000eV1tW\u000e{WO\u001c;\u0016\u0005\u0005\r\u0004cBA\u000b\u0003K\n\u0019\"Y\u0005\u0005\u0003O\nyBA\u0002NCBD\u0011\"a\u001b\u0001\u0001\u0004%\t\"!\u001c\u00021!|7\u000f\u001e+p\u0019>\u001c\u0017\r\u001c+bg.\u001cu.\u001e8u?\u0012*\u0017\u000fF\u0002H\u0003_B\u0011bSA5\u0003\u0003\u0005\r!a\u0019\t\u0011\u0005M\u0004\u0001)Q\u0005\u0003G\nQ\u0003[8tiR{Gj\\2bYR\u000b7o[\"pk:$\b\u0005\u0003\u0005\u0002x\u0001\u0001\r\u0011\"\u0005a\u0003IawnY1mSRL\u0018i^1sKR\u000b7o[:\t\u0013\u0005m\u0004\u00011A\u0005\u0012\u0005u\u0014A\u00067pG\u0006d\u0017\u000e^=Bo\u0006\u0014X\rV1tWN|F%Z9\u0015\u0007\u001d\u000by\b\u0003\u0005L\u0003s\n\t\u00111\u0001b\u0011\u001d\t\u0019\t\u0001Q!\n\u0005\f1\u0003\\8dC2LG/_!xCJ,G+Y:lg\u0002B\u0011\"a\"\u0001\u0005\u0004%\t\"!#\u00025\u0015DXmY;u_J\u001c\b+\u001a8eS:<Gj\\:t%\u0016\f7o\u001c8\u0016\u0005\u0005-\u0005CBA\u0003\u0003\u001b\u000b\u0019\"\u0003\u0003\u0002\u0010\u0006\u001d!a\u0002%bg\"\u001cV\r\u001e\u0005\t\u0003'\u0003\u0001\u0015!\u0003\u0002\f\u0006YR\r_3dkR|'o\u001d)f]\u0012Lgn\u001a'pgN\u0014V-Y:p]\u00022a!a&\u0001\u0001\u0005e%A\u0004#sSZ,'/\u00128ea>Lg\u000e^\n\u0007\u0003+k\u00111T\u000e\u0011\u0007\u001d\ni*C\u0002\u0002 \"\u0012Q\u0003\u00165sK\u0006$7+\u00194f%B\u001cWI\u001c3q_&tG\u000fC\u0005%\u0003+\u0013)\u0019!C!K!IQ&!&\u0003\u0002\u0003\u0006IA\n\u0005\f\u0003O\u000b)J!A!\u0002\u0013\tI+A\bta\u0006\u00148\u000e\u0015:pa\u0016\u0014H/[3t!\u0019\tY+a/\u0002B:!\u0011QVA\\\u001d\u0011\ty+!.\u000e\u0005\u0005E&bAAZ?\u00051AH]8pizJ\u0011\u0001E\u0005\u0004\u0003s{\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003{\u000byLA\u0002TKFT1!!/\u0010!\u001dq\u00111YA\n\u0003'I1!!2\u0010\u0005\u0019!V\u000f\u001d7fe!9q&!&\u0005\u0002\u0005%GCBAf\u0003\u001f\f\t\u000e\u0005\u0003\u0002N\u0006UU\"\u0001\u0001\t\r\u0011\n9\r1\u0001'\u0011!\t9+a2A\u0002\u0005%\u0006BCAk\u0003+\u0013\r\u0011\"\u0003\u0002X\u0006\u00191/\u001a:\u0016\u0005\u0005e\u0007\u0003BAn\u0003Cl!!!8\u000b\u0007\u0005}g!\u0001\u0006tKJL\u0017\r\\5{KJLA!a9\u0002^\n\u00112+\u001a:jC2L'0\u001a:J]N$\u0018M\\2f\u0011%\t9/!&!\u0002\u0013\tI.\u0001\u0003tKJ\u0004\u0003\u0002CAv\u0003+#\t&!<\u0002\u00071|w-\u0006\u0002\u0002pB!\u0011\u0011_A|\u001b\t\t\u0019PC\u0002\u0002v*\tQa\u001d7gi)LA!!?\u0002t\n1Aj\\4hKJD!\"!@\u0002\u0016\n\u0007I\u0011CA\u0000\u0003M\tG\r\u001a:fgN$v.\u0012=fGV$xN]%e+\t\u0011\t\u0001\u0005\u0005\u0002\u0006\u0005=!1AA\n!\r9#QA\u0005\u0004\u0005\u000fA#A\u0003*qG\u0006#GM]3tg\"I!1BAKA\u0003%!\u0011A\u0001\u0015C\u0012$'/Z:t)>,\u00050Z2vi>\u0014\u0018\n\u001a\u0011\t\u0015\t=\u0011Q\u0013b\u0001\n\u0013\u0011\t\"\u0001\u0007sKZLg/\u001a+ie\u0016\fG-\u0006\u0002\u0003\u0014A!!Q\u0003B\f\u001b\u0005a\u0014b\u0001B\ry\tA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u0013\tu\u0011Q\u0013Q\u0001\n\tM\u0011!\u0004:fm&4X\r\u00165sK\u0006$\u0007\u0005\u0003\u0005\u0003\"\u0005UE\u0011\tB\u0012\u0003\u001dygn\u0015;beR$\u0012a\u0012\u0005\t\u0005O\t)\n\"\u0011\u0003*\u00059!/Z2fSZ,WC\u0001B\u0016!\u0019q!Q\u0006B\u0019\u000f&\u0019!qF\b\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u00042A\u0004B\u001a\u0013\r\u0011)d\u0004\u0002\u0004\u0003:L\b\u0002\u0003B\u001d\u0003+#\tEa\u000f\u0002\u001fI,7-Z5wK\u0006sGMU3qYf$BAa\u000b\u0003>!A!q\bB\u001c\u0001\u0004\u0011\t%A\u0004d_:$X\r\u001f;\u0011\u0007\u001d\u0012\u0019%C\u0002\u0003F!\u0012aB\u00159d\u0007\u0006dGnQ8oi\u0016DH\u000f\u0003\u0005\u0003J\u0005UE\u0011\u0002B\u0012\u0003)i\u0017m[3PM\u001a,'o\u001d\u0005\t\u0005\u001b\n)\n\"\u0011\u0003P\u0005qqN\u001c#jg\u000e|gN\\3di\u0016$GcA$\u0003R!A!1\u000bB&\u0001\u0004\u0011\u0019!A\u0007sK6|G/Z!eIJ,7o\u001d\u0005\t\u0005\u0013\n)\n\"\u0003\u0003XQ\u0019qI!\u0017\t\u0011\tm#Q\u000ba\u0001\u0003'\t!\"\u001a=fGV$xN]%e\u0011!\u0011y&!&\u0005\n\t\u0005\u0014aD3yK\u000e,Ho\u001c:Jg\u0006c\u0017N^3\u0015\t\u0005M#1\r\u0005\t\u00057\u0012i\u00061\u0001\u0002\u0014!A!qMAK\t\u0013\u0011I'A\u0006mCVt7\r\u001b+bg.\u001cHcA$\u0003l!A!Q\u000eB3\u0001\u0004\u0011y'A\u0003uCN\\7\u000f\u0005\u0004\u0002,\u0006m&\u0011\u000f\t\u0007\u0003W\u000bYLa\u001d\u0011\u0007a\u0011)(C\u0002\u0003x\u0011\u0011q\u0002V1tW\u0012+7o\u0019:jaRLwN\u001c\u0005\t\u0005w\n)\n\"\u0001\u0003~\u0005q!/Z7pm\u0016,\u00050Z2vi>\u0014H#B$\u0003\u0000\t\u0005\u0005\u0002\u0003B.\u0005s\u0002\r!a\u0005\t\u0011\t\r%\u0011\u0010a\u0001\u0005\u000b\u000baA]3bg>t\u0007c\u0001\r\u0003\b&\u0019!\u0011\u0012\u0003\u0003%\u0015CXmY;u_Jdun]:SK\u0006\u001cxN\u001c\u0005\t\u0005\u001b\u000b)\n\"\u0005\u0003\u0010\u0006yA-[:bE2,W\t_3dkR|'\u000f\u0006\u0003\u0002T\tE\u0005\u0002\u0003B.\u0005\u0017\u0003\r!a\u0005\t\u0011\tU\u0015Q\u0013C!\u0005G\taa\u001c8Ti>\u0004\b\"\u0003BM\u0001\u0001\u0007I\u0011\u0001BN\u00039!'/\u001b<fe\u0016sG\r]8j]R,\"A!(\u0011\u0007\u001d\u0012y*C\u0002\u0003\"\"\u0012aB\u00159d\u000b:$\u0007o\\5oiJ+g\rC\u0005\u0003&\u0002\u0001\r\u0011\"\u0001\u0003(\u0006\u0011BM]5wKJ,e\u000e\u001a9pS:$x\fJ3r)\r9%\u0011\u0016\u0005\n\u0017\n\r\u0016\u0011!a\u0001\u0005;C\u0001B!,\u0001A\u0003&!QT\u0001\u0010IJLg/\u001a:F]\u0012\u0004x.\u001b8uA!I!\u0011\u0017\u0001C\u0002\u0013\u0005!1W\u0001\u000fi\u0006\u001c8.\u00133t\u001f:\u001cF.\u0019<f+\t\u0011)\f\u0005\u0005\u0002\u0006\u0005=\u00111CAF\u0011!\u0011I\f\u0001Q\u0001\n\tU\u0016a\u0004;bg.LEm](o'2\fg/\u001a\u0011\t\u000f\tu\u0006\u0001\"\u0011\u0003$\u0005)1\u000f^1si\"9!\u0011\u0019\u0001\u0005\u0012\t\r\u0017\u0001F2sK\u0006$X\r\u0012:jm\u0016\u0014XI\u001c3q_&tG\u000f\u0006\u0003\u0002L\n\u0015\u0007\u0002\u0003Bd\u0005\u007f\u0003\r!!+\u0002\u0015A\u0014x\u000e]3si&,7\u000fC\u0004\u0003L\u0002!\tAa\t\u0002\u001bM$x\u000e]#yK\u000e,Ho\u001c:t\u0011\u001d\u0011y\r\u0001C!\u0005G\tAa\u001d;pa\"9!1\u001b\u0001\u0005B\t\r\u0012\u0001\u0004:fm&4Xm\u00144gKJ\u001c\bb\u0002Bl\u0001\u0011\u0005#\u0011\\\u0001\tW&dG\u000eV1tWR9qIa7\u0003`\n\u0005\bb\u0002Bo\u0005+\u0004\r!^\u0001\u0007i\u0006\u001c8.\u00133\t\u0011\tm#Q\u001ba\u0001\u0003'A\u0001Ba9\u0003V\u0002\u0007\u00111K\u0001\u0010S:$XM\u001d:vaR$\u0006N]3bI\"9!q\u001d\u0001\u0005B\t%\u0018A\u00053fM\u0006,H\u000e\u001e)be\u0006dG.\u001a7jg6$\u0012!\u0019\u0005\b\u0005w\u0002A\u0011\u0001Bw)\u00159%q\u001eBy\u0011!\u0011YFa;A\u0002\u0005M\u0001\u0002\u0003BB\u0005W\u0004\rA!\"\t\u000f\tU\b\u0001\"\u0001\u0003x\u0006i2/\u001e4gS\u000eLWM\u001c;SKN|WO]2fgJ+w-[:uKJ,G\r\u0006\u0002\u0002T!9!1 \u0001\u0005B\t]\u0018aB5t%\u0016\fG-\u001f\u0005\u0007\u0005\u007f\u0004A\u0011\u00011\u0002)9,X.\u0012=jgRLgnZ#yK\u000e,Ho\u001c:t\u0011\u001d\u0019\u0019\u0001\u0001C#\u0007\u000b\t\u0001C]3rk\u0016\u001cH/\u0012=fGV$xN]:\u0015\t\u0005M3q\u0001\u0005\b\u0007\u0013\u0019\t\u00011\u0001b\u0003YqW/\\!eI&$\u0018n\u001c8bY\u0016CXmY;u_J\u001c\bbBB\u0007\u0001\u0011\u00153qB\u0001\u0016e\u0016\fX/Z:u)>$\u0018\r\\#yK\u000e,Ho\u001c:t)!\t\u0019f!\u0005\u0004\u0016\r]\u0001bBB\n\u0007\u0017\u0001\r!Y\u0001\r]VlW\t_3dkR|'o\u001d\u0005\b\u0003o\u001aY\u00011\u0001b\u0011!\tyfa\u0003A\u0002\u0005\r\u0004bBB\u000e\u0001\u0011E1QD\u0001\u0018I>\u0014V-];fgR$v\u000e^1m\u000bb,7-\u001e;peN$B!a\u0015\u0004 !91\u0011EB\r\u0001\u0004\t\u0017A\u0004:fcV,7\u000f^3e)>$\u0018\r\u001c\u0005\b\u0007K\u0001AQIB\u0014\u00035Y\u0017\u000e\u001c7Fq\u0016\u001cW\u000f^8sgR!\u00111KB\u0015\u0011!\u0019Yca\tA\u0002\r5\u0012aC3yK\u000e,Ho\u001c:JIN\u0004b!a+\u0002<\u0006M\u0001bBB\u0013\u0001\u0011\u00151\u0011\u0007\u000b\t\u0003'\u001a\u0019d!\u000e\u0004:!A11FB\u0018\u0001\u0004\u0019i\u0003\u0003\u0005\u00048\r=\u0002\u0019AA*\u0003\u001d\u0011X\r\u001d7bG\u0016D\u0001ba\u000f\u00040\u0001\u0007\u00111K\u0001\u0006M>\u00148-\u001a\u0005\b\u0007\u007f\u0001A\u0011CB!\u0003=!wnS5mY\u0016CXmY;u_J\u001cH\u0003BA*\u0007\u0007B\u0001ba\u000b\u0004>\u0001\u00071QF\u0004\t\u0007\u000f\u0012\u0001\u0012\u0001\u0004\u0004J\u0005i2i\\1sg\u0016<%/Y5oK\u0012\u001c6\r[3ek2,'OQ1dW\u0016tG\rE\u00023\u0007\u00172q!\u0001\u0002\t\u0002\u0019\u0019ieE\u0002\u0004L5AqaLB&\t\u0003\u0019\t\u0006\u0006\u0002\u0004J!Q1QKB&\u0005\u0004%\taa\u0016\u0002\u001b\u0015sE\tU(J\u001dR{f*Q'F+\t\u0019I\u0006\u0005\u0003\u0004\\\r\u0005TBAB/\u0015\r\u0019y\u0006Q\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u001e\ru\u0003\"CB3\u0007\u0017\u0002\u000b\u0011BB-\u00039)e\n\u0012)P\u0013:#vLT!N\u000b\u0002\u0002")
public class CoarseGrainedSchedulerBackend
implements ExecutorAllocationClient,
SchedulerBackend,
Logging {
    public final TaskSchedulerImpl org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler;
    private final RpcEnv rpcEnv;
    private AtomicInteger totalCoreCount;
    private AtomicInteger totalRegisteredExecutors;
    private final SparkConf conf;
    private final int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$akkaFrameSize;
    private double minRegisteredRatio;
    private final long maxRegisteredWaitingTimeMs;
    private final long createTime;
    private final HashMap<String, ExecutorData> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap;
    private int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors;
    private final LiveListenerBus org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus;
    private final HashMap<String, Object> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove;
    private scala.collection.immutable.Map<String, Object> hostToLocalTaskCount;
    private int localityAwareTasks;
    private final HashSet<String> executorsPendingLossReason;
    private RpcEndpointRef driverEndpoint;
    private final HashMap<String, HashSet<String>> taskIdsOnSlave;
    private transient Logger org$apache$spark$Logging$$log_;
    private final String org$apache$spark$scheduler$SchedulerBackend$$appId;

    public static String ENDPOINT_NAME() {
        return CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public String org$apache$spark$scheduler$SchedulerBackend$$appId() {
        return this.org$apache$spark$scheduler$SchedulerBackend$$appId;
    }

    @Override
    public void org$apache$spark$scheduler$SchedulerBackend$_setter_$org$apache$spark$scheduler$SchedulerBackend$$appId_$eq(String x$1) {
        this.org$apache$spark$scheduler$SchedulerBackend$$appId = x$1;
    }

    @Override
    public String applicationId() {
        return SchedulerBackend$class.applicationId(this);
    }

    @Override
    public Option<String> applicationAttemptId() {
        return SchedulerBackend$class.applicationAttemptId(this);
    }

    @Override
    public Option<scala.collection.immutable.Map<String, String>> getDriverLogUrls() {
        return SchedulerBackend$class.getDriverLogUrls(this);
    }

    @Override
    public boolean killExecutor(String executorId) {
        return ExecutorAllocationClient$class.killExecutor(this, executorId);
    }

    public RpcEnv rpcEnv() {
        return this.rpcEnv;
    }

    public AtomicInteger totalCoreCount() {
        return this.totalCoreCount;
    }

    public void totalCoreCount_$eq(AtomicInteger x$1) {
        this.totalCoreCount = x$1;
    }

    public AtomicInteger totalRegisteredExecutors() {
        return this.totalRegisteredExecutors;
    }

    public void totalRegisteredExecutors_$eq(AtomicInteger x$1) {
        this.totalRegisteredExecutors = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$akkaFrameSize() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$akkaFrameSize;
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    public void minRegisteredRatio_$eq(double x$1) {
        this.minRegisteredRatio = x$1;
    }

    public long maxRegisteredWaitingTimeMs() {
        return this.maxRegisteredWaitingTimeMs;
    }

    public long createTime() {
        return this.createTime;
    }

    public HashMap<String, ExecutorData> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap;
    }

    public int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors;
    }

    public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(int x$1) {
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors = x$1;
    }

    public LiveListenerBus org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus;
    }

    public HashMap<String, Object> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove;
    }

    public scala.collection.immutable.Map<String, Object> hostToLocalTaskCount() {
        return this.hostToLocalTaskCount;
    }

    public void hostToLocalTaskCount_$eq(scala.collection.immutable.Map<String, Object> x$1) {
        this.hostToLocalTaskCount = x$1;
    }

    public int localityAwareTasks() {
        return this.localityAwareTasks;
    }

    public void localityAwareTasks_$eq(int x$1) {
        this.localityAwareTasks = x$1;
    }

    public HashSet<String> executorsPendingLossReason() {
        return this.executorsPendingLossReason;
    }

    public RpcEndpointRef driverEndpoint() {
        return this.driverEndpoint;
    }

    public void driverEndpoint_$eq(RpcEndpointRef x$1) {
        this.driverEndpoint = x$1;
    }

    public HashMap<String, HashSet<String>> taskIdsOnSlave() {
        return this.taskIdsOnSlave;
    }

    @Override
    public void start() {
        ArrayBuffer properties = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.sc().conf().getAll()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$2) {
                Tuple2<String, String> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, properties){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer properties$1;

            public final Object apply(Tuple2<String, String> x$4) {
                Tuple2<String, String> tuple2 = x$4;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    BoxedUnit boxedUnit = key.startsWith("spark.") ? this.properties$1.$plus$eq((Object)new Tuple2((Object)key, (Object)value)) : BoxedUnit.UNIT;
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                this.properties$1 = properties$1;
            }
        });
        this.driverEndpoint_$eq(this.rpcEnv().setupEndpoint(CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME(), this.createDriverEndpoint((Seq<Tuple2<String, String>>)properties)));
    }

    public DriverEndpoint createDriverEndpoint(Seq<Tuple2<String, String>> properties) {
        return new DriverEndpoint(this, this.rpcEnv(), properties);
    }

    public void stopExecutors() {
        try {
            if (this.driverEndpoint() != null) {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Shutting down all executors";
                    }
                });
                this.driverEndpoint().askWithRetry(CoarseGrainedClusterMessages$StopExecutors$.MODULE$, ClassTag$.MODULE$.Boolean());
            }
            return;
        }
        catch (Exception exception2) {
            throw new SparkException("Error asking standalone scheduler to shut down executors", exception2);
        }
    }

    @Override
    public void stop() {
        this.stopExecutors();
        try {
            if (this.driverEndpoint() != null) {
                this.driverEndpoint().askWithRetry(CoarseGrainedClusterMessages$StopDriver$.MODULE$, ClassTag$.MODULE$.Boolean());
            }
            return;
        }
        catch (Exception exception2) {
            throw new SparkException("Error stopping standalone scheduler's driver endpoint", exception2);
        }
    }

    @Override
    public void reviveOffers() {
        this.driverEndpoint().send(CoarseGrainedClusterMessages$ReviveOffers$.MODULE$);
    }

    @Override
    public void killTask(long taskId, String executorId, boolean interruptThread) {
        this.driverEndpoint().send(new CoarseGrainedClusterMessages.KillTask(taskId, executorId, interruptThread));
    }

    @Override
    public int defaultParallelism() {
        return this.conf().getInt("spark.default.parallelism", package$.MODULE$.max(this.totalCoreCount().get(), 2));
    }

    public void removeExecutor(String executorId, ExecutorLossReason reason) {
        try {
            this.driverEndpoint().askWithRetry(new CoarseGrainedClusterMessages.RemoveExecutor(executorId, reason), ClassTag$.MODULE$.Boolean());
            return;
        }
        catch (Exception exception2) {
            throw new SparkException("Error notifying standalone scheduler's driver endpoint", exception2);
        }
    }

    public boolean sufficientResourcesRegistered() {
        return true;
    }

    @Override
    public boolean isReady() {
        if (this.sufficientResourcesRegistered()) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"SchedulerBackend is ready for scheduling beginning after ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reached minRegisteredResourcesRatio: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.minRegisteredRatio())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            return true;
        }
        if (System.currentTimeMillis() - this.createTime() >= this.maxRegisteredWaitingTimeMs()) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"SchedulerBackend is ready for scheduling beginning after waiting ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxRegisteredResourcesWaitingTime: ", "(ms)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.maxRegisteredWaitingTimeMs())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            return true;
        }
        return false;
    }

    public int numExistingExecutors() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().size();
    }

    @Override
    public final synchronized boolean requestExecutors(int numAdditionalExecutors) {
        if (numAdditionalExecutors < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Attempted to request a negative number of additional executor(s) ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " from the cluster manager. Please specify a positive number!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numAdditionalExecutors)}))).toString());
        }
        this.logInfo((Function0<String>)new Serializable(this, numAdditionalExecutors){
            public static final long serialVersionUID = 0L;
            private final int numAdditionalExecutors$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requesting ", " additional executor(s) from the cluster manager"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numAdditionalExecutors$1)}));
            }
            {
                this.numAdditionalExecutors$1 = numAdditionalExecutors$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of pending executors is now ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() + numAdditionalExecutors);
        int newTotal = this.numExistingExecutors() + this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() - this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().size();
        return this.doRequestTotalExecutors(newTotal);
    }

    @Override
    public final synchronized boolean requestTotalExecutors(int numExecutors, int localityAwareTasks, scala.collection.immutable.Map<String, Object> hostToLocalTaskCount) {
        if (numExecutors < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Attempted to request a negative number of executor(s) ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " from the cluster manager. Please specify a positive number!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numExecutors)}))).toString());
        }
        this.localityAwareTasks_$eq(localityAwareTasks);
        this.hostToLocalTaskCount_$eq(hostToLocalTaskCount);
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(package$.MODULE$.max(numExecutors - this.numExistingExecutors() + this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().size(), 0));
        return this.doRequestTotalExecutors(numExecutors);
    }

    public boolean doRequestTotalExecutors(int requestedTotal) {
        return false;
    }

    @Override
    public final synchronized boolean killExecutors(Seq<String> executorIds) {
        return this.killExecutors(executorIds, false, false);
    }

    public final synchronized boolean killExecutors(Seq<String> executorIds, boolean replace, boolean force) {
        this.logInfo((Function0<String>)new Serializable(this, executorIds){
            public static final long serialVersionUID = 0L;
            private final Seq executorIds$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requesting to kill executor(s) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorIds$1.mkString(", ")}));
            }
            {
                this.executorIds$1 = executorIds$1;
            }
        });
        Tuple2 tuple2 = executorIds.partition((Function1)new $anonfun$4(this));
        if (tuple2 != null) {
            Object object;
            Tuple2 tuple22;
            Seq knownExecutors = (Seq)tuple2._1();
            Seq unknownExecutors = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)knownExecutors, (Object)unknownExecutors);
            Seq knownExecutors2 = (Seq)tuple23._1();
            Seq unknownExecutors2 = (Seq)tuple23._2();
            unknownExecutors2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

                public final void apply(String id) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this, id){
                        public static final long serialVersionUID = 0L;
                        private final String id$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executor to kill ", " does not exist!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id$1}));
                        }
                        {
                            this.id$1 = id$1;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Seq executorsToKill = (Seq)((TraversableLike)knownExecutors2.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

                public final boolean apply(String id) {
                    return !this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().contains((Object)id);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            })).filter((Function1)new Serializable(this, force){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;
                private final boolean force$1;

                public final boolean apply(String id) {
                    return this.force$1 || !this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.isExecutorBusy(id);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.force$1 = force$1;
                }
            });
            executorsToKill.foreach((Function1)new Serializable(this, replace){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;
                private final boolean replace$1;

                public final void apply(String id) {
                    this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().update((Object)id, (Object)BoxesRunTime.boxToBoolean((!this.replace$1 ? 1 : 0) != 0));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.replace$1 = replace$1;
                }
            });
            if (replace) {
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() + knownExecutors2.size());
                object = BoxedUnit.UNIT;
            } else {
                object = BoxesRunTime.boxToBoolean((boolean)this.doRequestTotalExecutors(this.numExistingExecutors() + this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() - this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().size()));
            }
            return this.doKillExecutors((Seq<String>)executorsToKill);
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean doKillExecutors(Seq<String> executorIds) {
        return false;
    }

    public CoarseGrainedSchedulerBackend(TaskSchedulerImpl scheduler, RpcEnv rpcEnv) {
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler = scheduler;
        this.rpcEnv = rpcEnv;
        ExecutorAllocationClient$class.$init$(this);
        SchedulerBackend$class.$init$(this);
        Logging$class.$init$(this);
        this.totalCoreCount = new AtomicInteger(0);
        this.totalRegisteredExecutors = new AtomicInteger(0);
        this.conf = scheduler.sc().conf();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$akkaFrameSize = AkkaUtils$.MODULE$.maxFrameSizeBytes(this.conf());
        this.minRegisteredRatio = package$.MODULE$.min(1.0, this.conf().getDouble("spark.scheduler.minRegisteredResourcesRatio", 0.0));
        this.maxRegisteredWaitingTimeMs = this.conf().getTimeAsMs("spark.scheduler.maxRegisteredResourcesWaitingTime", "30s");
        this.createTime = System.currentTimeMillis();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap = new HashMap();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors = 0;
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus = scheduler.sc().listenerBus();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove = new HashMap();
        this.hostToLocalTaskCount = Predef$.MODULE$.Map().empty();
        this.localityAwareTasks = 0;
        this.executorsPendingLossReason = new HashSet();
        this.driverEndpoint = null;
        this.taskIdsOnSlave = new HashMap();
    }

    public class DriverEndpoint
    implements ThreadSafeRpcEndpoint,
    Logging {
        private final RpcEnv rpcEnv;
        public final Seq<Tuple2<String, String>> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$sparkProperties;
        private final SerializerInstance org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser;
        private final HashMap<RpcAddress, String> addressToExecutorId;
        private final ScheduledExecutorService reviveThread;
        public final /* synthetic */ CoarseGrainedSchedulerBackend $outer;
        private transient Logger org$apache$spark$Logging$$log_;

        @Override
        public Logger org$apache$spark$Logging$$log_() {
            return this.org$apache$spark$Logging$$log_;
        }

        @Override
        @TraitSetter
        public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$Logging$$log_ = x$1;
        }

        @Override
        public String logName() {
            return Logging$class.logName(this);
        }

        @Override
        public void logInfo(Function0<String> msg) {
            Logging$class.logInfo(this, msg);
        }

        @Override
        public void logDebug(Function0<String> msg) {
            Logging$class.logDebug(this, msg);
        }

        @Override
        public void logTrace(Function0<String> msg) {
            Logging$class.logTrace(this, msg);
        }

        @Override
        public void logWarning(Function0<String> msg) {
            Logging$class.logWarning(this, msg);
        }

        @Override
        public void logError(Function0<String> msg) {
            Logging$class.logError(this, msg);
        }

        @Override
        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging$class.logInfo(this, msg, throwable);
        }

        @Override
        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging$class.logDebug(this, msg, throwable);
        }

        @Override
        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging$class.logTrace(this, msg, throwable);
        }

        @Override
        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging$class.logWarning(this, msg, throwable);
        }

        @Override
        public void logError(Function0<String> msg, Throwable throwable) {
            Logging$class.logError(this, msg, throwable);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging$class.isTraceEnabled(this);
        }

        @Override
        public final RpcEndpointRef self() {
            return RpcEndpoint$class.self(this);
        }

        @Override
        public void onError(Throwable cause) {
            RpcEndpoint$class.onError(this, cause);
        }

        @Override
        public void onConnected(RpcAddress remoteAddress) {
            RpcEndpoint$class.onConnected(this, remoteAddress);
        }

        @Override
        public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
            RpcEndpoint$class.onNetworkError(this, cause, remoteAddress);
        }

        @Override
        public final void stop() {
            RpcEndpoint$class.stop(this);
        }

        @Override
        public RpcEnv rpcEnv() {
            return this.rpcEnv;
        }

        public SerializerInstance org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser() {
            return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser;
        }

        @Override
        public Logger log() {
            return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().log();
        }

        public HashMap<RpcAddress, String> addressToExecutorId() {
            return this.addressToExecutorId;
        }

        private ScheduledExecutorService reviveThread() {
            return this.reviveThread;
        }

        @Override
        public void onStart() {
            long reviveIntervalMs = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().conf().getTimeAsMs("spark.scheduler.revive.interval", "1s");
            this.reviveThread().scheduleAtFixedRate(new Runnable(this){
                private final /* synthetic */ DriverEndpoint $outer;

                public void run() {
                    Utils$.MODULE$.tryLogNonFatalError((Function0<BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DriverEndpoint$$anon$1 $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            Option$.MODULE$.apply((Object)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anon$$$outer().self()).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(RpcEndpointRef x$1) {
                                    x$1.send(CoarseGrainedClusterMessages$ReviveOffers$.MODULE$);
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ DriverEndpoint org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anon$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, 0L, reviveIntervalMs, TimeUnit.MILLISECONDS);
        }

        @Override
        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    void var10_19;
                    A1 A1 = x1;
                    if (A1 instanceof CoarseGrainedClusterMessages.StatusUpdate) {
                        BoxedUnit boxedUnit;
                        CoarseGrainedClusterMessages.StatusUpdate statusUpdate2 = (CoarseGrainedClusterMessages.StatusUpdate)A1;
                        String executorId = statusUpdate2.executorId();
                        long taskId = statusUpdate2.taskId();
                        Enumeration.Value state = statusUpdate2.state();
                        SerializableBuffer data = statusUpdate2.data();
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.statusUpdate(taskId, state, data.value());
                        if (TaskState$.MODULE$.isFinished(state)) {
                            Option option = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId);
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                ExecutorData executorInfo = (ExecutorData)some.x();
                                executorInfo.freeCores_$eq(executorInfo.freeCores() + this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.CPUS_PER_TASK());
                                this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers(executorId);
                                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                            } else {
                                None$ none$ = None$.MODULE$;
                                Option option2 = option;
                                if (none$ != null ? !none$.equals(option2) : option2 != null) throw new MatchError((Object)option);
                                this.$outer.logWarning((Function0<String>)new Serializable(this, executorId, taskId, state){
                                    public static final long serialVersionUID = 0L;
                                    private final String executorId$1;
                                    private final long taskId$1;
                                    private final Enumeration.Value state$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored task status update (", " state ", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.taskId$1), this.state$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from unknown executor with ID ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$1}))).toString();
                                    }
                                    {
                                        this.executorId$1 = executorId$1;
                                        this.taskId$1 = taskId$1;
                                        this.state$1 = state$1;
                                    }
                                });
                                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                            }
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit4 = boxedUnit;
                        return var10_19;
                    } else {
                        CoarseGrainedClusterMessages$ReviveOffers$ coarseGrainedClusterMessages$ReviveOffers$ = CoarseGrainedClusterMessages$ReviveOffers$.MODULE$;
                        A1 A12 = A1;
                        if (!(coarseGrainedClusterMessages$ReviveOffers$ != null ? !coarseGrainedClusterMessages$ReviveOffers$.equals(A12) : A12 != null)) {
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return var10_19;
                        } else if (A1 instanceof CoarseGrainedClusterMessages.KillTask) {
                            CoarseGrainedClusterMessages.KillTask killTask2 = (CoarseGrainedClusterMessages.KillTask)A1;
                            long taskId = killTask2.taskId();
                            String executorId = killTask2.executor();
                            boolean interruptThread = killTask2.interruptThread();
                            Option option = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId);
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                ExecutorData executorInfo = (ExecutorData)some.x();
                                executorInfo.executorEndpoint().send(new CoarseGrainedClusterMessages.KillTask(taskId, executorId, interruptThread));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                None$ none$ = None$.MODULE$;
                                Option option3 = option;
                                if (none$ != null ? !none$.equals(option3) : option3 != null) throw new MatchError((Object)option);
                                this.$outer.logWarning((Function0<String>)new Serializable(this, taskId, executorId){
                                    public static final long serialVersionUID = 0L;
                                    private final long taskId$2;
                                    private final String executorId$2;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to kill task ", " for unknown executor ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.taskId$2), this.executorId$2}));
                                    }
                                    {
                                        this.taskId$2 = taskId$2;
                                        this.executorId$2 = executorId$2;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return var10_19;
                        } else {
                            Object object = function1.apply(x1);
                        }
                    }
                    return var10_19;
                }

                public final boolean isDefinedAt(Object x1) {
                    boolean bl;
                    Object object = x1;
                    if (object instanceof CoarseGrainedClusterMessages.StatusUpdate) {
                        bl = true;
                    } else {
                        CoarseGrainedClusterMessages$ReviveOffers$ coarseGrainedClusterMessages$ReviveOffers$ = CoarseGrainedClusterMessages$ReviveOffers$.MODULE$;
                        Object object2 = object;
                        bl = !(coarseGrainedClusterMessages$ReviveOffers$ != null ? !coarseGrainedClusterMessages$ReviveOffers$.equals(object2) : object2 != null) ? true : object instanceof CoarseGrainedClusterMessages.KillTask;
                    }
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            };
        }

        @Override
        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return new Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;
                private final RpcCallContext context$1;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof CoarseGrainedClusterMessages.RegisterExecutor) {
                        BoxedUnit boxedUnit;
                        CoarseGrainedClusterMessages.RegisterExecutor registerExecutor = (CoarseGrainedClusterMessages.RegisterExecutor)A1;
                        String executorId = registerExecutor.executorId();
                        RpcEndpointRef executorRef = registerExecutor.executorRef();
                        int cores = registerExecutor.cores();
                        scala.collection.immutable.Map<String, String> logUrls = registerExecutor.logUrls();
                        if (this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().contains((Object)executorId)) {
                            this.context$1.reply(new CoarseGrainedClusterMessages.RegisterExecutorFailed(new StringBuilder().append((Object)"Duplicate executor ID: ").append((Object)executorId).toString()));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            RpcAddress executorAddress = executorRef.address() == null ? this.context$1.senderAddress() : executorRef.address();
                            this.$outer.logInfo((Function0<String>)new Serializable(this, executorId, executorRef, executorAddress){
                                public static final long serialVersionUID = 0L;
                                private final String executorId$3;
                                private final RpcEndpointRef executorRef$1;
                                private final RpcAddress executorAddress$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registered executor ", " (", ") with ID ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorRef$1, this.executorAddress$1, this.executorId$3}));
                                }
                                {
                                    this.executorId$3 = executorId$3;
                                    this.executorRef$1 = executorRef$1;
                                    this.executorAddress$1 = executorAddress$1;
                                }
                            });
                            this.$outer.addressToExecutorId().update((Object)executorAddress, (Object)executorId);
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalCoreCount().addAndGet(cores);
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalRegisteredExecutors().addAndGet(1);
                            ExecutorData data = new ExecutorData(executorRef, executorRef.address(), executorAddress.host(), cores, cores, logUrls);
                            CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer();
                            synchronized (coarseGrainedSchedulerBackend) {
                                BoxedUnit boxedUnit2;
                                this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().put((Object)executorId, (Object)data);
                                if (this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() > 0) {
                                    this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() - 1);
                                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ DriverEndpoint$$anonfun$receiveAndReply$1 $outer;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Decremented number of pending executors (", " left)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors())}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 9, 11] lbl31 : MonitorExitStatement: MONITOREXIT : coarseGrainedSchedulerBackend
                                this.context$1.reply(new CoarseGrainedClusterMessages.RegisteredExecutor(executorAddress.host()));
                            }
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus().post(new SparkListenerExecutorAdded(System.currentTimeMillis(), executorId, data));
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers();
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = boxedUnit;
                        return (B1)object;
                    }
                    CoarseGrainedClusterMessages$StopDriver$ coarseGrainedClusterMessages$StopDriver$ = CoarseGrainedClusterMessages$StopDriver$.MODULE$;
                    A1 A12 = A1;
                    if (!(coarseGrainedClusterMessages$StopDriver$ != null ? !coarseGrainedClusterMessages$StopDriver$.equals(A12) : A12 != null)) {
                        this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                        this.$outer.stop();
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    CoarseGrainedClusterMessages$StopExecutors$ coarseGrainedClusterMessages$StopExecutors$ = CoarseGrainedClusterMessages$StopExecutors$.MODULE$;
                    A1 A13 = A1;
                    if (!(coarseGrainedClusterMessages$StopExecutors$ != null ? !coarseGrainedClusterMessages$StopExecutors$.equals(A13) : A13 != null)) {
                        this.$outer.logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Asking each executor to shut down";
                            }
                        });
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<String, ExecutorData> check$ifrefutable$1) {
                                Tuple2<String, ExecutorData> tuple2 = check$ifrefutable$1;
                                boolean bl = tuple2 != null;
                                return bl;
                            }
                        }).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Tuple2<String, ExecutorData> x$2) {
                                Tuple2<String, ExecutorData> tuple2 = x$2;
                                if (tuple2 != null) {
                                    ExecutorData executorData = (ExecutorData)tuple2._2();
                                    executorData.executorEndpoint().send(CoarseGrainedClusterMessages$StopExecutor$.MODULE$);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                        });
                        this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    if (A1 instanceof CoarseGrainedClusterMessages.RemoveExecutor) {
                        CoarseGrainedClusterMessages.RemoveExecutor removeExecutor2 = (CoarseGrainedClusterMessages.RemoveExecutor)A1;
                        String executorId = removeExecutor2.executorId();
                        ExecutorLossReason reason = removeExecutor2.reason();
                        this.$outer.removeExecutor(executorId, reason);
                        this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    CoarseGrainedClusterMessages$RetrieveSparkProps$ coarseGrainedClusterMessages$RetrieveSparkProps$ = CoarseGrainedClusterMessages$RetrieveSparkProps$.MODULE$;
                    A1 A14 = A1;
                    if (!(coarseGrainedClusterMessages$RetrieveSparkProps$ != null ? !coarseGrainedClusterMessages$RetrieveSparkProps$.equals(A14) : A14 != null)) {
                        this.context$1.reply(this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$sparkProperties);
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    object = function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x2) {
                    boolean bl;
                    Object object = x2;
                    if (object instanceof CoarseGrainedClusterMessages.RegisterExecutor) {
                        bl = true;
                    } else {
                        CoarseGrainedClusterMessages$StopDriver$ coarseGrainedClusterMessages$StopDriver$ = CoarseGrainedClusterMessages$StopDriver$.MODULE$;
                        Object object2 = object;
                        if (!(coarseGrainedClusterMessages$StopDriver$ != null ? !coarseGrainedClusterMessages$StopDriver$.equals(object2) : object2 != null)) {
                            bl = true;
                        } else {
                            CoarseGrainedClusterMessages$StopExecutors$ coarseGrainedClusterMessages$StopExecutors$ = CoarseGrainedClusterMessages$StopExecutors$.MODULE$;
                            Object object3 = object;
                            if (!(coarseGrainedClusterMessages$StopExecutors$ != null ? !coarseGrainedClusterMessages$StopExecutors$.equals(object3) : object3 != null)) {
                                bl = true;
                            } else if (object instanceof CoarseGrainedClusterMessages.RemoveExecutor) {
                                bl = true;
                            } else {
                                CoarseGrainedClusterMessages$RetrieveSparkProps$ coarseGrainedClusterMessages$RetrieveSparkProps$ = CoarseGrainedClusterMessages$RetrieveSparkProps$.MODULE$;
                                Object object4 = object;
                                bl = !(coarseGrainedClusterMessages$RetrieveSparkProps$ != null ? !coarseGrainedClusterMessages$RetrieveSparkProps$.equals(object4) : object4 != null);
                            }
                        }
                    }
                    return bl;
                }

                public /* synthetic */ DriverEndpoint org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }
            };
        }

        public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers() {
            Map activeExecutors = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().filterKeys((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;

                public final boolean apply(String executorId) {
                    return this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$executorIsAlive(executorId);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Seq workOffers = ((TraversableOnce)activeExecutors.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final WorkerOffer apply(Tuple2<String, ExecutorData> x0$1) {
                    Tuple2<String, ExecutorData> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String id = (String)tuple2._1();
                        ExecutorData executorData = (ExecutorData)tuple2._2();
                        WorkerOffer workerOffer = new WorkerOffer(id, executorData.executorHost(), executorData.freeCores());
                        return workerOffer;
                    }
                    throw new MatchError(tuple2);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.launchTasks(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.resourceOffers((Seq<WorkerOffer>)workOffers));
        }

        @Override
        public void onDisconnected(RpcAddress remoteAddress) {
            this.addressToExecutorId().get((Object)remoteAddress).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;

                public final void apply(String x$3) {
                    this.$outer.removeExecutor(x$3, new SlaveLost("Remote RPC client disassociated. Likely due to containers exceeding thresholds, or network issues. Check driver logs for WARN messages."));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers(String executorId) {
            if (this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$executorIsAlive(executorId)) {
                ExecutorData executorData = (ExecutorData)this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().apply((Object)executorId);
                Seq workOffers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WorkerOffer[]{new WorkerOffer(executorId, executorData.executorHost(), executorData.freeCores())}));
                this.launchTasks(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.resourceOffers((Seq<WorkerOffer>)workOffers));
            }
        }

        public synchronized boolean org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$executorIsAlive(String executorId) {
            return !this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().contains((Object)executorId) && !this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().executorsPendingLossReason().contains((Object)executorId);
        }

        private void launchTasks(Seq<Seq<TaskDescription>> tasks) {
            ((IterableLike)tasks.flatten((Function1)Predef$.MODULE$.conforms())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;

                public final void apply(TaskDescription task) {
                    ByteBuffer serializedTask = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser().serialize(task, ClassTag$.MODULE$.apply(TaskDescription.class));
                    if (serializedTask.limit() >= this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$akkaFrameSize() - AkkaUtils$.MODULE$.reservedSizeBytes()) {
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.taskIdToTaskSetManager().get((Object)BoxesRunTime.boxToLong((long)task.taskId())).foreach((Function1)new Serializable(this, task, serializedTask){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ DriverEndpoint$$anonfun$launchTasks$1 $outer;
                            private final TaskDescription task$1;
                            private final ByteBuffer serializedTask$1;

                            public final void apply(TaskSetManager taskSetMgr) {
                                try {
                                    String msg = "Serialized task %s:%d was %d bytes, which exceeds max allowed: spark.akka.frameSize (%d bytes) - reserved (%d bytes). Consider increasing spark.akka.frameSize or using broadcast variables for large values.";
                                    msg = new StringOps(Predef$.MODULE$.augmentString(msg)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.task$1.taskId()), BoxesRunTime.boxToInteger((int)this.task$1.index()), BoxesRunTime.boxToInteger((int)this.serializedTask$1.limit()), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$akkaFrameSize()), BoxesRunTime.boxToInteger((int)AkkaUtils$.MODULE$.reservedSizeBytes())}));
                                    taskSetMgr.abort(msg, taskSetMgr.abort$default$2());
                                }
                                catch (Exception exception2) {
                                    this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer().logError((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "Exception in error callback";
                                        }
                                    }, exception2);
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.task$1 = task$1;
                                this.serializedTask$1 = serializedTask$1;
                            }
                        });
                    } else {
                        ExecutorData executorData = (ExecutorData)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().apply((Object)task.executorId());
                        executorData.freeCores_$eq(executorData.freeCores() - this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.CPUS_PER_TASK());
                        executorData.executorEndpoint().send(new CoarseGrainedClusterMessages.LaunchTask(new SerializableBuffer(serializedTask)));
                    }
                }

                public /* synthetic */ DriverEndpoint org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void removeExecutor(String executorId, ExecutorLossReason reason) {
            Option option = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId);
            if (option instanceof Some) {
                Object object;
                Some some = (Some)option;
                ExecutorData executorInfo = (ExecutorData)some.x();
                CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer();
                synchronized (coarseGrainedSchedulerBackend) {
                    this.addressToExecutorId().$minus$eq((Object)executorInfo.executorAddress());
                    this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().$minus$eq((Object)executorId);
                    this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().executorsPendingLossReason().$minus$eq((Object)executorId);
                    object = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().remove((Object)executorId).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return false;
                        }
                    });
                }
                boolean killed = BoxesRunTime.unboxToBoolean((Object)object);
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalCoreCount().addAndGet(-executorInfo.totalCores());
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalRegisteredExecutors().addAndGet(-1);
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.executorLost(executorId, killed ? ExecutorKilled$.MODULE$ : reason);
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus().post(new SparkListenerExecutorRemoved(System.currentTimeMillis(), executorId, reason.toString()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            None$ none$ = None$.MODULE$;
            Option option2 = option;
            if (none$ == null) {
                if (option2 != null) {
                    throw new MatchError((Object)option);
                }
            } else if (!none$.equals(option2)) throw new MatchError((Object)option);
            this.logInfo((Function0<String>)new Serializable(this, executorId){
                public static final long serialVersionUID = 0L;
                private final String executorId$4;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Asked to remove non-existent executor ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$4}));
                }
                {
                    this.executorId$4 = executorId$4;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean disableExecutor(String executorId) {
            void var2_4;
            Boolean bl;
            CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer();
            synchronized (coarseGrainedSchedulerBackend) {
                Boolean bl2;
                if (this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$executorIsAlive(executorId)) {
                    this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().executorsPendingLossReason().$plus$eq((Object)executorId);
                    bl2 = BoxesRunTime.boxToBoolean((boolean)true);
                } else {
                    bl2 = BoxesRunTime.boxToBoolean((boolean)this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().contains((Object)executorId));
                }
                bl = bl2;
            }
            boolean shouldDisable = BoxesRunTime.unboxToBoolean((Object)bl);
            if (shouldDisable) {
                this.logInfo((Function0<String>)new Serializable(this, executorId){
                    public static final long serialVersionUID = 0L;
                    private final String executorId$5;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Disabling executor ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$5}));
                    }
                    {
                        this.executorId$5 = executorId$5;
                    }
                });
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.executorLost(executorId, LossReasonPending$.MODULE$);
            }
            return (boolean)var2_4;
        }

        @Override
        public void onStop() {
            this.reviveThread().shutdownNow();
        }

        public /* synthetic */ CoarseGrainedSchedulerBackend org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer() {
            return this.$outer;
        }

        public DriverEndpoint(CoarseGrainedSchedulerBackend $outer, RpcEnv rpcEnv, Seq<Tuple2<String, String>> sparkProperties) {
            this.rpcEnv = rpcEnv;
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$sparkProperties = sparkProperties;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            RpcEndpoint$class.$init$(this);
            Logging$class.$init$(this);
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser = SparkEnv$.MODULE$.get().closureSerializer().newInstance();
            this.addressToExecutorId = new HashMap();
            this.reviveThread = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("driver-revive-thread");
        }
    }
}

