/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.executor;

import java.nio.ByteBuffer;
import org.apache.mesos.ExecutorDriver;
import org.apache.mesos.Protos;
import org.apache.mesos.protobuf.ByteString;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskState$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.executor.Executor;
import org.apache.spark.executor.Executor$;
import org.apache.spark.executor.ExecutorBackend;
import org.apache.spark.executor.MesosExecutorBackend$;
import org.apache.spark.scheduler.cluster.mesos.MesosTaskLaunchData;
import org.apache.spark.scheduler.cluster.mesos.MesosTaskLaunchData$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005=e!B\u0001\u0003\u0001\u0011Q!\u0001F'fg>\u001cX\t_3dkR|'OQ1dW\u0016tGM\u0003\u0002\u0004\t\u0005AQ\r_3dkR|'O\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h'\u0015\u00011bE\r\u001e!\ta\u0011#D\u0001\u000e\u0015\tqq\"\u0001\u0003mC:<'\"\u0001\t\u0002\t)\fg/Y\u0005\u0003%5\u0011aa\u00142kK\u000e$\bC\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0007\u0003\u0015iWm]8t\u0013\tARC\u0001\u0005Fq\u0016\u001cW\u000f^8s!\tQ2$D\u0001\u0003\u0013\ta\"AA\bFq\u0016\u001cW\u000f^8s\u0005\u0006\u001c7.\u001a8e!\tqr$D\u0001\u0005\u0013\t\u0001CAA\u0004M_\u001e<\u0017N\\4\t\u000b\t\u0002A\u0011\u0001\u0013\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\n\t\u00035\u0001Aqa\u0001\u0001A\u0002\u0013\u0005q%F\u0001)!\tQ\u0012&\u0003\u0002\u0019\u0005!91\u0006\u0001a\u0001\n\u0003a\u0013\u0001D3yK\u000e,Ho\u001c:`I\u0015\fHCA\u00174!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0011)f.\u001b;\t\u000fQR\u0013\u0011!a\u0001Q\u0005\u0019\u0001\u0010J\u0019\t\rY\u0002\u0001\u0015)\u0003)\u0003%)\u00070Z2vi>\u0014\b\u0005C\u00049\u0001\u0001\u0007I\u0011A\u001d\u0002\r\u0011\u0014\u0018N^3s+\u0005Q\u0004C\u0001\u000b<\u0013\taTC\u0001\bFq\u0016\u001cW\u000f^8s\tJLg/\u001a:\t\u000fy\u0002\u0001\u0019!C\u0001\u007f\u0005QAM]5wKJ|F%Z9\u0015\u00055\u0002\u0005b\u0002\u001b>\u0003\u0003\u0005\rA\u000f\u0005\u0007\u0005\u0002\u0001\u000b\u0015\u0002\u001e\u0002\u000f\u0011\u0014\u0018N^3sA!)A\t\u0001C!\u000b\u0006a1\u000f^1ukN,\u0006\u000fZ1uKR!QFR&^\u0011\u001595\t1\u0001I\u0003\u0019!\u0018m]6JIB\u0011a&S\u0005\u0003\u0015>\u0012A\u0001T8oO\")Aj\u0011a\u0001\u001b\u0006)1\u000f^1uKB\u0011aJ\u0017\b\u0003\u001fbs!\u0001U,\u000f\u0005E3fB\u0001*V\u001b\u0005\u0019&B\u0001+$\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u00033\u0012\t\u0011\u0002V1tWN#\u0018\r^3\n\u0005mc&!\u0003+bg.\u001cF/\u0019;f\u0015\tIF\u0001C\u0003_\u0007\u0002\u0007q,\u0001\u0003eCR\f\u0007C\u00011d\u001b\u0005\t'B\u00012\u0010\u0003\rq\u0017n\\\u0005\u0003I\u0006\u0014!BQ=uK\n+hMZ3s\u0011\u00151\u0007\u0001\"\u0011h\u0003)\u0011XmZ5ti\u0016\u0014X\r\u001a\u000b\u0006[!LG/\u001f\u0005\u0006q\u0015\u0004\rA\u000f\u0005\u0006U\u0016\u0004\ra[\u0001\rKb,7-\u001e;pe&sgm\u001c\t\u0003YFt!!\\8\u000f\u0005As\u0017B\u0001\f\u0007\u0013\t\u0001X#\u0001\u0004Qe>$xn]\u0005\u0003eN\u0014A\"\u0012=fGV$xN]%oM>T!\u0001]\u000b\t\u000bU,\u0007\u0019\u0001<\u0002\u001b\u0019\u0014\u0018-\\3x_J\\\u0017J\u001c4p!\taw/\u0003\u0002yg\niaI]1nK^|'o[%oM>DQA_3A\u0002m\f\u0011b\u001d7bm\u0016LeNZ8\u0011\u00051d\u0018BA?t\u0005%\u0019F.\u0019<f\u0013:4w\u000e\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011A\u0001\u000bY\u0006,hn\u00195UCN\\G#B\u0017\u0002\u0004\u0005\u001d\u0001BBA\u0003}\u0002\u0007!(A\u0001e\u0011\u001d\tIA a\u0001\u0003\u0017\t\u0001\u0002^1tW&sgm\u001c\t\u0004Y\u00065\u0011bAA\bg\nAA+Y:l\u0013:4w\u000eC\u0004\u0002\u0014\u0001!\t%!\u0006\u0002\u000b\u0015\u0014(o\u001c:\u0015\u000b5\n9\"!\u0007\t\u000f\u0005\u0015\u0011\u0011\u0003a\u0001u!A\u00111DA\t\u0001\u0004\ti\"A\u0004nKN\u001c\u0018mZ3\u0011\t\u0005}\u0011Q\u0005\b\u0004]\u0005\u0005\u0012bAA\u0012_\u00051\u0001K]3eK\u001aLA!a\n\u0002*\t11\u000b\u001e:j]\u001eT1!a\t0\u0011\u001d\ti\u0003\u0001C!\u0003_\t\u0001b[5mYR\u000b7o\u001b\u000b\u0006[\u0005E\u00121\u0007\u0005\b\u0003\u000b\tY\u00031\u0001;\u0011!\t)$a\u000bA\u0002\u0005]\u0012!\u0001;\u0011\u00071\fI$C\u0002\u0002<M\u0014a\u0001V1tW&#\u0005bBA \u0001\u0011\u0005\u0013\u0011I\u0001\re\u0016\u0014XmZ5ti\u0016\u0014X\r\u001a\u000b\u0006[\u0005\r\u0013Q\t\u0005\b\u0003\u000b\ti\u00041\u0001;\u0011\u001d\t9%!\u0010A\u0002m\f!\u0001\u001d\u001a\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N\u0005aA-[:d_:tWm\u0019;fIR\u0019Q&a\u0014\t\u000f\u0005\u0015\u0011\u0011\na\u0001u!9\u00111\u000b\u0001\u0005B\u0005U\u0013\u0001\u00054sC6,wo\u001c:l\u001b\u0016\u001c8/Y4f)\u0015i\u0013qKA-\u0011\u001d\t)!!\u0015A\u0002iBqAXA)\u0001\u0004\tY\u0006E\u0003/\u0003;\n\t'C\u0002\u0002`=\u0012Q!\u0011:sCf\u00042ALA2\u0013\r\t)g\f\u0002\u0005\u0005f$X\rC\u0004\u0002j\u0001!\t%a\u001b\u0002\u0011MDW\u000f\u001e3po:$2!LA7\u0011\u001d\t)!a\u001aA\u0002i:\u0001\"!\u001d\u0003\u0011\u0003!\u00111O\u0001\u0015\u001b\u0016\u001cxn]#yK\u000e,Ho\u001c:CC\u000e\\WM\u001c3\u0011\u0007i\t)HB\u0004\u0002\u0005!\u0005A!a\u001e\u0014\u000b\u0005U\u0014\u0011P\u000f\u0011\u00079\nY(C\u0002\u0002~=\u0012a!\u00118z%\u00164\u0007b\u0002\u0012\u0002v\u0011\u0005\u0011\u0011\u0011\u000b\u0003\u0003gB\u0001\"!\"\u0002v\u0011\u0005\u0011qQ\u0001\u0005[\u0006Lg\u000eF\u0002.\u0003\u0013C\u0001\"a#\u0002\u0004\u0002\u0007\u0011QR\u0001\u0005CJ<7\u000fE\u0003/\u0003;\ni\u0002")
public class MesosExecutorBackend
implements org.apache.mesos.Executor,
ExecutorBackend,
Logging {
    private Executor executor;
    private ExecutorDriver driver;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void main(String[] stringArray) {
        MesosExecutorBackend$.MODULE$.main(stringArray);
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public Executor executor() {
        return this.executor;
    }

    public void executor_$eq(Executor x$1) {
        this.executor = x$1;
    }

    public ExecutorDriver driver() {
        return this.driver;
    }

    public void driver_$eq(ExecutorDriver x$1) {
        this.driver = x$1;
    }

    @Override
    public void statusUpdate(long taskId, Enumeration.Value state, ByteBuffer data) {
        Protos.TaskID mesosTaskId = Protos.TaskID.newBuilder().setValue(((Object)BoxesRunTime.boxToLong((long)taskId)).toString()).build();
        this.driver().sendStatusUpdate(Protos.TaskStatus.newBuilder().setTaskId(mesosTaskId).setState(TaskState$.MODULE$.toMesos(state)).setData(ByteString.copyFrom((ByteBuffer)data)).build());
    }

    public void registered(ExecutorDriver driver, Protos.ExecutorInfo executorInfo, Protos.FrameworkInfo frameworkInfo, Protos.SlaveInfo slaveInfo) {
        int cpusPerTask = BoxesRunTime.unboxToInt((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(executorInfo.getResourcesList()).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Protos.Resource x$1) {
                String string = x$1.getName();
                String string2 = "cpus";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Protos.Resource x$2) {
                return (int)x$2.getScalar().getValue();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
        String executorId = executorInfo.getExecutorId().getValue();
        this.logInfo((Function0<String>)new Serializable(this, cpusPerTask, executorId){
            public static final long serialVersionUID = 0L;
            private final int cpusPerTask$1;
            private final String executorId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registered with Mesos as executor ID ", " with ", " cpus"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$1, BoxesRunTime.boxToInteger((int)this.cpusPerTask$1)}));
            }
            {
                this.cpusPerTask$1 = cpusPerTask$1;
                this.executorId$1 = executorId$1;
            }
        });
        this.driver_$eq(driver);
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        Tuple2[] properties = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.deserialize(executorInfo.getData().toByteArray())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"spark.app.id", (Object)frameworkInfo.getId().getValue())})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        SparkConf conf = new SparkConf(true).setAll((Traversable<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])properties));
        int port = conf.getInt("spark.executor.port", 0);
        SparkEnv env = SparkEnv$.MODULE$.createExecutorEnv(conf, executorId, slaveInfo.getHostname(), port, cpusPerTask, false);
        this.executor_$eq(new Executor(executorId, slaveInfo.getHostname(), env, Executor$.MODULE$.$lessinit$greater$default$4(), Executor$.MODULE$.$lessinit$greater$default$5()));
    }

    public void launchTask(ExecutorDriver d, Protos.TaskInfo taskInfo) {
        long taskId = new StringOps(Predef$.MODULE$.augmentString(taskInfo.getTaskId().getValue())).toLong();
        MesosTaskLaunchData taskData = MesosTaskLaunchData$.MODULE$.fromByteString(taskInfo.getData());
        if (this.executor() == null) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Received launchTask but executor was null";
                }
            });
        } else {
            SparkHadoopUtil$.MODULE$.get().runAsSparkUser((Function0<BoxedUnit>)new Serializable(this, taskInfo, taskId, taskData){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MesosExecutorBackend $outer;
                private final Protos.TaskInfo taskInfo$1;
                private final long taskId$1;
                private final MesosTaskLaunchData taskData$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.executor().launchTask(this.$outer, this.taskId$1, this.taskData$1.attemptNumber(), this.taskInfo$1.getName(), this.taskData$1.serializedTask());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.taskInfo$1 = taskInfo$1;
                    this.taskId$1 = taskId$1;
                    this.taskData$1 = taskData$1;
                }
            });
        }
    }

    public void error(ExecutorDriver d, String message) {
        this.logError((Function0<String>)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final String message$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Error from Mesos: ").append((Object)this.message$1).toString();
            }
            {
                this.message$1 = message$1;
            }
        });
    }

    public void killTask(ExecutorDriver d, Protos.TaskID t) {
        if (this.executor() == null) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Received KillTask but executor was null";
                }
            });
        } else {
            this.executor().killTask(new StringOps(Predef$.MODULE$.augmentString(t.getValue())).toLong(), false);
        }
    }

    public void reregistered(ExecutorDriver d, Protos.SlaveInfo p2) {
    }

    public void disconnected(ExecutorDriver d) {
    }

    public void frameworkMessage(ExecutorDriver d, byte[] data) {
    }

    public void shutdown(ExecutorDriver d) {
    }

    public MesosExecutorBackend() {
        Logging$class.$init$(this);
        this.executor = null;
        this.driver = null;
    }
}

