/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.util.concurrent.TimeoutException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.FaultToleranceTest;
import org.apache.spark.deploy.FaultToleranceTest$;
import org.apache.spark.deploy.SparkCuratorUtil$;
import org.apache.spark.deploy.SparkDocker$;
import org.apache.spark.deploy.TestMasterInfo;
import org.apache.spark.deploy.TestWorkerInfo;
import org.apache.spark.deploy.master.RecoveryState$;
import org.slf4j.Logger;
import scala.App;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;

public final class FaultToleranceTest$
implements App,
Logging {
    public static final FaultToleranceTest$ MODULE$;
    private SparkConf org$apache$spark$deploy$FaultToleranceTest$$conf;
    private String ZK_DIR;
    private ListBuffer<TestMasterInfo> org$apache$spark$deploy$FaultToleranceTest$$masters;
    private ListBuffer<TestWorkerInfo> org$apache$spark$deploy$FaultToleranceTest$$workers;
    private SparkContext org$apache$spark$deploy$FaultToleranceTest$$sc;
    private CuratorFramework zk;
    private int org$apache$spark$deploy$FaultToleranceTest$$numPassed;
    private int org$apache$spark$deploy$FaultToleranceTest$$numFailed;
    private String org$apache$spark$deploy$FaultToleranceTest$$sparkHome;
    private String org$apache$spark$deploy$FaultToleranceTest$$containerSparkHome;
    private String org$apache$spark$deploy$FaultToleranceTest$$dockerMountDir;
    private transient Logger org$apache$spark$Logging$$log_;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new FaultToleranceTest$();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.class.delayedInit((App)this, body2);
    }

    public void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    public SparkConf org$apache$spark$deploy$FaultToleranceTest$$conf() {
        return this.org$apache$spark$deploy$FaultToleranceTest$$conf;
    }

    private String ZK_DIR() {
        return this.ZK_DIR;
    }

    public ListBuffer<TestMasterInfo> org$apache$spark$deploy$FaultToleranceTest$$masters() {
        return this.org$apache$spark$deploy$FaultToleranceTest$$masters;
    }

    public ListBuffer<TestWorkerInfo> org$apache$spark$deploy$FaultToleranceTest$$workers() {
        return this.org$apache$spark$deploy$FaultToleranceTest$$workers;
    }

    public SparkContext org$apache$spark$deploy$FaultToleranceTest$$sc() {
        return this.org$apache$spark$deploy$FaultToleranceTest$$sc;
    }

    private void org$apache$spark$deploy$FaultToleranceTest$$sc_$eq(SparkContext x$1) {
        this.org$apache$spark$deploy$FaultToleranceTest$$sc = x$1;
    }

    private CuratorFramework zk() {
        return this.zk;
    }

    public int org$apache$spark$deploy$FaultToleranceTest$$numPassed() {
        return this.org$apache$spark$deploy$FaultToleranceTest$$numPassed;
    }

    public void org$apache$spark$deploy$FaultToleranceTest$$numPassed_$eq(int x$1) {
        this.org$apache$spark$deploy$FaultToleranceTest$$numPassed = x$1;
    }

    public int org$apache$spark$deploy$FaultToleranceTest$$numFailed() {
        return this.org$apache$spark$deploy$FaultToleranceTest$$numFailed;
    }

    public void org$apache$spark$deploy$FaultToleranceTest$$numFailed_$eq(int x$1) {
        this.org$apache$spark$deploy$FaultToleranceTest$$numFailed = x$1;
    }

    public String org$apache$spark$deploy$FaultToleranceTest$$sparkHome() {
        return this.org$apache$spark$deploy$FaultToleranceTest$$sparkHome;
    }

    public String org$apache$spark$deploy$FaultToleranceTest$$containerSparkHome() {
        return this.org$apache$spark$deploy$FaultToleranceTest$$containerSparkHome;
    }

    public String org$apache$spark$deploy$FaultToleranceTest$$dockerMountDir() {
        return this.org$apache$spark$deploy$FaultToleranceTest$$dockerMountDir;
    }

    private void afterEach() {
        if (this.org$apache$spark$deploy$FaultToleranceTest$$sc() != null) {
            this.org$apache$spark$deploy$FaultToleranceTest$$sc().stop();
            this.org$apache$spark$deploy$FaultToleranceTest$$sc_$eq(null);
        }
        this.org$apache$spark$deploy$FaultToleranceTest$$terminateCluster();
        SparkCuratorUtil$.MODULE$.deleteRecursive(this.zk(), new StringBuilder().append((Object)this.ZK_DIR()).append((Object)"/spark_leader").toString());
        SparkCuratorUtil$.MODULE$.deleteRecursive(this.zk(), new StringBuilder().append((Object)this.ZK_DIR()).append((Object)"/master_status").toString());
    }

    public void org$apache$spark$deploy$FaultToleranceTest$$test(String name, Function0<BoxedUnit> fn2) {
        try {
            fn2.apply$mcV$sp();
            this.org$apache$spark$deploy$FaultToleranceTest$$numPassed_$eq(this.org$apache$spark$deploy$FaultToleranceTest$$numPassed() + 1);
            this.logInfo((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "==============================================";
                }
            });
            this.logInfo((Function0<String>)new Serializable(name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Passed: ").append((Object)this.name$1).toString();
                }
                {
                    this.name$1 = name$1;
                }
            });
            this.logInfo((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "==============================================";
                }
            });
            this.afterEach();
            return;
        }
        catch (Exception exception2) {
            this.org$apache$spark$deploy$FaultToleranceTest$$numFailed_$eq(this.org$apache$spark$deploy$FaultToleranceTest$$numFailed() + 1);
            this.logInfo((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
                }
            });
            this.logError((Function0<String>)new Serializable(name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"FAILED: ").append((Object)this.name$1).toString();
                }
                {
                    this.name$1 = name$1;
                }
            }, exception2);
            this.logInfo((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
                }
            });
            throw scala.sys.package$.MODULE$.exit(1);
        }
    }

    public void org$apache$spark$deploy$FaultToleranceTest$$addMasters(int num) {
        this.logInfo((Function0<String>)new Serializable(num){
            public static final long serialVersionUID = 0L;
            private final int num$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{">>>>> ADD MASTERS ", " <<<<<"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.num$1)}));
            }
            {
                this.num$1 = num$1;
            }
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), num).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ListBuffer<TestMasterInfo> apply(int x$3) {
                return FaultToleranceTest$.MODULE$.org$apache$spark$deploy$FaultToleranceTest$$masters().$plus$eq((Object)SparkDocker$.MODULE$.startMaster(FaultToleranceTest$.MODULE$.org$apache$spark$deploy$FaultToleranceTest$$dockerMountDir()));
            }
        });
    }

    public void org$apache$spark$deploy$FaultToleranceTest$$addWorkers(int num) {
        this.logInfo((Function0<String>)new Serializable(num){
            public static final long serialVersionUID = 0L;
            private final int num$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{">>>>> ADD WORKERS ", " <<<<<"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.num$2)}));
            }
            {
                this.num$2 = num$2;
            }
        });
        String masterUrls = this.getMasterUrls((Seq<TestMasterInfo>)this.org$apache$spark$deploy$FaultToleranceTest$$masters());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), num).foreach((Function1)new Serializable(masterUrls){
            public static final long serialVersionUID = 0L;
            private final String masterUrls$1;

            public final ListBuffer<TestWorkerInfo> apply(int x$4) {
                return FaultToleranceTest$.MODULE$.org$apache$spark$deploy$FaultToleranceTest$$workers().$plus$eq((Object)SparkDocker$.MODULE$.startWorker(FaultToleranceTest$.MODULE$.org$apache$spark$deploy$FaultToleranceTest$$dockerMountDir(), this.masterUrls$1));
            }
            {
                this.masterUrls$1 = masterUrls$1;
            }
        });
    }

    public void org$apache$spark$deploy$FaultToleranceTest$$createClient() {
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ">>>>> CREATE CLIENT <<<<<";
            }
        });
        if (this.org$apache$spark$deploy$FaultToleranceTest$$sc() != null) {
            this.org$apache$spark$deploy$FaultToleranceTest$$sc().stop();
        }
        System.setProperty("spark.driver.port", "0");
        this.org$apache$spark$deploy$FaultToleranceTest$$sc_$eq(new SparkContext(this.getMasterUrls((Seq<TestMasterInfo>)this.org$apache$spark$deploy$FaultToleranceTest$$masters()), "fault-tolerance", this.org$apache$spark$deploy$FaultToleranceTest$$containerSparkHome()));
    }

    private String getMasterUrls(Seq<TestMasterInfo> masters) {
        return new StringBuilder().append((Object)"spark://").append((Object)((TraversableOnce)masters.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(TestMasterInfo master) {
                return new StringBuilder().append((Object)master.ip()).append((Object)":7077").toString();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",")).toString();
    }

    public TestMasterInfo org$apache$spark$deploy$FaultToleranceTest$$getLeader() {
        ListBuffer leaders = (ListBuffer)this.org$apache$spark$deploy$FaultToleranceTest$$masters().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(TestMasterInfo x$5) {
                Enumeration.Value value = x$5.state();
                Enumeration.Value value2 = RecoveryState$.MODULE$.ALIVE();
                return !(value != null ? !value.equals(value2) : value2 != null);
            }
        });
        this.org$apache$spark$deploy$FaultToleranceTest$$assertTrue(leaders.size() == 1, this.org$apache$spark$deploy$FaultToleranceTest$$assertTrue$default$2());
        return (TestMasterInfo)leaders.apply(0);
    }

    public void org$apache$spark$deploy$FaultToleranceTest$$killLeader() {
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ">>>>> KILL LEADER <<<<<";
            }
        });
        this.org$apache$spark$deploy$FaultToleranceTest$$masters().foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(TestMasterInfo x$6) {
                x$6.readState();
            }
        });
        TestMasterInfo leader = this.org$apache$spark$deploy$FaultToleranceTest$$getLeader();
        this.org$apache$spark$deploy$FaultToleranceTest$$masters().$minus$eq((Object)leader);
        leader.kill();
    }

    public void org$apache$spark$deploy$FaultToleranceTest$$delay(Duration secs) {
        Thread.sleep(secs.toMillis());
    }

    public Duration org$apache$spark$deploy$FaultToleranceTest$$delay$default$1() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds();
    }

    public void org$apache$spark$deploy$FaultToleranceTest$$terminateCluster() {
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ">>>>> TERMINATE CLUSTER <<<<<";
            }
        });
        this.org$apache$spark$deploy$FaultToleranceTest$$masters().foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(TestMasterInfo x$7) {
                x$7.kill();
            }
        });
        this.org$apache$spark$deploy$FaultToleranceTest$$workers().foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(TestWorkerInfo x$8) {
                x$8.kill();
            }
        });
        this.org$apache$spark$deploy$FaultToleranceTest$$masters().clear();
        this.org$apache$spark$deploy$FaultToleranceTest$$workers().clear();
    }

    private void assertUsable() {
        Future f = package$.MODULE$.future((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                boolean bl;
                try {
                    SparkContext qual$1 = FaultToleranceTest$.MODULE$.org$apache$spark$deploy$FaultToleranceTest$$sc();
                    Range x$15 = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10);
                    int x$16 = qual$1.parallelize$default$2();
                    int[] res = (int[])qual$1.parallelize(x$15, x$16, ClassTag$.MODULE$.Int()).collect();
                    List list = Predef$.MODULE$.intArrayOps(res).toList();
                    List list2 = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).toList();
                    FaultToleranceTest$.MODULE$.org$apache$spark$deploy$FaultToleranceTest$$assertTrue(!(list != null ? !list.equals(list2) : list2 != null), FaultToleranceTest$.MODULE$.org$apache$spark$deploy$FaultToleranceTest$$assertTrue$default$2());
                    bl = true;
                }
                catch (Exception exception2) {
                    FaultToleranceTest$.MODULE$.logError((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "assertUsable() had exception";
                        }
                    }, exception2);
                    exception2.printStackTrace();
                    bl = false;
                }
                return bl;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        this.org$apache$spark$deploy$FaultToleranceTest$$assertTrue(BoxesRunTime.unboxToBoolean((Object)Await$.MODULE$.result((Awaitable)f, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(120)).seconds())), this.org$apache$spark$deploy$FaultToleranceTest$$assertTrue$default$2());
    }

    public void org$apache$spark$deploy$FaultToleranceTest$$assertValidClusterState() {
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ">>>>> ASSERT VALID CLUSTER STATE <<<<<";
            }
        });
        this.assertUsable();
        IntRef numAlive = new IntRef(0);
        IntRef numStandby = new IntRef(0);
        IntRef numLiveApps = new IntRef(0);
        ObjectRef liveWorkerIPs = new ObjectRef((Object)Nil$.MODULE$);
        Future f = package$.MODULE$.future((Function0)new Serializable(numAlive, numStandby, numLiveApps, liveWorkerIPs){
            public static final long serialVersionUID = 0L;
            public final IntRef numAlive$1;
            public final IntRef numStandby$1;
            public final IntRef numLiveApps$1;
            public final ObjectRef liveWorkerIPs$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                boolean bl;
                try {
                    while (true) {
                        if (FaultToleranceTest$.MODULE$.org$apache$spark$deploy$FaultToleranceTest$$stateValid$1(this.numAlive$1, this.numStandby$1, this.numLiveApps$1, this.liveWorkerIPs$1)) {
                            bl = true;
                            break;
                        }
                        Thread.sleep(1000L);
                        this.numAlive$1.elem = 0;
                        this.numStandby$1.elem = 0;
                        this.numLiveApps$1.elem = 0;
                        FaultToleranceTest$.MODULE$.org$apache$spark$deploy$FaultToleranceTest$$masters().foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(TestMasterInfo x$10) {
                                x$10.readState();
                            }
                        });
                        FaultToleranceTest$.MODULE$.org$apache$spark$deploy$FaultToleranceTest$$masters().foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.9 $outer;

                            public final void apply(TestMasterInfo master) {
                                Enumeration.Value value = master.state();
                                Enumeration.Value value2 = RecoveryState$.MODULE$.ALIVE();
                                Enumeration.Value value3 = value;
                                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                                    ++this.$outer.numAlive$1.elem;
                                    this.$outer.liveWorkerIPs$1.elem = master.liveWorkerIPs();
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    Enumeration.Value value4 = RecoveryState$.MODULE$.STANDBY();
                                    Enumeration.Value value5 = value;
                                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                                        ++this.$outer.numStandby$1.elem;
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }
                                }
                                this.$outer.numLiveApps$1.elem += master.numLiveApps();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                }
                catch (Exception exception2) {
                    FaultToleranceTest$.MODULE$.logError((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "assertValidClusterState() had exception";
                        }
                    }, exception2);
                    bl = false;
                }
                return bl;
            }
            {
                this.numAlive$1 = numAlive$1;
                this.numStandby$1 = numStandby$1;
                this.numLiveApps$1 = numLiveApps$1;
                this.liveWorkerIPs$1 = liveWorkerIPs$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        try {
            this.org$apache$spark$deploy$FaultToleranceTest$$assertTrue(BoxesRunTime.unboxToBoolean((Object)Await$.MODULE$.result((Awaitable)f, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(120)).seconds())), this.org$apache$spark$deploy$FaultToleranceTest$$assertTrue$default$2());
            return;
        }
        catch (TimeoutException timeoutException) {
            this.logError((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)"Master states: ").append(FaultToleranceTest$.MODULE$.org$apache$spark$deploy$FaultToleranceTest$$masters().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Enumeration.Value apply(TestMasterInfo x$11) {
                            return x$11.state();
                        }
                    }, ListBuffer$.MODULE$.canBuildFrom())).toString();
                }
            });
            this.logError((Function0<String>)new Serializable(numLiveApps){
                public static final long serialVersionUID = 0L;
                private final IntRef numLiveApps$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Num apps: ").append((Object)BoxesRunTime.boxToInteger((int)this.numLiveApps$1.elem)).toString();
                }
                {
                    this.numLiveApps$1 = numLiveApps$1;
                }
            });
            this.logError((Function0<String>)new Serializable(liveWorkerIPs){
                public static final long serialVersionUID = 0L;
                private final ObjectRef liveWorkerIPs$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"IPs expected: ").append(FaultToleranceTest$.MODULE$.org$apache$spark$deploy$FaultToleranceTest$$workers().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(TestWorkerInfo x$12) {
                            return x$12.ip();
                        }
                    }, ListBuffer$.MODULE$.canBuildFrom())).append((Object)" / found: ").append((Object)((Seq)this.liveWorkerIPs$1.elem)).toString();
                }
                {
                    this.liveWorkerIPs$1 = liveWorkerIPs$1;
                }
            });
            throw new RuntimeException("Failed to get into acceptable cluster state after 2 min.", timeoutException);
        }
    }

    public void org$apache$spark$deploy$FaultToleranceTest$$assertTrue(boolean bool, String message) {
        if (bool) {
            return;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"Assertion failed: ").append((Object)message).toString());
    }

    public String org$apache$spark$deploy$FaultToleranceTest$$assertTrue$default$2() {
        return "";
    }

    public final boolean org$apache$spark$deploy$FaultToleranceTest$$stateValid$1(IntRef numAlive$1, IntRef numStandby$1, IntRef numLiveApps$1, ObjectRef liveWorkerIPs$1) {
        return ((TraversableForwarder)((BufferLike)this.org$apache$spark$deploy$FaultToleranceTest$$workers().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(TestWorkerInfo x$9) {
                return x$9.ip();
            }
        }, ListBuffer$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)((Seq)liveWorkerIPs$1.elem))).isEmpty() && numAlive$1.elem == 1 && numStandby$1.elem == this.org$apache$spark$deploy$FaultToleranceTest$$masters().size() - 1 && numLiveApps$1.elem >= 1;
    }

    public void org$apache$spark$deploy$FaultToleranceTest$$conf_$eq(SparkConf x$1) {
        this.org$apache$spark$deploy$FaultToleranceTest$$conf = x$1;
    }

    public void ZK_DIR_$eq(String x$1) {
        this.ZK_DIR = x$1;
    }

    public void org$apache$spark$deploy$FaultToleranceTest$$masters_$eq(ListBuffer x$1) {
        this.org$apache$spark$deploy$FaultToleranceTest$$masters = x$1;
    }

    public void org$apache$spark$deploy$FaultToleranceTest$$workers_$eq(ListBuffer x$1) {
        this.org$apache$spark$deploy$FaultToleranceTest$$workers = x$1;
    }

    public void zk_$eq(CuratorFramework x$1) {
        this.zk = x$1;
    }

    public void org$apache$spark$deploy$FaultToleranceTest$$sparkHome_$eq(String x$1) {
        this.org$apache$spark$deploy$FaultToleranceTest$$sparkHome = x$1;
    }

    public void org$apache$spark$deploy$FaultToleranceTest$$containerSparkHome_$eq(String x$1) {
        this.org$apache$spark$deploy$FaultToleranceTest$$containerSparkHome = x$1;
    }

    public void org$apache$spark$deploy$FaultToleranceTest$$dockerMountDir_$eq(String x$1) {
        this.org$apache$spark$deploy$FaultToleranceTest$$dockerMountDir = x$1;
    }

    private FaultToleranceTest$() {
        MODULE$ = this;
        App.class.$init$((App)this);
        Logging$class.$init$(this);
        this.delayedInit((Function0<BoxedUnit>)new FaultToleranceTest.delayedInit.body(this));
    }
}

