/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import akka.actor.ActorRef;
import akka.actor.ActorRefProvider;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.ExtendedActorSystem;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.util.Timeout$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import org.apache.log4j.Level;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.TraitSetter;

public final class AkkaUtils$
implements Logging {
    public static final AkkaUtils$ MODULE$;
    private final int AKKA_MAX_FRAME_SIZE_IN_MB;
    private final int reservedSizeBytes;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new AkkaUtils$();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public Tuple2<ActorSystem, Object> createActorSystem(String name, String host, int port, SparkConf conf, SecurityManager securityManager) {
        Serializable startService = new Serializable(name, host, conf, securityManager){
            public static final long serialVersionUID = 0L;
            private final String name$1;
            private final String host$1;
            private final SparkConf conf$1;
            private final SecurityManager securityManager$1;

            public final Tuple2<ActorSystem, Object> apply(int actualPort) {
                return AkkaUtils$.MODULE$.org$apache$spark$util$AkkaUtils$$doCreateActorSystem(this.name$1, this.host$1, actualPort, this.conf$1, this.securityManager$1);
            }
            {
                this.name$1 = name$1;
                this.host$1 = host$1;
                this.conf$1 = conf$1;
                this.securityManager$1 = securityManager$1;
            }
        };
        return Utils$.MODULE$.startServiceOnPort(port, startService, conf, name);
    }

    public Tuple2<ActorSystem, Object> org$apache$spark$util$AkkaUtils$$doCreateActorSystem(String name, String host, int port, SparkConf conf, SecurityManager securityManager) {
        int akkaThreads = conf.getInt("spark.akka.threads", 4);
        int akkaBatchSize = conf.getInt("spark.akka.batchSize", 15);
        long akkaTimeoutS = conf.getTimeAsSeconds("spark.akka.timeout", conf.get("spark.network.timeout", "120s"));
        int akkaFrameSize = this.maxFrameSizeBytes(conf);
        boolean akkaLogLifecycleEvents = conf.getBoolean("spark.akka.logLifecycleEvents", false);
        String lifecycleEvents = akkaLogLifecycleEvents ? "on" : "off";
        Object object = akkaLogLifecycleEvents ? BoxedUnit.UNIT : Option$.MODULE$.apply((Object)org.apache.log4j.Logger.getLogger((String)"akka.remote.EndpointWriter")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(org.apache.log4j.Logger l) {
                l.setLevel(Level.FATAL);
            }
        });
        String logAkkaConfig = conf.getBoolean("spark.akka.logAkkaConfig", false) ? "on" : "off";
        long akkaHeartBeatPausesS = conf.getTimeAsSeconds("spark.akka.heartbeat.pauses", "6000s");
        long akkaHeartBeatIntervalS = conf.getTimeAsSeconds("spark.akka.heartbeat.interval", "1000s");
        String secretKey = securityManager.getSecretKey();
        boolean isAuthOn = securityManager.isAuthenticationEnabled();
        if (isAuthOn && secretKey == null) {
            throw new Exception("Secret key is null with authentication on");
        }
        String requireCookie = isAuthOn ? "on" : "off";
        String secureCookie = isAuthOn ? secretKey : "";
        this.logDebug((Function0<String>)new Serializable(requireCookie){
            public static final long serialVersionUID = 0L;
            private final String requireCookie$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"In createActorSystem, requireCookie is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.requireCookie$1}));
            }
            {
                this.requireCookie$1 = requireCookie$1;
            }
        });
        Config akkaSslConfig = (Config)securityManager.akkaSSLOptions().createAkkaConfig().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Config apply() {
                return ConfigFactory.empty();
            }
        });
        Config akkaConf = ConfigFactory.parseMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)conf.getAkkaConf().toMap(Predef$.MODULE$.conforms())).asJava())).withFallback((ConfigMergeable)akkaSslConfig).withFallback((ConfigMergeable)ConfigFactory.parseString((String)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      |akka.daemonic = on\n      |akka.loggers = [\"\"akka.event.slf4j.Slf4jLogger\"\"]\n      |akka.stdout-loglevel = \"ERROR\"\n      |akka.jvm-exit-on-fatal-error = off\n      |akka.remote.require-cookie = \"", "\"\n      |akka.remote.secure-cookie = \"", "\"\n      |akka.remote.transport-failure-detector.heartbeat-interval = ", " s\n      |akka.remote.transport-failure-detector.acceptable-heartbeat-pause = ", " s\n      |akka.actor.provider = \"akka.remote.RemoteActorRefProvider\"\n      |akka.remote.netty.tcp.transport-class = \"akka.remote.transport.netty.NettyTransport\"\n      |akka.remote.netty.tcp.hostname = \"", "\"\n      |akka.remote.netty.tcp.port = ", "\n      |akka.remote.netty.tcp.tcp-nodelay = on\n      |akka.remote.netty.tcp.connection-timeout = ", " s\n      |akka.remote.netty.tcp.maximum-frame-size = ", "B\n      |akka.remote.netty.tcp.execution-pool-size = ", "\n      |akka.actor.default-dispatcher.throughput = ", "\n      |akka.log-config-on-start = ", "\n      |akka.remote.log-remote-lifecycle-events = ", "\n      |akka.log-dead-letters = ", "\n      |akka.log-dead-letters-during-shutdown = ", "\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{requireCookie, secureCookie, BoxesRunTime.boxToLong((long)akkaHeartBeatIntervalS), BoxesRunTime.boxToLong((long)akkaHeartBeatPausesS), host, BoxesRunTime.boxToInteger((int)port), BoxesRunTime.boxToLong((long)akkaTimeoutS), BoxesRunTime.boxToInteger((int)akkaFrameSize), BoxesRunTime.boxToInteger((int)akkaThreads), BoxesRunTime.boxToInteger((int)akkaBatchSize), logAkkaConfig, lifecycleEvents, lifecycleEvents, lifecycleEvents})))).stripMargin()));
        ActorSystem actorSystem = ActorSystem$.MODULE$.apply(name, akkaConf);
        ActorRefProvider provider = ((ExtendedActorSystem)actorSystem).provider();
        int boundPort2 = BoxesRunTime.unboxToInt((Object)provider.getDefaultAddress().port().get());
        return new Tuple2((Object)actorSystem, (Object)BoxesRunTime.boxToInteger((int)boundPort2));
    }

    private int AKKA_MAX_FRAME_SIZE_IN_MB() {
        return this.AKKA_MAX_FRAME_SIZE_IN_MB;
    }

    public int maxFrameSizeBytes(SparkConf conf) {
        int frameSizeInMB = conf.getInt("spark.akka.frameSize", 128);
        if (frameSizeInMB > this.AKKA_MAX_FRAME_SIZE_IN_MB()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.akka.frameSize should not be greater than ", " MB"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.AKKA_MAX_FRAME_SIZE_IN_MB())})));
        }
        return frameSizeInMB * 1024 * 1024;
    }

    public int reservedSizeBytes() {
        return this.reservedSizeBytes;
    }

    public <T> T askWithReply(Object message, ActorRef actor, RpcTimeout timeout) {
        return this.askWithReply(message, actor, 1, Integer.MAX_VALUE, timeout);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T askWithReply(Object message, ActorRef actor, int maxAttempts, long retryInterval, RpcTimeout timeout) {
        if (actor == null) {
            throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error sending message [message = ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message}))).append((Object)" as actor is null ").toString());
        }
        IntRef attempts = new IntRef(0);
        Exception lastException = null;
        if (attempts.elem >= maxAttempts) {
            throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error sending message [message = ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})), lastException);
        }
        ++attempts.elem;
        Future future = AskableActorRef$.MODULE$.ask$extension(package$.MODULE$.ask(actor), message, Timeout$.MODULE$.durationToTimeout(timeout.duration()));
        Object result = timeout.awaitResult(future);
        if (result == null) {
            throw new SparkException("Actor returned null");
        }
        return result;
    }

    public ActorRef makeDriverRef(String name, SparkConf conf, ActorSystem actorSystem) {
        String driverActorSystemName = SparkEnv$.MODULE$.driverActorSystemName();
        String driverHost = conf.get("spark.driver.host", "localhost");
        int driverPort = conf.getInt("spark.driver.port", 7077);
        Utils$.MODULE$.checkHost(driverHost, "Expected hostname");
        String url = this.address(this.protocol(actorSystem), driverActorSystemName, driverHost, driverPort, name);
        RpcTimeout timeout = RpcUtils$.MODULE$.lookupRpcTimeout(conf);
        this.logInfo((Function0<String>)new Serializable(name, url){
            public static final long serialVersionUID = 0L;
            private final String name$2;
            private final String url$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connecting to ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$2, this.url$1}));
            }
            {
                this.name$2 = name$2;
                this.url$1 = url$1;
            }
        });
        return (ActorRef)timeout.awaitResult(actorSystem.actorSelection(url).resolveOne(timeout.duration()));
    }

    public ActorRef makeExecutorRef(String name, SparkConf conf, String host, int port, ActorSystem actorSystem) {
        String executorActorSystemName = SparkEnv$.MODULE$.executorActorSystemName();
        Utils$.MODULE$.checkHost(host, "Expected hostname");
        String url = this.address(this.protocol(actorSystem), executorActorSystemName, host, port, name);
        RpcTimeout timeout = RpcUtils$.MODULE$.lookupRpcTimeout(conf);
        this.logInfo((Function0<String>)new Serializable(name, url){
            public static final long serialVersionUID = 0L;
            private final String name$3;
            private final String url$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connecting to ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$3, this.url$2}));
            }
            {
                this.name$3 = name$3;
                this.url$2 = url$2;
            }
        });
        return (ActorRef)timeout.awaitResult(actorSystem.actorSelection(url).resolveOne(timeout.duration()));
    }

    public String protocol(ActorSystem actorSystem) {
        String sslProp;
        Config akkaConf = actorSystem.settings().config();
        return this.protocol(akkaConf.hasPath(sslProp = "akka.remote.netty.tcp.enable-ssl") && akkaConf.getBoolean(sslProp));
    }

    public String protocol(boolean ssl) {
        return ssl ? "akka.ssl.tcp" : "akka.tcp";
    }

    public boolean protocol$default$1() {
        return false;
    }

    public String address(String protocol, String systemName, String host, int port, String actorName) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://", "@", ":", "/user/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{protocol, systemName, host, BoxesRunTime.boxToInteger((int)port), actorName}));
    }

    private AkkaUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.AKKA_MAX_FRAME_SIZE_IN_MB = 2047;
        this.reservedSizeBytes = 204800;
    }
}

