/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.RDDInfo;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.storage.StorageStatus;
import org.apache.spark.storage.StorageUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public final class StorageUtils$ {
    public static final StorageUtils$ MODULE$;

    static {
        new StorageUtils$();
    }

    public void updateRddInfo(Seq<RDDInfo> rddInfos, Seq<StorageStatus> statuses) {
        rddInfos.foreach((Function1)new Serializable(statuses){
            public static final long serialVersionUID = 0L;
            private final Seq statuses$1;

            public final void apply(RDDInfo rddInfo) {
                int rddId = rddInfo.id();
                StorageLevel storageLevel = (StorageLevel)((TraversableLike)this.statuses$1.flatMap((Function1)new Serializable(this, rddId){
                    public static final long serialVersionUID = 0L;
                    private final int rddId$2;

                    public final Iterable<StorageLevel> apply(StorageStatus x$11) {
                        return Option$.MODULE$.option2Iterable(x$11.rddStorageLevel(this.rddId$2));
                    }
                    {
                        this.rddId$2 = rddId$2;
                    }
                }, Seq$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StorageLevel apply() {
                        return StorageLevel$.MODULE$.NONE();
                    }
                });
                int numCachedPartitions = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.statuses$1.map((Function1)new Serializable(this, rddId){
                    public static final long serialVersionUID = 0L;
                    private final int rddId$2;

                    public final int apply(StorageStatus x$12) {
                        return x$12.numRddBlocksById(this.rddId$2);
                    }
                    {
                        this.rddId$2 = rddId$2;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                long memSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.statuses$1.map((Function1)new Serializable(this, rddId){
                    public static final long serialVersionUID = 0L;
                    private final int rddId$2;

                    public final long apply(StorageStatus x$13) {
                        return x$13.memUsedByRdd(this.rddId$2);
                    }
                    {
                        this.rddId$2 = rddId$2;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                long diskSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.statuses$1.map((Function1)new Serializable(this, rddId){
                    public static final long serialVersionUID = 0L;
                    private final int rddId$2;

                    public final long apply(StorageStatus x$14) {
                        return x$14.diskUsedByRdd(this.rddId$2);
                    }
                    {
                        this.rddId$2 = rddId$2;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                long externalBlockStoreSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.statuses$1.map((Function1)new Serializable(this, rddId){
                    public static final long serialVersionUID = 0L;
                    private final int rddId$2;

                    public final long apply(StorageStatus x$15) {
                        return x$15.offHeapUsedByRdd(this.rddId$2);
                    }
                    {
                        this.rddId$2 = rddId$2;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                rddInfo.storageLevel_$eq(storageLevel);
                rddInfo.numCachedPartitions_$eq(numCachedPartitions);
                rddInfo.memSize_$eq(memSize);
                rddInfo.diskSize_$eq(diskSize);
                rddInfo.externalBlockStoreSize_$eq(externalBlockStoreSize);
            }
            {
                this.statuses$1 = statuses$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Map<BlockId, Seq<String>> getRddBlockLocations(int rddId, Seq<StorageStatus> statuses) {
        void var3_3;
        HashMap blockLocations = new HashMap();
        statuses.foreach((Function1)new Serializable(rddId, blockLocations){
            public static final long serialVersionUID = 0L;
            private final int rddId$1;
            public final HashMap blockLocations$1;

            public final void apply(StorageStatus status) {
                status.rddBlocksById(this.rddId$1).foreach((Function1)new Serializable(this, status){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getRddBlockLocations.1 $outer;
                    private final StorageStatus status$1;

                    public final ListBuffer<String> apply(Tuple2<BlockId, BlockStatus> x0$5) {
                        Tuple2<BlockId, BlockStatus> tuple2 = x0$5;
                        if (tuple2 != null) {
                            BlockId bid = (BlockId)tuple2._1();
                            String location = this.status$1.blockManagerId().hostPort();
                            ListBuffer listBuffer = ((ListBuffer)this.$outer.blockLocations$1.getOrElseUpdate((Object)bid, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final ListBuffer<String> apply() {
                                    return (ListBuffer)ListBuffer$.MODULE$.empty();
                                }
                            })).$plus$eq((Object)location);
                            return listBuffer;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.status$1 = status$1;
                    }
                });
            }
            {
                this.rddId$1 = rddId$1;
                this.blockLocations$1 = blockLocations$1;
            }
        });
        return var3_3;
    }

    private StorageUtils$() {
        MODULE$ = this;
    }
}

