/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.mesos;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.mesos.MesosSchedulerDriver;
import org.apache.mesos.Protos;
import org.apache.mesos.Scheduler;
import org.apache.mesos.SchedulerDriver;
import org.apache.mesos.protobuf.ByteString;
import org.apache.mesos.protobuf.GeneratedMessage;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.scheduler.cluster.mesos.MesosSchedulerUtils;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.util.control.NonFatal$;

public abstract class MesosSchedulerUtils$class {
    public static SchedulerDriver createSchedulerDriver(MesosSchedulerUtils $this, String masterUrl, Scheduler scheduler, String sparkUser, String appName, SparkConf conf, Option webuiUrl, Option checkpoint, Option failoverTimeout, Option frameworkId) {
        Protos.FrameworkInfo.Builder fwInfoBuilder = Protos.FrameworkInfo.newBuilder().setUser(sparkUser).setName(appName);
        Protos.Credential.Builder credBuilder = Protos.Credential.newBuilder();
        webuiUrl.foreach((Function1)new Serializable($this, fwInfoBuilder){
            public static final long serialVersionUID = 0L;
            private final Protos.FrameworkInfo.Builder fwInfoBuilder$1;

            public final Protos.FrameworkInfo.Builder apply(String url) {
                return this.fwInfoBuilder$1.setWebuiUrl(url);
            }
            {
                this.fwInfoBuilder$1 = fwInfoBuilder$1;
            }
        });
        checkpoint.foreach((Function1)new Serializable($this, fwInfoBuilder){
            public static final long serialVersionUID = 0L;
            private final Protos.FrameworkInfo.Builder fwInfoBuilder$1;

            public final Protos.FrameworkInfo.Builder apply(boolean checkpoint) {
                return this.fwInfoBuilder$1.setCheckpoint(checkpoint);
            }
            {
                this.fwInfoBuilder$1 = fwInfoBuilder$1;
            }
        });
        failoverTimeout.foreach((Function1)new Serializable($this, fwInfoBuilder){
            public static final long serialVersionUID = 0L;
            private final Protos.FrameworkInfo.Builder fwInfoBuilder$1;

            public final Protos.FrameworkInfo.Builder apply(double timeout) {
                return this.fwInfoBuilder$1.setFailoverTimeout(timeout);
            }
            {
                this.fwInfoBuilder$1 = fwInfoBuilder$1;
            }
        });
        frameworkId.foreach((Function1)new Serializable($this, fwInfoBuilder){
            public static final long serialVersionUID = 0L;
            private final Protos.FrameworkInfo.Builder fwInfoBuilder$1;

            public final Protos.FrameworkInfo.Builder apply(String id) {
                return this.fwInfoBuilder$1.setId(Protos.FrameworkID.newBuilder().setValue(id).build());
            }
            {
                this.fwInfoBuilder$1 = fwInfoBuilder$1;
            }
        });
        conf.getOption("spark.mesos.principal").foreach((Function1)new Serializable($this, fwInfoBuilder, credBuilder){
            public static final long serialVersionUID = 0L;
            private final Protos.FrameworkInfo.Builder fwInfoBuilder$1;
            private final Protos.Credential.Builder credBuilder$1;

            public final Protos.Credential.Builder apply(String principal) {
                this.fwInfoBuilder$1.setPrincipal(principal);
                return this.credBuilder$1.setPrincipal(principal);
            }
            {
                this.fwInfoBuilder$1 = fwInfoBuilder$1;
                this.credBuilder$1 = credBuilder$1;
            }
        });
        conf.getOption("spark.mesos.secret").foreach((Function1)new Serializable($this, credBuilder){
            public static final long serialVersionUID = 0L;
            private final Protos.Credential.Builder credBuilder$1;

            public final Protos.Credential.Builder apply(String secret) {
                return this.credBuilder$1.setSecret(ByteString.copyFromUtf8((String)secret));
            }
            {
                this.credBuilder$1 = credBuilder$1;
            }
        });
        if (credBuilder.hasSecret() && !fwInfoBuilder.hasPrincipal()) {
            throw new SparkException("spark.mesos.principal must be configured when spark.mesos.secret is set");
        }
        conf.getOption("spark.mesos.role").foreach((Function1)new Serializable($this, fwInfoBuilder){
            public static final long serialVersionUID = 0L;
            private final Protos.FrameworkInfo.Builder fwInfoBuilder$1;

            public final Protos.FrameworkInfo.Builder apply(String role) {
                return this.fwInfoBuilder$1.setRole(role);
            }
            {
                this.fwInfoBuilder$1 = fwInfoBuilder$1;
            }
        });
        return credBuilder.hasPrincipal() ? new MesosSchedulerDriver(scheduler, fwInfoBuilder.build(), masterUrl, credBuilder.build()) : new MesosSchedulerDriver(scheduler, fwInfoBuilder.build(), masterUrl);
    }

    public static Option createSchedulerDriver$default$6(MesosSchedulerUtils $this) {
        return None$.MODULE$;
    }

    public static Option createSchedulerDriver$default$7(MesosSchedulerUtils $this) {
        return None$.MODULE$;
    }

    public static Option createSchedulerDriver$default$8(MesosSchedulerUtils $this) {
        return None$.MODULE$;
    }

    public static Option createSchedulerDriver$default$9(MesosSchedulerUtils $this) {
        return None$.MODULE$;
    }

    public static void startScheduler(MesosSchedulerUtils $this, SchedulerDriver newDriver) {
        MesosSchedulerUtils mesosSchedulerUtils = $this;
        synchronized (mesosSchedulerUtils) {
            if ($this.mesosDriver() == null) {
                new Thread($this, newDriver){
                    private final /* synthetic */ MesosSchedulerUtils $outer;
                    private final SchedulerDriver newDriver$1;

                    public void run() {
                        this.$outer.mesosDriver_$eq(this.newDriver$1);
                        try {
                            Protos.Status ret = this.$outer.mesosDriver().run();
                            this.$outer.logInfo((Function0<String>)new Serializable(this, ret){
                                public static final long serialVersionUID = 0L;
                                private final Protos.Status ret$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"driver.run() returned with code ").append((Object)this.ret$1).toString();
                                }
                                {
                                    this.ret$1 = ret$1;
                                }
                            });
                            if (ret != null && ret.equals((Object)Protos.Status.DRIVER_ABORTED)) {
                                System.exit(1);
                            }
                        }
                        catch (Exception exception2) {
                            this.$outer.logError((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "driver.run() failed";
                                }
                            }, exception2);
                            System.exit(1);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.newDriver$1 = newDriver$1;
                        super(new StringBuilder().append((Object)Utils$.MODULE$.getFormattedClassName($outer)).append((Object)"-mesos-driver").toString());
                        this.setDaemon(true);
                    }
                }.start();
                $this.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$registerLatch().await();
                return;
            }
            $this.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$registerLatch().await();
            return;
        }
    }

    public static double getResource(MesosSchedulerUtils $this, List res, String name) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res).asScala()).filter((Function1)new Serializable($this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final boolean apply(Protos.Resource x$1) {
                String string = x$1.getName();
                String string2 = this.name$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.name$1 = name$1;
            }
        })).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final double apply(Protos.Resource x$2) {
                return x$2.getScalar().getValue();
            }
        }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static void markRegistered(MesosSchedulerUtils $this) {
        $this.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$registerLatch().countDown();
    }

    public static Protos.Resource createResource(MesosSchedulerUtils $this, String name, double amount, Option role) {
        Protos.Resource.Builder builder = Protos.Resource.newBuilder().setName(name).setType(Protos.Value.Type.SCALAR).setScalar(Protos.Value.Scalar.newBuilder().setValue(amount).build());
        role.foreach((Function1)new Serializable($this, builder){
            public static final long serialVersionUID = 0L;
            private final Protos.Resource.Builder builder$1;

            public final Protos.Resource.Builder apply(String r) {
                return this.builder$1.setRole(r);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder.build();
    }

    public static Tuple2 partitionResources(MesosSchedulerUtils $this, List resources, String resourceName, double amountToUse) {
        DoubleRef remain = new DoubleRef(amountToUse);
        ObjectRef requestedResources = new ObjectRef((Object)new ArrayBuffer());
        Buffer remainingResources = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(resources).asScala()).map((Function1)new Serializable($this, remain, requestedResources, resourceName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MesosSchedulerUtils $outer;
            private final DoubleRef remain$1;
            private final ObjectRef requestedResources$1;
            private final String resourceName$1;

            /*
             * Unable to fully structure code
             */
            public final Protos.Resource apply(Protos.Resource x0$1) {
                var2_2 = x0$1;
                if (!(this.remain$1.elem > (double)false)) ** GOTO lbl-1000
                v0 = var2_2.getType();
                var4_3 = Protos.Value.Type.SCALAR;
                if ((v0 != null ? v0.equals(var4_3) == false : var4_3 != null) || !(var2_2.getScalar().getValue() > 0.0)) ** GOTO lbl-1000
                v1 = var2_2.getName();
                var5_4 = this.resourceName$1;
                if (!(v1 != null ? v1.equals(var5_4) == false : var5_4 != null)) {
                    usage = Math.min(this.remain$1.elem, var2_2.getScalar().getValue());
                    ((ArrayBuffer)this.requestedResources$1.elem).$plus$eq((Object)this.$outer.createResource(this.resourceName$1, usage, (Option<String>)new Some((Object)var2_2.getRole())));
                    this.remain$1.elem -= usage;
                    v2 = this.$outer.createResource(this.resourceName$1, var2_2.getScalar().getValue() - usage, (Option<String>)new Some((Object)var2_2.getRole()));
                } else lbl-1000:
                // 3 sources

                {
                    v2 = var2_2;
                }
                var3_6 = v2;
                return var3_6;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.remain$1 = remain$1;
                this.requestedResources$1 = requestedResources$1;
                this.resourceName$1 = resourceName$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Buffer filteredResources = (Buffer)remainingResources.filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Protos.Resource r) {
                Protos.Value.Type type = r.getType();
                Protos.Value.Type type2 = Protos.Value.Type.SCALAR;
                return (type != null ? !type.equals(type2) : type2 != null) || r.getScalar().getValue() > 0.0;
            }
        });
        return new Tuple2((Object)filteredResources.toList(), (Object)((ArrayBuffer)requestedResources.elem).toList());
    }

    public static Tuple2 getAttribute(MesosSchedulerUtils $this, Protos.Attribute attr) {
        return new Tuple2((Object)attr.getName(), (Object)Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(attr.getText().getValue())).split(',')).toSet());
    }

    public static Protos.Resource createResource(MesosSchedulerUtils $this, String resourceName, double quantity) {
        return Protos.Resource.newBuilder().setName(resourceName).setType(Protos.Value.Type.SCALAR).setScalar(Protos.Value.Scalar.newBuilder().setValue(quantity).build()).build();
    }

    public static Option createResource$default$3(MesosSchedulerUtils $this) {
        return None$.MODULE$;
    }

    public static Map toAttributeMap(MesosSchedulerUtils $this, List offerAttributes) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(offerAttributes).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, GeneratedMessage> apply(Protos.Attribute attr) {
                Protos.Value.Type type;
                block6: {
                    Protos.Value.Scalar scalar;
                    block3: {
                        block5: {
                            block4: {
                                block2: {
                                    type = attr.getType();
                                    Protos.Value.Type type2 = Protos.Value.Type.SCALAR;
                                    Protos.Value.Type type3 = type;
                                    if (type2 != null ? !type2.equals(type3) : type3 != null) break block2;
                                    scalar = attr.getScalar();
                                    break block3;
                                }
                                Protos.Value.Type type4 = Protos.Value.Type.RANGES;
                                Protos.Value.Type type5 = type;
                                if (type4 != null ? !type4.equals(type5) : type5 != null) break block4;
                                scalar = attr.getRanges();
                                break block3;
                            }
                            Protos.Value.Type type6 = Protos.Value.Type.SET;
                            Protos.Value.Type type7 = type;
                            if (type6 != null ? !type6.equals(type7) : type7 != null) break block5;
                            scalar = attr.getSet();
                            break block3;
                        }
                        Protos.Value.Type type8 = Protos.Value.Type.TEXT;
                        Protos.Value.Type type9 = type;
                        if (type8 != null ? !type8.equals(type9) : type9 != null) break block6;
                        scalar = attr.getText();
                    }
                    Protos.Value.Scalar attrValue = scalar;
                    return new Tuple2((Object)attr.getName(), (Object)attrValue);
                }
                throw new MatchError((Object)type);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public static boolean matchesAttributeRequirements(MesosSchedulerUtils $this, Map slaveOfferConstraints, Map offerAttributes) {
        return slaveOfferConstraints.forall((Function1)new Serializable($this, offerAttributes){
            public static final long serialVersionUID = 0L;
            private final Map offerAttributes$1;

            public final boolean apply(Tuple2<String, Set<String>> x0$2) {
                Tuple2<String, Set<String>> tuple2;
                block2: {
                    Option option;
                    block9: {
                        boolean bl;
                        block4: {
                            GeneratedMessage textValue;
                            Some some;
                            boolean bl2;
                            Set requiredValues;
                            block8: {
                                GeneratedMessage offeredValue;
                                block7: {
                                    GeneratedMessage rangeValue;
                                    block6: {
                                        GeneratedMessage scalarValue;
                                        block5: {
                                            block3: {
                                                tuple2 = x0$2;
                                                if (tuple2 == null) break block2;
                                                String name = (String)tuple2._1();
                                                requiredValues = (Set)tuple2._2();
                                                bl2 = false;
                                                some = null;
                                                option = this.offerAttributes$1.get((Object)name);
                                                None$ none$ = None$.MODULE$;
                                                Option option2 = option;
                                                if (none$ != null ? !none$.equals(option2) : option2 != null) break block3;
                                                bl = false;
                                                break block4;
                                            }
                                            if (!(option instanceof Some)) break block5;
                                            bl2 = true;
                                            some = (Some)option;
                                            if (!requiredValues.isEmpty()) break block5;
                                            bl = true;
                                            break block4;
                                        }
                                        if (!bl2 || !((scalarValue = (GeneratedMessage)some.x()) instanceof Protos.Value.Scalar)) break block6;
                                        Protos.Value.Scalar scalar = (Protos.Value.Scalar)scalarValue;
                                        bl = ((IterableLike)requiredValues.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final double apply(String x$3) {
                                                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toDouble();
                                            }
                                        }, Set$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(this, scalar){
                                            public static final long serialVersionUID = 0L;
                                            private final Protos.Value.Scalar x9$1;

                                            public final boolean apply(double x$4) {
                                                return this.apply$mcZD$sp(x$4);
                                            }

                                            public boolean apply$mcZD$sp(double x$4) {
                                                return x$4 <= this.x9$1.getValue();
                                            }
                                            {
                                                this.x9$1 = x9$1;
                                            }
                                        });
                                        break block4;
                                    }
                                    if (!bl2 || !((rangeValue = (GeneratedMessage)some.x()) instanceof Protos.Value.Range)) break block7;
                                    Protos.Value.Range range2 = (Protos.Value.Range)rangeValue;
                                    NumericRange.Inclusive offerRange = new RichLong(Predef$.MODULE$.longWrapper(range2.getBegin())).to((Object)BoxesRunTime.boxToLong((long)range2.getEnd()));
                                    bl = ((IterableLike)requiredValues.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final long apply(String x$5) {
                                            return new StringOps(Predef$.MODULE$.augmentString(x$5)).toLong();
                                        }
                                    }, Set$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(this, offerRange){
                                        public static final long serialVersionUID = 0L;
                                        private final NumericRange.Inclusive offerRange$1;

                                        public final boolean apply(long x$6) {
                                            return this.apply$mcZJ$sp(x$6);
                                        }

                                        public boolean apply$mcZJ$sp(long x$6) {
                                            return this.offerRange$1.contains((Object)BoxesRunTime.boxToLong((long)x$6));
                                        }
                                        {
                                            this.offerRange$1 = offerRange$1;
                                        }
                                    });
                                    break block4;
                                }
                                if (!bl2 || !((offeredValue = (GeneratedMessage)some.x()) instanceof Protos.Value.Set)) break block8;
                                Protos.Value.Set set = (Protos.Value.Set)offeredValue;
                                bl = requiredValues.subsetOf((GenSet)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(set.getItemList()).asScala()).toSet());
                                break block4;
                            }
                            if (!bl2 || !((textValue = (GeneratedMessage)some.x()) instanceof Protos.Value.Text)) break block9;
                            Protos.Value.Text text = (Protos.Value.Text)textValue;
                            bl = requiredValues.contains((Object)text.getValue());
                        }
                        boolean bl3 = bl;
                        return bl3;
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError(tuple2);
            }
            {
                this.offerAttributes$1 = offerAttributes$1;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map parseConstraintString(MesosSchedulerUtils $this, String constraintsVal) {
        Map map2;
        Splitter.MapSplitter splitter = Splitter.on((char)';').trimResults().withKeyValueSeparator(':');
        if (constraintsVal.isEmpty()) {
            map2 = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            return map2;
        }
        try {
            map2 = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(splitter.split((CharSequence)constraintsVal)).asScala()).toMap(Predef$.MODULE$.conforms()).mapValues((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Set<String> apply(String v) {
                    return v == null || v.isEmpty() ? (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$) : Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(v)).split(',')).toSet();
                }
            });
            return map2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bad constraint string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{constraintsVal})), e);
        }
    }

    public static int calculateTotalMemory(MesosSchedulerUtils $this, SparkContext sc) {
        return sc.conf().getInt("spark.mesos.executor.memoryOverhead", (int)package$.MODULE$.max($this.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$MEMORY_OVERHEAD_FRACTION() * (double)sc.executorMemory(), (double)$this.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$MEMORY_OVERHEAD_MINIMUM())) + sc.executorMemory();
    }

    public static void setupUris(MesosSchedulerUtils $this, String uris, Protos.CommandInfo.Builder builder) {
        Predef$.MODULE$.refArrayOps((Object[])uris.split(",")).foreach((Function1)new Serializable($this, builder){
            public static final long serialVersionUID = 0L;
            private final Protos.CommandInfo.Builder builder$2;

            public final Protos.CommandInfo.Builder apply(String uri) {
                return this.builder$2.addUris(Protos.CommandInfo.URI.newBuilder().setValue(uri.trim()));
            }
            {
                this.builder$2 = builder$2;
            }
        });
    }

    public static long getRejectOfferDurationForUnmetConstraints(MesosSchedulerUtils $this, SparkContext sc) {
        return sc.conf().getTimeAsSeconds("spark.mesos.rejectOfferDurationForUnmetConstraints", "120s");
    }

    public static void $init$(MesosSchedulerUtils $this) {
        $this.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$_setter_$org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$registerLatch_$eq(new CountDownLatch(1));
        $this.mesosDriver_$eq(null);
        $this.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$_setter_$org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$MEMORY_OVERHEAD_FRACTION_$eq(0.1);
        $this.org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$_setter_$org$apache$spark$scheduler$cluster$mesos$MesosSchedulerUtils$$MEMORY_OVERHEAD_MINIMUM_$eq(384);
    }
}

