/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rdd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.ReliableCheckpointRDD;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;
import scala.util.control.NonFatal$;

public final class ReliableCheckpointRDD$
implements Logging,
Serializable {
    public static final ReliableCheckpointRDD$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new ReliableCheckpointRDD$();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public String org$apache$spark$rdd$ReliableCheckpointRDD$$checkpointFileName(int partitionIndex) {
        return new StringOps(Predef$.MODULE$.augmentString("part-%05d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionIndex)}));
    }

    private String checkpointPartitionerFileName() {
        return "_partitioner";
    }

    /*
     * WARNING - void declaration
     */
    public <T> ReliableCheckpointRDD<T> writeRDDToCheckpointDirectory(RDD<T> originalRDD, String checkpointDir, int blockSize, ClassTag<T> evidence$2) {
        void var6_6;
        Path checkpointDirPath = new Path(checkpointDir);
        SparkContext sc = originalRDD.sparkContext();
        FileSystem fs = checkpointDirPath.getFileSystem(sc.hadoopConfiguration());
        if (fs.mkdirs(checkpointDirPath)) {
            ReliableCheckpointRDD<T> newRDD;
            Broadcast<SerializableConfiguration> broadcastedConf = sc.broadcast(new SerializableConfiguration(sc.hadoopConfiguration()), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
            String string = checkpointDirPath.toString();
            int n = this.writePartitionToCheckpointFile$default$3();
            sc.runJob(originalRDD, new Serializable(evidence$2, broadcastedConf, string, n){
                public static final long serialVersionUID = 0L;
                private final ClassTag evidence$2$1;
                private final Broadcast broadcastedConf$1;
                private final String eta$0$1$1;
                private final int eta$1$1$1;

                public final void apply(TaskContext ctx, Iterator<T> iterator2) {
                    ReliableCheckpointRDD$.MODULE$.writePartitionToCheckpointFile(this.eta$0$1$1, this.broadcastedConf$1, this.eta$1$1$1, ctx, iterator2, this.evidence$2$1);
                }
                {
                    this.evidence$2$1 = evidence$2$1;
                    this.broadcastedConf$1 = broadcastedConf$1;
                    this.eta$0$1$1 = eta$0$1$1;
                    this.eta$1$1$1 = eta$1$1$1;
                }
            }, ClassTag$.MODULE$.Unit());
            if (originalRDD.partitioner().nonEmpty()) {
                this.writePartitionerToCheckpointDir(sc, (Partitioner)originalRDD.partitioner().get(), checkpointDirPath);
            }
            if ((newRDD = new ReliableCheckpointRDD<T>(sc, checkpointDirPath.toString(), originalRDD.partitioner(), evidence$2)).partitions().length != originalRDD.partitions().length) {
                throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpoint RDD ", "(", ") has different "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newRDD, BoxesRunTime.boxToInteger((int)newRDD.partitions().length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of partitions from original RDD ", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{originalRDD, BoxesRunTime.boxToInteger((int)originalRDD.partitions().length)}))).toString());
            }
            return newRDD;
        }
        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create checkpoint path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var6_6})));
    }

    public <T> int writeRDDToCheckpointDirectory$default$3() {
        return -1;
    }

    public <T> void writePartitionToCheckpointFile(String path, Broadcast<SerializableConfiguration> broadcastedConf, int blockSize, TaskContext ctx, Iterator<T> iterator2, ClassTag<T> evidence$3) {
        Path tempOutputPath;
        Path finalOutputPath;
        FileSystem fs;
        block6: {
            block5: {
                SparkEnv env = SparkEnv$.MODULE$.get();
                Path outputDir = new Path(path);
                fs = outputDir.getFileSystem(broadcastedConf.value().value());
                String finalOutputName = this.org$apache$spark$rdd$ReliableCheckpointRDD$$checkpointFileName(ctx.partitionId());
                finalOutputPath = new Path(outputDir, finalOutputName);
                tempOutputPath = new Path(outputDir, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", "-attempt-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{finalOutputName, BoxesRunTime.boxToInteger((int)ctx.attemptNumber())})));
                if (fs.exists(tempOutputPath)) {
                    throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpoint failed: temporary path ", " already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tempOutputPath})));
                }
                int bufferSize = env.conf().getInt("spark.buffer.size", 65536);
                FSDataOutputStream fileOutputStream = blockSize < 0 ? fs.create(tempOutputPath, false, bufferSize) : fs.create(tempOutputPath, false, bufferSize, fs.getDefaultReplication(), (long)blockSize);
                SerializerInstance serializer = env.serializer().newInstance();
                SerializationStream serializeStream = serializer.serializeStream((OutputStream)fileOutputStream);
                Utils$.MODULE$.tryWithSafeFinally(new Serializable(iterator2, evidence$3, serializeStream){
                    public static final long serialVersionUID = 0L;
                    private final Iterator iterator$1;
                    private final ClassTag evidence$3$1;
                    private final SerializationStream serializeStream$1;

                    public final SerializationStream apply() {
                        return this.serializeStream$1.writeAll(this.iterator$1, this.evidence$3$1);
                    }
                    {
                        this.iterator$1 = iterator$1;
                        this.evidence$3$1 = evidence$3$1;
                        this.serializeStream$1 = serializeStream$1;
                    }
                }, (Function0<BoxedUnit>)new Serializable(serializeStream){
                    public static final long serialVersionUID = 0L;
                    private final SerializationStream serializeStream$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.serializeStream$1.close();
                    }
                    {
                        this.serializeStream$1 = serializeStream$1;
                    }
                });
                if (fs.rename(tempOutputPath, finalOutputPath)) break block5;
                if (!fs.exists(finalOutputPath)) break block6;
                this.logInfo((Function0<String>)new Serializable(finalOutputPath){
                    public static final long serialVersionUID = 0L;
                    private final Path finalOutputPath$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Final output path ", " already exists; not overwriting it"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.finalOutputPath$1}));
                    }
                    {
                        this.finalOutputPath$1 = finalOutputPath$1;
                    }
                });
                if (!fs.delete(tempOutputPath, false)) {
                    this.logWarning((Function0<String>)new Serializable(tempOutputPath){
                        public static final long serialVersionUID = 0L;
                        private final Path tempOutputPath$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tempOutputPath$1}));
                        }
                        {
                            this.tempOutputPath$1 = tempOutputPath$1;
                        }
                    });
                }
            }
            return;
        }
        this.logInfo((Function0<String>)new Serializable(tempOutputPath){
            public static final long serialVersionUID = 0L;
            private final Path tempOutputPath$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting tempOutputPath ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tempOutputPath$1}));
            }
            {
                this.tempOutputPath$1 = tempOutputPath$1;
            }
        });
        fs.delete(tempOutputPath, false);
        throw new IOException(new StringBuilder().append((Object)"Checkpoint failed: failed to save output of task: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " and final output path does not exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ctx.attemptNumber()), finalOutputPath}))).toString());
    }

    public <T> int writePartitionToCheckpointFile$default$3() {
        return -1;
    }

    private void writePartitionerToCheckpointDir(SparkContext sc, Partitioner partitioner, Path checkpointDirPath) {
        try {
            Path partitionerFilePath = new Path(checkpointDirPath, this.checkpointPartitionerFileName());
            int bufferSize = sc.conf().getInt("spark.buffer.size", 65536);
            FileSystem fs = partitionerFilePath.getFileSystem(sc.hadoopConfiguration());
            FSDataOutputStream fileOutputStream = fs.create(partitionerFilePath, false, bufferSize);
            SerializerInstance serializer = SparkEnv$.MODULE$.get().serializer().newInstance();
            SerializationStream serializeStream = serializer.serializeStream((OutputStream)fileOutputStream);
            Utils$.MODULE$.tryWithSafeFinally(new Serializable(partitioner, serializeStream){
                public static final long serialVersionUID = 0L;
                private final Partitioner partitioner$1;
                private final SerializationStream serializeStream$2;

                public final SerializationStream apply() {
                    return this.serializeStream$2.writeObject(this.partitioner$1, ClassTag$.MODULE$.apply(Partitioner.class));
                }
                {
                    this.partitioner$1 = partitioner$1;
                    this.serializeStream$2 = serializeStream$2;
                }
            }, (Function0<BoxedUnit>)new Serializable(serializeStream){
                public static final long serialVersionUID = 0L;
                private final SerializationStream serializeStream$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.serializeStream$2.close();
                }
                {
                    this.serializeStream$2 = serializeStream$2;
                }
            });
            this.logDebug((Function0<String>)new Serializable(partitionerFilePath){
                public static final long serialVersionUID = 0L;
                private final Path partitionerFilePath$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Written partitioner to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionerFilePath$1}));
                }
                {
                    this.partitionerFilePath$1 = partitionerFilePath$1;
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            this.logWarning((Function0<String>)new Serializable(partitioner, checkpointDirPath){
                public static final long serialVersionUID = 0L;
                private final Partitioner partitioner$1;
                private final Path checkpointDirPath$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error writing partitioner ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitioner$1, this.checkpointDirPath$2}));
                }
                {
                    this.partitioner$1 = partitioner$1;
                    this.checkpointDirPath$2 = checkpointDirPath$2;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Option<Partitioner> org$apache$spark$rdd$ReliableCheckpointRDD$$readCheckpointedPartitionerFile(SparkContext sc, String checkpointDirPath) {
        None$ none$;
        try {
            int bufferSize = sc.conf().getInt("spark.buffer.size", 65536);
            Path partitionerFilePath = new Path(checkpointDirPath, this.checkpointPartitionerFileName());
            FileSystem fs = partitionerFilePath.getFileSystem(sc.hadoopConfiguration());
            if (fs.exists(partitionerFilePath)) {
                FSDataInputStream fileInputStream = fs.open(partitionerFilePath, bufferSize);
                SerializerInstance serializer = SparkEnv$.MODULE$.get().serializer().newInstance();
                DeserializationStream deserializeStream = serializer.deserializeStream((InputStream)fileInputStream);
                Partitioner partitioner = (Partitioner)Utils$.MODULE$.tryWithSafeFinally(new Serializable(deserializeStream){
                    public static final long serialVersionUID = 0L;
                    private final DeserializationStream deserializeStream$1;

                    public final Partitioner apply() {
                        return (Partitioner)this.deserializeStream$1.readObject(ClassTag$.MODULE$.apply(Partitioner.class));
                    }
                    {
                        this.deserializeStream$1 = deserializeStream$1;
                    }
                }, (Function0<BoxedUnit>)new Serializable(deserializeStream){
                    public static final long serialVersionUID = 0L;
                    private final DeserializationStream deserializeStream$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.deserializeStream$1.close();
                    }
                    {
                        this.deserializeStream$1 = deserializeStream$1;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(partitionerFilePath){
                    public static final long serialVersionUID = 0L;
                    private final Path partitionerFilePath$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read partitioner from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionerFilePath$2}));
                    }
                    {
                        this.partitionerFilePath$2 = partitionerFilePath$2;
                    }
                });
                none$ = new Some((Object)partitioner);
            } else {
                this.logDebug((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No partitioner file";
                    }
                });
                none$ = None$.MODULE$;
            }
        }
        catch (Throwable throwable) {
            None$ none$2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)new Serializable(checkpointDirPath){
                public static final long serialVersionUID = 0L;
                private final String checkpointDirPath$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading partitioner from ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.checkpointDirPath$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitioner will not be recovered which may lead to performance loss"})).s((Seq)Nil$.MODULE$)).toString();
                }
                {
                    this.checkpointDirPath$1 = checkpointDirPath$1;
                }
            }, e);
            none$ = none$2 = None$.MODULE$;
        }
        return none$;
    }

    public <T> Iterator<T> readCheckpointFile(Path path, Broadcast<SerializableConfiguration> broadcastedConf, TaskContext context) {
        SparkEnv env = SparkEnv$.MODULE$.get();
        FileSystem fs = path.getFileSystem(broadcastedConf.value().value());
        int bufferSize = env.conf().getInt("spark.buffer.size", 65536);
        FSDataInputStream fileInputStream = fs.open(path, bufferSize);
        SerializerInstance serializer = env.serializer().newInstance();
        DeserializationStream deserializeStream = serializer.deserializeStream((InputStream)fileInputStream);
        context.addTaskCompletionListener((Function1<TaskContext, BoxedUnit>)new Serializable(deserializeStream){
            public static final long serialVersionUID = 0L;
            private final DeserializationStream deserializeStream$2;

            public final void apply(TaskContext context) {
                this.deserializeStream$2.close();
            }
            {
                this.deserializeStream$2 = deserializeStream$2;
            }
        });
        return deserializeStream.asIterator();
    }

    public <T> Option<Partitioner> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ReliableCheckpointRDD$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

