/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import org.apache.spark.SparkConf;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.StaticMemoryManager$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockStatus;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y4Q!\u0001\u0002\u0001\t)\u00111c\u0015;bi&\u001cW*Z7pefl\u0015M\\1hKJT!a\u0001\u0003\u0002\r5,Wn\u001c:z\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7C\u0001\u0001\f!\taQ\"D\u0001\u0003\u0013\tq!AA\u0007NK6|'/_'b]\u0006<WM\u001d\u0005\t!\u0001\u0011)\u0019!C\u0001%\u0005!1m\u001c8g\u0007\u0001)\u0012a\u0005\t\u0003)Ui\u0011\u0001B\u0005\u0003-\u0011\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011a\u0001!\u0011!Q\u0001\nM\tQaY8oM\u0002B\u0001B\u0007\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0019[\u0006DxJ\u001c%fCB,\u00050Z2vi&|g.T3n_JL\bC\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"\u0001\u0002'p]\u001eD\u0001B\t\u0001\u0003\u0006\u0004%\teI\u0001\u0011[\u0006D8\u000b^8sC\u001e,W*Z7pef,\u0012a\u0007\u0005\tK\u0001\u0011\t\u0011)A\u00057\u0005\tR.\u0019=Ti>\u0014\u0018mZ3NK6|'/\u001f\u0011\t\u0011\u001d\u0002!\u0011!Q\u0001\n!\n\u0001B\\;n\u0007>\u0014Xm\u001d\t\u00039%J!AK\u000f\u0003\u0007%sG\u000fC\u0003-\u0001\u0011\u0005Q&\u0001\u0004=S:LGO\u0010\u000b\u0006]=\u0002\u0014G\r\t\u0003\u0019\u0001AQ\u0001E\u0016A\u0002MAQAG\u0016A\u0002mAQAI\u0016A\u0002mAQaJ\u0016A\u0002!BQ\u0001\f\u0001\u0005\u0002Q\"2AL\u001b7\u0011\u0015\u00012\u00071\u0001\u0014\u0011\u001593\u00071\u0001)\u0011\u001dA\u0004A1A\u0005\n\r\nq\"\\1y+:\u0014x\u000e\u001c7NK6|'/\u001f\u0005\u0007u\u0001\u0001\u000b\u0011B\u000e\u0002!5\f\u00070\u00168s_2dW*Z7pef\u0004\u0003\"\u0002\u001f\u0001\t\u0003j\u0014\u0001F1dcVL'/Z*u_J\fw-Z'f[>\u0014\u0018\u0010\u0006\u0003?\u0003&[\u0005C\u0001\u000f@\u0013\t\u0001UDA\u0004C_>dW-\u00198\t\u000b\t[\u0004\u0019A\"\u0002\u000f\tdwnY6JIB\u0011AiR\u0007\u0002\u000b*\u0011a\tB\u0001\bgR|'/Y4f\u0013\tAUIA\u0004CY>\u001c7.\u00133\t\u000b)[\u0004\u0019A\u000e\u0002\u00119,XNQ=uKNDQ\u0001T\u001eA\u00025\u000bQ\"\u001a<jGR,GM\u00117pG.\u001c\bc\u0001(T+6\tqJ\u0003\u0002Q#\u00069Q.\u001e;bE2,'B\u0001*\u001e\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003)>\u0013aAQ;gM\u0016\u0014\b\u0003\u0002\u000fW\u0007bK!aV\u000f\u0003\rQ+\b\u000f\\33!\t!\u0015,\u0003\u0002[\u000b\nY!\t\\8dWN#\u0018\r^;t\u0011\u0015a\u0006\u0001\"\u0011^\u0003M\t7-];je\u0016,fN]8mY6+Wn\u001c:z)\u0011qdl\u00181\t\u000b\t[\u0006\u0019A\"\t\u000b)[\u0006\u0019A\u000e\t\u000b1[\u0006\u0019A'\t\r\t\u0004A\u0011\t\u0002d\u0003Y\t7-];je\u0016,\u00050Z2vi&|g.T3n_JLH\u0003B\u000eeK\u001eDQAS1A\u0002mAQAZ1A\u0002m\tQ\u0002^1tW\u0006#H/Z7qi&#\u0007\"\u00025b\u0001\u0004I\u0017AC7f[>\u0014\u00180T8eKB\u0011AB[\u0005\u0003W\n\u0011!\"T3n_JLXj\u001c3f\u000f\u0019i'\u0001#\u0001\u0005]\u0006\u00192\u000b^1uS\u000elU-\\8ss6\u000bg.Y4feB\u0011Ab\u001c\u0004\u0007\u0003\tA\t\u0001\u00029\u0014\u0005=\f\bC\u0001\u000fs\u0013\t\u0019XD\u0001\u0004B]f\u0014VM\u001a\u0005\u0006Y=$\t!\u001e\u000b\u0002]\")qo\u001cC\u0001q\u0006\u0019r-\u001a;NCb\u001cFo\u001c:bO\u0016lU-\\8ssR\u00111$\u001f\u0005\u0006!Y\u0004\ra\u0005\u0005\u0006w>$\t\u0001`\u0001\u0016O\u0016$X*\u0019=Fq\u0016\u001cW\u000f^5p]6+Wn\u001c:z)\tYR\u0010C\u0003\u0011u\u0002\u00071\u0003")
public class StaticMemoryManager
extends MemoryManager {
    private final SparkConf conf;
    private final long maxStorageMemory;
    private final long maxUnrollMemory;

    public static long getMaxExecutionMemory(SparkConf sparkConf) {
        return StaticMemoryManager$.MODULE$.getMaxExecutionMemory(sparkConf);
    }

    public static long getMaxStorageMemory(SparkConf sparkConf) {
        return StaticMemoryManager$.MODULE$.getMaxStorageMemory(sparkConf);
    }

    public SparkConf conf() {
        return this.conf;
    }

    @Override
    public long maxStorageMemory() {
        return this.maxStorageMemory;
    }

    private long maxUnrollMemory() {
        return this.maxUnrollMemory;
    }

    @Override
    public synchronized boolean acquireStorageMemory(BlockId blockId, long numBytes, Buffer<Tuple2<BlockId, BlockStatus>> evictedBlocks) {
        boolean bl;
        if (numBytes > this.maxStorageMemory()) {
            this.logInfo((Function0<String>)new Serializable(this, blockId, numBytes){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ StaticMemoryManager $outer;
                private final BlockId blockId$1;
                private final long numBytes$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will not store ", " as the required space (", " bytes) exceeds our "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1, BoxesRunTime.boxToLong((long)this.numBytes$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory limit (", " bytes)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.maxStorageMemory())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.blockId$1 = blockId$1;
                    this.numBytes$1 = numBytes$1;
                }
            });
            bl = false;
        } else {
            bl = this.storageMemoryPool().acquireMemory(blockId, numBytes, evictedBlocks);
        }
        return bl;
    }

    @Override
    public synchronized boolean acquireUnrollMemory(BlockId blockId, long numBytes, Buffer<Tuple2<BlockId, BlockStatus>> evictedBlocks) {
        long currentUnrollMemory = this.storageMemoryPool().memoryStore().currentUnrollMemory();
        long freeMemory = this.storageMemoryPool().memoryFree();
        long maxNumBytesToFree = package$.MODULE$.max(0L, this.maxUnrollMemory() - currentUnrollMemory - freeMemory);
        long numBytesToFree = package$.MODULE$.max(0L, package$.MODULE$.min(maxNumBytesToFree, numBytes - freeMemory));
        return this.storageMemoryPool().acquireMemory(blockId, numBytes, numBytesToFree, evictedBlocks);
    }

    @Override
    public synchronized long acquireExecutionMemory(long numBytes, long taskAttemptId, MemoryMode memoryMode) {
        MemoryMode memoryMode2;
        block4: {
            long l;
            block3: {
                block2: {
                    memoryMode2 = memoryMode;
                    MemoryMode memoryMode3 = MemoryMode.ON_HEAP;
                    MemoryMode memoryMode4 = memoryMode2;
                    if (memoryMode3 != null ? !((Object)((Object)memoryMode3)).equals((Object)memoryMode4) : memoryMode4 != null) break block2;
                    l = this.onHeapExecutionMemoryPool().acquireMemory(numBytes, taskAttemptId, this.onHeapExecutionMemoryPool().acquireMemory$default$3(), this.onHeapExecutionMemoryPool().acquireMemory$default$4());
                    break block3;
                }
                MemoryMode memoryMode5 = MemoryMode.OFF_HEAP;
                MemoryMode memoryMode6 = memoryMode2;
                if (memoryMode5 != null ? !((Object)((Object)memoryMode5)).equals((Object)memoryMode6) : memoryMode6 != null) break block4;
                l = this.offHeapExecutionMemoryPool().acquireMemory(numBytes, taskAttemptId, this.offHeapExecutionMemoryPool().acquireMemory$default$3(), this.offHeapExecutionMemoryPool().acquireMemory$default$4());
            }
            return l;
        }
        throw new MatchError((Object)memoryMode2);
    }

    public StaticMemoryManager(SparkConf conf, long maxOnHeapExecutionMemory, long maxStorageMemory, int numCores) {
        this.conf = conf;
        this.maxStorageMemory = maxStorageMemory;
        super(conf, numCores, maxStorageMemory, maxOnHeapExecutionMemory);
        this.maxUnrollMemory = (long)((double)maxStorageMemory * conf.getDouble("spark.storage.unrollFraction", 0.2));
    }

    public StaticMemoryManager(SparkConf conf, int numCores) {
        this(conf, StaticMemoryManager$.MODULE$.getMaxExecutionMemory(conf), StaticMemoryManager$.MODULE$.getMaxStorageMemory(conf), numCores);
    }
}

