/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.worker;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.deploy.Command;
import org.apache.spark.deploy.worker.CommandUtils$;
import org.apache.spark.launcher.WorkerCommandBuilder;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.TraitSetter;
import scala.sys.package$;

public final class CommandUtils$
implements Logging {
    public static final CommandUtils$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new CommandUtils$();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public ProcessBuilder buildProcessBuilder(Command command, SecurityManager securityMgr, int memory, String sparkHome, Function1<String, String> substituteArguments, Seq<String> classPaths, Map<String, String> env) {
        Command localCommand = this.buildLocalCommand(command, securityMgr, substituteArguments, classPaths, env);
        Seq<String> commandSeq = this.buildCommandSeq(localCommand, memory, sparkHome);
        ProcessBuilder builder = new ProcessBuilder((String[])commandSeq.toArray(ClassTag$.MODULE$.apply(String.class)));
        java.util.Map<String, String> environment = builder.environment();
        localCommand.environment().withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(environment){
            public static final long serialVersionUID = 0L;
            private final java.util.Map environment$1;

            public final String apply(Tuple2<String, String> x$1) {
                Tuple2<String, String> tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    String string = this.environment$1.put(key, value);
                    return string;
                }
                throw new MatchError(tuple2);
            }
            {
                this.environment$1 = environment$1;
            }
        });
        return builder;
    }

    public Seq<String> buildProcessBuilder$default$6() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Map<String, String> buildProcessBuilder$default$7() {
        return package$.MODULE$.env();
    }

    private Seq<String> buildCommandSeq(Command command, int memory, String sparkHome) {
        List<String> cmd = new WorkerCommandBuilder(sparkHome, memory, command).buildCommand();
        return ((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(cmd).asScala()).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{command.mainClass()}))).$plus$plus(command.arguments());
    }

    private Command buildLocalCommand(Command command, SecurityManager securityMgr, Function1<String, String> substituteArguments, Seq<String> classPath, Map<String, String> env) {
        Map newEnvironment;
        Map map2;
        String libraryPathName = Utils$.MODULE$.libraryPathEnvName();
        Seq<String> libraryPathEntries = command.libraryPathEntries();
        Option cmdLibraryPath = command.environment().get((Object)libraryPathName);
        if (libraryPathEntries.nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(libraryPathName)).nonEmpty()) {
            Seq libraryPaths = (Seq)((TraversableLike)libraryPathEntries.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(cmdLibraryPath), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(env.get((Object)libraryPathName)), Seq$.MODULE$.canBuildFrom());
            map2 = command.environment().$plus(new Tuple2((Object)libraryPathName, (Object)libraryPaths.mkString(File.pathSeparator)));
        } else {
            map2 = newEnvironment = command.environment();
        }
        if (securityMgr.isAuthenticationEnabled()) {
            newEnvironment = newEnvironment.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SecurityManager$.MODULE$.ENV_AUTH_SECRET()), (Object)securityMgr.getSecretKey()));
        }
        return new Command(command.mainClass(), (Seq<String>)((Seq)command.arguments().map(substituteArguments, Seq$.MODULE$.canBuildFrom())), (Map<String, String>)newEnvironment, (Seq<String>)((Seq)command.classPathEntries().$plus$plus(classPath, Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Seq<String>)((Seq)command.javaOpts().filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.startsWith(new StringBuilder().append((Object)"-D").append((Object)SecurityManager$.MODULE$.SPARK_AUTH_SECRET_CONF()).toString());
            }
        })));
    }

    private Seq<String> buildLocalCommand$default$4() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public void redirectStream(InputStream in, File file) {
        FileOutputStream out = new FileOutputStream(file, true);
        new Thread(in, file, out){
            private final InputStream in$1;
            public final File file$1;
            private final FileOutputStream out$1;

            public void run() {
                try {
                    Utils$.MODULE$.copyStream(this.in$1, this.out$1, true, Utils$.MODULE$.copyStream$default$4());
                }
                catch (IOException iOException) {
                    CommandUtils$.MODULE$.logInfo((Function0<String>)new Serializable(this, iOException){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.1 $outer;
                        private final IOException e$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Redirection to ").append((Object)this.$outer.file$1).append((Object)" closed: ").append((Object)this.e$1.getMessage()).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.e$1 = e$1;
                        }
                    });
                }
            }
            {
                this.in$1 = in$1;
                this.file$1 = file$1;
                this.out$1 = out$1;
                super(new StringBuilder().append((Object)"redirect output to ").append((Object)file$1).toString());
            }
        }.start();
    }

    private CommandUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

