/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.master;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkCuratorUtil$;
import org.apache.spark.deploy.master.PersistenceEngine;
import org.apache.spark.serializer.Serializer;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc!B\u0001\u0003\u0001\ta!A\u0007.p_.+W\r]3s!\u0016\u00148/[:uK:\u001cW-\u00128hS:,'BA\u0002\u0005\u0003\u0019i\u0017m\u001d;fe*\u0011QAB\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0012!\tqq\"D\u0001\u0003\u0013\t\u0001\"AA\tQKJ\u001c\u0018n\u001d;f]\u000e,WI\\4j]\u0016\u0004\"AE\n\u000e\u0003\u0019I!\u0001\u0006\u0004\u0003\u000f1{wmZ5oO\"Aa\u0003\u0001B\u0001B\u0003%\u0001$\u0001\u0003d_:47\u0001\u0001\t\u0003%eI!A\u0007\u0004\u0003\u0013M\u0003\u0018M]6D_:4\u0007\u0002\u0003\u000f\u0001\u0005\u000b\u0007I\u0011A\u000f\u0002\u0015M,'/[1mSj,'/F\u0001\u001f!\ty\u0012%D\u0001!\u0015\tab!\u0003\u0002#A\tQ1+\u001a:jC2L'0\u001a:\t\u0011\u0011\u0002!\u0011!Q\u0001\ny\t1b]3sS\u0006d\u0017N_3sA!)a\u0005\u0001C\u0001O\u00051A(\u001b8jiz\"2\u0001K\u0015+!\tq\u0001\u0001C\u0003\u0017K\u0001\u0007\u0001\u0004C\u0003\u001dK\u0001\u0007a\u0004C\u0004-\u0001\t\u0007I\u0011B\u0017\u0002\u0017]{%kS%O\u000f~#\u0015JU\u000b\u0002]A\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0005Y\u0006twMC\u00014\u0003\u0011Q\u0017M^1\n\u0005U\u0002$AB*ue&tw\r\u0003\u00048\u0001\u0001\u0006IAL\u0001\r/>\u00136*\u0013(H?\u0012K%\u000b\t\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0003\tQ8.F\u0001<!\ta\u0014)D\u0001>\u0015\tqt(A\u0005ge\u0006lWm^8sW*\u0011\u0001\tC\u0001\bGV\u0014\u0018\r^8s\u0013\t\u0011UH\u0001\tDkJ\fGo\u001c:Ge\u0006lWm^8sW\"1A\t\u0001Q\u0001\nm\n1A_6!\u0011\u00151\u0005\u0001\"\u0011H\u0003\u001d\u0001XM]:jgR$2\u0001\u0013(W!\tIE*D\u0001K\u0015\u0005Y\u0015!B:dC2\f\u0017BA'K\u0005\u0011)f.\u001b;\t\u000b=+\u0005\u0019\u0001)\u0002\t9\fW.\u001a\t\u0003#Rs!!\u0013*\n\u0005MS\u0015A\u0002)sK\u0012,g-\u0003\u00026+*\u00111K\u0013\u0005\u0006/\u0016\u0003\r\u0001W\u0001\u0004_\nT\u0007CA\u0018Z\u0013\tQ\u0006G\u0001\u0004PE*,7\r\u001e\u0005\u00069\u0002!\t%X\u0001\nk:\u0004XM]:jgR$\"\u0001\u00130\t\u000b=[\u0006\u0019\u0001)\t\u000b\u0001\u0004A\u0011I1\u0002\tI,\u0017\rZ\u000b\u0003EJ$2aYA\u0004)\t!7\u0010E\u0002f[Bt!AZ6\u000f\u0005\u001dTW\"\u00015\u000b\u0005%<\u0012A\u0002\u001fs_>$h(C\u0001L\u0013\ta'*A\u0004qC\u000e\\\u0017mZ3\n\u00059|'aA*fc*\u0011AN\u0013\t\u0003cJd\u0001\u0001B\u0003t?\n\u0007AOA\u0001U#\t)\b\u0010\u0005\u0002Jm&\u0011qO\u0013\u0002\b\u001d>$\b.\u001b8h!\tI\u00150\u0003\u0002{\u0015\n\u0019\u0011I\\=\t\u000fq|\u0016\u0011!a\u0002{\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\ty\f\u0019\u0001]\u0007\u0002\u007f*\u0019\u0011\u0011\u0001&\u0002\u000fI,g\r\\3di&\u0019\u0011QA@\u0003\u0011\rc\u0017m]:UC\u001eDa!!\u0003`\u0001\u0004\u0001\u0016A\u00029sK\u001aL\u0007\u0010C\u0004\u0002\u000e\u0001!\t%a\u0004\u0002\u000b\rdwn]3\u0015\u0003!Cq!a\u0005\u0001\t\u0013\t)\"A\ttKJL\u0017\r\\5{K&sGo\u001c$jY\u0016$R\u0001SA\f\u00037Aq!!\u0007\u0002\u0012\u0001\u0007\u0001+\u0001\u0003qCRD\u0007\u0002CA\u000f\u0003#\u0001\r!a\b\u0002\u000bY\fG.^3\u0011\u0007%\u000b\t#C\u0002\u0002$)\u0013a!\u00118z%\u00164\u0007bBA\u0014\u0001\u0011%\u0011\u0011F\u0001\u0014I\u0016\u001cXM]5bY&TXM\u0012:p[\u001aKG.Z\u000b\u0005\u0003W\t9\u0004\u0006\u0003\u0002.\u0005}B\u0003BA\u0018\u0003s\u0001R!SA\u0019\u0003kI1!a\rK\u0005\u0019y\u0005\u000f^5p]B\u0019\u0011/a\u000e\u0005\rM\f)C1\u0001u\u0011!\tY$!\nA\u0004\u0005u\u0012!A7\u0011\u000by\f\u0019!!\u000e\t\u000f\u0005\u0005\u0013Q\u0005a\u0001!\u0006Aa-\u001b7f]\u0006lW\r")
public class ZooKeeperPersistenceEngine
extends PersistenceEngine
implements Logging {
    private final Serializer serializer;
    private final String WORKING_DIR;
    private final CuratorFramework zk;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public Serializer serializer() {
        return this.serializer;
    }

    private String WORKING_DIR() {
        return this.WORKING_DIR;
    }

    private CuratorFramework zk() {
        return this.zk;
    }

    @Override
    public void persist(String name, Object obj) {
        this.serializeIntoFile(new StringBuilder().append((Object)this.WORKING_DIR()).append((Object)"/").append((Object)name).toString(), obj);
    }

    @Override
    public void unpersist(String name) {
        this.zk().delete().forPath(new StringBuilder().append((Object)this.WORKING_DIR()).append((Object)"/").append((Object)name).toString());
    }

    @Override
    public <T> Seq<T> read(String prefix, ClassTag<T> evidence$1) {
        return (Seq)((GenericTraversableTemplate)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.zk().getChildren().forPath(this.WORKING_DIR())).asScala()).filter((Function1)new Serializable(this, prefix){
            public static final long serialVersionUID = 0L;
            private final String prefix$1;

            public final boolean apply(String x$1) {
                return x$1.startsWith(this.prefix$1);
            }
            {
                this.prefix$1 = prefix$1;
            }
        })).map((Function1)new Serializable(this, evidence$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZooKeeperPersistenceEngine $outer;
            private final ClassTag evidence$1$1;

            public final Option<T> apply(String filename) {
                return this.$outer.org$apache$spark$deploy$master$ZooKeeperPersistenceEngine$$deserializeFromFile(filename, this.evidence$1$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.evidence$1$1 = evidence$1$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<T> apply(Option<T> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        });
    }

    @Override
    public void close() {
        this.zk().close();
    }

    private void serializeIntoFile(String path, Object value) {
        ByteBuffer serialized = this.serializer().newInstance().serialize(value, ClassTag$.MODULE$.AnyRef());
        byte[] bytes = new byte[serialized.remaining()];
        serialized.get(bytes);
        ((PathAndBytesable)this.zk().create().withMode(CreateMode.PERSISTENT)).forPath(path, bytes);
    }

    public <T> Option<T> org$apache$spark$deploy$master$ZooKeeperPersistenceEngine$$deserializeFromFile(String filename, ClassTag<T> m) {
        Some some;
        byte[] fileData = (byte[])this.zk().getData().forPath(new StringBuilder().append((Object)this.WORKING_DIR()).append((Object)"/").append((Object)filename).toString());
        try {
            some = new Some(this.serializer().newInstance().deserialize(ByteBuffer.wrap(fileData), m));
        }
        catch (Exception exception2) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exception while reading persisted file, deleting";
                }
            }, exception2);
            this.zk().delete().forPath(new StringBuilder().append((Object)this.WORKING_DIR()).append((Object)"/").append((Object)filename).toString());
            some = None$.MODULE$;
        }
        return some;
    }

    public ZooKeeperPersistenceEngine(SparkConf conf, Serializer serializer) {
        this.serializer = serializer;
        Logging$class.$init$(this);
        this.WORKING_DIR = new StringBuilder().append((Object)conf.get("spark.deploy.zookeeper.dir", "/spark")).append((Object)"/master_status").toString();
        this.zk = SparkCuratorUtil$.MODULE$.newClient(conf, SparkCuratorUtil$.MODULE$.newClient$default$2());
        SparkCuratorUtil$.MODULE$.mkdir(this.zk(), this.WORKING_DIR());
    }
}

