/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.master;

import java.io.ObjectInputStream;
import org.apache.spark.deploy.master.ApplicationInfo;
import org.apache.spark.deploy.master.DriverInfo;
import org.apache.spark.deploy.master.ExecutorDesc;
import org.apache.spark.deploy.master.WorkerState$;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.util.Utils$;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ug!B\u0001\u0003\u0001\u0019a!AC,pe.,'/\u00138g_*\u00111\u0001B\u0001\u0007[\u0006\u001cH/\u001a:\u000b\u0005\u00151\u0011A\u00023fa2|\u0017P\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\r\u0001Qb\u0005\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u00059!\u0012BA\u000b\u0010\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!9\u0002A!b\u0001\n\u0003I\u0012AA5e\u0007\u0001)\u0012A\u0007\t\u00037yq!A\u0004\u000f\n\u0005uy\u0011A\u0002)sK\u0012,g-\u0003\u0002 A\t11\u000b\u001e:j]\u001eT!!H\b\t\u0011\t\u0002!\u0011!Q\u0001\ni\t1!\u001b3!\u0011!!\u0003A!b\u0001\n\u0003I\u0012\u0001\u00025pgRD\u0001B\n\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0006Q>\u001cH\u000f\t\u0005\tQ\u0001\u0011)\u0019!C\u0001S\u0005!\u0001o\u001c:u+\u0005Q\u0003C\u0001\b,\u0013\tasBA\u0002J]RD\u0001B\f\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0006a>\u0014H\u000f\t\u0005\ta\u0001\u0011)\u0019!C\u0001S\u0005)1m\u001c:fg\"A!\u0007\u0001B\u0001B\u0003%!&\u0001\u0004d_J,7\u000f\t\u0005\ti\u0001\u0011)\u0019!C\u0001S\u00051Q.Z7pefD\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IAK\u0001\b[\u0016lwN]=!\u0011!A\u0004A!b\u0001\n\u0003I\u0014\u0001C3oIB|\u0017N\u001c;\u0016\u0003i\u0002\"a\u000f \u000e\u0003qR!!\u0010\u0004\u0002\u0007I\u00048-\u0003\u0002@y\tq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0007\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\u0002\u0013\u0015tG\r]8j]R\u0004\u0003\u0002C\"\u0001\u0005\u000b\u0007I\u0011A\u0015\u0002\u0013],'-V5Q_J$\b\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u0015],'-V5Q_J$\b\u0005\u0003\u0005H\u0001\t\u0015\r\u0011\"\u0001\u001a\u00035\u0001XO\u00197jG\u0006#GM]3tg\"A\u0011\n\u0001B\u0001B\u0003%!$\u0001\bqk\nd\u0017nY!eIJ,7o\u001d\u0011\t\u000b-\u0003A\u0011\u0001'\u0002\rqJg.\u001b;?)%iu\nU)S'R+f\u000b\u0005\u0002O\u00015\t!\u0001C\u0003\u0018\u0015\u0002\u0007!\u0004C\u0003%\u0015\u0002\u0007!\u0004C\u0003)\u0015\u0002\u0007!\u0006C\u00031\u0015\u0002\u0007!\u0006C\u00035\u0015\u0002\u0007!\u0006C\u00039\u0015\u0002\u0007!\bC\u0003D\u0015\u0002\u0007!\u0006C\u0003H\u0015\u0002\u0007!\u0004C\u0005Y\u0001\u0001\u0007\t\u0019!C\u00013\u0006IQ\r_3dkR|'o]\u000b\u00025B!1\f\u0019\u000ec\u001b\u0005a&BA/_\u0003\u001diW\u000f^1cY\u0016T!aX\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002b9\n9\u0001*Y:i\u001b\u0006\u0004\bC\u0001(d\u0013\t!'A\u0001\u0007Fq\u0016\u001cW\u000f^8s\t\u0016\u001c8\rC\u0005g\u0001\u0001\u0007\t\u0019!C\u0001O\u0006iQ\r_3dkR|'o]0%KF$\"\u0001[6\u0011\u00059I\u0017B\u00016\u0010\u0005\u0011)f.\u001b;\t\u000f1,\u0017\u0011!a\u00015\u0006\u0019\u0001\u0010J\u0019\t\r9\u0004\u0001\u0015)\u0003[\u0003))\u00070Z2vi>\u00148\u000f\t\u0015\u0003[B\u0004\"AD9\n\u0005I|!!\u0003;sC:\u001c\u0018.\u001a8u\u0011%!\b\u00011AA\u0002\u0013\u0005Q/A\u0004ee&4XM]:\u0016\u0003Y\u0004Ba\u00171\u001boB\u0011a\n_\u0005\u0003s\n\u0011!\u0002\u0012:jm\u0016\u0014\u0018J\u001c4p\u0011%Y\b\u00011AA\u0002\u0013\u0005A0A\u0006ee&4XM]:`I\u0015\fHC\u00015~\u0011\u001da'0!AA\u0002YDaa \u0001!B\u00131\u0018\u0001\u00033sSZ,'o\u001d\u0011)\u0005y\u0004\bbCA\u0003\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u000f\tQa\u001d;bi\u0016,\"!!\u0003\u0011\t\u0005-\u0011\u0011\u0003\b\u0004\u001d\u00065\u0011bAA\b\u0005\u0005Yqk\u001c:lKJ\u001cF/\u0019;f\u0013\u0011\t\u0019\"!\u0006\u0003\u000bY\u000bG.^3\n\u0007\u0005]qBA\u0006F]VlWM]1uS>t\u0007bCA\u000e\u0001\u0001\u0007\t\u0019!C\u0001\u0003;\t\u0011b\u001d;bi\u0016|F%Z9\u0015\u0007!\fy\u0002C\u0005m\u00033\t\t\u00111\u0001\u0002\n!A\u00111\u0005\u0001!B\u0013\tI!\u0001\u0004ti\u0006$X\r\t\u0015\u0004\u0003C\u0001\bBCA\u0015\u0001\u0001\u0007\t\u0019!C\u0001S\u0005I1m\u001c:fgV\u001bX\r\u001a\u0005\f\u0003[\u0001\u0001\u0019!a\u0001\n\u0003\ty#A\u0007d_J,7/V:fI~#S-\u001d\u000b\u0004Q\u0006E\u0002\u0002\u00037\u0002,\u0005\u0005\t\u0019\u0001\u0016\t\u000f\u0005U\u0002\u0001)Q\u0005U\u0005Q1m\u001c:fgV\u001bX\r\u001a\u0011)\u0007\u0005M\u0002\u000f\u0003\u0006\u0002<\u0001\u0001\r\u00111A\u0005\u0002%\n!\"\\3n_JLXk]3e\u0011-\ty\u0004\u0001a\u0001\u0002\u0004%\t!!\u0011\u0002\u001d5,Wn\u001c:z+N,Gm\u0018\u0013fcR\u0019\u0001.a\u0011\t\u00111\fi$!AA\u0002)Bq!a\u0012\u0001A\u0003&!&A\u0006nK6|'/_+tK\u0012\u0004\u0003fAA#a\"Y\u0011Q\n\u0001A\u0002\u0003\u0007I\u0011AA(\u00035a\u0017m\u001d;IK\u0006\u0014HOY3biV\u0011\u0011\u0011\u000b\t\u0004\u001d\u0005M\u0013bAA+\u001f\t!Aj\u001c8h\u0011-\tI\u0006\u0001a\u0001\u0002\u0004%\t!a\u0017\u0002#1\f7\u000f\u001e%fCJ$(-Z1u?\u0012*\u0017\u000fF\u0002i\u0003;B\u0011\u0002\\A,\u0003\u0003\u0005\r!!\u0015\t\u0011\u0005\u0005\u0004\u0001)Q\u0005\u0003#\na\u0002\\1ti\"+\u0017M\u001d;cK\u0006$\b\u0005K\u0002\u0002`ADa!a\u001a\u0001\t\u0003I\u0013!C2pe\u0016\u001chI]3f\u0011\u0019\tY\u0007\u0001C\u0001S\u0005QQ.Z7pef4%/Z3\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r\u0005Q!/Z1e\u001f\nTWm\u0019;\u0015\u0007!\f\u0019\b\u0003\u0005\u0002v\u00055\u0004\u0019AA<\u0003\tIg\u000e\u0005\u0003\u0002z\u0005\rUBAA>\u0015\u0011\ti(a \u0002\u0005%|'BAAA\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00151\u0010\u0002\u0012\u001f\nTWm\u0019;J]B,Ho\u0015;sK\u0006l\u0007bBAE\u0001\u0011%\u00111R\u0001\u0005S:LG\u000fF\u0001i\u0011\u0019\ty\t\u0001C\u00013\u0005A\u0001n\\:u!>\u0014H\u000fC\u0004\u0002\u0014\u0002!\t!!&\u0002\u0017\u0005$G-\u0012=fGV$xN\u001d\u000b\u0004Q\u0006]\u0005bBAM\u0003#\u0003\rAY\u0001\u0005Kb,7\rC\u0004\u0002\u001e\u0002!\t!a(\u0002\u001dI,Wn\u001c<f\u000bb,7-\u001e;peR\u0019\u0001.!)\t\u000f\u0005e\u00151\u0014a\u0001E\"9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0016a\u00035bg\u0016CXmY;u_J$B!!+\u00020B\u0019a\"a+\n\u0007\u00055vBA\u0004C_>dW-\u00198\t\u0011\u0005E\u00161\u0015a\u0001\u0003g\u000b1!\u00199q!\rq\u0015QW\u0005\u0004\u0003o\u0013!aD!qa2L7-\u0019;j_:LeNZ8\t\u000f\u0005m\u0006\u0001\"\u0001\u0002>\u0006I\u0011\r\u001a3Ee&4XM\u001d\u000b\u0004Q\u0006}\u0006bBAa\u0003s\u0003\ra^\u0001\u0007IJLg/\u001a:\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\u0006a!/Z7pm\u0016$%/\u001b<feR\u0019\u0001.!3\t\u000f\u0005\u0005\u00171\u0019a\u0001o\"1\u0011Q\u001a\u0001\u0005\u0002e\tAb^3c+&\fE\r\u001a:fgNDq!!5\u0001\t\u0003\t\u0019.\u0001\u0005tKR\u001cF/\u0019;f)\rA\u0017Q\u001b\u0005\t\u0003\u000b\ty\r1\u0001\u0002\n!9\u0011\u0011\u001c\u0001\u0005\u0002\u0005m\u0017aB5t\u00032Lg/\u001a\u000b\u0003\u0003S\u0003")
public class WorkerInfo
implements Serializable {
    private final String id;
    private final String host;
    private final int port;
    private final int cores;
    private final int memory;
    private final RpcEndpointRef endpoint;
    private final int webUiPort;
    private final String publicAddress;
    private transient HashMap<String, ExecutorDesc> executors;
    private transient HashMap<String, DriverInfo> drivers;
    private transient Enumeration.Value state;
    private transient int coresUsed;
    private transient int memoryUsed;
    private transient long lastHeartbeat;

    public String id() {
        return this.id;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int cores() {
        return this.cores;
    }

    public int memory() {
        return this.memory;
    }

    public RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    public int webUiPort() {
        return this.webUiPort;
    }

    public String publicAddress() {
        return this.publicAddress;
    }

    public HashMap<String, ExecutorDesc> executors() {
        return this.executors;
    }

    public void executors_$eq(HashMap<String, ExecutorDesc> x$1) {
        this.executors = x$1;
    }

    public HashMap<String, DriverInfo> drivers() {
        return this.drivers;
    }

    public void drivers_$eq(HashMap<String, DriverInfo> x$1) {
        this.drivers = x$1;
    }

    public Enumeration.Value state() {
        return this.state;
    }

    public void state_$eq(Enumeration.Value x$1) {
        this.state = x$1;
    }

    public int coresUsed() {
        return this.coresUsed;
    }

    public void coresUsed_$eq(int x$1) {
        this.coresUsed = x$1;
    }

    public int memoryUsed() {
        return this.memoryUsed;
    }

    public void memoryUsed_$eq(int x$1) {
        this.memoryUsed = x$1;
    }

    public long lastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void lastHeartbeat_$eq(long x$1) {
        this.lastHeartbeat = x$1;
    }

    public int coresFree() {
        return this.cores() - this.coresUsed();
    }

    public int memoryFree() {
        return this.memory() - this.memoryUsed();
    }

    private void readObject(ObjectInputStream in) {
        Utils$.MODULE$.tryOrIOException(new Serializable(this, in){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WorkerInfo $outer;
            private final ObjectInputStream in$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.in$1.defaultReadObject();
                this.$outer.org$apache$spark$deploy$master$WorkerInfo$$init();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.in$1 = in$1;
            }
        });
    }

    public void org$apache$spark$deploy$master$WorkerInfo$$init() {
        this.executors_$eq((HashMap<String, ExecutorDesc>)new HashMap());
        this.drivers_$eq((HashMap<String, DriverInfo>)new HashMap());
        this.state_$eq(WorkerState$.MODULE$.ALIVE());
        this.coresUsed_$eq(0);
        this.memoryUsed_$eq(0);
        this.lastHeartbeat_$eq(System.currentTimeMillis());
    }

    public String hostPort() {
        Predef$.MODULE$.assert(this.port() > 0);
        return new StringBuilder().append((Object)this.host()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)this.port())).toString();
    }

    public void addExecutor(ExecutorDesc exec) {
        this.executors().update((Object)exec.fullId(), (Object)exec);
        this.coresUsed_$eq(this.coresUsed() + exec.cores());
        this.memoryUsed_$eq(this.memoryUsed() + exec.memory());
    }

    public void removeExecutor(ExecutorDesc exec) {
        if (this.executors().contains((Object)exec.fullId())) {
            this.executors().$minus$eq((Object)exec.fullId());
            this.coresUsed_$eq(this.coresUsed() - exec.cores());
            this.memoryUsed_$eq(this.memoryUsed() - exec.memory());
        }
    }

    public boolean hasExecutor(ApplicationInfo app) {
        return this.executors().values().exists((Function1)new Serializable(this, app){
            public static final long serialVersionUID = 0L;
            private final ApplicationInfo app$1;

            public final boolean apply(ExecutorDesc x$1) {
                ApplicationInfo applicationInfo = x$1.application();
                ApplicationInfo applicationInfo2 = this.app$1;
                return !(applicationInfo != null ? !applicationInfo.equals(applicationInfo2) : applicationInfo2 != null);
            }
            {
                this.app$1 = app$1;
            }
        });
    }

    public void addDriver(DriverInfo driver) {
        this.drivers().update((Object)driver.id(), (Object)driver);
        this.memoryUsed_$eq(this.memoryUsed() + driver.desc().mem());
        this.coresUsed_$eq(this.coresUsed() + driver.desc().cores());
    }

    public void removeDriver(DriverInfo driver) {
        this.drivers().$minus$eq((Object)driver.id());
        this.memoryUsed_$eq(this.memoryUsed() - driver.desc().mem());
        this.coresUsed_$eq(this.coresUsed() - driver.desc().cores());
    }

    public String webUiAddress() {
        return new StringBuilder().append((Object)"http://").append((Object)this.publicAddress()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)this.webUiPort())).toString();
    }

    public void setState(Enumeration.Value state) {
        this.state_$eq(state);
    }

    public boolean isAlive() {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = WorkerState$.MODULE$.ALIVE();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public WorkerInfo(String id, String host, int port, int cores, int memory, RpcEndpointRef endpoint, int webUiPort, String publicAddress) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.cores = cores;
        this.memory = memory;
        this.endpoint = endpoint;
        this.webUiPort = webUiPort;
        this.publicAddress = publicAddress;
        Utils$.MODULE$.checkHost(host, "Expected hostname");
        Predef$.MODULE$.assert(port > 0);
        this.org$apache$spark$deploy$master$WorkerInfo$$init();
    }
}

