/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection.unsafe.sort;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnsafeSorterSpillReader
extends UnsafeSorterIterator {
    private static final Logger logger = LoggerFactory.getLogger(UnsafeSorterSpillReader.class);
    private final File file;
    private InputStream in;
    private DataInputStream din;
    private int recordLength;
    private long keyPrefix;
    private int numRecordsRemaining;
    private byte[] arr = new byte[0x100000];
    private Object baseObject = this.arr;
    private final long baseOffset = Platform.BYTE_ARRAY_OFFSET;

    public UnsafeSorterSpillReader(BlockManager blockManager, File file, BlockId blockId) throws IOException {
        assert (file.length() > 0L);
        this.file = file;
        BufferedInputStream bs = new BufferedInputStream(new FileInputStream(file));
        this.in = blockManager.wrapForCompression(blockId, bs);
        this.din = new DataInputStream(this.in);
        this.numRecordsRemaining = this.din.readInt();
    }

    @Override
    public boolean hasNext() {
        return this.numRecordsRemaining > 0;
    }

    @Override
    public void loadNext() throws IOException {
        this.recordLength = this.din.readInt();
        this.keyPrefix = this.din.readLong();
        if (this.recordLength > this.arr.length) {
            this.arr = new byte[this.recordLength];
            this.baseObject = this.arr;
        }
        ByteStreams.readFully((InputStream)this.in, (byte[])this.arr, (int)0, (int)this.recordLength);
        --this.numRecordsRemaining;
        if (this.numRecordsRemaining == 0) {
            this.in.close();
            if (!this.file.delete() && this.file.exists()) {
                logger.warn("Unable to delete spill file {}", (Object)this.file.getPath());
            }
            this.in = null;
            this.din = null;
        }
    }

    @Override
    public Object getBaseObject() {
        return this.baseObject;
    }

    @Override
    public long getBaseOffset() {
        return this.baseOffset;
    }

    @Override
    public int getRecordLength() {
        return this.recordLength;
    }

    @Override
    public long getKeyPrefix() {
        return this.keyPrefix;
    }
}

