/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection.unsafe.sort;

import org.apache.spark.util.collection.SortDataFormat;
import org.apache.spark.util.collection.unsafe.sort.RecordPointerAndKeyPrefix;

final class UnsafeSortDataFormat
extends SortDataFormat<RecordPointerAndKeyPrefix, long[]> {
    public static final UnsafeSortDataFormat INSTANCE = new UnsafeSortDataFormat();

    private UnsafeSortDataFormat() {
    }

    @Override
    public RecordPointerAndKeyPrefix getKey(long[] data, int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RecordPointerAndKeyPrefix newKey() {
        return new RecordPointerAndKeyPrefix();
    }

    @Override
    public RecordPointerAndKeyPrefix getKey(long[] data, int pos, RecordPointerAndKeyPrefix reuse) {
        reuse.recordPointer = data[pos * 2];
        reuse.keyPrefix = data[pos * 2 + 1];
        return reuse;
    }

    @Override
    public void swap(long[] data, int pos0, int pos1) {
        long tempPointer = data[pos0 * 2];
        long tempKeyPrefix = data[pos0 * 2 + 1];
        data[pos0 * 2] = data[pos1 * 2];
        data[pos0 * 2 + 1] = data[pos1 * 2 + 1];
        data[pos1 * 2] = tempPointer;
        data[pos1 * 2 + 1] = tempKeyPrefix;
    }

    @Override
    public void copyElement(long[] src, int srcPos, long[] dst, int dstPos) {
        dst[dstPos * 2] = src[srcPos * 2];
        dst[dstPos * 2 + 1] = src[srcPos * 2 + 1];
    }

    @Override
    public void copyRange(long[] src, int srcPos, long[] dst, int dstPos, int length) {
        System.arraycopy(src, srcPos * 2, dst, dstPos * 2, length * 2);
    }

    @Override
    public long[] allocate(int length) {
        assert (length < 0x3FFFFFFF) : "Length " + length + " is too large";
        return new long[length * 2];
    }
}

