/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection.unsafe.sort;

import java.util.Comparator;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.collection.Sorter;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;
import org.apache.spark.util.collection.unsafe.sort.RecordComparator;
import org.apache.spark.util.collection.unsafe.sort.RecordPointerAndKeyPrefix;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSortDataFormat;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterIterator;

public final class UnsafeInMemorySorter {
    private final TaskMemoryManager memoryManager;
    private final Sorter<RecordPointerAndKeyPrefix, long[]> sorter;
    private final Comparator<RecordPointerAndKeyPrefix> sortComparator;
    private long[] array;
    private int pos = 0;

    public UnsafeInMemorySorter(TaskMemoryManager memoryManager, RecordComparator recordComparator, PrefixComparator prefixComparator, int initialSize) {
        assert (initialSize > 0);
        this.array = new long[initialSize * 2];
        this.memoryManager = memoryManager;
        this.sorter = new Sorter<RecordPointerAndKeyPrefix, long[]>(UnsafeSortDataFormat.INSTANCE);
        this.sortComparator = new SortComparator(recordComparator, prefixComparator, memoryManager);
    }

    public void reset() {
        this.pos = 0;
    }

    public int numRecords() {
        return this.pos / 2;
    }

    private int newLength() {
        return this.array.length < 0x3FFFFFFF ? this.array.length * 2 : Integer.MAX_VALUE;
    }

    public long getMemoryToExpand() {
        return (long)(this.newLength() - this.array.length) * 8L;
    }

    public long getMemoryUsage() {
        return (long)this.array.length * 8L;
    }

    public boolean hasSpaceForAnotherRecord() {
        return this.pos + 2 <= this.array.length;
    }

    public void expandPointerArray() {
        long[] oldArray = this.array;
        this.array = new long[this.newLength()];
        System.arraycopy(oldArray, 0, this.array, 0, oldArray.length);
    }

    public void insertRecord(long recordPointer, long keyPrefix) {
        if (!this.hasSpaceForAnotherRecord()) {
            this.expandPointerArray();
        }
        this.array[this.pos] = recordPointer;
        ++this.pos;
        this.array[this.pos] = keyPrefix;
        ++this.pos;
    }

    public SortedIterator getSortedIterator() {
        this.sorter.sort(this.array, 0, this.pos / 2, this.sortComparator);
        return new SortedIterator(this.memoryManager, this.pos, this.array);
    }

    public static final class SortedIterator
    extends UnsafeSorterIterator {
        private final TaskMemoryManager memoryManager;
        private final int sortBufferInsertPosition;
        private final long[] sortBuffer;
        private int position = 0;
        private Object baseObject;
        private long baseOffset;
        private long keyPrefix;
        private int recordLength;

        private SortedIterator(TaskMemoryManager memoryManager, int sortBufferInsertPosition, long[] sortBuffer) {
            this.memoryManager = memoryManager;
            this.sortBufferInsertPosition = sortBufferInsertPosition;
            this.sortBuffer = sortBuffer;
        }

        public SortedIterator clone() {
            SortedIterator iter = new SortedIterator(this.memoryManager, this.sortBufferInsertPosition, this.sortBuffer);
            iter.position = this.position;
            iter.baseObject = this.baseObject;
            iter.baseOffset = this.baseOffset;
            iter.keyPrefix = this.keyPrefix;
            iter.recordLength = this.recordLength;
            return iter;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.sortBufferInsertPosition;
        }

        public int numRecordsLeft() {
            return (this.sortBufferInsertPosition - this.position) / 2;
        }

        @Override
        public void loadNext() {
            long recordPointer = this.sortBuffer[this.position];
            this.baseObject = this.memoryManager.getPage(recordPointer);
            this.baseOffset = this.memoryManager.getOffsetInPage(recordPointer) + 4L;
            this.recordLength = Platform.getInt((Object)this.baseObject, (long)(this.baseOffset - 4L));
            this.keyPrefix = this.sortBuffer[this.position + 1];
            this.position += 2;
        }

        @Override
        public Object getBaseObject() {
            return this.baseObject;
        }

        @Override
        public long getBaseOffset() {
            return this.baseOffset;
        }

        @Override
        public int getRecordLength() {
            return this.recordLength;
        }

        @Override
        public long getKeyPrefix() {
            return this.keyPrefix;
        }
    }

    private static final class SortComparator
    implements Comparator<RecordPointerAndKeyPrefix> {
        private final RecordComparator recordComparator;
        private final PrefixComparator prefixComparator;
        private final TaskMemoryManager memoryManager;

        SortComparator(RecordComparator recordComparator, PrefixComparator prefixComparator, TaskMemoryManager memoryManager) {
            this.recordComparator = recordComparator;
            this.prefixComparator = prefixComparator;
            this.memoryManager = memoryManager;
        }

        @Override
        public int compare(RecordPointerAndKeyPrefix r1, RecordPointerAndKeyPrefix r2) {
            int prefixComparisonResult = this.prefixComparator.compare(r1.keyPrefix, r2.keyPrefix);
            if (prefixComparisonResult == 0) {
                Object baseObject1 = this.memoryManager.getPage(r1.recordPointer);
                long baseOffset1 = this.memoryManager.getOffsetInPage(r1.recordPointer) + 4L;
                Object baseObject2 = this.memoryManager.getPage(r2.recordPointer);
                long baseOffset2 = this.memoryManager.getOffsetInPage(r2.recordPointer) + 4L;
                return this.recordComparator.compare(baseObject1, baseOffset1, baseObject2, baseOffset2);
            }
            return prefixComparisonResult;
        }
    }
}

