/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.executor.ExecutorExitCode$;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.ExternalBlockManager;
import org.apache.spark.storage.ExternalBlockStore$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.TraitSetter;
import scala.util.control.NonFatal$;
import tachyon.TachyonURI;
import tachyon.client.InStream;
import tachyon.client.OutStream;
import tachyon.client.ReadType;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.conf.TachyonConf;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg!B\u0001\u0003\u0001\u0011Q!a\u0005+bG\"LxN\u001c\"m_\u000e\\W*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003\u001d\u0019Ho\u001c:bO\u0016T!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011AB1qC\u000eDWMC\u0001\n\u0003\ry'oZ\n\u0004\u0001-y\u0001C\u0001\u0007\u000e\u001b\u0005\u0011\u0011B\u0001\b\u0003\u0005Q)\u0005\u0010^3s]\u0006d'\t\\8dW6\u000bg.Y4feB\u0011\u0001#E\u0007\u0002\t%\u0011!\u0003\u0002\u0002\b\u0019><w-\u001b8h\u0011\u0015!\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}\r\u0001A#A\f\u0011\u00051\u0001\u0001\"C\r\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u001b\u0003!\u0011xn\u001c;ESJ\u001cX#A\u000e\u0011\u0005q\u0011cBA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\u0012A\u0002)sK\u0012,g-\u0003\u0002$I\t11\u000b\u001e:j]\u001eT!!\t\u0010\t\u0013\u0019\u0002\u0001\u0019!a\u0001\n\u00039\u0013\u0001\u0004:p_R$\u0015N]:`I\u0015\fHC\u0001\u0015,!\ti\u0012&\u0003\u0002+=\t!QK\\5u\u0011\u001daS%!AA\u0002m\t1\u0001\u001f\u00132\u0011\u0019q\u0003\u0001)Q\u00057\u0005I!o\\8u\t&\u00148\u000f\t\u0005\na\u0001\u0001\r\u00111A\u0005\u0002i\ta!\\1ti\u0016\u0014\b\"\u0003\u001a\u0001\u0001\u0004\u0005\r\u0011\"\u00014\u0003)i\u0017m\u001d;fe~#S-\u001d\u000b\u0003QQBq\u0001L\u0019\u0002\u0002\u0003\u00071\u0004\u0003\u00047\u0001\u0001\u0006KaG\u0001\b[\u0006\u001cH/\u001a:!\u0011%A\u0004\u00011AA\u0002\u0013\u0005\u0011(\u0001\u0004dY&,g\u000e^\u000b\u0002uA\u00111hP\u0007\u0002y)\u0011\u0001(\u0010\u0006\u0002}\u00059A/Y2is>t\u0017B\u0001!=\u0005%!\u0016m\u00195z_:45\u000bC\u0005C\u0001\u0001\u0007\t\u0019!C\u0001\u0007\u0006Q1\r\\5f]R|F%Z9\u0015\u0005!\"\u0005b\u0002\u0017B\u0003\u0003\u0005\rA\u000f\u0005\u0007\r\u0002\u0001\u000b\u0015\u0002\u001e\u0002\u000f\rd\u0017.\u001a8uA!I\u0001\n\u0001a\u0001\u0002\u0004%I!S\u0001\u0015gV\u0014G)\u001b:t!\u0016\u0014H+Y2is>tG)\u001b:\u0016\u0003)\u0003\"!H&\n\u00051s\"aA%oi\"Ia\n\u0001a\u0001\u0002\u0004%IaT\u0001\u0019gV\u0014G)\u001b:t!\u0016\u0014H+Y2is>tG)\u001b:`I\u0015\fHC\u0001\u0015Q\u0011\u001daS*!AA\u0002)CaA\u0015\u0001!B\u0013Q\u0015!F:vE\u0012K'o\u001d)feR\u000b7\r[=p]\u0012K'\u000f\t\u0005\n)\u0002\u0001\r\u00111A\u0005\nU\u000b1\u0002^1dQf|g\u000eR5sgV\ta\u000bE\u0002\u001e/fK!\u0001\u0017\u0010\u0003\u000b\u0005\u0013(/Y=\u0011\u0005mR\u0016BA.=\u0005-!\u0016m\u00195z_:4\u0015\u000e\\3\t\u0013u\u0003\u0001\u0019!a\u0001\n\u0013q\u0016a\u0004;bG\"LxN\u001c#jeN|F%Z9\u0015\u0005!z\u0006b\u0002\u0017]\u0003\u0003\u0005\rA\u0016\u0005\u0007C\u0002\u0001\u000b\u0015\u0002,\u0002\u0019Q\f7\r[=p]\u0012K'o\u001d\u0011\t\u0013\r\u0004\u0001\u0019!a\u0001\n\u0013!\u0017aB:vE\u0012K'o]\u000b\u0002KB\u0019Qd\u0016,\t\u0013\u001d\u0004\u0001\u0019!a\u0001\n\u0013A\u0017aC:vE\u0012K'o]0%KF$\"\u0001K5\t\u000f12\u0017\u0011!a\u0001K\"11\u000e\u0001Q!\n\u0015\f\u0001b];c\t&\u00148\u000f\t\u0005\u0006[\u0002!\tE\\\u0001\u0005S:LG\u000fF\u0002)_RDQ\u0001\u001d7A\u0002E\fAB\u00197pG.l\u0015M\\1hKJ\u0004\"\u0001\u0004:\n\u0005M\u0014!\u0001\u0004\"m_\u000e\\W*\u00198bO\u0016\u0014\b\"B;m\u0001\u0004Y\u0012AC3yK\u000e,Ho\u001c:JI\")q\u000f\u0001C!q\u0006AAo\\*ue&tw\rF\u0001\u001c\u0011\u0015Q\b\u0001\"\u0011|\u0003-\u0011X-\\8wK\ncwnY6\u0015\u0005q|\bCA\u000f~\u0013\tqhDA\u0004C_>dW-\u00198\t\u000f\u0005\u0005\u0011\u00101\u0001\u0002\u0004\u00059!\r\\8dW&#\u0007c\u0001\u0007\u0002\u0006%\u0019\u0011q\u0001\u0002\u0003\u000f\tcwnY6JI\"9\u00111\u0002\u0001\u0005B\u00055\u0011a\u00032m_\u000e\\W\t_5tiN$2\u0001`A\b\u0011!\t\t!!\u0003A\u0002\u0005\r\u0001bBA\n\u0001\u0011\u0005\u0013QC\u0001\taV$()\u001f;fgR)\u0001&a\u0006\u0002\u001a!A\u0011\u0011AA\t\u0001\u0004\t\u0019\u0001\u0003\u0005\u0002\u001c\u0005E\u0001\u0019AA\u000f\u0003\u0015\u0011\u0017\u0010^3t!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\t1A\\5p\u0015\t\t9#\u0001\u0003kCZ\f\u0017\u0002BA\u0016\u0003C\u0011!BQ=uK\n+hMZ3s\u0011\u001d\ty\u0003\u0001C!\u0003c\t\u0011\u0002];u-\u0006dW/Z:\u0015\u000b!\n\u0019$!\u000e\t\u0011\u0005\u0005\u0011Q\u0006a\u0001\u0003\u0007A\u0001\"a\u000e\u0002.\u0001\u0007\u0011\u0011H\u0001\u0007m\u0006dW/Z:1\t\u0005m\u0012q\u000b\t\u0007\u0003{\ti%a\u0015\u000f\t\u0005}\u0012\u0011\n\b\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011QI\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0012bAA&=\u00059\u0001/Y2lC\u001e,\u0017\u0002BA(\u0003#\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003\u0017r\u0002\u0003BA+\u0003/b\u0001\u0001\u0002\u0007\u0002Z\u0005U\u0012\u0011!A\u0001\u0006\u0003\tYFA\u0002`IE\nB!!\u0018\u0002dA\u0019Q$a\u0018\n\u0007\u0005\u0005dDA\u0004O_RD\u0017N\\4\u0011\u0007u\t)'C\u0002\u0002hy\u00111!\u00118z\u0011\u001d\tY\u0007\u0001C!\u0003[\n\u0001bZ3u\u0005f$Xm\u001d\u000b\u0005\u0003_\n)\bE\u0003\u001e\u0003c\ni\"C\u0002\u0002ty\u0011aa\u00149uS>t\u0007\u0002CA\u0001\u0003S\u0002\r!a\u0001\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|\u0005Iq-\u001a;WC2,Xm\u001d\u000b\u0005\u0003{\nI\tE\u0003\u001e\u0003c\ny\b\r\u0003\u0002\u0002\u0006\u0015\u0005CBA\u001f\u0003\u001b\n\u0019\t\u0005\u0003\u0002V\u0005\u0015E\u0001DAD\u0003o\n\t\u0011!A\u0003\u0002\u0005m#aA0%e!A\u0011\u0011AA<\u0001\u0004\t\u0019\u0001C\u0004\u0002\u000e\u0002!\t%a$\u0002\u000f\u001d,GoU5{KR!\u0011\u0011SAL!\ri\u00121S\u0005\u0004\u0003+s\"\u0001\u0002'p]\u001eD\u0001\"!\u0001\u0002\f\u0002\u0007\u00111\u0001\u0005\b\u00037\u0003A\u0011AAO\u0003)\u0011X-\\8wK\u001aKG.\u001a\u000b\u0004y\u0006}\u0005bBAQ\u00033\u0003\r!W\u0001\u0005M&dW\rC\u0004\u0002&\u0002!\t!a*\u0002\u0015\u0019LG.Z#ySN$8\u000fF\u0002}\u0003SCq!!)\u0002$\u0002\u0007\u0011\fC\u0004\u0002.\u0002!\t!a,\u0002\u000f\u001d,GOR5mKR\u0019\u0011,!-\t\u000f\u0005M\u00161\u0016a\u00017\u0005Aa-\u001b7f]\u0006lW\rC\u0004\u0002.\u0002!\t!a.\u0015\u0007e\u000bI\f\u0003\u0005\u0002\u0002\u0005U\u0006\u0019AA\u0002\u0011\u001d\ti\f\u0001C\u0005\u0003\u007f\u000b\u0011c\u0019:fCR,G+Y2is>tG)\u001b:t)\u00051\u0006bBAb\u0001\u0011\u0005\u0013QY\u0001\tg\",H\u000fZ8x]R\t\u0001\u0006")
public class TachyonBlockManager
extends ExternalBlockManager
implements Logging {
    private String rootDirs;
    private String master;
    private TachyonFS client;
    private int org$apache$spark$storage$TachyonBlockManager$$subDirsPerTachyonDir;
    private TachyonFile[] tachyonDirs;
    private TachyonFile[][] subDirs;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public String rootDirs() {
        return this.rootDirs;
    }

    public void rootDirs_$eq(String x$1) {
        this.rootDirs = x$1;
    }

    public String master() {
        return this.master;
    }

    public void master_$eq(String x$1) {
        this.master = x$1;
    }

    public TachyonFS client() {
        return this.client;
    }

    public void client_$eq(TachyonFS x$1) {
        this.client = x$1;
    }

    public int org$apache$spark$storage$TachyonBlockManager$$subDirsPerTachyonDir() {
        return this.org$apache$spark$storage$TachyonBlockManager$$subDirsPerTachyonDir;
    }

    private void org$apache$spark$storage$TachyonBlockManager$$subDirsPerTachyonDir_$eq(int x$1) {
        this.org$apache$spark$storage$TachyonBlockManager$$subDirsPerTachyonDir = x$1;
    }

    private TachyonFile[] tachyonDirs() {
        return this.tachyonDirs;
    }

    private void tachyonDirs_$eq(TachyonFile[] x$1) {
        this.tachyonDirs = x$1;
    }

    private TachyonFile[][] subDirs() {
        return this.subDirs;
    }

    private void subDirs_$eq(TachyonFile[][] x$1) {
        this.subDirs = x$1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void init(BlockManager blockManager, String executorId) {
        super.init(blockManager, executorId);
        storeDir = blockManager.conf().get(ExternalBlockStore$.MODULE$.BASE_DIR(), "/tmp_spark_tachyon");
        appFolderName = blockManager.conf().get(ExternalBlockStore$.MODULE$.FOLD_NAME());
        this.rootDirs_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{storeDir, appFolderName, executorId})));
        this.master_$eq(blockManager.conf().get(ExternalBlockStore$.MODULE$.MASTER_URL(), "tachyon://localhost:19998"));
        if (this.master() == null) ** GOTO lbl11
        v0 = this.master();
        var5_5 = "";
        if (!(v0 != null ? v0.equals(var5_5) == false : var5_5 != null)) {
lbl11:
            // 2 sources

            v1 = null;
        } else {
            v1 = TachyonFS.get((TachyonURI)new TachyonURI(this.master()), (TachyonConf)new TachyonConf());
        }
        this.client_$eq(v1);
        if (this.client() == null) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Failed to connect to the Tachyon as the master address is not configured";
                }
            });
            throw new IOException("Failed to connect to the Tachyon as the master address is not configured");
        }
        this.org$apache$spark$storage$TachyonBlockManager$$subDirsPerTachyonDir_$eq(new StringOps(Predef$.MODULE$.augmentString(blockManager.conf().get("spark.externalBlockStore.subDirectories", ExternalBlockStore$.MODULE$.SUB_DIRS_PER_DIR()))).toInt());
        this.tachyonDirs_$eq(this.createTachyonDirs());
        this.subDirs_$eq((TachyonFile[][])Array$.MODULE$.fill(this.tachyonDirs().length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TachyonBlockManager $outer;

            public final TachyonFile[] apply() {
                return new TachyonFile[this.$outer.org$apache$spark$storage$TachyonBlockManager$$subDirsPerTachyonDir()];
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(TachyonFile.class))));
        Predef$.MODULE$.refArrayOps((Object[])this.tachyonDirs()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(TachyonFile tachyonDir) {
                ShutdownHookManager$.MODULE$.registerShutdownDeleteDir(tachyonDir);
            }
        });
    }

    @Override
    public String toString() {
        return "ExternalBlockStore-Tachyon";
    }

    @Override
    public boolean removeBlock(BlockId blockId) {
        TachyonFile file = this.getFile(blockId);
        return this.fileExists(file) ? this.removeFile(file) : false;
    }

    @Override
    public boolean blockExists(BlockId blockId) {
        TachyonFile file = this.getFile(blockId);
        return this.fileExists(file);
    }

    @Override
    public void putBytes(BlockId blockId, ByteBuffer bytes) {
        TachyonFile file = this.getFile(blockId);
        OutStream os = file.getOutStream(WriteType.TRY_CACHE);
        try {
            os.write(bytes.array());
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)new Serializable(this, blockId){
                    public static final long serialVersionUID = 0L;
                    private final BlockId blockId$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to put bytes of block ", " into Tachyon"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1}));
                    }
                    {
                        this.blockId$1 = blockId$1;
                    }
                }, e);
                os.cancel();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                os.close();
            }
        }
        os.close();
    }

    @Override
    public void putValues(BlockId blockId, Iterator<Object> values2) {
        TachyonFile file = this.getFile(blockId);
        OutStream os = file.getOutStream(WriteType.TRY_CACHE);
        try {
            BlockManager qual$1 = this.blockManager();
            BlockId x$1 = blockId;
            OutStream x$2 = os;
            Iterator<Object> x$3 = values2;
            Serializer x$4 = qual$1.dataSerializeStream$default$4();
            qual$1.dataSerializeStream(x$1, (OutputStream)x$2, x$3, x$4);
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)new Serializable(this, blockId){
                    public static final long serialVersionUID = 0L;
                    private final BlockId blockId$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to put values of block ", " into Tachyon"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$2}));
                    }
                    {
                        this.blockId$2 = blockId$2;
                    }
                }, e);
                os.cancel();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                os.close();
            }
        }
        os.close();
    }

    @Override
    public Option<ByteBuffer> getBytes(BlockId blockId) {
        Some some;
        TachyonFile file = this.getFile(blockId);
        if (file == null || file.getLocationHosts().size() == 0) {
            return None$.MODULE$;
        }
        InStream is = file.getInStream(ReadType.CACHE);
        try {
            long size = file.length();
            byte[] bs = new byte[(int)size];
            ByteStreams.readFully((InputStream)is, (byte[])bs);
            some = new Some((Object)ByteBuffer.wrap(bs));
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)new Serializable(this, blockId){
                    public static final long serialVersionUID = 0L;
                    private final BlockId blockId$3;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get bytes of block ", " from Tachyon"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$3}));
                    }
                    {
                        this.blockId$3 = blockId$3;
                    }
                }, e);
                None$ none$ = None$.MODULE$;
                some = none$;
            }
            finally {
                is.close();
            }
        }
        is.close();
        return some;
    }

    @Override
    public Option<Iterator<Object>> getValues(BlockId blockId) {
        TachyonFile file = this.getFile(blockId);
        if (file == null || file.getLocationHosts().size() == 0) {
            return None$.MODULE$;
        }
        InStream is = file.getInStream(ReadType.CACHE);
        return Option$.MODULE$.apply((Object)is).map((Function1)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TachyonBlockManager $outer;
            private final BlockId blockId$4;

            public final Iterator<Object> apply(InStream is) {
                BlockManager qual$2 = this.$outer.blockManager();
                BlockId x$5 = this.blockId$4;
                InStream x$6 = is;
                Serializer x$7 = qual$2.dataDeserializeStream$default$3();
                return qual$2.dataDeserializeStream(x$5, (InputStream)x$6, x$7);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.blockId$4 = blockId$4;
            }
        });
    }

    @Override
    public long getSize(BlockId blockId) {
        return this.getFile(blockId.name()).length();
    }

    public boolean removeFile(TachyonFile file) {
        return this.client().delete(new TachyonURI(file.getPath()), false);
    }

    public boolean fileExists(TachyonFile file) {
        return this.client().exist(new TachyonURI(file.getPath()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TachyonFile getFile(String filename) {
        int hash = Utils$.MODULE$.nonNegativeHash(filename);
        int dirId = hash % this.tachyonDirs().length;
        int subDirId = hash / this.tachyonDirs().length % this.org$apache$spark$storage$TachyonBlockManager$$subDirsPerTachyonDir();
        TachyonFile subDir = this.subDirs()[dirId][subDirId];
        if (subDir == null) {
            TachyonFile[] tachyonFileArray = this.subDirs()[dirId];
            synchronized (tachyonFileArray) {
                TachyonFile tachyonFile;
                TachyonFile old = this.subDirs()[dirId][subDirId];
                if (old == null) {
                    TachyonFile newDir;
                    TachyonURI path = new TachyonURI(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tachyonDirs()[dirId], new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)subDirId)}))})));
                    this.client().mkdir(path);
                    this.subDirs()[dirId][subDirId] = newDir = this.client().getFile(path);
                    tachyonFile = newDir;
                } else {
                    tachyonFile = old;
                }
                TachyonFile tachyonFile2 = tachyonFile;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl19 : MonitorExitStatement: MONITOREXIT : tachyonFileArray
                subDir = tachyonFile2;
            }
        }
        TachyonURI filePath = new TachyonURI(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{subDir, filename})));
        Object object = this.client().exist(filePath) ? BoxedUnit.UNIT : BoxesRunTime.boxToInteger((int)this.client().createFile(filePath));
        return this.client().getFile(filePath);
    }

    public TachyonFile getFile(BlockId blockId) {
        return this.getFile(blockId.name());
    }

    private TachyonFile[] createTachyonDirs() {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TachyonBlockManager $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Creating tachyon directories at root dirs '").append((Object)this.$outer.rootDirs()).append((Object)"'").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return (TachyonFile[])Predef$.MODULE$.refArrayOps((Object[])this.rootDirs().split(",")).map((Function1)new Serializable(this, dateFormat){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TachyonBlockManager $outer;
            private final SimpleDateFormat dateFormat$1;

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final TachyonFile apply(String rootDir) {
                boolean foundLocalDir = false;
                ObjectRef tachyonDir = new ObjectRef(null);
                String tachyonDirId = null;
                IntRef tries = new IntRef(0);
                Random rand = new Random();
                while (!foundLocalDir && tries.elem < ExternalBlockStore$.MODULE$.MAX_DIR_CREATION_ATTEMPTS()) {
                    ++tries.elem;
                    {
                        tachyonDirId = new StringOps(Predef$.MODULE$.augmentString("%s-%04x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dateFormat$1.format(new Date()), BoxesRunTime.boxToInteger((int)rand.nextInt(65536))}));
                        TachyonURI path = new TachyonURI(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/spark-tachyon-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootDir, tachyonDirId})));
                        if (this.$outer.client().exist(path)) continue;
                        foundLocalDir = this.$outer.client().mkdir(path);
                        tachyonDir.elem = this.$outer.client().getFile(path);
                    }
                }
                if (!foundLocalDir) {
                    this.$outer.logError((Function0<String>)new Serializable(this, rootDir){
                        public static final long serialVersionUID = 0L;
                        private final String rootDir$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Failed ").append((Object)BoxesRunTime.boxToInteger((int)ExternalBlockStore$.MODULE$.MAX_DIR_CREATION_ATTEMPTS())).append((Object)" attempts to create tachyon dir in ").append((Object)this.rootDir$1).toString();
                        }
                        {
                            this.rootDir$1 = rootDir$1;
                        }
                    });
                    System.exit(ExecutorExitCode$.MODULE$.EXTERNAL_BLOCK_STORE_FAILED_TO_CREATE_DIR());
                }
                this.$outer.logInfo((Function0<String>)new Serializable(this, tachyonDir){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef tachyonDir$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Created tachyon directory at ").append((Object)((TachyonFile)this.tachyonDir$1.elem)).toString();
                    }
                    {
                        this.tachyonDir$1 = tachyonDir$1;
                    }
                });
                return (TachyonFile)tachyonDir.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dateFormat$1 = dateFormat$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TachyonFile.class)));
    }

    @Override
    public void shutdown() {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutdown hook called";
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])this.tachyonDirs()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TachyonBlockManager $outer;

            public final void apply(TachyonFile tachyonDir) {
                try {
                    if (!ShutdownHookManager$.MODULE$.hasRootAsShutdownDeleteDir(tachyonDir)) {
                        Utils$.MODULE$.deleteRecursively(tachyonDir, this.$outer.client());
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.$outer.logError((Function0<String>)new Serializable(this, tachyonDir){
                        public static final long serialVersionUID = 0L;
                        private final TachyonFile tachyonDir$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Exception while deleting tachyon spark dir: ").append((Object)this.tachyonDir$2).toString();
                        }
                        {
                            this.tachyonDir$2 = tachyonDir$2;
                        }
                    }, e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.client().close();
    }

    public TachyonBlockManager() {
        Logging$class.$init$(this);
    }
}

