/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.storage.FileSegment;
import org.apache.spark.storage.TimeTrackingOutputStream;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005]h!B\u0001\u0003\u0001\u0011Q!!\u0006#jg.\u0014En\\2l\u001f\nTWm\u0019;Xe&$XM\u001d\u0006\u0003\u0007\u0011\tqa\u001d;pe\u0006<WM\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h'\r\u00011b\u0005\t\u0003\u0019Ei\u0011!\u0004\u0006\u0003\u001d=\t!![8\u000b\u0003A\tAA[1wC&\u0011!#\u0004\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\t\u0003)Ui\u0011\u0001B\u0005\u0003-\u0011\u0011q\u0001T8hO&tw\r\u0003\u0005\u0019\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u00111\u0017\u000e\\3\u0004\u0001A\u0011AbG\u0005\u000395\u0011AAR5mK\"Aa\u0004\u0001B\u0001B\u0003%q$\u0001\ntKJL\u0017\r\\5{KJLen\u001d;b]\u000e,\u0007C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0005\u0003)\u0019XM]5bY&TXM]\u0005\u0003I\u0005\u0012!cU3sS\u0006d\u0017N_3s\u0013:\u001cH/\u00198dK\"Aa\u0005\u0001B\u0001B\u0003%q%\u0001\u0006ck\u001a4WM]*ju\u0016\u0004\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u00121!\u00138u\u0011!q\u0003A!A!\u0002\u0013y\u0013AD2p[B\u0014Xm]:TiJ,\u0017-\u001c\t\u0005QAZ1\"\u0003\u00022S\tIa)\u001e8di&|g.\r\u0005\tg\u0001\u0011\t\u0011)A\u0005i\u0005Q1/\u001f8d/JLG/Z:\u0011\u0005!*\u0014B\u0001\u001c*\u0005\u001d\u0011un\u001c7fC:D\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!O\u0001\roJLG/Z'fiJL7m\u001d\t\u0003uuj\u0011a\u000f\u0006\u0003y\u0011\t\u0001\"\u001a=fGV$xN]\u0005\u0003}m\u00121c\u00155vM\u001adWm\u0016:ji\u0016lU\r\u001e:jGNDQ\u0001\u0011\u0001\u0005\u0002\u0005\u000ba\u0001P5oSRtDc\u0002\"E\u000b\u001a;\u0005*\u0013\t\u0003\u0007\u0002i\u0011A\u0001\u0005\u00061}\u0002\rA\u0007\u0005\u0006=}\u0002\ra\b\u0005\u0006M}\u0002\ra\n\u0005\u0006]}\u0002\ra\f\u0005\u0006g}\u0002\r\u0001\u000e\u0005\u0006q}\u0002\r!\u000f\u0005\b\u0017\u0002\u0001\r\u0011\"\u0003M\u0003\u001d\u0019\u0007.\u00198oK2,\u0012!\u0014\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000b\u0001b\u00195b]:,Gn\u001d\u0006\u0003%>\t1A\\5p\u0013\t!vJA\u0006GS2,7\t[1o]\u0016d\u0007b\u0002,\u0001\u0001\u0004%IaV\u0001\fG\"\fgN\\3m?\u0012*\u0017\u000f\u0006\u0002Y7B\u0011\u0001&W\u0005\u00035&\u0012A!\u00168ji\"9A,VA\u0001\u0002\u0004i\u0015a\u0001=%c!1a\f\u0001Q!\n5\u000b\u0001b\u00195b]:,G\u000e\t\u0005\bA\u0002\u0001\r\u0011\"\u0003b\u0003\t\u00117/F\u0001\f\u0011\u001d\u0019\u0007\u00011A\u0005\n\u0011\faAY:`I\u0015\fHC\u0001-f\u0011\u001da&-!AA\u0002-Aaa\u001a\u0001!B\u0013Y\u0011a\u00012tA!9\u0011\u000e\u0001a\u0001\n\u0013Q\u0017a\u00014pgV\t1\u000e\u0005\u0002\rY&\u0011Q.\u0004\u0002\u0011\r&dWmT;uaV$8\u000b\u001e:fC6Dqa\u001c\u0001A\u0002\u0013%\u0001/A\u0004g_N|F%Z9\u0015\u0005a\u000b\bb\u0002/o\u0003\u0003\u0005\ra\u001b\u0005\u0007g\u0002\u0001\u000b\u0015B6\u0002\t\u0019|7\u000f\t\u0005\bk\u0002\u0001\r\u0011\"\u0003w\u0003\t!8/F\u0001x!\t\u0019\u00050\u0003\u0002z\u0005\tAB+[7f)J\f7m[5oO>+H\u000f];u'R\u0014X-Y7\t\u000fm\u0004\u0001\u0019!C\u0005y\u00061Ao]0%KF$\"\u0001W?\t\u000fqS\u0018\u0011!a\u0001o\"1q\u0010\u0001Q!\n]\f1\u0001^:!\u0011%\t\u0019\u0001\u0001a\u0001\n\u0013\t)!\u0001\u0004pE*|U\u000f^\u000b\u0003\u0003\u000f\u00012\u0001IA\u0005\u0013\r\tY!\t\u0002\u0014'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8TiJ,\u0017-\u001c\u0005\n\u0003\u001f\u0001\u0001\u0019!C\u0005\u0003#\t!b\u001c2k\u001fV$x\fJ3r)\rA\u00161\u0003\u0005\n9\u00065\u0011\u0011!a\u0001\u0003\u000fA\u0001\"a\u0006\u0001A\u0003&\u0011qA\u0001\b_\nTw*\u001e;!\u0011%\tY\u0002\u0001a\u0001\n\u0013\ti\"A\u0006j]&$\u0018.\u00197ju\u0016$W#\u0001\u001b\t\u0013\u0005\u0005\u0002\u00011A\u0005\n\u0005\r\u0012aD5oSRL\u0017\r\\5{K\u0012|F%Z9\u0015\u0007a\u000b)\u0003\u0003\u0005]\u0003?\t\t\u00111\u00015\u0011\u001d\tI\u0003\u0001Q!\nQ\nA\"\u001b8ji&\fG.\u001b>fI\u0002B\u0011\"!\f\u0001\u0001\u0004%I!!\b\u0002\u001b!\f7OQ3f]\u000ecwn]3e\u0011%\t\t\u0004\u0001a\u0001\n\u0013\t\u0019$A\tiCN\u0014U-\u001a8DY>\u001cX\rZ0%KF$2\u0001WA\u001b\u0011!a\u0016qFA\u0001\u0002\u0004!\u0004bBA\u001d\u0001\u0001\u0006K\u0001N\u0001\u000fQ\u0006\u001c()Z3o\u00072|7/\u001a3!\u0011%\ti\u0004\u0001a\u0001\n\u0013\ti\"A\u000ed_6l\u0017\u000e^!oI\u000ecwn]3ICN\u0014U-\u001a8DC2dW\r\u001a\u0005\n\u0003\u0003\u0002\u0001\u0019!C\u0005\u0003\u0007\nqdY8n[&$\u0018I\u001c3DY>\u001cX\rS1t\u0005\u0016,gnQ1mY\u0016$w\fJ3r)\rA\u0016Q\t\u0005\t9\u0006}\u0012\u0011!a\u0001i!9\u0011\u0011\n\u0001!B\u0013!\u0014\u0001H2p[6LG/\u00118e\u00072|7/\u001a%bg\n+WM\\\"bY2,G\r\t\u0005\n\u0003\u001b\u0002!\u0019!C\u0005\u0003\u001f\nq\"\u001b8ji&\fG\u000eU8tSRLwN\\\u000b\u0003\u0003#\u00022\u0001KA*\u0013\r\t)&\u000b\u0002\u0005\u0019>tw\r\u0003\u0005\u0002Z\u0001\u0001\u000b\u0011BA)\u0003AIg.\u001b;jC2\u0004vn]5uS>t\u0007\u0005C\u0005\u0002^\u0001\u0001\r\u0011\"\u0003\u0002P\u0005ia-\u001b8bYB{7/\u001b;j_:D\u0011\"!\u0019\u0001\u0001\u0004%I!a\u0019\u0002#\u0019Lg.\u00197Q_NLG/[8o?\u0012*\u0017\u000fF\u0002Y\u0003KB\u0011\u0002XA0\u0003\u0003\u0005\r!!\u0015\t\u0011\u0005%\u0004\u0001)Q\u0005\u0003#\naBZ5oC2\u0004vn]5uS>t\u0007\u0005C\u0005\u0002n\u0001\u0001\r\u0011\"\u0003\u0002P\u0005\u0001\"/\u001a9peR,G\rU8tSRLwN\u001c\u0005\n\u0003c\u0002\u0001\u0019!C\u0005\u0003g\nAC]3q_J$X\r\u001a)pg&$\u0018n\u001c8`I\u0015\fHc\u0001-\u0002v!IA,a\u001c\u0002\u0002\u0003\u0007\u0011\u0011\u000b\u0005\t\u0003s\u0002\u0001\u0015)\u0003\u0002R\u0005\t\"/\u001a9peR,G\rU8tSRLwN\u001c\u0011\t\u0013\u0005u\u0004\u00011A\u0005\n\u0005}\u0014!\u00058v[J+7m\u001c:eg^\u0013\u0018\u000e\u001e;f]V\tq\u0005C\u0005\u0002\u0004\u0002\u0001\r\u0011\"\u0003\u0002\u0006\u0006)b.^7SK\u000e|'\u000fZ:Xe&$H/\u001a8`I\u0015\fHc\u0001-\u0002\b\"AA,!!\u0002\u0002\u0003\u0007q\u0005C\u0004\u0002\f\u0002\u0001\u000b\u0015B\u0014\u0002%9,XNU3d_J$7o\u0016:jiR,g\u000e\t\u0005\b\u0003\u001f\u0003A\u0011AAI\u0003\u0011y\u0007/\u001a8\u0015\u0003\tCq!!&\u0001\t\u0003\n9*A\u0003dY>\u001cX\rF\u0001Y\u0011\u001d\tY\n\u0001C\u0001\u0003;\ta![:Pa\u0016t\u0007bBAP\u0001\u0011\u0005\u0011qS\u0001\u000fG>lW.\u001b;B]\u0012\u001cEn\\:f\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003K\u000b1D]3wKJ$\b+\u0019:uS\u0006dwK]5uKN\fe\u000eZ\"m_N,G#\u0001\u000e\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\u0006)qO]5uKR)\u0001,!,\u00028\"A\u0011qVAT\u0001\u0004\t\t,A\u0002lKf\u00042\u0001KAZ\u0013\r\t),\u000b\u0002\u0004\u0003:L\b\u0002CA]\u0003O\u0003\r!!-\u0002\u000bY\fG.^3\t\u000f\u0005%\u0006\u0001\"\u0011\u0002>R\u0019\u0001,a0\t\u000f\u0005\u0005\u00171\u0018a\u0001O\u0005\t!\rC\u0004\u0002*\u0002!\t%!2\u0015\u000fa\u000b9-a6\u0002\\\"A\u0011\u0011ZAb\u0001\u0004\tY-A\u0004lm\nKH/Z:\u0011\u000b!\ni-!5\n\u0007\u0005=\u0017FA\u0003BeJ\f\u0017\u0010E\u0002)\u0003'L1!!6*\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005e\u00171\u0019a\u0001O\u0005!qN\u001a4t\u0011\u001d\ti.a1A\u0002\u001d\n1\u0001\\3o\u0011\u001d\t\t\u000f\u0001C\u0001\u0003/\u000bQB]3d_J$wK]5ui\u0016t\u0007bBAs\u0001\u0011\u0005\u0011q]\u0001\fM&dWmU3h[\u0016tG\u000f\u0006\u0002\u0002jB\u00191)a;\n\u0007\u00055(AA\u0006GS2,7+Z4nK:$\bbBAy\u0001\u0011%\u0011qS\u0001\u0013kB$\u0017\r^3CsR,7o\u0016:jiR,g\u000e\u0003\u0005\u0002v\u0002!\t\u0005BAL\u0003\u00151G.^:i\u0001")
public class DiskBlockObjectWriter
extends OutputStream
implements Logging {
    public final File org$apache$spark$storage$DiskBlockObjectWriter$$file;
    private final SerializerInstance serializerInstance;
    private final int bufferSize;
    private final Function1<OutputStream, OutputStream> compressStream;
    public final boolean org$apache$spark$storage$DiskBlockObjectWriter$$syncWrites;
    public final ShuffleWriteMetrics org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics;
    private FileChannel channel;
    private OutputStream bs;
    private FileOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$fos;
    private TimeTrackingOutputStream ts;
    private SerializationStream org$apache$spark$storage$DiskBlockObjectWriter$$objOut;
    private boolean initialized;
    private boolean hasBeenClosed;
    private boolean commitAndCloseHasBeenCalled;
    private final long initialPosition;
    private long finalPosition;
    private long reportedPosition;
    private int numRecordsWritten;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private FileChannel channel() {
        return this.channel;
    }

    private void channel_$eq(FileChannel x$1) {
        this.channel = x$1;
    }

    private OutputStream bs() {
        return this.bs;
    }

    private void bs_$eq(OutputStream x$1) {
        this.bs = x$1;
    }

    public FileOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$fos() {
        return this.org$apache$spark$storage$DiskBlockObjectWriter$$fos;
    }

    private void org$apache$spark$storage$DiskBlockObjectWriter$$fos_$eq(FileOutputStream x$1) {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$fos = x$1;
    }

    private TimeTrackingOutputStream ts() {
        return this.ts;
    }

    private void ts_$eq(TimeTrackingOutputStream x$1) {
        this.ts = x$1;
    }

    public SerializationStream org$apache$spark$storage$DiskBlockObjectWriter$$objOut() {
        return this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut;
    }

    private void org$apache$spark$storage$DiskBlockObjectWriter$$objOut_$eq(SerializationStream x$1) {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private boolean hasBeenClosed() {
        return this.hasBeenClosed;
    }

    private void hasBeenClosed_$eq(boolean x$1) {
        this.hasBeenClosed = x$1;
    }

    private boolean commitAndCloseHasBeenCalled() {
        return this.commitAndCloseHasBeenCalled;
    }

    private void commitAndCloseHasBeenCalled_$eq(boolean x$1) {
        this.commitAndCloseHasBeenCalled = x$1;
    }

    private long initialPosition() {
        return this.initialPosition;
    }

    private long finalPosition() {
        return this.finalPosition;
    }

    private void finalPosition_$eq(long x$1) {
        this.finalPosition = x$1;
    }

    private long reportedPosition() {
        return this.reportedPosition;
    }

    private void reportedPosition_$eq(long x$1) {
        this.reportedPosition = x$1;
    }

    private int numRecordsWritten() {
        return this.numRecordsWritten;
    }

    private void numRecordsWritten_$eq(int x$1) {
        this.numRecordsWritten = x$1;
    }

    public DiskBlockObjectWriter open() {
        if (this.hasBeenClosed()) {
            throw new IllegalStateException("Writer already closed. Cannot be reopened.");
        }
        this.org$apache$spark$storage$DiskBlockObjectWriter$$fos_$eq(new FileOutputStream(this.org$apache$spark$storage$DiskBlockObjectWriter$$file, true));
        this.ts_$eq(new TimeTrackingOutputStream(this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics, this.org$apache$spark$storage$DiskBlockObjectWriter$$fos()));
        this.channel_$eq(this.org$apache$spark$storage$DiskBlockObjectWriter$$fos().getChannel());
        this.bs_$eq((OutputStream)this.compressStream.apply((Object)new BufferedOutputStream(this.ts(), this.bufferSize)));
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut_$eq(this.serializerInstance.serializeStream(this.bs()));
        this.initialized_$eq(true);
        return this;
    }

    @Override
    public void close() {
        if (this.initialized()) {
            Utils$.MODULE$.tryWithSafeFinally(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DiskBlockObjectWriter $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    if (this.$outer.org$apache$spark$storage$DiskBlockObjectWriter$$syncWrites) {
                        this.$outer.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().flush();
                        long start2 = System.nanoTime();
                        this.$outer.org$apache$spark$storage$DiskBlockObjectWriter$$fos().getFD().sync();
                        this.$outer.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.incShuffleWriteTime(System.nanoTime() - start2);
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DiskBlockObjectWriter $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().close();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.channel_$eq(null);
            this.bs_$eq(null);
            this.org$apache$spark$storage$DiskBlockObjectWriter$$fos_$eq(null);
            this.ts_$eq(null);
            this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut_$eq(null);
            this.initialized_$eq(false);
            this.hasBeenClosed_$eq(true);
        }
    }

    public boolean isOpen() {
        return this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut() != null;
    }

    public void commitAndClose() {
        if (this.initialized()) {
            this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().flush();
            this.bs().flush();
            this.close();
            this.finalPosition_$eq(this.org$apache$spark$storage$DiskBlockObjectWriter$$file.length());
            this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.incShuffleBytesWritten(this.finalPosition() - this.reportedPosition());
        } else {
            this.finalPosition_$eq(this.org$apache$spark$storage$DiskBlockObjectWriter$$file.length());
        }
        this.commitAndCloseHasBeenCalled_$eq(true);
    }

    public File revertPartialWritesAndClose() {
        File file;
        try {
            if (this.initialized()) {
                this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.decShuffleBytesWritten(this.reportedPosition() - this.initialPosition());
                this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.decShuffleRecordsWritten(this.numRecordsWritten());
                this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().flush();
                this.bs().flush();
                this.close();
            }
            try (FileOutputStream truncateStream = new FileOutputStream(this.org$apache$spark$storage$DiskBlockObjectWriter$$file, true);){
                truncateStream.getChannel().truncate(this.initialPosition());
                file = this.org$apache$spark$storage$DiskBlockObjectWriter$$file;
            }
        }
        catch (Exception exception2) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DiskBlockObjectWriter $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Uncaught exception while reverting partial writes to file ").append((Object)this.$outer.org$apache$spark$storage$DiskBlockObjectWriter$$file).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, exception2);
            file = this.org$apache$spark$storage$DiskBlockObjectWriter$$file;
        }
        return file;
    }

    public void write(Object key, Object value) {
        Object object = this.initialized() ? BoxedUnit.UNIT : this.open();
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().writeKey(key, ClassTag$.MODULE$.Any());
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().writeValue(value, ClassTag$.MODULE$.Any());
        this.recordWritten();
    }

    @Override
    public void write(int b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] kvBytes, int offs, int len) {
        Object object = this.initialized() ? BoxedUnit.UNIT : this.open();
        this.bs().write(kvBytes, offs, len);
    }

    public void recordWritten() {
        this.numRecordsWritten_$eq(this.numRecordsWritten() + 1);
        this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.incShuffleRecordsWritten(1L);
        if (this.numRecordsWritten() % 32 == 0) {
            this.updateBytesWritten();
        }
    }

    public FileSegment fileSegment() {
        if (this.commitAndCloseHasBeenCalled()) {
            return new FileSegment(this.org$apache$spark$storage$DiskBlockObjectWriter$$file, this.initialPosition(), this.finalPosition() - this.initialPosition());
        }
        throw new IllegalStateException("fileSegment() is only valid after commitAndClose() has been called");
    }

    private void updateBytesWritten() {
        long pos = this.channel().position();
        this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.incShuffleBytesWritten(pos - this.reportedPosition());
        this.reportedPosition_$eq(pos);
    }

    @Override
    public void flush() {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().flush();
        this.bs().flush();
    }

    public DiskBlockObjectWriter(File file, SerializerInstance serializerInstance, int bufferSize, Function1<OutputStream, OutputStream> compressStream, boolean syncWrites, ShuffleWriteMetrics writeMetrics) {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$file = file;
        this.serializerInstance = serializerInstance;
        this.bufferSize = bufferSize;
        this.compressStream = compressStream;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$syncWrites = syncWrites;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics = writeMetrics;
        Logging$class.$init$(this);
        this.channel = null;
        this.bs = null;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$fos = null;
        this.ts = null;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut = null;
        this.initialized = false;
        this.hasBeenClosed = false;
        this.commitAndCloseHasBeenCalled = false;
        this.initialPosition = file.length();
        this.finalPosition = -1L;
        this.reportedPosition = this.initialPosition();
        this.numRecordsWritten = 0;
    }
}

