/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.util.HashMap;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005=c!B\u0001\u0003\u0001\u0011Q!\u0001\u0005\"m_\u000e\\W*\u00198bO\u0016\u0014\u0018J\u001c4p\u0015\t\u0019A!A\u0004ti>\u0014\u0018mZ3\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c2\u0001A\u0006\u0012!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fMB\u0011!cE\u0007\u0002\t%\u0011A\u0003\u0002\u0002\b\u0019><w-\u001b8h\u0011!1\u0002A!b\u0001\n\u0003A\u0012A\u00042m_\u000e\\W*\u00198bO\u0016\u0014\u0018\nZ\u0002\u0001+\u0005I\u0002C\u0001\u000e\u001c\u001b\u0005\u0011\u0011B\u0001\u000f\u0003\u00059\u0011En\\2l\u001b\u0006t\u0017mZ3s\u0013\u0012D\u0001B\b\u0001\u0003\u0002\u0003\u0006I!G\u0001\u0010E2|7m['b]\u0006<WM]%eA!A\u0001\u0005\u0001B\u0001B\u0003%\u0011%\u0001\u0004uS6,Wj\u001d\t\u0003\u0019\tJ!aI\u0007\u0003\t1{gn\u001a\u0005\tK\u0001\u0011)\u0019!C\u0001M\u00051Q.\u0019=NK6,\u0012!\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005C\u00059Q.\u0019=NK6\u0004\u0003\u0002\u0003\u0016\u0001\u0005\u000b\u0007I\u0011A\u0016\u0002\u001bMd\u0017M^3F]\u0012\u0004x.\u001b8u+\u0005a\u0003CA\u00171\u001b\u0005q#BA\u0018\u0005\u0003\r\u0011\boY\u0005\u0003c9\u0012aB\u00159d\u000b:$\u0007o\\5oiJ+g\r\u0003\u00054\u0001\t\u0005\t\u0015!\u0003-\u00039\u0019H.\u0019<f\u000b:$\u0007o\\5oi\u0002BQ!\u000e\u0001\u0005\u0002Y\na\u0001P5oSRtD#B\u001c9siZ\u0004C\u0001\u000e\u0001\u0011\u00151B\u00071\u0001\u001a\u0011\u0015\u0001C\u00071\u0001\"\u0011\u0015)C\u00071\u0001\"\u0011\u0015QC\u00071\u0001-\u0011\u001di\u0004\u00011A\u0005\n\u0019\n1b\u00187bgR\u001cV-\u001a8Ng\"9q\b\u0001a\u0001\n\u0013\u0001\u0015aD0mCN$8+Z3o\u001bN|F%Z9\u0015\u0005\u0005#\u0005C\u0001\u0007C\u0013\t\u0019UB\u0001\u0003V]&$\bbB#?\u0003\u0003\u0005\r!I\u0001\u0004q\u0012\n\u0004BB$\u0001A\u0003&\u0011%\u0001\u0007`Y\u0006\u001cHoU3f]6\u001b\b\u0005C\u0004J\u0001\u0001\u0007I\u0011\u0002\u0014\u0002\u001b}\u0013X-\\1j]&tw-T3n\u0011\u001dY\u0005\u00011A\u0005\n1\u000b\u0011c\u0018:f[\u0006Lg.\u001b8h\u001b\u0016lw\fJ3r)\t\tU\nC\u0004F\u0015\u0006\u0005\t\u0019A\u0011\t\r=\u0003\u0001\u0015)\u0003\"\u00039y&/Z7bS:LgnZ'f[\u0002Bq!\u0015\u0001C\u0002\u0013%!+A\u0004`E2|7m[:\u0016\u0003M\u0003B\u0001V-\\=6\tQK\u0003\u0002W/\u0006!Q\u000f^5m\u0015\u0005A\u0016\u0001\u00026bm\u0006L!AW+\u0003\u000f!\u000b7\u000f['baB\u0011!\u0004X\u0005\u0003;\n\u0011qA\u00117pG.LE\r\u0005\u0002\u001b?&\u0011\u0001M\u0001\u0002\f\u00052|7m[*uCR,8\u000f\u0003\u0004c\u0001\u0001\u0006IaU\u0001\t?\ndwnY6tA!9A\r\u0001b\u0001\n\u0013)\u0017!D0dC\u000eDW\r\u001a\"m_\u000e\\7/F\u0001g!\r9GnW\u0007\u0002Q*\u0011\u0011N[\u0001\b[V$\u0018M\u00197f\u0015\tYW\"\u0001\u0006d_2dWm\u0019;j_:L!!\u001c5\u0003\u000f!\u000b7\u000f[*fi\"1q\u000e\u0001Q\u0001\n\u0019\fabX2bG\",GM\u00117pG.\u001c\b\u0005C\u0003r\u0001\u0011\u0005!/A\u0005hKR\u001cF/\u0019;vgR\u00111O\u001e\t\u0004\u0019Qt\u0016BA;\u000e\u0005\u0019y\u0005\u000f^5p]\")q\u000f\u001da\u00017\u00069!\r\\8dW&#\u0007\"B=\u0001\t\u0003Q\u0018\u0001E;qI\u0006$X\rT1tiN+WM\\'t)\u0005\t\u0005\"\u0002?\u0001\t\u0003i\u0018aD;qI\u0006$XM\u00117pG.LeNZ8\u0015\u0013\u0005sx0!\u0003\u0002\u000e\u0005E\u0001\"B<|\u0001\u0004Y\u0006bBA\u0001w\u0002\u0007\u00111A\u0001\rgR|'/Y4f\u0019\u00164X\r\u001c\t\u00045\u0005\u0015\u0011bAA\u0004\u0005\ta1\u000b^8sC\u001e,G*\u001a<fY\"1\u00111B>A\u0002\u0005\nq!\\3n'&TX\r\u0003\u0004\u0002\u0010m\u0004\r!I\u0001\tI&\u001c8nU5{K\"1\u00111C>A\u0002\u0005\na#\u001a=uKJt\u0017\r\u001c\"m_\u000e\\7\u000b^8sKNK'0\u001a\u0005\b\u0003/\u0001A\u0011AA\r\u0003-\u0011X-\\8wK\ncwnY6\u0015\u0007\u0005\u000bY\u0002\u0003\u0004x\u0003+\u0001\ra\u0017\u0005\u0007\u0003?\u0001A\u0011\u0001\u0014\u0002\u0019I,W.Y5oS:<W*Z7\t\r\u0005\r\u0002\u0001\"\u0001'\u0003)a\u0017m\u001d;TK\u0016tWj\u001d\u0005\u0007\u0003O\u0001A\u0011\u0001*\u0002\r\tdwnY6t\u0011\u001d\tY\u0003\u0001C\u0001\u0003[\tAbY1dQ\u0016$'\t\\8dWN,\"!a\f\u0011\u000b\u0005E\u00121G.\u000e\u0003)L1!!\u000ek\u0005\r\u0019V\r\u001e\u0005\b\u0003s\u0001A\u0011IA\u001e\u0003!!xn\u0015;sS:<GCAA\u001f!\u0011\ty$!\u0012\u000f\u00071\t\t%C\u0002\u0002D5\ta\u0001\u0015:fI\u00164\u0017\u0002BA$\u0003\u0013\u0012aa\u0015;sS:<'bAA\"\u001b!1\u0011Q\n\u0001\u0005\u0002i\fQa\u00197fCJ\u0004")
public class BlockManagerInfo
implements Logging {
    private final BlockManagerId blockManagerId;
    private final long timeMs;
    private final long maxMem;
    private final RpcEndpointRef slaveEndpoint;
    private long _lastSeenMs;
    private long org$apache$spark$storage$BlockManagerInfo$$_remainingMem;
    private final HashMap<BlockId, BlockStatus> _blocks;
    private final HashSet<BlockId> _cachedBlocks;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public BlockManagerId blockManagerId() {
        return this.blockManagerId;
    }

    public long maxMem() {
        return this.maxMem;
    }

    public RpcEndpointRef slaveEndpoint() {
        return this.slaveEndpoint;
    }

    private long _lastSeenMs() {
        return this._lastSeenMs;
    }

    private void _lastSeenMs_$eq(long x$1) {
        this._lastSeenMs = x$1;
    }

    public long org$apache$spark$storage$BlockManagerInfo$$_remainingMem() {
        return this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem;
    }

    private void org$apache$spark$storage$BlockManagerInfo$$_remainingMem_$eq(long x$1) {
        this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem = x$1;
    }

    private HashMap<BlockId, BlockStatus> _blocks() {
        return this._blocks;
    }

    private HashSet<BlockId> _cachedBlocks() {
        return this._cachedBlocks;
    }

    public Option<BlockStatus> getStatus(BlockId blockId) {
        return Option$.MODULE$.apply((Object)this._blocks().get(blockId));
    }

    public void updateLastSeenMs() {
        this._lastSeenMs_$eq(System.currentTimeMillis());
    }

    public void updateBlockInfo(BlockId blockId, StorageLevel storageLevel, long memSize, long diskSize, long externalBlockStoreSize) {
        this.updateLastSeenMs();
        if (this._blocks().containsKey(blockId)) {
            BlockStatus blockStatus2 = this._blocks().get(blockId);
            StorageLevel originalLevel = blockStatus2.storageLevel();
            long originalMemSize = blockStatus2.memSize();
            if (originalLevel.useMemory()) {
                this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem_$eq(this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem() + originalMemSize);
            }
        }
        if (storageLevel.isValid()) {
            BlockStatus blockStatus3 = null;
            if (storageLevel.useMemory()) {
                blockStatus3 = new BlockStatus(storageLevel, memSize, 0L, 0L);
                this._blocks().put(blockId, blockStatus3);
                this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem_$eq(this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem() - memSize);
                this.logInfo((Function0<String>)new Serializable(this, blockId, memSize){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BlockManagerInfo $outer;
                    private final BlockId blockId$4;
                    private final long memSize$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Added %s in memory on %s (size: %s, free: %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$4, this.$outer.blockManagerId().hostPort(), Utils$.MODULE$.bytesToString(this.memSize$1), Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$BlockManagerInfo$$_remainingMem())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.blockId$4 = blockId$4;
                        this.memSize$1 = memSize$1;
                    }
                });
            }
            if (storageLevel.useDisk()) {
                blockStatus3 = new BlockStatus(storageLevel, 0L, diskSize, 0L);
                this._blocks().put(blockId, blockStatus3);
                this.logInfo((Function0<String>)new Serializable(this, blockId, diskSize){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BlockManagerInfo $outer;
                    private final BlockId blockId$4;
                    private final long diskSize$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Added %s on disk on %s (size: %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$4, this.$outer.blockManagerId().hostPort(), Utils$.MODULE$.bytesToString(this.diskSize$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.blockId$4 = blockId$4;
                        this.diskSize$1 = diskSize$1;
                    }
                });
            }
            if (storageLevel.useOffHeap()) {
                blockStatus3 = new BlockStatus(storageLevel, 0L, 0L, externalBlockStoreSize);
                this._blocks().put(blockId, blockStatus3);
                this.logInfo((Function0<String>)new Serializable(this, blockId, externalBlockStoreSize){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BlockManagerInfo $outer;
                    private final BlockId blockId$4;
                    private final long externalBlockStoreSize$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Added %s on ExternalBlockStore on %s (size: %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$4, this.$outer.blockManagerId().hostPort(), Utils$.MODULE$.bytesToString(this.externalBlockStoreSize$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.blockId$4 = blockId$4;
                        this.externalBlockStoreSize$1 = externalBlockStoreSize$1;
                    }
                });
            }
            if (!blockId.isBroadcast() && blockStatus3.isCached()) {
                this._cachedBlocks().$plus$eq((Object)blockId);
            }
        } else if (this._blocks().containsKey(blockId)) {
            BlockStatus blockStatus4 = this._blocks().get(blockId);
            this._blocks().remove(blockId);
            this._cachedBlocks().$minus$eq((Object)blockId);
            if (blockStatus4.storageLevel().useMemory()) {
                this.logInfo((Function0<String>)new Serializable(this, blockId, blockStatus4){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BlockManagerInfo $outer;
                    private final BlockId blockId$4;
                    private final BlockStatus blockStatus$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Removed %s on %s in memory (size: %s, free: %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$4, this.$outer.blockManagerId().hostPort(), Utils$.MODULE$.bytesToString(this.blockStatus$1.memSize()), Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$storage$BlockManagerInfo$$_remainingMem())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.blockId$4 = blockId$4;
                        this.blockStatus$1 = blockStatus$1;
                    }
                });
            }
            if (blockStatus4.storageLevel().useDisk()) {
                this.logInfo((Function0<String>)new Serializable(this, blockId, blockStatus4){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BlockManagerInfo $outer;
                    private final BlockId blockId$4;
                    private final BlockStatus blockStatus$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Removed %s on %s on disk (size: %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$4, this.$outer.blockManagerId().hostPort(), Utils$.MODULE$.bytesToString(this.blockStatus$1.diskSize())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.blockId$4 = blockId$4;
                        this.blockStatus$1 = blockStatus$1;
                    }
                });
            }
            if (blockStatus4.storageLevel().useOffHeap()) {
                this.logInfo((Function0<String>)new Serializable(this, blockId, blockStatus4){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BlockManagerInfo $outer;
                    private final BlockId blockId$4;
                    private final BlockStatus blockStatus$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Removed %s on %s on externalBlockStore (size: %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$4, this.$outer.blockManagerId().hostPort(), Utils$.MODULE$.bytesToString(this.blockStatus$1.externalBlockStoreSize())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.blockId$4 = blockId$4;
                        this.blockStatus$1 = blockStatus$1;
                    }
                });
            }
        }
    }

    public void removeBlock(BlockId blockId) {
        Object object;
        if (this._blocks().containsKey(blockId)) {
            this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem_$eq(this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem() + this._blocks().get(blockId).memSize());
            object = this._blocks().remove(blockId);
        } else {
            object = BoxedUnit.UNIT;
        }
        this._cachedBlocks().$minus$eq((Object)blockId);
    }

    public long remainingMem() {
        return this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem();
    }

    public long lastSeenMs() {
        return this._lastSeenMs();
    }

    public HashMap<BlockId, BlockStatus> blocks() {
        return this._blocks();
    }

    public Set<BlockId> cachedBlocks() {
        return this._cachedBlocks();
    }

    public String toString() {
        return new StringBuilder().append((Object)"BlockManagerInfo ").append((Object)BoxesRunTime.boxToLong((long)this.timeMs)).append((Object)" ").append((Object)BoxesRunTime.boxToLong((long)this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem())).toString();
    }

    public void clear() {
        this._blocks().clear();
    }

    public BlockManagerInfo(BlockManagerId blockManagerId, long timeMs, long maxMem, RpcEndpointRef slaveEndpoint) {
        this.blockManagerId = blockManagerId;
        this.timeMs = timeMs;
        this.maxMem = maxMem;
        this.slaveEndpoint = slaveEndpoint;
        Logging$class.$init$(this);
        this._lastSeenMs = timeMs;
        this.org$apache$spark$storage$BlockManagerInfo$$_remainingMem = maxMem;
        this._blocks = new HashMap();
        this._cachedBlocks = new HashSet();
    }
}

