/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort;

import java.util.Comparator;
import org.apache.spark.shuffle.sort.PackedRecordPointer;
import org.apache.spark.shuffle.sort.ShuffleSortDataFormat;
import org.apache.spark.util.collection.Sorter;

final class ShuffleInMemorySorter {
    private final Sorter<PackedRecordPointer, long[]> sorter;
    private static final SortComparator SORT_COMPARATOR = new SortComparator();
    private long[] array;
    private int pos = 0;

    public ShuffleInMemorySorter(int initialSize) {
        assert (initialSize > 0);
        this.array = new long[initialSize];
        this.sorter = new Sorter<PackedRecordPointer, long[]>(ShuffleSortDataFormat.INSTANCE);
    }

    public int numRecords() {
        return this.pos;
    }

    public void reset() {
        this.pos = 0;
    }

    private int newLength() {
        return this.array.length <= 0x3FFFFFFF ? this.array.length * 2 : Integer.MAX_VALUE;
    }

    public long getMemoryToExpand() {
        return (long)(this.newLength() - this.array.length) * 8L;
    }

    public void expandPointerArray() {
        long[] oldArray = this.array;
        this.array = new long[this.newLength()];
        System.arraycopy(oldArray, 0, this.array, 0, oldArray.length);
    }

    public boolean hasSpaceForAnotherRecord() {
        return this.pos < this.array.length;
    }

    public long getMemoryUsage() {
        return (long)this.array.length * 8L;
    }

    public void insertRecord(long recordPointer, int partitionId) {
        if (!this.hasSpaceForAnotherRecord()) {
            if (this.array.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Sort pointer array has reached maximum size");
            }
            this.expandPointerArray();
        }
        this.array[this.pos] = PackedRecordPointer.packPointer(recordPointer, partitionId);
        ++this.pos;
    }

    public ShuffleSorterIterator getSortedIterator() {
        this.sorter.sort(this.array, 0, this.pos, SORT_COMPARATOR);
        return new ShuffleSorterIterator(this.pos, this.array);
    }

    public static final class ShuffleSorterIterator {
        private final long[] pointerArray;
        private final int numRecords;
        final PackedRecordPointer packedRecordPointer = new PackedRecordPointer();
        private int position = 0;

        public ShuffleSorterIterator(int numRecords, long[] pointerArray) {
            this.numRecords = numRecords;
            this.pointerArray = pointerArray;
        }

        public boolean hasNext() {
            return this.position < this.numRecords;
        }

        public void loadNext() {
            this.packedRecordPointer.set(this.pointerArray[this.position]);
            ++this.position;
        }
    }

    private static final class SortComparator
    implements Comparator<PackedRecordPointer> {
        private SortComparator() {
        }

        @Override
        public int compare(PackedRecordPointer left, PackedRecordPointer right) {
            return left.getPartitionId() - right.getPartitionId();
        }
    }
}

