/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import com.google.common.io.ByteStreams;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.ShuffleDataBlockId;
import org.apache.spark.storage.ShuffleIndexBlockId;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005-a!B\u0001\u0003\u0001\u0011Q!!G%oI\u0016D8\u000b[;gM2,'\t\\8dWJ+7o\u001c7wKJT!a\u0001\u0003\u0002\u000fMDWO\u001a4mK*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0005\u0003\u0001\u0017E)\u0002C\u0001\u0007\u0010\u001b\u0005i!\"\u0001\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ai!AB!osJ+g\r\u0005\u0002\u0013'5\t!!\u0003\u0002\u0015\u0005\t!2\u000b[;gM2,'\t\\8dWJ+7o\u001c7wKJ\u0004\"AF\f\u000e\u0003\u0011I!\u0001\u0007\u0003\u0003\u000f1{wmZ5oO\"A!\u0004\u0001B\u0001B\u0003%A$\u0001\u0003d_:47\u0001\u0001\t\u0003-uI!A\b\u0003\u0003\u0013M\u0003\u0018M]6D_:4\u0007\"\u0002\u0011\u0001\t\u0003\t\u0013A\u0002\u001fj]&$h\b\u0006\u0002#GA\u0011!\u0003\u0001\u0005\u00065}\u0001\r\u0001\b\u0005\tK\u0001A)\u0019!C\u0005M\u0005a!\r\\8dW6\u000bg.Y4feV\tq\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+\t\u000591\u000f^8sC\u001e,\u0017B\u0001\u0017*\u00051\u0011En\\2l\u001b\u0006t\u0017mZ3s\u0011!q\u0003\u0001#A!B\u00139\u0013!\u00042m_\u000e\\W*\u00198bO\u0016\u0014\b\u0005C\u00041\u0001\t\u0007I\u0011B\u0019\u0002\u001bQ\u0014\u0018M\\:q_J$8i\u001c8g+\u0005\u0011\u0004CA\u001a9\u001b\u0005!$BA\u001b7\u0003\u0011)H/\u001b7\u000b\u0005]\"\u0011a\u00028fi^|'o[\u0005\u0003sQ\u0012Q\u0002\u0016:b]N\u0004xN\u001d;D_:4\u0007BB\u001e\u0001A\u0003%!'\u0001\bue\u0006t7\u000f]8si\u000e{gN\u001a\u0011\t\u000bu\u0002A\u0011\u0001 \u0002\u0017\u001d,G\u000fR1uC\u001aKG.\u001a\u000b\u0004\u007f\u001dc\u0005C\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\tIwNC\u0001E\u0003\u0011Q\u0017M^1\n\u0005\u0019\u000b%\u0001\u0002$jY\u0016DQ\u0001\u0013\u001fA\u0002%\u000b\u0011b\u001d5vM\u001adW-\u00133\u0011\u00051Q\u0015BA&\u000e\u0005\rIe\u000e\u001e\u0005\u0006\u001br\u0002\r!S\u0001\u0006[\u0006\u0004\u0018\n\u001a\u0005\u0006\u001f\u0002!I\u0001U\u0001\rO\u0016$\u0018J\u001c3fq\u001aKG.\u001a\u000b\u0004\u007fE\u0013\u0006\"\u0002%O\u0001\u0004I\u0005\"B'O\u0001\u0004I\u0005\"\u0002+\u0001\t\u0003)\u0016a\u0004:f[>4X\rR1uC\nKX*\u00199\u0015\u0007YK&\f\u0005\u0002\r/&\u0011\u0001,\u0004\u0002\u0005+:LG\u000fC\u0003I'\u0002\u0007\u0011\nC\u0003N'\u0002\u0007\u0011\nC\u0003]\u0001\u0011\u0005Q,\u0001\bxe&$X-\u00138eKb4\u0015\u000e\\3\u0015\tYsv\f\u0019\u0005\u0006\u0011n\u0003\r!\u0013\u0005\u0006\u001bn\u0003\r!\u0013\u0005\u0006Cn\u0003\rAY\u0001\bY\u0016tw\r\u001e5t!\ra1-Z\u0005\u0003I6\u0011Q!\u0011:sCf\u0004\"\u0001\u00044\n\u0005\u001dl!\u0001\u0002'p]\u001eDQ!\u001b\u0001\u0005B)\fAbZ3u\u00052|7m\u001b#bi\u0006$\"a[9\u0011\u00051|W\"A7\u000b\u000594\u0014A\u00022vM\u001a,'/\u0003\u0002q[\niQ*\u00198bO\u0016$')\u001e4gKJDQA\u001d5A\u0002M\fqA\u00197pG.LE\r\u0005\u0002)i&\u0011Q/\u000b\u0002\u000f'\",hM\u001a7f\u00052|7m[%e\u0011\u00159\b\u0001\"\u0011y\u0003\u0011\u0019Ho\u001c9\u0015\u0003Y;aA\u001f\u0002\t\u0002\u0011Y\u0018!G%oI\u0016D8\u000b[;gM2,'\t\\8dWJ+7o\u001c7wKJ\u0004\"A\u0005?\u0007\r\u0005\u0011\u0001\u0012\u0001\u0003~'\ta8\u0002C\u0003!y\u0012\u0005q\u0010F\u0001|\u0011%\t\u0019\u0001 b\u0001\n\u0003\t)!\u0001\bO\u001f>\u0003vLU#E+\u000e+u,\u0013#\u0016\u0003%Cq!!\u0003}A\u0003%\u0011*A\bO\u001f>\u0003vLU#E+\u000e+u,\u0013#!\u0001")
public class IndexShuffleBlockResolver
implements ShuffleBlockResolver,
Logging {
    private BlockManager blockManager;
    private final TransportConf transportConf;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile boolean bitmap$0;

    public static int NOOP_REDUCE_ID() {
        return IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID();
    }

    private BlockManager blockManager$lzycompute() {
        IndexShuffleBlockResolver indexShuffleBlockResolver = this;
        synchronized (indexShuffleBlockResolver) {
            if (!this.bitmap$0) {
                this.blockManager = SparkEnv$.MODULE$.get().blockManager();
                this.bitmap$0 = true;
            }
            return this.blockManager;
        }
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private BlockManager blockManager() {
        return this.bitmap$0 ? this.blockManager : this.blockManager$lzycompute();
    }

    private TransportConf transportConf() {
        return this.transportConf;
    }

    public File getDataFile(int shuffleId, int mapId) {
        return this.blockManager().diskBlockManager().getFile(new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()));
    }

    private File getIndexFile(int shuffleId, int mapId) {
        return this.blockManager().diskBlockManager().getFile(new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()));
    }

    public void removeDataByMap(int shuffleId, int mapId) {
        ObjectRef file = new ObjectRef((Object)this.getDataFile(shuffleId, mapId));
        if (((File)file.elem).exists() && !((File)file.elem).delete()) {
            this.logWarning((Function0<String>)new Serializable(this, file){
                public static final long serialVersionUID = 0L;
                private final ObjectRef file$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting data ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((File)this.file$1.elem).getPath()}));
                }
                {
                    this.file$1 = file$1;
                }
            });
        }
        file.elem = this.getIndexFile(shuffleId, mapId);
        if (((File)file.elem).exists() && !((File)file.elem).delete()) {
            this.logWarning((Function0<String>)new Serializable(this, file){
                public static final long serialVersionUID = 0L;
                private final ObjectRef file$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((File)this.file$1.elem).getPath()}));
                }
                {
                    this.file$1 = file$1;
                }
            });
        }
    }

    public void writeIndexFile(int shuffleId, int mapId, long[] lengths) {
        File indexFile = this.getIndexFile(shuffleId, mapId);
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
        Utils$.MODULE$.tryWithSafeFinally(new Serializable(this, lengths, out){
            public static final long serialVersionUID = 0L;
            private final long[] lengths$1;
            public final DataOutputStream out$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LongRef offset = new LongRef(0L);
                this.out$1.writeLong(offset.elem);
                Predef$.MODULE$.longArrayOps(this.lengths$1).foreach((Function1)new Serializable(this, offset){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeIndexFile$1 $outer;
                    private final LongRef offset$1;

                    public final void apply(long length) {
                        this.apply$mcVJ$sp(length);
                    }

                    public void apply$mcVJ$sp(long length) {
                        this.offset$1.elem += length;
                        this.$outer.out$1.writeLong(this.offset$1.elem);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.offset$1 = offset$1;
                    }
                });
            }
            {
                this.lengths$1 = lengths$1;
                this.out$1 = out$1;
            }
        }, (Function0<BoxedUnit>)new Serializable(this, out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.out$1.close();
            }
            {
                this.out$1 = out$1;
            }
        });
    }

    @Override
    public ManagedBuffer getBlockData(ShuffleBlockId blockId) {
        File indexFile = this.getIndexFile(blockId.shuffleId(), blockId.mapId());
        try (DataInputStream in = new DataInputStream(new FileInputStream(indexFile));){
            ByteStreams.skipFully((InputStream)in, (long)(blockId.reduceId() * 8));
            long offset = in.readLong();
            long nextOffset = in.readLong();
            return new FileSegmentManagedBuffer(this.transportConf(), this.getDataFile(blockId.shuffleId(), blockId.mapId()), offset, nextOffset - offset);
        }
    }

    @Override
    public void stop() {
    }

    public IndexShuffleBlockResolver(SparkConf conf) {
        Logging$class.$init$(this);
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, SparkTransportConf$.MODULE$.fromSparkConf$default$2());
    }
}

