/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.ExecutorAllocationClient$class;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskState$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint$class;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.SchedulerBackend$class;
import org.apache.spark.scheduler.SlaveLost;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.TaskDescription;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.TaskSetManager;
import org.apache.spark.scheduler.WorkerOffer;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$RetrieveSparkProps$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$ReviveOffers$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$StopDriver$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$StopExecutor$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$StopExecutors$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$DriverEndpoint$;
import org.apache.spark.scheduler.cluster.ExecutorData;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.util.AkkaUtils$;
import org.apache.spark.util.SerializableBuffer;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\r\u001dc!B\u0001\u0003\u0001\u0019a!!H\"pCJ\u001cXm\u0012:bS:,GmU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u000b\u0005\r!\u0011aB2mkN$XM\u001d\u0006\u0003\u000b\u0019\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001cR\u0001A\u0007\u0014/m\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0016\u001b\u00051\u0011B\u0001\f\u0007\u0005a)\u00050Z2vi>\u0014\u0018\t\u001c7pG\u0006$\u0018n\u001c8DY&,g\u000e\u001e\t\u00031ei\u0011\u0001B\u0005\u00035\u0011\u0011\u0001cU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0011\u0005Qa\u0012BA\u000f\u0007\u0005\u001daunZ4j]\u001eD\u0001\"\u0002\u0001\u0003\u0002\u0003\u0006I\u0001I\u0002\u0001!\tA\u0012%\u0003\u0002#\t\t\tB+Y:l'\u000eDW\rZ;mKJLU\u000e\u001d7\t\u0011\u0011\u0002!Q1A\u0005\u0002\u0015\naA\u001d9d\u000b:4X#\u0001\u0014\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%2\u0011a\u0001:qG&\u00111\u0006\u000b\u0002\u0007%B\u001cWI\u001c<\t\u00115\u0002!\u0011!Q\u0001\n\u0019\nqA\u001d9d\u000b:4\b\u0005C\u00030\u0001\u0011\u0005\u0001'\u0001\u0004=S:LGO\u0010\u000b\u0004cM\"\u0004C\u0001\u001a\u0001\u001b\u0005\u0011\u0001\"B\u0003/\u0001\u0004\u0001\u0003\"\u0002\u0013/\u0001\u00041\u0003b\u0002\u001c\u0001\u0001\u0004%\taN\u0001\u000fi>$\u0018\r\\\"pe\u0016\u001cu.\u001e8u+\u0005A\u0004CA\u001dC\u001b\u0005Q$BA\u001e=\u0003\u0019\tGo\\7jG*\u0011QHP\u0001\u000bG>t7-\u001e:sK:$(BA A\u0003\u0011)H/\u001b7\u000b\u0003\u0005\u000bAA[1wC&\u00111I\u000f\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\t\u000f\u0015\u0003\u0001\u0019!C\u0001\r\u0006\u0011Bo\u001c;bY\u000e{'/Z\"pk:$x\fJ3r)\t9%\n\u0005\u0002\u000f\u0011&\u0011\u0011j\u0004\u0002\u0005+:LG\u000fC\u0004L\t\u0006\u0005\t\u0019\u0001\u001d\u0002\u0007a$\u0013\u0007\u0003\u0004N\u0001\u0001\u0006K\u0001O\u0001\u0010i>$\u0018\r\\\"pe\u0016\u001cu.\u001e8uA!9q\n\u0001a\u0001\n\u00039\u0014\u0001\u0007;pi\u0006d'+Z4jgR,'/\u001a3Fq\u0016\u001cW\u000f^8sg\"9\u0011\u000b\u0001a\u0001\n\u0003\u0011\u0016\u0001\b;pi\u0006d'+Z4jgR,'/\u001a3Fq\u0016\u001cW\u000f^8sg~#S-\u001d\u000b\u0003\u000fNCqa\u0013)\u0002\u0002\u0003\u0007\u0001\b\u0003\u0004V\u0001\u0001\u0006K\u0001O\u0001\u001ai>$\u0018\r\u001c*fO&\u001cH/\u001a:fI\u0016CXmY;u_J\u001c\b\u0005C\u0004X\u0001\t\u0007I\u0011\u0001-\u0002\t\r|gNZ\u000b\u00023B\u0011ACW\u0005\u00037\u001a\u0011\u0011b\u00159be.\u001cuN\u001c4\t\ru\u0003\u0001\u0015!\u0003Z\u0003\u0015\u0019wN\u001c4!\u0011\u001dy\u0006A1A\u0005\n\u0001\fQ\"Y6lC\u001a\u0013\u0018-\\3TSj,W#A1\u0011\u00059\u0011\u0017BA2\u0010\u0005\rIe\u000e\u001e\u0005\u0007K\u0002\u0001\u000b\u0011B1\u0002\u001d\u0005\\7.\u0019$sC6,7+\u001b>fA!9q\r\u0001a\u0001\n\u0003A\u0017AE7j]J+w-[:uKJ,GMU1uS>,\u0012!\u001b\t\u0003\u001d)L!a[\b\u0003\r\u0011{WO\u00197f\u0011\u001di\u0007\u00011A\u0005\u00029\fa#\\5o%\u0016<\u0017n\u001d;fe\u0016$'+\u0019;j_~#S-\u001d\u000b\u0003\u000f>Dqa\u00137\u0002\u0002\u0003\u0007\u0011\u000e\u0003\u0004r\u0001\u0001\u0006K![\u0001\u0014[&t'+Z4jgR,'/\u001a3SCRLw\u000e\t\u0005\bg\u0002\u0011\r\u0011\"\u0001u\u0003ii\u0017\r\u001f*fO&\u001cH/\u001a:fI^\u000b\u0017\u000e^5oORKW.Z't+\u0005)\bC\u0001\bw\u0013\t9xB\u0001\u0003M_:<\u0007BB=\u0001A\u0003%Q/A\u000enCb\u0014VmZ5ti\u0016\u0014X\rZ,bSRLgn\u001a+j[\u0016l5\u000f\t\u0005\bw\u0002\u0011\r\u0011\"\u0001u\u0003)\u0019'/Z1uKRKW.\u001a\u0005\u0007{\u0002\u0001\u000b\u0011B;\u0002\u0017\r\u0014X-\u0019;f)&lW\r\t\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002\u0005yQ\r_3dkR|'\u000fR1uC6\u000b\u0007/\u0006\u0002\u0002\u0004AA\u0011QAA\b\u0003'\t\t#\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003\u001diW\u000f^1cY\u0016T1!!\u0004\u0010\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003#\t9AA\u0004ICNDW*\u00199\u0011\t\u0005U\u00111\u0004\b\u0004\u001d\u0005]\u0011bAA\r\u001f\u00051\u0001K]3eK\u001aLA!!\b\u0002 \t11\u000b\u001e:j]\u001eT1!!\u0007\u0010!\r\u0011\u00141E\u0005\u0004\u0003K\u0011!\u0001D#yK\u000e,Ho\u001c:ECR\f\u0007\u0002CA\u0015\u0001\u0001\u0006I!a\u0001\u0002!\u0015DXmY;u_J$\u0015\r^1NCB\u0004\u0003\u0002CA\u0017\u0001\u0001\u0007I\u0011\u00021\u0002'9,X\u000eU3oI&tw-\u0012=fGV$xN]:\t\u0013\u0005E\u0002\u00011A\u0005\n\u0005M\u0012a\u00068v[B+g\u000eZ5oO\u0016CXmY;u_J\u001cx\fJ3r)\r9\u0015Q\u0007\u0005\t\u0017\u0006=\u0012\u0011!a\u0001C\"9\u0011\u0011\b\u0001!B\u0013\t\u0017\u0001\u00068v[B+g\u000eZ5oO\u0016CXmY;u_J\u001c\b\u0005C\u0005\u0002>\u0001\u0011\r\u0011\"\u0003\u0002@\u0005YA.[:uK:,'OQ;t+\t\t\t\u0005E\u0002\u0019\u0003\u0007J1!!\u0012\u0005\u0005=a\u0015N^3MSN$XM\\3s\u0005V\u001c\b\u0002CA%\u0001\u0001\u0006I!!\u0011\u0002\u00191L7\u000f^3oKJ\u0014Uo\u001d\u0011\t\u0013\u00055\u0003A1A\u0005\n\u0005=\u0013\u0001G3yK\u000e,Ho\u001c:t!\u0016tG-\u001b8h)>\u0014V-\\8wKV\u0011\u0011\u0011\u000b\t\u0007\u0003\u000b\t\u0019&a\u0005\n\t\u0005U\u0013q\u0001\u0002\b\u0011\u0006\u001c\bnU3u\u0011!\tI\u0006\u0001Q\u0001\n\u0005E\u0013!G3yK\u000e,Ho\u001c:t!\u0016tG-\u001b8h)>\u0014V-\\8wK\u0002B\u0011\"!\u0018\u0001\u0001\u0004%\t\"a\u0018\u0002)!|7\u000f\u001e+p\u0019>\u001c\u0017\r\u001c+bg.\u001cu.\u001e8u+\t\t\t\u0007E\u0004\u0002\u0016\u0005\r\u00141C1\n\t\u0005\u0015\u0014q\u0004\u0002\u0004\u001b\u0006\u0004\b\"CA5\u0001\u0001\u0007I\u0011CA6\u0003aAwn\u001d;U_2{7-\u00197UCN\\7i\\;oi~#S-\u001d\u000b\u0004\u000f\u00065\u0004\"C&\u0002h\u0005\u0005\t\u0019AA1\u0011!\t\t\b\u0001Q!\n\u0005\u0005\u0014!\u00065pgR$v\u000eT8dC2$\u0016m]6D_VtG\u000f\t\u0005\t\u0003k\u0002\u0001\u0019!C\tA\u0006\u0011Bn\\2bY&$\u00180Q<be\u0016$\u0016m]6t\u0011%\tI\b\u0001a\u0001\n#\tY(\u0001\fm_\u000e\fG.\u001b;z\u0003^\f'/\u001a+bg.\u001cx\fJ3r)\r9\u0015Q\u0010\u0005\t\u0017\u0006]\u0014\u0011!a\u0001C\"9\u0011\u0011\u0011\u0001!B\u0013\t\u0017a\u00057pG\u0006d\u0017\u000e^=Bo\u0006\u0014X\rV1tWN\u0004cABAC\u0001\u0001\t9I\u0001\bEe&4XM]#oIB|\u0017N\u001c;\u0014\r\u0005\rU\"!#\u001c!\r9\u00131R\u0005\u0004\u0003\u001bC#!\u0006+ie\u0016\fGmU1gKJ\u00038-\u00128ea>Lg\u000e\u001e\u0005\nI\u0005\r%Q1A\u0005B\u0015B\u0011\"LAB\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u0017\u0005U\u00151\u0011B\u0001B\u0003%\u0011qS\u0001\u0010gB\f'o\u001b)s_B,'\u000f^5fgB1\u0011\u0011TAU\u0003_sA!a'\u0002&:!\u0011QTAR\u001b\t\tyJC\u0002\u0002\"~\ta\u0001\u0010:p_Rt\u0014\"\u0001\t\n\u0007\u0005\u001dv\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0016Q\u0016\u0002\u0004'\u0016\f(bAAT\u001fA9a\"!-\u0002\u0014\u0005M\u0011bAAZ\u001f\t1A+\u001e9mKJBqaLAB\t\u0003\t9\f\u0006\u0004\u0002:\u0006u\u0016q\u0018\t\u0005\u0003w\u000b\u0019)D\u0001\u0001\u0011\u0019!\u0013Q\u0017a\u0001M!A\u0011QSA[\u0001\u0004\t9\n\u0003\u0006\u0002D\u0006\r%\u0019!C\u0005\u0003\u000b\f1a]3s+\t\t9\r\u0005\u0003\u0002J\u0006=WBAAf\u0015\r\tiMB\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\u0002BAi\u0003\u0017\u0014!cU3sS\u0006d\u0017N_3s\u0013:\u001cH/\u00198dK\"I\u0011Q[ABA\u0003%\u0011qY\u0001\u0005g\u0016\u0014\b\u0005\u0003\u0005\u0002Z\u0006\rE\u0011KAn\u0003\rawnZ\u000b\u0003\u0003;\u0004B!a8\u0002f6\u0011\u0011\u0011\u001d\u0006\u0004\u0003GT\u0011!B:mMRR\u0017\u0002BAt\u0003C\u0014a\u0001T8hO\u0016\u0014\bBCAv\u0003\u0007\u0013\r\u0011\"\u0005\u0002n\u0006\u0019\u0012\r\u001a3sKN\u001cHk\\#yK\u000e,Ho\u001c:JIV\u0011\u0011q\u001e\t\t\u0003\u000b\ty!!=\u0002\u0014A\u0019q%a=\n\u0007\u0005U\bF\u0001\u0006Sa\u000e\fE\r\u001a:fgND\u0011\"!?\u0002\u0004\u0002\u0006I!a<\u0002)\u0005$GM]3tgR{W\t_3dkR|'/\u00133!\u0011)\ti0a!C\u0002\u0013%\u0011q`\u0001\re\u00164\u0018N^3UQJ,\u0017\rZ\u000b\u0003\u0005\u0003\u0001BAa\u0001\u0003\u00065\tA(C\u0002\u0003\bq\u0012\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011%\u0011Y!a!!\u0002\u0013\u0011\t!A\u0007sKZLg/\u001a+ie\u0016\fG\r\t\u0005\t\u0005\u001f\t\u0019\t\"\u0011\u0003\u0012\u00059qN\\*uCJ$H#A$\t\u0011\tU\u00111\u0011C!\u0005/\tqA]3dK&4X-\u0006\u0002\u0003\u001aA1aBa\u0007\u0003 \u001dK1A!\b\u0010\u0005=\u0001\u0016M\u001d;jC24UO\\2uS>t\u0007c\u0001\b\u0003\"%\u0019!1E\b\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0003(\u0005\rE\u0011\tB\u0015\u0003=\u0011XmY3jm\u0016\fe\u000e\u001a*fa2LH\u0003\u0002B\r\u0005WA\u0001B!\f\u0003&\u0001\u0007!qF\u0001\bG>tG/\u001a=u!\r9#\u0011G\u0005\u0004\u0005gA#A\u0004*qG\u000e\u000bG\u000e\\\"p]R,\u0007\u0010\u001e\u0005\t\u0005o\t\u0019\t\"\u0003\u0003\u0012\u0005QQ.Y6f\u001f\u001a4WM]:\t\u0011\tm\u00121\u0011C!\u0005{\tab\u001c8ESN\u001cwN\u001c8fGR,G\rF\u0002H\u0005\u007fA\u0001B!\u0011\u0003:\u0001\u0007\u0011\u0011_\u0001\u000ee\u0016lw\u000e^3BI\u0012\u0014Xm]:\t\u0011\t]\u00121\u0011C\u0005\u0005\u000b\"2a\u0012B$\u0011!\u0011IEa\u0011A\u0002\u0005M\u0011AC3yK\u000e,Ho\u001c:JI\"A!QJAB\t\u0013\u0011y%A\u0006mCVt7\r\u001b+bg.\u001cHcA$\u0003R!A!1\u000bB&\u0001\u0004\u0011)&A\u0003uCN\\7\u000f\u0005\u0004\u0002\u001a\u0006%&q\u000b\t\u0007\u00033\u000bIK!\u0017\u0011\u0007a\u0011Y&C\u0002\u0003^\u0011\u0011q\u0002V1tW\u0012+7o\u0019:jaRLwN\u001c\u0005\t\u0005C\n\u0019\t\"\u0001\u0003d\u0005q!/Z7pm\u0016,\u00050Z2vi>\u0014H#B$\u0003f\t\u001d\u0004\u0002\u0003B%\u0005?\u0002\r!a\u0005\t\u0011\t%$q\fa\u0001\u0005W\naA]3bg>t\u0007c\u0001\r\u0003n%\u0019!q\u000e\u0003\u0003%\u0015CXmY;u_Jdun]:SK\u0006\u001cxN\u001c\u0005\t\u0005g\n\u0019\t\"\u0011\u0003\u0012\u00051qN\\*u_BD\u0011Ba\u001e\u0001\u0001\u0004%\tA!\u001f\u0002\u001d\u0011\u0014\u0018N^3s\u000b:$\u0007o\\5oiV\u0011!1\u0010\t\u0004O\tu\u0014b\u0001B@Q\tq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0007\"\u0003BB\u0001\u0001\u0007I\u0011\u0001BC\u0003I!'/\u001b<fe\u0016sG\r]8j]R|F%Z9\u0015\u0007\u001d\u00139\tC\u0005L\u0005\u0003\u000b\t\u00111\u0001\u0003|!A!1\u0012\u0001!B\u0013\u0011Y(A\bee&4XM]#oIB|\u0017N\u001c;!\u0011%\u0011y\t\u0001b\u0001\n\u0003\u0011\t*\u0001\buCN\\\u0017\nZ:P]Nc\u0017M^3\u0016\u0005\tM\u0005\u0003CA\u0003\u0003\u001f\t\u0019\"!\u0015\t\u0011\t]\u0005\u0001)A\u0005\u0005'\u000bq\u0002^1tW&#7o\u00148TY\u00064X\r\t\u0005\b\u00057\u0003A\u0011\tB\t\u0003\u0015\u0019H/\u0019:u\u0011\u001d\u0011y\n\u0001C\t\u0005C\u000bAc\u0019:fCR,GI]5wKJ,e\u000e\u001a9pS:$H\u0003BA]\u0005GC\u0001B!*\u0003\u001e\u0002\u0007\u0011qS\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bb\u0002BU\u0001\u0011\u0005!\u0011C\u0001\u000egR|\u0007/\u0012=fGV$xN]:\t\u000f\t5\u0006\u0001\"\u0011\u0003\u0012\u0005!1\u000f^8q\u0011\u001d\u0011\t\f\u0001C!\u0005#\tAB]3wSZ,wJ\u001a4feNDqA!.\u0001\t\u0003\u00129,\u0001\u0005lS2dG+Y:l)\u001d9%\u0011\u0018B_\u0005\u007fCqAa/\u00034\u0002\u0007Q/\u0001\u0004uCN\\\u0017\n\u001a\u0005\t\u0005\u0013\u0012\u0019\f1\u0001\u0002\u0014!A!\u0011\u0019BZ\u0001\u0004\u0011\u0019-A\bj]R,'O];qiRC'/Z1e!\rq!QY\u0005\u0004\u0005\u000f|!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005\u0017\u0004A\u0011\tBg\u0003I!WMZ1vYR\u0004\u0016M]1mY\u0016d\u0017n]7\u0015\u0003\u0005DqA!\u0019\u0001\t\u0003\u0011\t\u000eF\u0003H\u0005'\u0014)\u000e\u0003\u0005\u0003J\t=\u0007\u0019AA\n\u0011!\u0011IGa4A\u0002\t-\u0004b\u0002Bm\u0001\u0011\u0005!1\\\u0001\u001egV4g-[2jK:$(+Z:pkJ\u001cWm\u001d*fO&\u001cH/\u001a:fIR\u0011!1\u0019\u0005\b\u0005?\u0004A\u0011\tBn\u0003\u001dI7OU3bIfDaAa9\u0001\t\u0003\u0001\u0017\u0001\u00068v[\u0016C\u0018n\u001d;j]\u001e,\u00050Z2vi>\u00148\u000fC\u0004\u0003h\u0002!)E!;\u0002!I,\u0017/^3ti\u0016CXmY;u_J\u001cH\u0003\u0002Bb\u0005WDqA!<\u0003f\u0002\u0007\u0011-\u0001\fok6\fE\rZ5uS>t\u0017\r\\#yK\u000e,Ho\u001c:t\u0011\u001d\u0011\t\u0010\u0001C#\u0005g\fQC]3rk\u0016\u001cH\u000fV8uC2,\u00050Z2vi>\u00148\u000f\u0006\u0005\u0003D\nU(\u0011 B~\u0011\u001d\u00119Pa<A\u0002\u0005\fAB\\;n\u000bb,7-\u001e;peNDq!!\u001e\u0003p\u0002\u0007\u0011\r\u0003\u0005\u0002^\t=\b\u0019AA1\u0011\u001d\u0011y\u0010\u0001C\t\u0007\u0003\tq\u0003Z8SKF,Xm\u001d;U_R\fG.\u0012=fGV$xN]:\u0015\t\t\r71\u0001\u0005\b\u0007\u000b\u0011i\u00101\u0001b\u00039\u0011X-];fgR,G\rV8uC2Dqa!\u0003\u0001\t\u000b\u001aY!A\u0007lS2dW\t_3dkR|'o\u001d\u000b\u0005\u0005\u0007\u001ci\u0001\u0003\u0005\u0004\u0010\r\u001d\u0001\u0019AB\t\u0003-)\u00070Z2vi>\u0014\u0018\nZ:\u0011\r\u0005e\u0015\u0011VA\n\u0011\u001d\u0019I\u0001\u0001C\u0003\u0007+!bAa1\u0004\u0018\re\u0001\u0002CB\b\u0007'\u0001\ra!\u0005\t\u0011\rm11\u0003a\u0001\u0005\u0007\fqA]3qY\u0006\u001cW\rC\u0004\u0004 \u0001!\tb!\t\u0002\u001f\u0011|7*\u001b7m\u000bb,7-\u001e;peN$BAa1\u0004$!A1qBB\u000f\u0001\u0004\u0019\tb\u0002\u0005\u0004(\tA\tABB\u0015\u0003u\u0019u.\u0019:tK\u001e\u0013\u0018-\u001b8fIN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0007c\u0001\u001a\u0004,\u00199\u0011A\u0001E\u0001\r\r52cAB\u0016\u001b!9qfa\u000b\u0005\u0002\rEBCAB\u0015\u0011)\u0019)da\u000bC\u0002\u0013\u00051qG\u0001\u000e\u000b:#\u0005kT%O)~s\u0015)T#\u0016\u0005\re\u0002\u0003BB\u001e\u0007\u0003j!a!\u0010\u000b\u0007\r}\u0002)\u0001\u0003mC:<\u0017\u0002BA\u000f\u0007{A\u0011b!\u0012\u0004,\u0001\u0006Ia!\u000f\u0002\u001d\u0015sE\tU(J\u001dR{f*Q'FA\u0001")
public class CoarseGrainedSchedulerBackend
implements ExecutorAllocationClient,
SchedulerBackend,
Logging {
    public final TaskSchedulerImpl org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler;
    private final RpcEnv rpcEnv;
    private AtomicInteger totalCoreCount;
    private AtomicInteger totalRegisteredExecutors;
    private final SparkConf conf;
    private final int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$akkaFrameSize;
    private double minRegisteredRatio;
    private final long maxRegisteredWaitingTimeMs;
    private final long createTime;
    private final HashMap<String, ExecutorData> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap;
    private int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors;
    private final LiveListenerBus org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus;
    private final HashSet<String> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove;
    private scala.collection.immutable.Map<String, Object> hostToLocalTaskCount;
    private int localityAwareTasks;
    private RpcEndpointRef driverEndpoint;
    private final HashMap<String, HashSet<String>> taskIdsOnSlave;
    private transient Logger org$apache$spark$Logging$$log_;
    private final String org$apache$spark$scheduler$SchedulerBackend$$appId;

    public static String ENDPOINT_NAME() {
        return CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public String org$apache$spark$scheduler$SchedulerBackend$$appId() {
        return this.org$apache$spark$scheduler$SchedulerBackend$$appId;
    }

    @Override
    public void org$apache$spark$scheduler$SchedulerBackend$_setter_$org$apache$spark$scheduler$SchedulerBackend$$appId_$eq(String x$1) {
        this.org$apache$spark$scheduler$SchedulerBackend$$appId = x$1;
    }

    @Override
    public String applicationId() {
        return SchedulerBackend$class.applicationId(this);
    }

    @Override
    public Option<String> applicationAttemptId() {
        return SchedulerBackend$class.applicationAttemptId(this);
    }

    @Override
    public Option<scala.collection.immutable.Map<String, String>> getDriverLogUrls() {
        return SchedulerBackend$class.getDriverLogUrls(this);
    }

    @Override
    public boolean killExecutor(String executorId) {
        return ExecutorAllocationClient$class.killExecutor(this, executorId);
    }

    public RpcEnv rpcEnv() {
        return this.rpcEnv;
    }

    public AtomicInteger totalCoreCount() {
        return this.totalCoreCount;
    }

    public void totalCoreCount_$eq(AtomicInteger x$1) {
        this.totalCoreCount = x$1;
    }

    public AtomicInteger totalRegisteredExecutors() {
        return this.totalRegisteredExecutors;
    }

    public void totalRegisteredExecutors_$eq(AtomicInteger x$1) {
        this.totalRegisteredExecutors = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$akkaFrameSize() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$akkaFrameSize;
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    public void minRegisteredRatio_$eq(double x$1) {
        this.minRegisteredRatio = x$1;
    }

    public long maxRegisteredWaitingTimeMs() {
        return this.maxRegisteredWaitingTimeMs;
    }

    public long createTime() {
        return this.createTime;
    }

    public HashMap<String, ExecutorData> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap;
    }

    public int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors;
    }

    public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(int x$1) {
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors = x$1;
    }

    public LiveListenerBus org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus;
    }

    public HashSet<String> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove;
    }

    public scala.collection.immutable.Map<String, Object> hostToLocalTaskCount() {
        return this.hostToLocalTaskCount;
    }

    public void hostToLocalTaskCount_$eq(scala.collection.immutable.Map<String, Object> x$1) {
        this.hostToLocalTaskCount = x$1;
    }

    public int localityAwareTasks() {
        return this.localityAwareTasks;
    }

    public void localityAwareTasks_$eq(int x$1) {
        this.localityAwareTasks = x$1;
    }

    public RpcEndpointRef driverEndpoint() {
        return this.driverEndpoint;
    }

    public void driverEndpoint_$eq(RpcEndpointRef x$1) {
        this.driverEndpoint = x$1;
    }

    public HashMap<String, HashSet<String>> taskIdsOnSlave() {
        return this.taskIdsOnSlave;
    }

    @Override
    public void start() {
        ArrayBuffer properties = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.sc().conf().getAll()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$2) {
                Tuple2<String, String> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, properties){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer properties$1;

            public final Object apply(Tuple2<String, String> x$5) {
                Tuple2<String, String> tuple2 = x$5;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    BoxedUnit boxedUnit = key.startsWith("spark.") ? this.properties$1.$plus$eq((Object)new Tuple2((Object)key, (Object)value)) : BoxedUnit.UNIT;
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                this.properties$1 = properties$1;
            }
        });
        this.driverEndpoint_$eq(this.rpcEnv().setupEndpoint(CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME(), this.createDriverEndpoint((Seq<Tuple2<String, String>>)properties)));
    }

    public DriverEndpoint createDriverEndpoint(Seq<Tuple2<String, String>> properties) {
        return new DriverEndpoint(this, this.rpcEnv(), properties);
    }

    public void stopExecutors() {
        try {
            if (this.driverEndpoint() != null) {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Shutting down all executors";
                    }
                });
                this.driverEndpoint().askWithRetry(CoarseGrainedClusterMessages$StopExecutors$.MODULE$, ClassTag$.MODULE$.Boolean());
            }
            return;
        }
        catch (Exception exception2) {
            throw new SparkException("Error asking standalone scheduler to shut down executors", exception2);
        }
    }

    @Override
    public void stop() {
        this.stopExecutors();
        try {
            if (this.driverEndpoint() != null) {
                this.driverEndpoint().askWithRetry(CoarseGrainedClusterMessages$StopDriver$.MODULE$, ClassTag$.MODULE$.Boolean());
            }
            return;
        }
        catch (Exception exception2) {
            throw new SparkException("Error stopping standalone scheduler's driver endpoint", exception2);
        }
    }

    @Override
    public void reviveOffers() {
        this.driverEndpoint().send(CoarseGrainedClusterMessages$ReviveOffers$.MODULE$);
    }

    @Override
    public void killTask(long taskId, String executorId, boolean interruptThread) {
        this.driverEndpoint().send(new CoarseGrainedClusterMessages.KillTask(taskId, executorId, interruptThread));
    }

    @Override
    public int defaultParallelism() {
        return this.conf().getInt("spark.default.parallelism", package$.MODULE$.max(this.totalCoreCount().get(), 2));
    }

    public void removeExecutor(String executorId, ExecutorLossReason reason) {
        try {
            this.driverEndpoint().askWithRetry(new CoarseGrainedClusterMessages.RemoveExecutor(executorId, reason), ClassTag$.MODULE$.Boolean());
            return;
        }
        catch (Exception exception2) {
            throw new SparkException("Error notifying standalone scheduler's driver endpoint", exception2);
        }
    }

    public boolean sufficientResourcesRegistered() {
        return true;
    }

    @Override
    public boolean isReady() {
        if (this.sufficientResourcesRegistered()) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"SchedulerBackend is ready for scheduling beginning after ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reached minRegisteredResourcesRatio: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.minRegisteredRatio())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            return true;
        }
        if (System.currentTimeMillis() - this.createTime() >= this.maxRegisteredWaitingTimeMs()) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"SchedulerBackend is ready for scheduling beginning after waiting ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxRegisteredResourcesWaitingTime: ", "(ms)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.maxRegisteredWaitingTimeMs())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            return true;
        }
        return false;
    }

    public int numExistingExecutors() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().size();
    }

    @Override
    public final synchronized boolean requestExecutors(int numAdditionalExecutors) {
        if (numAdditionalExecutors < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Attempted to request a negative number of additional executor(s) ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " from the cluster manager. Please specify a positive number!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numAdditionalExecutors)}))).toString());
        }
        this.logInfo((Function0<String>)new Serializable(this, numAdditionalExecutors){
            public static final long serialVersionUID = 0L;
            private final int numAdditionalExecutors$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requesting ", " additional executor(s) from the cluster manager"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numAdditionalExecutors$1)}));
            }
            {
                this.numAdditionalExecutors$1 = numAdditionalExecutors$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of pending executors is now ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() + numAdditionalExecutors);
        int newTotal = this.numExistingExecutors() + this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() - this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().size();
        return this.doRequestTotalExecutors(newTotal);
    }

    @Override
    public final synchronized boolean requestTotalExecutors(int numExecutors, int localityAwareTasks, scala.collection.immutable.Map<String, Object> hostToLocalTaskCount) {
        if (numExecutors < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Attempted to request a negative number of executor(s) ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " from the cluster manager. Please specify a positive number!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numExecutors)}))).toString());
        }
        this.localityAwareTasks_$eq(localityAwareTasks);
        this.hostToLocalTaskCount_$eq(hostToLocalTaskCount);
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(package$.MODULE$.max(numExecutors - this.numExistingExecutors() + this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().size(), 0));
        return this.doRequestTotalExecutors(numExecutors);
    }

    public boolean doRequestTotalExecutors(int requestedTotal) {
        return false;
    }

    @Override
    public final synchronized boolean killExecutors(Seq<String> executorIds) {
        return this.killExecutors(executorIds, false);
    }

    public final synchronized boolean killExecutors(Seq<String> executorIds, boolean replace) {
        this.logInfo((Function0<String>)new Serializable(this, executorIds){
            public static final long serialVersionUID = 0L;
            private final Seq executorIds$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requesting to kill executor(s) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorIds$1.mkString(", ")}));
            }
            {
                this.executorIds$1 = executorIds$1;
            }
        });
        Tuple2 tuple2 = executorIds.partition((Function1)new $anonfun$3(this));
        if (tuple2 != null) {
            Object object;
            Tuple2 tuple22;
            Seq knownExecutors = (Seq)tuple2._1();
            Seq unknownExecutors = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)knownExecutors, (Object)unknownExecutors);
            Seq knownExecutors2 = (Seq)tuple23._1();
            Seq unknownExecutors2 = (Seq)tuple23._2();
            unknownExecutors2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

                public final void apply(String id) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this, id){
                        public static final long serialVersionUID = 0L;
                        private final String id$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executor to kill ", " does not exist!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id$1}));
                        }
                        {
                            this.id$1 = id$1;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Seq executorsToKill = (Seq)knownExecutors2.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

                public final boolean apply(String id) {
                    return !this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().contains((Object)id);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().$plus$plus$eq((TraversableOnce)executorsToKill);
            if (replace) {
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() + knownExecutors2.size());
                object = BoxedUnit.UNIT;
            } else {
                object = BoxesRunTime.boxToBoolean((boolean)this.doRequestTotalExecutors(this.numExistingExecutors() + this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() - this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().size()));
            }
            return this.doKillExecutors((Seq<String>)executorsToKill);
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean doKillExecutors(Seq<String> executorIds) {
        return false;
    }

    public CoarseGrainedSchedulerBackend(TaskSchedulerImpl scheduler, RpcEnv rpcEnv) {
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler = scheduler;
        this.rpcEnv = rpcEnv;
        ExecutorAllocationClient$class.$init$(this);
        SchedulerBackend$class.$init$(this);
        Logging$class.$init$(this);
        this.totalCoreCount = new AtomicInteger(0);
        this.totalRegisteredExecutors = new AtomicInteger(0);
        this.conf = scheduler.sc().conf();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$akkaFrameSize = AkkaUtils$.MODULE$.maxFrameSizeBytes(this.conf());
        this.minRegisteredRatio = package$.MODULE$.min(1.0, this.conf().getDouble("spark.scheduler.minRegisteredResourcesRatio", 0.0));
        this.maxRegisteredWaitingTimeMs = this.conf().getTimeAsMs("spark.scheduler.maxRegisteredResourcesWaitingTime", "30s");
        this.createTime = System.currentTimeMillis();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap = new HashMap();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors = 0;
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus = scheduler.sc().listenerBus();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove = new HashSet();
        this.hostToLocalTaskCount = Predef$.MODULE$.Map().empty();
        this.localityAwareTasks = 0;
        this.driverEndpoint = null;
        this.taskIdsOnSlave = new HashMap();
    }

    public class DriverEndpoint
    implements ThreadSafeRpcEndpoint,
    Logging {
        private final RpcEnv rpcEnv;
        public final Seq<Tuple2<String, String>> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$sparkProperties;
        private final SerializerInstance org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser;
        private final HashMap<RpcAddress, String> addressToExecutorId;
        private final ScheduledExecutorService reviveThread;
        public final /* synthetic */ CoarseGrainedSchedulerBackend $outer;
        private transient Logger org$apache$spark$Logging$$log_;

        @Override
        public Logger org$apache$spark$Logging$$log_() {
            return this.org$apache$spark$Logging$$log_;
        }

        @Override
        @TraitSetter
        public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$Logging$$log_ = x$1;
        }

        @Override
        public String logName() {
            return Logging$class.logName(this);
        }

        @Override
        public void logInfo(Function0<String> msg) {
            Logging$class.logInfo(this, msg);
        }

        @Override
        public void logDebug(Function0<String> msg) {
            Logging$class.logDebug(this, msg);
        }

        @Override
        public void logTrace(Function0<String> msg) {
            Logging$class.logTrace(this, msg);
        }

        @Override
        public void logWarning(Function0<String> msg) {
            Logging$class.logWarning(this, msg);
        }

        @Override
        public void logError(Function0<String> msg) {
            Logging$class.logError(this, msg);
        }

        @Override
        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging$class.logInfo(this, msg, throwable);
        }

        @Override
        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging$class.logDebug(this, msg, throwable);
        }

        @Override
        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging$class.logTrace(this, msg, throwable);
        }

        @Override
        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging$class.logWarning(this, msg, throwable);
        }

        @Override
        public void logError(Function0<String> msg, Throwable throwable) {
            Logging$class.logError(this, msg, throwable);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging$class.isTraceEnabled(this);
        }

        @Override
        public final RpcEndpointRef self() {
            return RpcEndpoint$class.self(this);
        }

        @Override
        public void onError(Throwable cause) {
            RpcEndpoint$class.onError(this, cause);
        }

        @Override
        public void onConnected(RpcAddress remoteAddress) {
            RpcEndpoint$class.onConnected(this, remoteAddress);
        }

        @Override
        public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
            RpcEndpoint$class.onNetworkError(this, cause, remoteAddress);
        }

        @Override
        public final void stop() {
            RpcEndpoint$class.stop(this);
        }

        @Override
        public RpcEnv rpcEnv() {
            return this.rpcEnv;
        }

        public SerializerInstance org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser() {
            return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser;
        }

        @Override
        public Logger log() {
            return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().log();
        }

        public HashMap<RpcAddress, String> addressToExecutorId() {
            return this.addressToExecutorId;
        }

        private ScheduledExecutorService reviveThread() {
            return this.reviveThread;
        }

        @Override
        public void onStart() {
            long reviveIntervalMs = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().conf().getTimeAsMs("spark.scheduler.revive.interval", "1s");
            this.reviveThread().scheduleAtFixedRate(new Runnable(this){
                private final /* synthetic */ DriverEndpoint $outer;

                public void run() {
                    Utils$.MODULE$.tryLogNonFatalError((Function0<BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DriverEndpoint$$anon$1 $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            Option$.MODULE$.apply((Object)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anon$$$outer().self()).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(RpcEndpointRef x$1) {
                                    x$1.send(CoarseGrainedClusterMessages$ReviveOffers$.MODULE$);
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ DriverEndpoint org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anon$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, 0L, reviveIntervalMs, TimeUnit.MILLISECONDS);
        }

        @Override
        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    void var10_19;
                    A1 A1 = x1;
                    if (A1 instanceof CoarseGrainedClusterMessages.StatusUpdate) {
                        BoxedUnit boxedUnit;
                        CoarseGrainedClusterMessages.StatusUpdate statusUpdate2 = (CoarseGrainedClusterMessages.StatusUpdate)A1;
                        String executorId = statusUpdate2.executorId();
                        long taskId = statusUpdate2.taskId();
                        Enumeration.Value state = statusUpdate2.state();
                        SerializableBuffer data = statusUpdate2.data();
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.statusUpdate(taskId, state, data.value());
                        if (TaskState$.MODULE$.isFinished(state)) {
                            Option option = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId);
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                ExecutorData executorInfo = (ExecutorData)some.x();
                                executorInfo.freeCores_$eq(executorInfo.freeCores() + this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.CPUS_PER_TASK());
                                this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers(executorId);
                                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                            } else {
                                None$ none$ = None$.MODULE$;
                                Option option2 = option;
                                if (none$ != null ? !none$.equals(option2) : option2 != null) throw new MatchError((Object)option);
                                this.$outer.logWarning((Function0<String>)new Serializable(this, executorId, taskId, state){
                                    public static final long serialVersionUID = 0L;
                                    private final String executorId$1;
                                    private final long taskId$1;
                                    private final Enumeration.Value state$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored task status update (", " state ", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.taskId$1), this.state$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from unknown executor with ID ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$1}))).toString();
                                    }
                                    {
                                        this.executorId$1 = executorId$1;
                                        this.taskId$1 = taskId$1;
                                        this.state$1 = state$1;
                                    }
                                });
                                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                            }
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit4 = boxedUnit;
                        return var10_19;
                    } else {
                        CoarseGrainedClusterMessages$ReviveOffers$ coarseGrainedClusterMessages$ReviveOffers$ = CoarseGrainedClusterMessages$ReviveOffers$.MODULE$;
                        A1 A12 = A1;
                        if (!(coarseGrainedClusterMessages$ReviveOffers$ != null ? !coarseGrainedClusterMessages$ReviveOffers$.equals(A12) : A12 != null)) {
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return var10_19;
                        } else if (A1 instanceof CoarseGrainedClusterMessages.KillTask) {
                            CoarseGrainedClusterMessages.KillTask killTask2 = (CoarseGrainedClusterMessages.KillTask)A1;
                            long taskId = killTask2.taskId();
                            String executorId = killTask2.executor();
                            boolean interruptThread = killTask2.interruptThread();
                            Option option = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId);
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                ExecutorData executorInfo = (ExecutorData)some.x();
                                executorInfo.executorEndpoint().send(new CoarseGrainedClusterMessages.KillTask(taskId, executorId, interruptThread));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                None$ none$ = None$.MODULE$;
                                Option option3 = option;
                                if (none$ != null ? !none$.equals(option3) : option3 != null) throw new MatchError((Object)option);
                                this.$outer.logWarning((Function0<String>)new Serializable(this, taskId, executorId){
                                    public static final long serialVersionUID = 0L;
                                    private final long taskId$2;
                                    private final String executorId$2;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to kill task ", " for unknown executor ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.taskId$2), this.executorId$2}));
                                    }
                                    {
                                        this.taskId$2 = taskId$2;
                                        this.executorId$2 = executorId$2;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return var10_19;
                        } else {
                            Object object = function1.apply(x1);
                        }
                    }
                    return var10_19;
                }

                public final boolean isDefinedAt(Object x1) {
                    boolean bl;
                    Object object = x1;
                    if (object instanceof CoarseGrainedClusterMessages.StatusUpdate) {
                        bl = true;
                    } else {
                        CoarseGrainedClusterMessages$ReviveOffers$ coarseGrainedClusterMessages$ReviveOffers$ = CoarseGrainedClusterMessages$ReviveOffers$.MODULE$;
                        Object object2 = object;
                        bl = !(coarseGrainedClusterMessages$ReviveOffers$ != null ? !coarseGrainedClusterMessages$ReviveOffers$.equals(object2) : object2 != null) ? true : object instanceof CoarseGrainedClusterMessages.KillTask;
                    }
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            };
        }

        @Override
        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return new Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;
                private final RpcCallContext context$1;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof CoarseGrainedClusterMessages.RegisterExecutor) {
                        BoxedUnit boxedUnit;
                        CoarseGrainedClusterMessages.RegisterExecutor registerExecutor = (CoarseGrainedClusterMessages.RegisterExecutor)A1;
                        String executorId = registerExecutor.executorId();
                        RpcEndpointRef executorRef = registerExecutor.executorRef();
                        int cores = registerExecutor.cores();
                        scala.collection.immutable.Map<String, String> logUrls = registerExecutor.logUrls();
                        if (this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().contains((Object)executorId)) {
                            this.context$1.reply(new CoarseGrainedClusterMessages.RegisterExecutorFailed(new StringBuilder().append((Object)"Duplicate executor ID: ").append((Object)executorId).toString()));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            RpcAddress executorAddress = executorRef.address() == null ? this.context$1.senderAddress() : executorRef.address();
                            this.$outer.logInfo((Function0<String>)new Serializable(this, executorId, executorRef, executorAddress){
                                public static final long serialVersionUID = 0L;
                                private final String executorId$3;
                                private final RpcEndpointRef executorRef$1;
                                private final RpcAddress executorAddress$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registered executor ", " (", ") with ID ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorRef$1, this.executorAddress$1, this.executorId$3}));
                                }
                                {
                                    this.executorId$3 = executorId$3;
                                    this.executorRef$1 = executorRef$1;
                                    this.executorAddress$1 = executorAddress$1;
                                }
                            });
                            this.$outer.addressToExecutorId().update((Object)executorAddress, (Object)executorId);
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalCoreCount().addAndGet(cores);
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalRegisteredExecutors().addAndGet(1);
                            ExecutorData data = new ExecutorData(executorRef, executorRef.address(), executorAddress.host(), cores, cores, logUrls);
                            CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer();
                            synchronized (coarseGrainedSchedulerBackend) {
                                BoxedUnit boxedUnit2;
                                this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().put((Object)executorId, (Object)data);
                                if (this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() > 0) {
                                    this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() - 1);
                                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ DriverEndpoint$$anonfun$receiveAndReply$1 $outer;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Decremented number of pending executors (", " left)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors())}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 9, 11] lbl31 : MonitorExitStatement: MONITOREXIT : coarseGrainedSchedulerBackend
                                this.context$1.reply(new CoarseGrainedClusterMessages.RegisteredExecutor(executorAddress.host()));
                            }
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus().post(new SparkListenerExecutorAdded(System.currentTimeMillis(), executorId, data));
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers();
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = boxedUnit;
                        return (B1)object;
                    }
                    CoarseGrainedClusterMessages$StopDriver$ coarseGrainedClusterMessages$StopDriver$ = CoarseGrainedClusterMessages$StopDriver$.MODULE$;
                    A1 A12 = A1;
                    if (!(coarseGrainedClusterMessages$StopDriver$ != null ? !coarseGrainedClusterMessages$StopDriver$.equals(A12) : A12 != null)) {
                        this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                        this.$outer.stop();
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    CoarseGrainedClusterMessages$StopExecutors$ coarseGrainedClusterMessages$StopExecutors$ = CoarseGrainedClusterMessages$StopExecutors$.MODULE$;
                    A1 A13 = A1;
                    if (!(coarseGrainedClusterMessages$StopExecutors$ != null ? !coarseGrainedClusterMessages$StopExecutors$.equals(A13) : A13 != null)) {
                        this.$outer.logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Asking each executor to shut down";
                            }
                        });
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<String, ExecutorData> check$ifrefutable$1) {
                                Tuple2<String, ExecutorData> tuple2 = check$ifrefutable$1;
                                boolean bl = tuple2 != null;
                                return bl;
                            }
                        }).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Tuple2<String, ExecutorData> x$2) {
                                Tuple2<String, ExecutorData> tuple2 = x$2;
                                if (tuple2 != null) {
                                    ExecutorData executorData = (ExecutorData)tuple2._2();
                                    executorData.executorEndpoint().send(CoarseGrainedClusterMessages$StopExecutor$.MODULE$);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                        });
                        this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    if (A1 instanceof CoarseGrainedClusterMessages.RemoveExecutor) {
                        CoarseGrainedClusterMessages.RemoveExecutor removeExecutor2 = (CoarseGrainedClusterMessages.RemoveExecutor)A1;
                        String executorId = removeExecutor2.executorId();
                        ExecutorLossReason reason = removeExecutor2.reason();
                        this.$outer.removeExecutor(executorId, reason);
                        this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    CoarseGrainedClusterMessages$RetrieveSparkProps$ coarseGrainedClusterMessages$RetrieveSparkProps$ = CoarseGrainedClusterMessages$RetrieveSparkProps$.MODULE$;
                    A1 A14 = A1;
                    if (!(coarseGrainedClusterMessages$RetrieveSparkProps$ != null ? !coarseGrainedClusterMessages$RetrieveSparkProps$.equals(A14) : A14 != null)) {
                        this.context$1.reply(this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$sparkProperties);
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    object = function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x2) {
                    boolean bl;
                    Object object = x2;
                    if (object instanceof CoarseGrainedClusterMessages.RegisterExecutor) {
                        bl = true;
                    } else {
                        CoarseGrainedClusterMessages$StopDriver$ coarseGrainedClusterMessages$StopDriver$ = CoarseGrainedClusterMessages$StopDriver$.MODULE$;
                        Object object2 = object;
                        if (!(coarseGrainedClusterMessages$StopDriver$ != null ? !coarseGrainedClusterMessages$StopDriver$.equals(object2) : object2 != null)) {
                            bl = true;
                        } else {
                            CoarseGrainedClusterMessages$StopExecutors$ coarseGrainedClusterMessages$StopExecutors$ = CoarseGrainedClusterMessages$StopExecutors$.MODULE$;
                            Object object3 = object;
                            if (!(coarseGrainedClusterMessages$StopExecutors$ != null ? !coarseGrainedClusterMessages$StopExecutors$.equals(object3) : object3 != null)) {
                                bl = true;
                            } else if (object instanceof CoarseGrainedClusterMessages.RemoveExecutor) {
                                bl = true;
                            } else {
                                CoarseGrainedClusterMessages$RetrieveSparkProps$ coarseGrainedClusterMessages$RetrieveSparkProps$ = CoarseGrainedClusterMessages$RetrieveSparkProps$.MODULE$;
                                Object object4 = object;
                                bl = !(coarseGrainedClusterMessages$RetrieveSparkProps$ != null ? !coarseGrainedClusterMessages$RetrieveSparkProps$.equals(object4) : object4 != null);
                            }
                        }
                    }
                    return bl;
                }

                public /* synthetic */ DriverEndpoint org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }
            };
        }

        public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers() {
            Map activeExecutors = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().filterKeys((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;

                public final boolean apply(String x$3) {
                    return !this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().contains((Object)x$3);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            Seq workOffers = ((TraversableOnce)activeExecutors.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final WorkerOffer apply(Tuple2<String, ExecutorData> x0$1) {
                    Tuple2<String, ExecutorData> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String id = (String)tuple2._1();
                        ExecutorData executorData = (ExecutorData)tuple2._2();
                        WorkerOffer workerOffer = new WorkerOffer(id, executorData.executorHost(), executorData.freeCores());
                        return workerOffer;
                    }
                    throw new MatchError(tuple2);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.launchTasks(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.resourceOffers((Seq<WorkerOffer>)workOffers));
        }

        @Override
        public void onDisconnected(RpcAddress remoteAddress) {
            this.addressToExecutorId().get((Object)remoteAddress).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;

                public final void apply(String x$4) {
                    this.$outer.removeExecutor(x$4, new SlaveLost("remote Rpc client disassociated"));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers(String executorId) {
            if (!this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().contains((Object)executorId)) {
                ExecutorData executorData = (ExecutorData)this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().apply((Object)executorId);
                Seq workOffers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WorkerOffer[]{new WorkerOffer(executorId, executorData.executorHost(), executorData.freeCores())}));
                this.launchTasks(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.resourceOffers((Seq<WorkerOffer>)workOffers));
            }
        }

        private void launchTasks(Seq<Seq<TaskDescription>> tasks) {
            ((IterableLike)tasks.flatten((Function1)Predef$.MODULE$.conforms())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;

                public final void apply(TaskDescription task) {
                    ByteBuffer serializedTask = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser().serialize(task, ClassTag$.MODULE$.apply(TaskDescription.class));
                    if (serializedTask.limit() >= this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$akkaFrameSize() - AkkaUtils$.MODULE$.reservedSizeBytes()) {
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.taskIdToTaskSetManager().get((Object)BoxesRunTime.boxToLong((long)task.taskId())).foreach((Function1)new Serializable(this, task, serializedTask){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ DriverEndpoint$$anonfun$launchTasks$1 $outer;
                            private final TaskDescription task$1;
                            private final ByteBuffer serializedTask$1;

                            public final void apply(TaskSetManager taskSetMgr) {
                                try {
                                    String msg = "Serialized task %s:%d was %d bytes, which exceeds max allowed: spark.akka.frameSize (%d bytes) - reserved (%d bytes). Consider increasing spark.akka.frameSize or using broadcast variables for large values.";
                                    msg = new StringOps(Predef$.MODULE$.augmentString(msg)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.task$1.taskId()), BoxesRunTime.boxToInteger((int)this.task$1.index()), BoxesRunTime.boxToInteger((int)this.serializedTask$1.limit()), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$akkaFrameSize()), BoxesRunTime.boxToInteger((int)AkkaUtils$.MODULE$.reservedSizeBytes())}));
                                    taskSetMgr.abort(msg, taskSetMgr.abort$default$2());
                                }
                                catch (Exception exception2) {
                                    this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer().logError((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "Exception in error callback";
                                        }
                                    }, exception2);
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.task$1 = task$1;
                                this.serializedTask$1 = serializedTask$1;
                            }
                        });
                    } else {
                        ExecutorData executorData = (ExecutorData)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().apply((Object)task.executorId());
                        executorData.freeCores_$eq(executorData.freeCores() - this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.CPUS_PER_TASK());
                        executorData.executorEndpoint().send(new CoarseGrainedClusterMessages.LaunchTask(new SerializableBuffer(serializedTask)));
                    }
                }

                public /* synthetic */ DriverEndpoint org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void removeExecutor(String executorId, ExecutorLossReason reason) {
            Option option = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId);
            if (option instanceof Some) {
                Some some = (Some)option;
                ExecutorData executorInfo = (ExecutorData)some.x();
                CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer();
                synchronized (coarseGrainedSchedulerBackend) {
                    this.addressToExecutorId().$minus$eq((Object)executorInfo.executorAddress());
                    this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().$minus$eq((Object)executorId);
                    this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().$minus$eq((Object)executorId);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl14 : MonitorExitStatement: MONITOREXIT : coarseGrainedSchedulerBackend
                    this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalCoreCount().addAndGet(-executorInfo.totalCores());
                }
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalRegisteredExecutors().addAndGet(-1);
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.executorLost(executorId, reason);
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus().post(new SparkListenerExecutorRemoved(System.currentTimeMillis(), executorId, reason.toString()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            None$ none$ = None$.MODULE$;
            Option option2 = option;
            if (none$ == null) {
                if (option2 != null) {
                    throw new MatchError((Object)option);
                }
            } else if (!none$.equals(option2)) throw new MatchError((Object)option);
            this.logInfo((Function0<String>)new Serializable(this, executorId){
                public static final long serialVersionUID = 0L;
                private final String executorId$4;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Asked to remove non-existent executor ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$4}));
                }
                {
                    this.executorId$4 = executorId$4;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        @Override
        public void onStop() {
            this.reviveThread().shutdownNow();
        }

        public /* synthetic */ CoarseGrainedSchedulerBackend org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer() {
            return this.$outer;
        }

        public DriverEndpoint(CoarseGrainedSchedulerBackend $outer, RpcEnv rpcEnv, Seq<Tuple2<String, String>> sparkProperties) {
            this.rpcEnv = rpcEnv;
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$sparkProperties = sparkProperties;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            RpcEndpoint$class.$init$(this);
            Logging$class.$init$(this);
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser = SparkEnv$.MODULE$.get().closureSerializer().newInstance();
            this.addressToExecutorId = new HashMap();
            this.reviveThread = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("driver-revive-thread");
        }
    }
}

