/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.server.OneForOneStreamManager;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.netty.Dispatcher;
import org.apache.spark.rpc.netty.NettyRpcEnv;
import org.apache.spark.rpc.netty.RemoteProcessConnected;
import org.apache.spark.rpc.netty.RemoteProcessConnectionError;
import org.apache.spark.rpc.netty.RemoteProcessDisconnected;
import org.apache.spark.rpc.netty.RequestMessage;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001e4Q!\u0001\u0002\u0001\u00051\u0011qBT3uif\u0014\u0006o\u0019%b]\u0012dWM\u001d\u0006\u0003\u0007\u0011\tQA\\3uifT!!\u0002\u0004\u0002\u0007I\u00048M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\r\u0001Q\"\u0006\t\u0003\u001dMi\u0011a\u0004\u0006\u0003!E\taa]3sm\u0016\u0014(B\u0001\n\u0007\u0003\u001dqW\r^<pe.L!\u0001F\b\u0003\u0015I\u00038\rS1oI2,'\u000f\u0005\u0002\u0017/5\ta!\u0003\u0002\u0019\r\t9Aj\\4hS:<\u0007\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0015\u0011L7\u000f]1uG\",'o\u0001\u0001\u0011\u0005uqR\"\u0001\u0002\n\u0005}\u0011!A\u0003#jgB\fGo\u00195fe\"A\u0011\u0005\u0001B\u0001B\u0003%!%\u0001\u0005oKR$\u00180\u00128w!\ti2%\u0003\u0002%\u0005\tYa*\u001a;usJ\u00038-\u00128w\u0011\u00151\u0003\u0001\"\u0001(\u0003\u0019a\u0014N\\5u}Q\u0019\u0001&\u000b\u0016\u0011\u0005u\u0001\u0001\"\u0002\u000e&\u0001\u0004a\u0002\"B\u0011&\u0001\u0004\u0011\u0003b\u0002\u0017\u0001\u0005\u0004%I!L\u0001\bG2LWM\u001c;t+\u0005q\u0003\u0003B\u00187qyj\u0011\u0001\r\u0006\u0003cI\n!bY8oGV\u0014(/\u001a8u\u0015\t\u0019D'\u0001\u0003vi&d'\"A\u001b\u0002\t)\fg/Y\u0005\u0003oA\u0012\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\tID(D\u0001;\u0015\tY\u0014#\u0001\u0004dY&,g\u000e^\u0005\u0003{i\u0012q\u0002\u0016:b]N\u0004xN\u001d;DY&,g\u000e\u001e\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003R\nA\u0001\\1oO&\u00111\t\u0011\u0002\b\u0005>|G.Z1o\u0011\u0019)\u0005\u0001)A\u0005]\u0005A1\r\\5f]R\u001c\b\u0005C\u0003H\u0001\u0011\u0005\u0003*A\u0004sK\u000e,\u0017N^3\u0015\t%{\u0005\u000b\u0017\t\u0003\u00156k\u0011a\u0013\u0006\u0002\u0019\u0006)1oY1mC&\u0011aj\u0013\u0002\u0005+:LG\u000fC\u0003<\r\u0002\u0007\u0001\bC\u0003R\r\u0002\u0007!+A\u0004nKN\u001c\u0018mZ3\u0011\u0007)\u001bV+\u0003\u0002U\u0017\n)\u0011I\u001d:bsB\u0011!JV\u0005\u0003/.\u0013AAQ=uK\")\u0011L\u0012a\u00015\u0006A1-\u00197mE\u0006\u001c7\u000e\u0005\u0002:7&\u0011AL\u000f\u0002\u0014%B\u001c'+Z:q_:\u001cXmQ1mY\n\f7m\u001b\u0005\u0006=\u0002!\teX\u0001\u0011O\u0016$8\u000b\u001e:fC6l\u0015M\\1hKJ$\u0012\u0001\u0019\t\u0003\u001d\u0005L!AY\b\u0003\u001bM#(/Z1n\u001b\u0006t\u0017mZ3s\u0011\u0015!\u0007\u0001\"\u0011f\u0003=)\u0007pY3qi&|gnQ1vO\"$HcA%gi\")qm\u0019a\u0001Q\u0006)1-Y;tKB\u0011\u0011.\u001d\b\u0003U>t!a\u001b8\u000e\u00031T!!\\\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0015B\u00019L\u0003\u001d\u0001\u0018mY6bO\u0016L!A]:\u0003\u0013QC'o\\<bE2,'B\u00019L\u0011\u0015Y4\r1\u00019\u0011\u00151\b\u0001\"\u0011x\u0003Q\u0019wN\u001c8fGRLwN\u001c+fe6Lg.\u0019;fIR\u0011\u0011\n\u001f\u0005\u0006wU\u0004\r\u0001\u000f")
public class NettyRpcHandler
extends RpcHandler
implements Logging {
    private final Dispatcher dispatcher;
    private final NettyRpcEnv nettyEnv;
    private final ConcurrentHashMap<TransportClient, Boolean> clients;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private ConcurrentHashMap<TransportClient, Boolean> clients() {
        return this.clients;
    }

    public void receive(TransportClient client, byte[] message, RpcResponseCallback callback) {
        RequestMessage requestMessage;
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        Predef$.MODULE$.assert(addr != null);
        RpcAddress clientAddr = new RpcAddress(addr.getHostName(), addr.getPort());
        if (this.clients().putIfAbsent(client, Boolean.TRUE) == null) {
            this.dispatcher.postToAll(new RemoteProcessConnected(clientAddr));
        }
        RequestMessage messageToDispatch = (requestMessage = (RequestMessage)this.nettyEnv.deserialize(client, message, ClassTag$.MODULE$.apply(RequestMessage.class))).senderAddress() == null ? new RequestMessage(clientAddr, requestMessage.receiver(), requestMessage.content(), requestMessage.needReply()) : requestMessage;
        this.dispatcher.postRemoteMessage(messageToDispatch, callback);
    }

    public StreamManager getStreamManager() {
        return new OneForOneStreamManager();
    }

    public void exceptionCaught(Throwable cause, TransportClient client) {
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        if (addr == null) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exception before connecting to the client";
                }
            }, cause);
        } else {
            RpcAddress clientAddr = new RpcAddress(addr.getHostName(), addr.getPort());
            this.dispatcher.postToAll(new RemoteProcessConnectionError(cause, clientAddr));
        }
    }

    public void connectionTerminated(TransportClient client) {
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        if (addr != null) {
            RpcAddress clientAddr = new RpcAddress(addr.getHostName(), addr.getPort());
            this.clients().remove(client);
            this.nettyEnv.removeOutbox(clientAddr);
            this.dispatcher.postToAll(new RemoteProcessDisconnected(clientAddr));
        }
    }

    public NettyRpcHandler(Dispatcher dispatcher, NettyRpcEnv nettyEnv) {
        this.dispatcher = dispatcher;
        this.nettyEnv = nettyEnv;
        Logging$class.$init$(this);
        this.clients = new ConcurrentHashMap();
    }
}

