/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientBootstrap;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SaslClientBootstrap;
import org.apache.spark.network.sasl.SaslServerBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointNotFoundException;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.netty.Ack;
import org.apache.spark.rpc.netty.AskResponse;
import org.apache.spark.rpc.netty.Dispatcher;
import org.apache.spark.rpc.netty.NettyRpcEndpointRef;
import org.apache.spark.rpc.netty.NettyRpcEnv$;
import org.apache.spark.rpc.netty.NettyRpcHandler;
import org.apache.spark.rpc.netty.Outbox;
import org.apache.spark.rpc.netty.OutboxMessage;
import org.apache.spark.rpc.netty.RequestMessage;
import org.apache.spark.rpc.netty.RpcEndpointAddress;
import org.apache.spark.rpc.netty.RpcEndpointAddress$;
import org.apache.spark.rpc.netty.RpcEndpointVerifier;
import org.apache.spark.rpc.netty.RpcEndpointVerifier$;
import org.apache.spark.rpc.netty.RpcFailure;
import org.apache.spark.serializer.JavaSerializerInstance;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t\u0005g!B\u0001\u0003\u0001\ta!a\u0003(fiRL(\u000b]2F]ZT!a\u0001\u0003\u0002\u000b9,G\u000f^=\u000b\u0005\u00151\u0011a\u0001:qG*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bE\u0001\"AD\b\u000e\u0003\u0011I!\u0001\u0005\u0003\u0003\rI\u00038-\u00128w!\t\u00112#D\u0001\u0007\u0013\t!bAA\u0004M_\u001e<\u0017N\\4\t\u0011Y\u0001!Q1A\u0005\u0002a\tAaY8oM\u000e\u0001Q#A\r\u0011\u0005IQ\u0012BA\u000e\u0007\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001a\u0003\u0015\u0019wN\u001c4!\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013A\u00066bm\u0006\u001cVM]5bY&TXM]%ogR\fgnY3\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r2\u0011AC:fe&\fG.\u001b>fe&\u0011QE\t\u0002\u0017\u0015\u00064\u0018mU3sS\u0006d\u0017N_3s\u0013:\u001cH/\u00198dK\"Aq\u0005\u0001B\u0001B\u0003%\u0001&\u0001\u0003i_N$\bCA\u00150\u001d\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001'\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059Z\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002\u001fM,7-\u001e:jifl\u0015M\\1hKJ\u0004\"AE\u001b\n\u0005Y2!aD*fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\t\u000ba\u0002A\u0011A\u001d\u0002\rqJg.\u001b;?)\u0015QD(\u0010 @!\tY\u0004!D\u0001\u0003\u0011\u00151r\u00071\u0001\u001a\u0011\u0015yr\u00071\u0001!\u0011\u00159s\u00071\u0001)\u0011\u0015\u0019t\u00071\u00015\u0011\u001d\t\u0005A1A\u0005\n\t\u000bQ\u0002\u001e:b]N\u0004xN\u001d;D_:4W#A\"\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015\u0001B;uS2T!\u0001\u0013\u0004\u0002\u000f9,Go^8sW&\u0011!*\u0012\u0002\u000e)J\fgn\u001d9peR\u001cuN\u001c4\t\r1\u0003\u0001\u0015!\u0003D\u00039!(/\u00198ta>\u0014HoQ8oM\u0002BqA\u0014\u0001C\u0002\u0013%q*\u0001\u0006eSN\u0004\u0018\r^2iKJ,\u0012\u0001\u0015\t\u0003wEK!A\u0015\u0002\u0003\u0015\u0011K7\u000f]1uG\",'\u000f\u0003\u0004U\u0001\u0001\u0006I\u0001U\u0001\fI&\u001c\b/\u0019;dQ\u0016\u0014\b\u0005C\u0004W\u0001\t\u0007I\u0011B,\u0002!Q\u0014\u0018M\\:q_J$8i\u001c8uKb$X#\u0001-\u0011\u0005eSV\"A$\n\u0005m;%\u0001\u0005+sC:\u001c\bo\u001c:u\u0007>tG/\u001a=u\u0011\u0019i\u0006\u0001)A\u00051\u0006\tBO]1ogB|'\u000f^\"p]R,\u0007\u0010\u001e\u0011\t\u000f}\u0003!\u0019!C\u0005A\u0006i1\r\\5f]R4\u0015m\u0019;pef,\u0012!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I\u001e\u000baa\u00197jK:$\u0018B\u00014d\u0005Y!&/\u00198ta>\u0014Ho\u00117jK:$h)Y2u_JL\bB\u00025\u0001A\u0003%\u0011-\u0001\bdY&,g\u000e\u001e$bGR|'/\u001f\u0011\t\u000f)\u0004!\u0019!C\u0001W\u0006\u0001B/[7f_V$8k\u00195fIVdWM]\u000b\u0002YB\u0011Qn]\u0007\u0002]*\u0011q\u000e]\u0001\u000bG>t7-\u001e:sK:$(B\u0001$r\u0015\u0005\u0011\u0018\u0001\u00026bm\u0006L!\u0001\u001e8\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW\r\u0003\u0004w\u0001\u0001\u0006I\u0001\\\u0001\u0012i&lWm\\;u'\u000eDW\rZ;mKJ\u0004\u0003\u0002\u0003=\u0001\u0005\u0004%\tAA=\u00021\rd\u0017.\u001a8u\u0007>tg.Z2uS>tW\t_3dkR|'/F\u0001{!\ti70\u0003\u0002}]\n\u0011B\u000b\u001b:fC\u0012\u0004vn\u001c7Fq\u0016\u001cW\u000f^8s\u0011\u0019q\b\u0001)A\u0005u\u0006I2\r\\5f]R\u001cuN\u001c8fGRLwN\\#yK\u000e,Ho\u001c:!\u0011-\t\t\u0001\u0001a\u0001\u0002\u0004%I!a\u0001\u0002\rM,'O^3s+\t\t)\u0001\u0005\u0003\u0002\b\u0005-QBAA\u0005\u0015\r\t\taR\u0005\u0005\u0003\u001b\tIAA\bUe\u0006t7\u000f]8siN+'O^3s\u0011-\t\t\u0002\u0001a\u0001\u0002\u0004%I!a\u0005\u0002\u0015M,'O^3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\u0005m\u0001c\u0001\u0016\u0002\u0018%\u0019\u0011\u0011D\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003;\ty!!AA\u0002\u0005\u0015\u0011a\u0001=%c!A\u0011\u0011\u0005\u0001!B\u0013\t)!A\u0004tKJ4XM\u001d\u0011)\t\u0005}\u0011Q\u0005\t\u0004U\u0005\u001d\u0012bAA\u0015W\tAao\u001c7bi&dW\rC\u0005\u0002.\u0001\u0011\r\u0011\"\u0003\u00020\u000591\u000f^8qa\u0016$WCAA\u0019!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001c]\u00061\u0011\r^8nS\u000eLA!a\u000f\u00026\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:D\u0001\"a\u0010\u0001A\u0003%\u0011\u0011G\u0001\tgR|\u0007\u000f]3eA!I\u00111\t\u0001C\u0002\u0013%\u0011QI\u0001\t_V$(m\u001c=fgV\u0011\u0011q\t\t\b[\u0006%\u0013QJA*\u0013\r\tYE\u001c\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bc\u0001\b\u0002P%\u0019\u0011\u0011\u000b\u0003\u0003\u0015I\u00038-\u00113ee\u0016\u001c8\u000fE\u0002<\u0003+J1!a\u0016\u0003\u0005\u0019yU\u000f\u001e2pq\"A\u00111\f\u0001!\u0002\u0013\t9%A\u0005pkR\u0014w\u000e_3tA!A\u0011q\f\u0001\u0005\u0002\t\t\t'\u0001\u0007sK6|g/Z(vi\n|\u0007\u0010\u0006\u0003\u0002\u0016\u0005\r\u0004\u0002CA3\u0003;\u0002\r!!\u0014\u0002\u000f\u0005$GM]3tg\"9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0014aC:uCJ$8+\u001a:wKJ$B!!\u0006\u0002n!A\u0011qNA4\u0001\u0004\t\t(\u0001\u0003q_J$\bc\u0001\u0016\u0002t%\u0019\u0011QO\u0016\u0003\u0007%sG\u000f\u0003\u0006\u0002f\u0001A)\u0019!C!\u0003s*\"!!\u0014\t\u0015\u0005u\u0004\u0001#A!B\u0013\ti%\u0001\u0005bI\u0012\u0014Xm]:!Q\u0011\tY(!!\u0011\t\u0005\r\u0015QR\u0007\u0003\u0003\u000bSA!a\"\u0002\n\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u0005-\u0015!\u00026bm\u0006D\u0018\u0002BAH\u0003\u000b\u0013\u0001BT;mY\u0006\u0014G.\u001a\u0005\b\u0003'\u0003A\u0011IAK\u00035\u0019X\r^;q\u000b:$\u0007o\\5oiR1\u0011qSAO\u0003C\u00032ADAM\u0013\r\tY\n\u0002\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u0011\u001d\ty*!%A\u0002!\nAA\\1nK\"A\u00111UAI\u0001\u0004\t)+\u0001\u0005f]\u0012\u0004x.\u001b8u!\rq\u0011qU\u0005\u0004\u0003S#!a\u0003*qG\u0016sG\r]8j]RDq!!,\u0001\t\u0003\ty+\u0001\u000ebgft7mU3ukB,e\u000e\u001a9pS:$(+\u001a4CsV\u0013\u0016\n\u0006\u0003\u00022\u0006m\u0006CBAZ\u0003o\u000b9*\u0004\u0002\u00026*\u0011qnK\u0005\u0005\u0003s\u000b)L\u0001\u0004GkR,(/\u001a\u0005\b\u0003{\u000bY\u000b1\u0001)\u0003\r)(/\u001b\u0005\b\u0003\u0003\u0004A\u0011IAb\u0003\u0011\u0019Ho\u001c9\u0015\t\u0005U\u0011Q\u0019\u0005\t\u0003\u000f\fy\f1\u0001\u0002\u0018\u0006YQM\u001c3q_&tGOU3g\u0011\u001d\tY\r\u0001C\u0005\u0003\u001b\fA\u0002]8tiR{w*\u001e;c_b$b!!\u0006\u0002P\u0006e\u0007\u0002CAi\u0003\u0013\u0004\r!a5\u0002\u0011I,7-Z5wKJ\u00042aOAk\u0013\r\t9N\u0001\u0002\u0014\u001d\u0016$H/\u001f*qG\u0016sG\r]8j]R\u0014VM\u001a\u0005\t\u00037\fI\r1\u0001\u0002^\u00069Q.Z:tC\u001e,\u0007cA\u001e\u0002`&\u0019\u0011\u0011\u001d\u0002\u0003\u001b=+HOY8y\u001b\u0016\u001c8/Y4f\u0011!\t)\u000f\u0001C\u0001\u0005\u0005\u001d\u0018\u0001B:f]\u0012$B!!\u0006\u0002j\"A\u00111\\Ar\u0001\u0004\tY\u000fE\u0002<\u0003[L1!a<\u0003\u00059\u0011V-];fgRlUm]:bO\u0016D\u0001\"a=\u0001\t\u0003\u0011\u0011Q_\u0001\rGJ,\u0017\r^3DY&,g\u000e\u001e\u000b\u0005\u0003o\fi\u0010E\u0002c\u0003sL1!a?d\u0005=!&/\u00198ta>\u0014Ho\u00117jK:$\b\u0002CA3\u0003c\u0004\r!!\u0014\t\u0011\t\u0005\u0001\u0001\"\u0001\u0003\u0005\u0007\t1!Y:l)\u0011\u0011)A!\u0004\u0011\r\u0005M\u0016q\u0017B\u0004!\rQ#\u0011B\u0005\u0004\u0005\u0017Y#aA!os\"A\u00111\\A\u0000\u0001\u0004\tY\u000f\u0003\u0005\u0003\u0012\u0001!\tA\u0001B\n\u0003%\u0019XM]5bY&TX\r\u0006\u0003\u0003\u0016\t\u0005\u0002#\u0002\u0016\u0003\u0018\tm\u0011b\u0001B\rW\t)\u0011I\u001d:bsB\u0019!F!\b\n\u0007\t}1F\u0001\u0003CsR,\u0007\u0002\u0003B\u0012\u0005\u001f\u0001\rAa\u0002\u0002\u000f\r|g\u000e^3oi\"A!q\u0005\u0001\u0005\u0002\t\u0011I#A\u0006eKN,'/[1mSj,W\u0003\u0002B\u0016\u0005g!bA!\f\u0003P\tEC\u0003\u0002B\u0018\u0005\u007f\u0001BA!\r\u000341\u0001A\u0001\u0003B\u001b\u0005K\u0011\rAa\u000e\u0003\u0003Q\u000bBA!\u000f\u0003\bA\u0019!Fa\u000f\n\u0007\tu2FA\u0004O_RD\u0017N\\4\t\u0015\t\u0005#QEA\u0001\u0002\b\u0011\u0019%\u0001\u0006fm&$WM\\2fIE\u0002bA!\u0012\u0003L\t=RB\u0001B$\u0015\r\u0011IeK\u0001\be\u00164G.Z2u\u0013\u0011\u0011iEa\u0012\u0003\u0011\rc\u0017m]:UC\u001eDq\u0001\u001aB\u0013\u0001\u0004\t9\u0010\u0003\u0005\u0003T\t\u0015\u0002\u0019\u0001B\u000b\u0003\u0015\u0011\u0017\u0010^3t\u0011\u001d\t9\r\u0001C!\u0005/\"B!a&\u0003Z!A\u00111\u0015B+\u0001\u0004\t)\u000bC\u0004\u0003^\u0001!\tEa\u0018\u0002\u000bU\u0014\u0018n\u00144\u0015\u000f!\u0012\tG!\u001a\u0003h!9!1\rB.\u0001\u0004A\u0013AC:zgR,WNT1nK\"A\u0011Q\rB.\u0001\u0004\ti\u0005C\u0004\u0003j\tm\u0003\u0019\u0001\u0015\u0002\u0019\u0015tG\r]8j]Rt\u0015-\\3\t\u000f\t5\u0004\u0001\"\u0011\u0003p\u0005A1\u000f[;uI><h\u000e\u0006\u0002\u0002\u0016!9!1\u000f\u0001\u0005B\t=\u0014\u0001E1xC&$H+\u001a:nS:\fG/[8o\u0011\u001d\u00119\b\u0001C\u0005\u0005_\nqa\u00197fC:,\b\u000fC\u0004\u0003(\u0001!\tEa\u001f\u0016\t\tu$\u0011\u0011\u000b\u0005\u0005\u007f\u0012\u0019\t\u0005\u0003\u00032\t\u0005E\u0001\u0003B\u001b\u0005s\u0012\rAa\u000e\t\u0011\t\u0015%\u0011\u0010a\u0001\u0005\u000f\u000bQ\u0003Z3tKJL\u0017\r\\5{CRLwN\\!di&|g\u000eE\u0003+\u0005\u0013\u0013y(C\u0002\u0003\f.\u0012\u0011BR;oGRLwN\u001c\u0019\b\u0011\t=%\u0001#\u0001\u0003\u0005#\u000b1BT3uif\u0014\u0006oY#omB\u00191Ha%\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0002\u0003\u0016N)!1\u0013BL#A\u0019!F!'\n\u0007\tm5F\u0001\u0004B]f\u0014VM\u001a\u0005\bq\tME\u0011\u0001BP)\t\u0011\t\nC\u0006\u0003$\nM%\u0019!C\u0001\u0005\t\u0015\u0016AC2veJ,g\u000e^#omV\u0011!q\u0015\t\u0006\u0005S\u0013iKO\u0007\u0003\u0005WS!AR\u0016\n\t\t=&1\u0016\u0002\u0010\tft\u0017-\\5d-\u0006\u0014\u0018.\u00192mK\"I!1\u0017BJA\u0003%!qU\u0001\fGV\u0014(/\u001a8u\u000b:4\b\u0005C\u0006\u00038\nM%\u0019!C\u0001\u0005\te\u0016!D2veJ,g\u000e^\"mS\u0016tG/\u0006\u0002\u0003<B1!\u0011\u0016BW\u0003oD\u0011Ba0\u0003\u0014\u0002\u0006IAa/\u0002\u001d\r,(O]3oi\u000ec\u0017.\u001a8uA\u0001")
public class NettyRpcEnv
extends RpcEnv
implements Logging {
    private final SparkConf conf;
    public final JavaSerializerInstance org$apache$spark$rpc$netty$NettyRpcEnv$$javaSerializerInstance;
    private final String host;
    private final SecurityManager securityManager;
    private final TransportConf transportConf;
    private final Dispatcher dispatcher;
    private final TransportContext transportContext;
    private final TransportClientFactory clientFactory;
    private final ScheduledExecutorService timeoutScheduler;
    private final ThreadPoolExecutor clientConnectionExecutor;
    private volatile TransportServer server;
    private final AtomicBoolean stopped;
    private final ConcurrentHashMap<RpcAddress, Outbox> outboxes;
    @Nullable
    private RpcAddress address;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile boolean bitmap$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RpcAddress address$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$0) {
                this.address = this.server() == null ? null : new RpcAddress(this.host, this.server().getPort());
                this.bitmap$0 = true;
            }
        }
        this.host = null;
        return this.address;
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public SparkConf conf() {
        return this.conf;
    }

    private TransportConf transportConf() {
        return this.transportConf;
    }

    private Dispatcher dispatcher() {
        return this.dispatcher;
    }

    private TransportContext transportContext() {
        return this.transportContext;
    }

    private TransportClientFactory clientFactory() {
        return this.clientFactory;
    }

    public ScheduledExecutorService timeoutScheduler() {
        return this.timeoutScheduler;
    }

    public ThreadPoolExecutor clientConnectionExecutor() {
        return this.clientConnectionExecutor;
    }

    private TransportServer server() {
        return this.server;
    }

    private void server_$eq(TransportServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private ConcurrentHashMap<RpcAddress, Outbox> outboxes() {
        return this.outboxes;
    }

    public void removeOutbox(RpcAddress address2) {
        Outbox outbox = this.outboxes().remove(address2);
        if (outbox != null) {
            outbox.stop();
        }
    }

    public void startServer(int port) {
        List bootstraps = this.securityManager.isAuthenticationEnabled() ? Arrays.asList((Object[])new TransportServerBootstrap[]{new SaslServerBootstrap(this.transportConf(), (SecretKeyHolder)this.securityManager)}) : Collections.emptyList();
        this.server_$eq(this.transportContext().createServer(port, bootstraps));
        this.dispatcher().registerRpcEndpoint(RpcEndpointVerifier$.MODULE$.NAME(), new RpcEndpointVerifier(this, this.dispatcher()));
    }

    @Override
    public RpcAddress address() {
        return this.bitmap$0 ? this.address : this.address$lzycompute();
    }

    @Override
    public RpcEndpointRef setupEndpoint(String name, RpcEndpoint endpoint) {
        return this.dispatcher().registerRpcEndpoint(name, endpoint);
    }

    @Override
    public Future<RpcEndpointRef> asyncSetupEndpointRefByURI(String uri) {
        RpcEndpointAddress addr = RpcEndpointAddress$.MODULE$.apply(uri);
        NettyRpcEndpointRef endpointRef = new NettyRpcEndpointRef(this.conf(), addr, this);
        NettyRpcEndpointRef verifier = new NettyRpcEndpointRef(this.conf(), new RpcEndpointAddress(addr.rpcAddress(), RpcEndpointVerifier$.MODULE$.NAME()), this);
        return verifier.ask(new RpcEndpointVerifier.CheckExistence(endpointRef.name()), ClassTag$.MODULE$.Boolean()).flatMap((Function1)new Serializable(this, uri, endpointRef){
            public static final long serialVersionUID = 0L;
            private final String uri$1;
            private final NettyRpcEndpointRef endpointRef$1;

            public final Future<NettyRpcEndpointRef> apply(boolean find) {
                return find ? Future$.MODULE$.successful((Object)this.endpointRef$1) : Future$.MODULE$.failed((Throwable)new RpcEndpointNotFoundException(this.uri$1));
            }
            {
                this.uri$1 = uri$1;
                this.endpointRef$1 = endpointRef$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    @Override
    public void stop(RpcEndpointRef endpointRef) {
        Predef$.MODULE$.require(endpointRef instanceof NettyRpcEndpointRef);
        this.dispatcher().stop(endpointRef);
    }

    private void postToOutbox(NettyRpcEndpointRef receiver, OutboxMessage message) {
        if (receiver.client() == null) {
            Outbox targetOutbox;
            Outbox outbox;
            Predef$.MODULE$.require(receiver.address() != null, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Cannot send message to client endpoint with no listen address.";
                }
            });
            Outbox outbox2 = this.outboxes().get(receiver.address());
            if (outbox2 == null) {
                Outbox newOutbox = new Outbox(this, receiver.address());
                Outbox oldOutbox = this.outboxes().putIfAbsent(receiver.address(), newOutbox);
                outbox = oldOutbox == null ? newOutbox : oldOutbox;
            } else {
                outbox = targetOutbox = outbox2;
            }
            if (this.stopped().get()) {
                this.outboxes().remove(receiver.address());
                targetOutbox.stop();
            } else {
                targetOutbox.send(message);
            }
        } else {
            receiver.client().sendRpc(message.content(), message.createCallback(receiver.client()));
        }
    }

    public void send(RequestMessage message) {
        RpcAddress remoteAddr;
        RpcAddress rpcAddress = remoteAddr = message.receiver().address();
        RpcAddress rpcAddress2 = this.address();
        if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
            Promise promise = Promise$.MODULE$.apply();
            this.dispatcher().postLocalMessage(message, (Promise<Object>)promise);
            promise.future().onComplete((Function1)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyRpcEnv $outer;
                public final RequestMessage message$1;

                public final void apply(Try<Object> x0$1) {
                    Try<Object> try_;
                    block4: {
                        block3: {
                            block2: {
                                try_ = x0$1;
                                if (!(try_ instanceof Success)) break block2;
                                Success success = (Success)try_;
                                Object response = success.value();
                                Ack ack = (Ack)response;
                                this.$outer.logTrace((Function0<String>)new Serializable(this, ack){
                                    public static final long serialVersionUID = 0L;
                                    private final Ack ack$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received ack from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ack$1.sender()}));
                                    }
                                    {
                                        this.ack$1 = ack$1;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(try_ instanceof Failure)) break block4;
                            Failure failure = (Failure)try_;
                            Throwable e = failure.exception();
                            this.$outer.logWarning((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$send$1 $outer;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception when sending ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.message$1}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }, e);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    throw new MatchError(try_);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.message$1 = message$1;
                }
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        } else {
            this.postToOutbox(message.receiver(), new OutboxMessage(this.serialize(message), (Function1<Throwable, BoxedUnit>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyRpcEnv $outer;
                public final RequestMessage message$1;

                public final void apply(Throwable e) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$send$2 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception when sending ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.message$1}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, e);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.message$1 = message$1;
                }
            }, (Function2<TransportClient, byte[], BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyRpcEnv $outer;

                public final void apply(TransportClient client, byte[] response) {
                    Ack ack = (Ack)this.$outer.deserialize(client, response, ClassTag$.MODULE$.apply(Ack.class));
                    this.$outer.logDebug((Function0<String>)new Serializable(this, ack){
                        public static final long serialVersionUID = 0L;
                        private final Ack ack$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Receive ack from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ack$2.sender()}));
                        }
                        {
                            this.ack$2 = ack$2;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }));
        }
    }

    public TransportClient createClient(RpcAddress address2) {
        return this.clientFactory().createClient(address2.host(), address2.port());
    }

    public Future<Object> ask(RequestMessage message) {
        RpcAddress remoteAddr;
        Promise promise = Promise$.MODULE$.apply();
        RpcAddress rpcAddress = remoteAddr = message.receiver().address();
        RpcAddress rpcAddress2 = this.address();
        if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
            Promise p = Promise$.MODULE$.apply();
            this.dispatcher().postLocalMessage(message, (Promise<Object>)p);
            p.future().onComplete((Function1)new Serializable(this, promise){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyRpcEnv $outer;
                private final Promise promise$1;

                public final void apply(Try<Object> x0$2) {
                    Try<Object> try_;
                    block13: {
                        block12: {
                            BoxedUnit boxedUnit;
                            block11: {
                                BoxedUnit boxedUnit2;
                                try_ = x0$2;
                                if (!(try_ instanceof Success)) break block11;
                                Success success = (Success)try_;
                                Object response = success.value();
                                AskResponse reply = (AskResponse)response;
                                if (reply.reply() instanceof RpcFailure) {
                                    if (this.promise$1.tryFailure(((RpcFailure)reply.reply()).e())) {
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else {
                                        this.$outer.logWarning((Function0<String>)new Serializable(this, reply){
                                            public static final long serialVersionUID = 0L;
                                            private final AskResponse reply$1;

                                            public final String apply() {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignore failure: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reply$1.reply()}));
                                            }
                                            {
                                                this.reply$1 = reply$1;
                                            }
                                        });
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    }
                                } else if (this.promise$1.trySuccess(reply.reply())) {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    this.$outer.logWarning((Function0<String>)new Serializable(this, reply){
                                        public static final long serialVersionUID = 0L;
                                        private final AskResponse reply$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignore message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reply$1}));
                                        }
                                        {
                                            this.reply$1 = reply$1;
                                        }
                                    });
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit3 = boxedUnit2;
                                break block12;
                            }
                            if (!(try_ instanceof Failure)) break block13;
                            Failure failure = (Failure)try_;
                            Throwable e = failure.exception();
                            if (this.promise$1.tryFailure(e)) {
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                this.$outer.logWarning((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Ignore Exception";
                                    }
                                }, e);
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit4 = boxedUnit;
                        }
                        return;
                    }
                    throw new MatchError(try_);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.promise$1 = promise$1;
                }
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        } else {
            this.postToOutbox(message.receiver(), new OutboxMessage(this.serialize(message), (Function1<Throwable, BoxedUnit>)new Serializable(this, promise){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyRpcEnv $outer;
                private final Promise promise$1;

                public final void apply(Throwable e) {
                    if (!this.promise$1.tryFailure(e)) {
                        this.$outer.logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Ignore Exception";
                            }
                        }, e);
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.promise$1 = promise$1;
                }
            }, (Function2<TransportClient, byte[], BoxedUnit>)new Serializable(this, promise){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyRpcEnv $outer;
                private final Promise promise$1;

                public final void apply(TransportClient client, byte[] response) {
                    AskResponse reply = (AskResponse)this.$outer.deserialize(client, response, ClassTag$.MODULE$.apply(AskResponse.class));
                    if (reply.reply() instanceof RpcFailure) {
                        if (!this.promise$1.tryFailure(((RpcFailure)reply.reply()).e())) {
                            this.$outer.logWarning((Function0<String>)new Serializable(this, reply){
                                public static final long serialVersionUID = 0L;
                                private final AskResponse reply$2;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignore failure: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reply$2.reply()}));
                                }
                                {
                                    this.reply$2 = reply$2;
                                }
                            });
                        }
                    } else if (!this.promise$1.trySuccess(reply.reply())) {
                        this.$outer.logWarning((Function0<String>)new Serializable(this, reply){
                            public static final long serialVersionUID = 0L;
                            private final AskResponse reply$2;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignore message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reply$2}));
                            }
                            {
                                this.reply$2 = reply$2;
                            }
                        });
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.promise$1 = promise$1;
                }
            }));
        }
        return promise.future();
    }

    public byte[] serialize(Object content) {
        ByteBuffer buffer = this.org$apache$spark$rpc$netty$NettyRpcEnv$$javaSerializerInstance.serialize(content, ClassTag$.MODULE$.Any());
        return Arrays.copyOfRange(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.arrayOffset() + buffer.limit());
    }

    public <T> T deserialize(TransportClient client, byte[] bytes, ClassTag<T> evidence$1) {
        return (T)NettyRpcEnv$.MODULE$.currentClient().withValue((Object)client, (Function0)new Serializable(this, bytes, evidence$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyRpcEnv $outer;
            public final byte[] bytes$1;
            public final ClassTag evidence$1$1;

            public final T apply() {
                return this.$outer.deserialize(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deserialize$1 $outer;

                    public final T apply() {
                        return this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$anonfun$$$outer().org$apache$spark$rpc$netty$NettyRpcEnv$$javaSerializerInstance.deserialize(ByteBuffer.wrap(this.$outer.bytes$1), this.$outer.evidence$1$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ NettyRpcEnv org$apache$spark$rpc$netty$NettyRpcEnv$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bytes$1 = bytes$1;
                this.evidence$1$1 = evidence$1$1;
            }
        });
    }

    @Override
    public RpcEndpointRef endpointRef(RpcEndpoint endpoint) {
        return this.dispatcher().getRpcEndpointRef(endpoint);
    }

    @Override
    public String uriOf(String systemName, RpcAddress address2, String endpointName) {
        return new RpcEndpointAddress(address2, endpointName).toString();
    }

    @Override
    public void shutdown() {
        this.cleanup();
    }

    @Override
    public void awaitTermination() {
        this.dispatcher().awaitTermination();
    }

    private void cleanup() {
        if (this.stopped().compareAndSet(false, true)) {
            for (Outbox outbox : this.outboxes().values()) {
                this.outboxes().remove(outbox.address());
                outbox.stop();
            }
            Object object = this.timeoutScheduler() == null ? BoxedUnit.UNIT : this.timeoutScheduler().shutdownNow();
            if (this.server() != null) {
                this.server().close();
            }
            if (this.clientFactory() != null) {
                this.clientFactory().close();
            }
            if (this.dispatcher() != null) {
                this.dispatcher().stop();
            }
            if (this.clientConnectionExecutor() != null) {
                this.clientConnectionExecutor().shutdownNow();
            }
            return;
        }
    }

    @Override
    public <T> T deserialize(Function0<T> deserializationAction) {
        return (T)NettyRpcEnv$.MODULE$.currentEnv().withValue((Object)this, deserializationAction);
    }

    public NettyRpcEnv(SparkConf conf, JavaSerializerInstance javaSerializerInstance, String host, SecurityManager securityManager) {
        this.conf = conf;
        this.org$apache$spark$rpc$netty$NettyRpcEnv$$javaSerializerInstance = javaSerializerInstance;
        this.host = host;
        this.securityManager = securityManager;
        super(conf);
        Logging$class.$init$(this);
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf.clone().set("spark.shuffle.io.numConnectionsPerPeer", "1"), conf.getInt("spark.rpc.io.threads", 0));
        this.dispatcher = new Dispatcher(this);
        this.transportContext = new TransportContext(this.transportConf(), (RpcHandler)new NettyRpcHandler(this.dispatcher(), this));
        List bootstraps = securityManager.isAuthenticationEnabled() ? Arrays.asList((Object[])new TransportClientBootstrap[]{new SaslClientBootstrap(this.transportConf(), "", (SecretKeyHolder)securityManager, securityManager.isSaslEncryptionEnabled())}) : Collections.emptyList();
        this.clientFactory = this.transportContext().createClientFactory(bootstraps);
        this.timeoutScheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("netty-rpc-env-timeout");
        this.clientConnectionExecutor = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("netty-rpc-connection", conf.getInt("spark.rpc.connect.threads", 64));
        this.stopped = new AtomicBoolean(false);
        this.outboxes = new ConcurrentHashMap();
    }
}

