/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rdd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

public final class ReliableCheckpointRDD$
implements Logging,
Serializable {
    public static final ReliableCheckpointRDD$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new ReliableCheckpointRDD$();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public String org$apache$spark$rdd$ReliableCheckpointRDD$$checkpointFileName(int partitionIndex) {
        return new StringOps(Predef$.MODULE$.augmentString("part-%05d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionIndex)}));
    }

    public <T> void writeCheckpointFile(String path, Broadcast<SerializableConfiguration> broadcastedConf, int blockSize, TaskContext ctx, Iterator<T> iterator2, ClassTag<T> evidence$2) {
        Path tempOutputPath;
        Path finalOutputPath;
        FileSystem fs;
        block6: {
            block5: {
                SparkEnv env = SparkEnv$.MODULE$.get();
                Path outputDir = new Path(path);
                fs = outputDir.getFileSystem(broadcastedConf.value().value());
                String finalOutputName = this.org$apache$spark$rdd$ReliableCheckpointRDD$$checkpointFileName(ctx.partitionId());
                finalOutputPath = new Path(outputDir, finalOutputName);
                tempOutputPath = new Path(outputDir, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", "-attempt-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{finalOutputName, BoxesRunTime.boxToInteger((int)ctx.attemptNumber())})));
                if (fs.exists(tempOutputPath)) {
                    throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpoint failed: temporary path ", " already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tempOutputPath})));
                }
                int bufferSize = env.conf().getInt("spark.buffer.size", 65536);
                FSDataOutputStream fileOutputStream = blockSize < 0 ? fs.create(tempOutputPath, false, bufferSize) : fs.create(tempOutputPath, false, bufferSize, fs.getDefaultReplication(), (long)blockSize);
                SerializerInstance serializer = env.serializer().newInstance();
                SerializationStream serializeStream = serializer.serializeStream((OutputStream)fileOutputStream);
                Utils$.MODULE$.tryWithSafeFinally(new Serializable(iterator2, evidence$2, serializeStream){
                    public static final long serialVersionUID = 0L;
                    private final Iterator iterator$1;
                    private final ClassTag evidence$2$1;
                    private final SerializationStream serializeStream$1;

                    public final SerializationStream apply() {
                        return this.serializeStream$1.writeAll(this.iterator$1, this.evidence$2$1);
                    }
                    {
                        this.iterator$1 = iterator$1;
                        this.evidence$2$1 = evidence$2$1;
                        this.serializeStream$1 = serializeStream$1;
                    }
                }, (Function0<BoxedUnit>)new Serializable(serializeStream){
                    public static final long serialVersionUID = 0L;
                    private final SerializationStream serializeStream$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.serializeStream$1.close();
                    }
                    {
                        this.serializeStream$1 = serializeStream$1;
                    }
                });
                if (fs.rename(tempOutputPath, finalOutputPath)) break block5;
                if (!fs.exists(finalOutputPath)) break block6;
                this.logInfo((Function0<String>)new Serializable(finalOutputPath){
                    public static final long serialVersionUID = 0L;
                    private final Path finalOutputPath$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Final output path ", " already exists; not overwriting it"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.finalOutputPath$1}));
                    }
                    {
                        this.finalOutputPath$1 = finalOutputPath$1;
                    }
                });
                if (!fs.delete(tempOutputPath, false)) {
                    this.logWarning((Function0<String>)new Serializable(tempOutputPath){
                        public static final long serialVersionUID = 0L;
                        private final Path tempOutputPath$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tempOutputPath$1}));
                        }
                        {
                            this.tempOutputPath$1 = tempOutputPath$1;
                        }
                    });
                }
            }
            return;
        }
        this.logInfo((Function0<String>)new Serializable(tempOutputPath){
            public static final long serialVersionUID = 0L;
            private final Path tempOutputPath$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting tempOutputPath ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tempOutputPath$1}));
            }
            {
                this.tempOutputPath$1 = tempOutputPath$1;
            }
        });
        fs.delete(tempOutputPath, false);
        throw new IOException(new StringBuilder().append((Object)"Checkpoint failed: failed to save output of task: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " and final output path does not exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ctx.attemptNumber()), finalOutputPath}))).toString());
    }

    public <T> int writeCheckpointFile$default$3() {
        return -1;
    }

    public <T> Iterator<T> readCheckpointFile(Path path, Broadcast<SerializableConfiguration> broadcastedConf, TaskContext context) {
        SparkEnv env = SparkEnv$.MODULE$.get();
        FileSystem fs = path.getFileSystem(broadcastedConf.value().value());
        int bufferSize = env.conf().getInt("spark.buffer.size", 65536);
        FSDataInputStream fileInputStream = fs.open(path, bufferSize);
        SerializerInstance serializer = env.serializer().newInstance();
        DeserializationStream deserializeStream = serializer.deserializeStream((InputStream)fileInputStream);
        context.addTaskCompletionListener((Function1<TaskContext, BoxedUnit>)new Serializable(deserializeStream){
            public static final long serialVersionUID = 0L;
            private final DeserializationStream deserializeStream$1;

            public final void apply(TaskContext context) {
                this.deserializeStream$1.close();
            }
            {
                this.deserializeStream$1 = deserializeStream$1;
            }
        });
        return deserializeStream.asIterator();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ReliableCheckpointRDD$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

