/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import org.apache.spark.SparkConf;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.UnifiedMemoryManager$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockStatus;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.Buffer;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000114Q!\u0001\u0002\u0001\t)\u0011A#\u00168jM&,G-T3n_JLX*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003\u0019iW-\\8ss*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0005\u0002\u0001\u0017A\u0011A\"D\u0007\u0002\u0005%\u0011aB\u0001\u0002\u000e\u001b\u0016lwN]=NC:\fw-\u001a:\t\u0011A\u0001!\u0011!Q\u0001\nI\tAaY8oM\u000e\u0001\u0001CA\n\u0015\u001b\u0005!\u0011BA\u000b\u0005\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u0003%i\u0017\r_'f[>\u0014\u0018\u0010\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0003M_:<\u0007\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\u00119,XnQ8sKN\u0004\"!G\u0011\n\u0005\tR\"aA%oi\")A\u0005\u0001C\u0001K\u00051A(\u001b8jiz\"BAJ\u0014)SA\u0011A\u0002\u0001\u0005\u0006!\r\u0002\rA\u0005\u0005\u0006/\r\u0002\r\u0001\u0007\u0005\u0006?\r\u0002\r\u0001\t\u0005\u0006I\u0001!\ta\u000b\u000b\u0004M1j\u0003\"\u0002\t+\u0001\u0004\u0011\u0002\"B\u0010+\u0001\u0004\u0001\u0003bB\u0018\u0001\u0005\u0004%I\u0001M\u0001\u0012gR|'/Y4f%\u0016<\u0017n\u001c8TSj,W#\u0001\r\t\rI\u0002\u0001\u0015!\u0003\u0019\u0003I\u0019Ho\u001c:bO\u0016\u0014VmZ5p]NK'0\u001a\u0011\t\u000bQ\u0002A\u0011\u0002\u0019\u0002\u001fQ|G/\u00197Ge\u0016,W*Z7pefDQA\u000e\u0001\u0005BA\n!#\\1y\u000bb,7-\u001e;j_:lU-\\8ss\")\u0001\b\u0001C!a\u0005\u0001R.\u0019=Ti>\u0014\u0018mZ3NK6|'/\u001f\u0005\u0007u\u0001!\tEA\u001e\u00021\u0011|\u0017iY9vSJ,W\t_3dkRLwN\\'f[>\u0014\u0018\u0010F\u0002\u0019yyBQ!P\u001dA\u0002a\t\u0001B\\;n\u0005f$Xm\u001d\u0005\u0006\u007fe\u0002\r\u0001Q\u0001\u000eKZL7\r^3e\u00052|7m[:\u0011\u0007\u00053\u0005*D\u0001C\u0015\t\u0019E)A\u0004nkR\f'\r\\3\u000b\u0005\u0015S\u0012AC2pY2,7\r^5p]&\u0011qI\u0011\u0002\u0007\u0005V4g-\u001a:\u0011\teI5*U\u0005\u0003\u0015j\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001'P\u001b\u0005i%B\u0001(\u0005\u0003\u001d\u0019Ho\u001c:bO\u0016L!\u0001U'\u0003\u000f\tcwnY6JIB\u0011AJU\u0005\u0003'6\u00131B\u00117pG.\u001cF/\u0019;vg\")Q\u000b\u0001C!-\u0006!\u0012mY9vSJ,7\u000b^8sC\u001e,W*Z7pef$Ba\u0016.];B\u0011\u0011\u0004W\u0005\u00033j\u0011qAQ8pY\u0016\fg\u000eC\u0003\\)\u0002\u00071*A\u0004cY>\u001c7.\u00133\t\u000bu\"\u0006\u0019\u0001\r\t\u000b}\"\u0006\u0019\u0001!\b\u000b}\u0013\u0001\u0012\u00021\u0002)Us\u0017NZ5fI6+Wn\u001c:z\u001b\u0006t\u0017mZ3s!\ta\u0011MB\u0003\u0002\u0005!%!m\u0005\u0002bGB\u0011\u0011\u0004Z\u0005\u0003Kj\u0011a!\u00118z%\u00164\u0007\"\u0002\u0013b\t\u00039G#\u00011\t\u000b%\fG\u0011\u00026\u0002\u0019\u001d,G/T1y\u001b\u0016lwN]=\u0015\u0005aY\u0007\"\u0002\ti\u0001\u0004\u0011\u0002")
public class UnifiedMemoryManager
extends MemoryManager {
    private final long maxMemory;
    private final long storageRegionSize;

    private long storageRegionSize() {
        return this.storageRegionSize;
    }

    private synchronized long totalFreeMemory() {
        Predef$.MODULE$.assert(this._executionMemoryUsed() <= this.maxMemory);
        Predef$.MODULE$.assert(this._storageMemoryUsed() <= this.maxMemory);
        Predef$.MODULE$.assert(this._executionMemoryUsed() + this._storageMemoryUsed() <= this.maxMemory);
        return this.maxMemory - this._executionMemoryUsed() - this._storageMemoryUsed();
    }

    @Override
    public synchronized long maxExecutionMemory() {
        return this.maxMemory - this._storageMemoryUsed();
    }

    @Override
    public synchronized long maxStorageMemory() {
        return this.maxMemory - this._executionMemoryUsed();
    }

    @Override
    public synchronized long doAcquireExecutionMemory(long numBytes, Buffer<Tuple2<BlockId, BlockStatus>> evictedBlocks) {
        Object object;
        boolean shouldEvictStorage;
        Predef$.MODULE$.assert(numBytes >= 0L);
        long memoryBorrowedByStorage = package$.MODULE$.max(0L, this._storageMemoryUsed() - this.storageRegionSize());
        boolean bl = shouldEvictStorage = this.totalFreeMemory() < numBytes && memoryBorrowedByStorage > 0L;
        if (shouldEvictStorage) {
            long spaceToEnsure = package$.MODULE$.min(numBytes, memoryBorrowedByStorage);
            object = BoxesRunTime.boxToBoolean((boolean)this.memoryStore().ensureFreeSpace(spaceToEnsure, evictedBlocks));
        } else {
            object = BoxedUnit.UNIT;
        }
        long bytesToGrant = package$.MODULE$.min(numBytes, this.totalFreeMemory());
        this._executionMemoryUsed_$eq(this._executionMemoryUsed() + bytesToGrant);
        return bytesToGrant;
    }

    @Override
    public synchronized boolean acquireStorageMemory(BlockId blockId, long numBytes, Buffer<Tuple2<BlockId, BlockStatus>> evictedBlocks) {
        boolean enoughMemory;
        Predef$.MODULE$.assert(numBytes >= 0L);
        this.memoryStore().ensureFreeSpace(blockId, numBytes, evictedBlocks);
        boolean bl = enoughMemory = this.totalFreeMemory() >= numBytes;
        if (enoughMemory) {
            this._storageMemoryUsed_$eq(this._storageMemoryUsed() + numBytes);
        }
        return enoughMemory;
    }

    public UnifiedMemoryManager(SparkConf conf, long maxMemory, int numCores) {
        this.maxMemory = maxMemory;
        super(conf, numCores);
        this.storageRegionSize = (long)((double)maxMemory * conf.getDouble("spark.memory.storageFraction", 0.5));
    }

    public UnifiedMemoryManager(SparkConf conf, int numCores) {
        this(conf, UnifiedMemoryManager$.MODULE$.org$apache$spark$memory$UnifiedMemoryManager$$getMaxMemory(conf), numCores);
    }
}

