/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import org.apache.spark.SparkConf;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.StaticMemoryManager$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockStatus;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.Buffer;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a!B\u0001\u0003\u0001\u0011Q!aE*uCRL7-T3n_JLX*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003\u0019iW-\\8ss*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0005\u0002\u0001\u0017A\u0011A\"D\u0007\u0002\u0005%\u0011aB\u0001\u0002\u000e\u001b\u0016lwN]=NC:\fw-\u001a:\t\u0011A\u0001!Q1A\u0005\u0002I\tAaY8oM\u000e\u0001Q#A\n\u0011\u0005Q)R\"\u0001\u0003\n\u0005Y!!!C*qCJ\\7i\u001c8g\u0011!A\u0002A!A!\u0002\u0013\u0019\u0012!B2p]\u001a\u0004\u0003\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011I\u000e\u0002%5\f\u00070\u0012=fGV$\u0018n\u001c8NK6|'/_\u000b\u00029A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t!Aj\u001c8h\u0011!\u0019\u0003A!A!\u0002\u0013a\u0012aE7bq\u0016CXmY;uS>tW*Z7pef\u0004\u0003\u0002C\u0013\u0001\u0005\u000b\u0007I\u0011I\u000e\u0002!5\f\u0007p\u0015;pe\u0006<W-T3n_JL\b\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002#5\f\u0007p\u0015;pe\u0006<W-T3n_JL\b\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003!qW/\\\"pe\u0016\u001c\bCA\u000f,\u0013\tacDA\u0002J]RDQA\f\u0001\u0005\u0002=\na\u0001P5oSRtD#\u0002\u00192eM\"\u0004C\u0001\u0007\u0001\u0011\u0015\u0001R\u00061\u0001\u0014\u0011\u0015QR\u00061\u0001\u001d\u0011\u0015)S\u00061\u0001\u001d\u0011\u0015IS\u00061\u0001+\u0011\u0015q\u0003\u0001\"\u00017)\r\u0001t\u0007\u000f\u0005\u0006!U\u0002\ra\u0005\u0005\u0006SU\u0002\rA\u000b\u0005\bu\u0001\u0011\r\u0011\"\u0003\u001c\u0003ei\u0017\r_'f[>\u0014\u0018\u0010V8Fm&\u001cGOR8s+:\u0014x\u000e\u001c7\t\rq\u0002\u0001\u0015!\u0003\u001d\u0003ii\u0017\r_'f[>\u0014\u0018\u0010V8Fm&\u001cGOR8s+:\u0014x\u000e\u001c7!\u0011\u0015q\u0004\u0001\"\u0011@\u0003a!w.Q2rk&\u0014X-\u0012=fGV$\u0018n\u001c8NK6|'/\u001f\u000b\u00049\u0001\u0013\u0005\"B!>\u0001\u0004a\u0012\u0001\u00038v[\nKH/Z:\t\u000b\rk\u0004\u0019\u0001#\u0002\u001b\u00154\u0018n\u0019;fI\ncwnY6t!\r)%\nT\u0007\u0002\r*\u0011q\tS\u0001\b[V$\u0018M\u00197f\u0015\tIe$\u0001\u0006d_2dWm\u0019;j_:L!a\u0013$\u0003\r\t+hMZ3s!\u0011iRjT+\n\u00059s\"A\u0002+va2,'\u0007\u0005\u0002Q'6\t\u0011K\u0003\u0002S\t\u000591\u000f^8sC\u001e,\u0017B\u0001+R\u0005\u001d\u0011En\\2l\u0013\u0012\u0004\"\u0001\u0015,\n\u0005]\u000b&a\u0003\"m_\u000e\\7\u000b^1ukNDQ!\u0017\u0001\u0005Bi\u000bA#Y2rk&\u0014Xm\u0015;pe\u0006<W-T3n_JLH\u0003B._A\u0006\u0004\"!\b/\n\u0005us\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006?b\u0003\raT\u0001\bE2|7m[%e\u0011\u0015\t\u0005\f1\u0001\u001d\u0011\u0015\u0019\u0005\f1\u0001E\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0003M\t7-];je\u0016,fN]8mY6+Wn\u001c:z)\u0011YVMZ4\t\u000b}\u0013\u0007\u0019A(\t\u000b\u0005\u0013\u0007\u0019\u0001\u000f\t\u000b\r\u0013\u0007\u0019\u0001#\t\re\u0003A\u0011\u0001\u0003j)\u0015Y&n[7p\u0011\u0015y\u0006\u000e1\u0001P\u0011\u0015a\u0007\u000e1\u0001\u001d\u0003EqW/\u001c\"zi\u0016\u001cHk\\!dcVL'/\u001a\u0005\u0006]\"\u0004\r\u0001H\u0001\u000f]Vl')\u001f;fgR{gI]3f\u0011\u0015\u0019\u0005\u000e1\u0001E\u000f\u0019\t(\u0001#\u0001\u0005e\u0006\u00192\u000b^1uS\u000elU-\\8ss6\u000bg.Y4feB\u0011Ab\u001d\u0004\u0007\u0003\tA\t\u0001\u0002;\u0014\u0005M,\bCA\u000fw\u0013\t9hD\u0001\u0004B]f\u0014VM\u001a\u0005\u0006]M$\t!\u001f\u000b\u0002e\"11p\u001dC\u0001\tq\f1cZ3u\u001b\u0006D8\u000b^8sC\u001e,W*Z7pef$\"\u0001H?\t\u000bAQ\b\u0019A\n\t\u000f}\u001cH\u0011\u0001\u0003\u0002\u0002\u0005)r-\u001a;NCb,\u00050Z2vi&|g.T3n_JLHc\u0001\u000f\u0002\u0004!)\u0001C a\u0001'\u0001")
public class StaticMemoryManager
extends MemoryManager {
    private final SparkConf conf;
    private final long maxExecutionMemory;
    private final long maxStorageMemory;
    private final long maxMemoryToEvictForUnroll;

    public SparkConf conf() {
        return this.conf;
    }

    @Override
    public long maxExecutionMemory() {
        return this.maxExecutionMemory;
    }

    @Override
    public long maxStorageMemory() {
        return this.maxStorageMemory;
    }

    private long maxMemoryToEvictForUnroll() {
        return this.maxMemoryToEvictForUnroll;
    }

    @Override
    public synchronized long doAcquireExecutionMemory(long numBytes, Buffer<Tuple2<BlockId, BlockStatus>> evictedBlocks) {
        Predef$.MODULE$.assert(numBytes >= 0L);
        Predef$.MODULE$.assert(this._executionMemoryUsed() <= this.maxExecutionMemory());
        long bytesToGrant = package$.MODULE$.min(numBytes, this.maxExecutionMemory() - this._executionMemoryUsed());
        this._executionMemoryUsed_$eq(this._executionMemoryUsed() + bytesToGrant);
        return bytesToGrant;
    }

    @Override
    public synchronized boolean acquireStorageMemory(BlockId blockId, long numBytes, Buffer<Tuple2<BlockId, BlockStatus>> evictedBlocks) {
        return this.acquireStorageMemory(blockId, numBytes, numBytes, evictedBlocks);
    }

    @Override
    public synchronized boolean acquireUnrollMemory(BlockId blockId, long numBytes, Buffer<Tuple2<BlockId, BlockStatus>> evictedBlocks) {
        long currentUnrollMemory = this.memoryStore().currentUnrollMemory();
        long maxNumBytesToFree = package$.MODULE$.max(0L, this.maxMemoryToEvictForUnroll() - currentUnrollMemory);
        long numBytesToFree = package$.MODULE$.min(numBytes, maxNumBytesToFree);
        return this.acquireStorageMemory(blockId, numBytes, numBytesToFree, evictedBlocks);
    }

    public synchronized boolean acquireStorageMemory(BlockId blockId, long numBytesToAcquire, long numBytesToFree, Buffer<Tuple2<BlockId, BlockStatus>> evictedBlocks) {
        boolean enoughMemory;
        Predef$.MODULE$.assert(numBytesToAcquire >= 0L);
        Predef$.MODULE$.assert(numBytesToFree >= 0L);
        this.memoryStore().ensureFreeSpace(blockId, numBytesToFree, evictedBlocks);
        Predef$.MODULE$.assert(this._storageMemoryUsed() <= this.maxStorageMemory());
        boolean bl = enoughMemory = this._storageMemoryUsed() + numBytesToAcquire <= this.maxStorageMemory();
        if (enoughMemory) {
            this._storageMemoryUsed_$eq(this._storageMemoryUsed() + numBytesToAcquire);
        }
        return enoughMemory;
    }

    public StaticMemoryManager(SparkConf conf, long maxExecutionMemory, long maxStorageMemory, int numCores) {
        this.conf = conf;
        this.maxExecutionMemory = maxExecutionMemory;
        this.maxStorageMemory = maxStorageMemory;
        super(conf, numCores);
        this.maxMemoryToEvictForUnroll = (long)((double)maxStorageMemory * conf.getDouble("spark.storage.unrollFraction", 0.2));
    }

    public StaticMemoryManager(SparkConf conf, int numCores) {
        this(conf, StaticMemoryManager$.MODULE$.getMaxExecutionMemory(conf), StaticMemoryManager$.MODULE$.getMaxStorageMemory(conf), numCores);
    }
}

