/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.MemoryStore;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.memory.MemoryAllocator;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\rgAB\u0001\u0003\u0003\u0003!!BA\u0007NK6|'/_'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\ta!\\3n_JL(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0014\u0007\u0001Y\u0011\u0003\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VM\u001a\t\u0003%Mi\u0011\u0001B\u0005\u0003)\u0011\u0011q\u0001T8hO&tw\r\u0003\u0005\u0017\u0001\t\u0005\t\u0015!\u0003\u0019\u0003\u0011\u0019wN\u001c4\u0004\u0001A\u0011!#G\u0005\u00035\u0011\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011q\u0001!\u0011!Q\u0001\nu\t\u0001B\\;n\u0007>\u0014Xm\u001d\t\u0003\u0019yI!aH\u0007\u0003\u0007%sG\u000fC\u0003\"\u0001\u0011\u0005!%\u0001\u0004=S:LGO\u0010\u000b\u0004G\u00152\u0003C\u0001\u0013\u0001\u001b\u0005\u0011\u0001\"\u0002\f!\u0001\u0004A\u0002\"\u0002\u000f!\u0001\u0004i\u0002\"\u0003\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0003*\u00031yV.Z7pef\u001cFo\u001c:f+\u0005Q\u0003CA\u0016/\u001b\u0005a#BA\u0017\u0005\u0003\u001d\u0019Ho\u001c:bO\u0016L!a\f\u0017\u0003\u00175+Wn\u001c:z'R|'/\u001a\u0005\nc\u0001\u0001\r\u00111A\u0005\nI\n\u0001cX7f[>\u0014\u0018p\u0015;pe\u0016|F%Z9\u0015\u0005M2\u0004C\u0001\u00075\u0013\t)TB\u0001\u0003V]&$\bbB\u001c1\u0003\u0003\u0005\rAK\u0001\u0004q\u0012\n\u0004BB\u001d\u0001A\u0003&!&A\u0007`[\u0016lwN]=Ti>\u0014X\r\t\u0005\u0006w\u0001!\t\"K\u0001\f[\u0016lwN]=Ti>\u0014X\rC\u0004>\u0001\u0001\u0007I\u0011\u0003 \u0002)}+\u00070Z2vi&|g.T3n_JLXk]3e+\u0005y\u0004C\u0001\u0007A\u0013\t\tUB\u0001\u0003M_:<\u0007bB\"\u0001\u0001\u0004%\t\u0002R\u0001\u0019?\u0016DXmY;uS>tW*Z7pef,6/\u001a3`I\u0015\fHCA\u001aF\u0011\u001d9$)!AA\u0002}Baa\u0012\u0001!B\u0013y\u0014!F0fq\u0016\u001cW\u000f^5p]6+Wn\u001c:z+N,G\r\t\u0015\u0005\r&\u001bF\u000b\u0005\u0002K#6\t1J\u0003\u0002M\u001b\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u00059{\u0015AC1o]>$\u0018\r^5p]*\t\u0001+A\u0003kCZ\f\u00070\u0003\u0002S\u0017\nIq)^1sI\u0016$')_\u0001\u0006m\u0006dW/Z\u0011\u0002+\u0006!A\u000f[5t\u0011\u001d9\u0006\u00011A\u0005\u0012y\n!cX:u_J\fw-Z'f[>\u0014\u00180V:fI\"9\u0011\f\u0001a\u0001\n#Q\u0016AF0ti>\u0014\u0018mZ3NK6|'/_+tK\u0012|F%Z9\u0015\u0005MZ\u0006bB\u001cY\u0003\u0003\u0005\ra\u0010\u0005\u0007;\u0002\u0001\u000b\u0015B \u0002'}\u001bHo\u001c:bO\u0016lU-\\8ssV\u001bX\r\u001a\u0011)\tqK5\u000b\u0016\u0005\bA\u0002\u0011\r\u0011\"\u0003b\u0003Y)\u00070Z2vi&|g.T3n_JLhi\u001c:UCN\\W#\u00012\u0011\t\rDwhP\u0007\u0002I*\u0011QMZ\u0001\b[V$\u0018M\u00197f\u0015\t9W\"\u0001\u0006d_2dWm\u0019;j_:L!!\u001b3\u0003\u000f!\u000b7\u000f['ba\"11\u000e\u0001Q\u0001\n\t\fq#\u001a=fGV$\u0018n\u001c8NK6|'/\u001f$peR\u000b7o\u001b\u0011)\t)L5\u000b\u0016\u0005\u0006]\u0002!)a\\\u0001\u000fg\u0016$X*Z7pef\u001cFo\u001c:f)\t\u0019\u0004\u000fC\u0003r[\u0002\u0007!&A\u0003ti>\u0014X\rC\u0003t\u0001\u0019\u0005a(\u0001\nnCb,\u00050Z2vi&|g.T3n_JL\b\"B;\u0001\r\u0003q\u0014\u0001E7bqN#xN]1hK6+Wn\u001c:z\u0011\u00159\bA\"\u0001y\u0003Q\t7-];je\u0016\u001cFo\u001c:bO\u0016lU-\\8ssR1\u0011\u0010`A\u0002\u0003\u000f\u0001\"\u0001\u0004>\n\u0005ml!a\u0002\"p_2,\u0017M\u001c\u0005\u0006{Z\u0004\rA`\u0001\bE2|7m[%e!\tYs0C\u0002\u0002\u00021\u0012qA\u00117pG.LE\r\u0003\u0004\u0002\u0006Y\u0004\raP\u0001\t]Vl')\u001f;fg\"9\u0011\u0011\u0002<A\u0002\u0005-\u0011!D3wS\u000e$X\r\u001a\"m_\u000e\\7\u000fE\u0003d\u0003\u001b\t\t\"C\u0002\u0002\u0010\u0011\u0014aAQ;gM\u0016\u0014\bC\u0002\u0007\u0002\u0014y\f9\"C\u0002\u0002\u00165\u0011a\u0001V;qY\u0016\u0014\u0004cA\u0016\u0002\u001a%\u0019\u00111\u0004\u0017\u0003\u0017\tcwnY6Ti\u0006$Xo\u001d\u0005\b\u0003?\u0001A\u0011AA\u0011\u0003M\t7-];je\u0016,fN]8mY6+Wn\u001c:z)\u001dI\u00181EA\u0013\u0003OAa!`A\u000f\u0001\u0004q\bbBA\u0003\u0003;\u0001\ra\u0010\u0005\t\u0003\u0013\ti\u00021\u0001\u0002\f!A\u00111\u0006\u0001\u0007\u0002\t\ti#\u0001\re_\u0006\u001b\u0017/^5sK\u0016CXmY;uS>tW*Z7pef$RaPA\u0018\u0003cAq!!\u0002\u0002*\u0001\u0007q\b\u0003\u0005\u0002\n\u0005%\u0002\u0019AA\u0006Q\u0011\tI#!\u000e\u0011\t\u0005]\u0012\u0011J\u0007\u0003\u0003sQA!a\u000f\u0002>\u0005Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\u0011\ty$!\u0011\u0002\r\r|W.\\8o\u0015\u0011\t\u0019%!\u0012\u0002\r\u001d|wn\u001a7f\u0015\t\t9%A\u0002d_6LA!a\u0013\u0002:\t\tb+[:jE2,gi\u001c:UKN$\u0018N\\4\t\u0011\u0005=\u0003\u0001\"\u0002\u0003\u0003#\na#Y2rk&\u0014X-\u0012=fGV$\u0018n\u001c8NK6|'/\u001f\u000b\u0006\u007f\u0005M\u0013Q\u000b\u0005\b\u0003\u000b\ti\u00051\u0001@\u0011\u001d\t9&!\u0014A\u0002}\nQ\u0002^1tW\u0006#H/Z7qi&#\u0007\u0002CA.\u0001\u0011\u0005!!!\u0018\u0002-I,G.Z1tK\u0016CXmY;uS>tW*Z7pef$2aMA0\u0011\u001d\t)!!\u0017A\u0002}BC!!\u0017\u00026!A\u00111\f\u0001\u0005\u0006\t\t)\u0007F\u00034\u0003O\nI\u0007C\u0004\u0002\u0006\u0005\r\u0004\u0019A \t\u000f\u0005]\u00131\ra\u0001\u007f!A\u0011Q\u000e\u0001\u0005\u0002\t\ty'\u0001\u0011sK2,\u0017m]3BY2,\u00050Z2vi&|g.T3n_JLhi\u001c:UCN\\GcA \u0002r!9\u0011qKA6\u0001\u0004y\u0004bBA;\u0001\u0011\u0005\u0011qO\u0001\u0015e\u0016dW-Y:f'R|'/Y4f\u001b\u0016lwN]=\u0015\u0007M\nI\bC\u0004\u0002\u0006\u0005M\u0004\u0019A \t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000\u00059\"/\u001a7fCN,\u0017\t\u001c7Ti>\u0014\u0018mZ3NK6|'/\u001f\u000b\u0002g!9\u00111\u0011\u0001\u0005\u0002\u0005\u0015\u0015a\u0005:fY\u0016\f7/Z+oe>dG.T3n_JLHcA\u001a\u0002\b\"9\u0011QAAA\u0001\u0004y\u0004BBAF\u0001\u0011\u0015a(A\nfq\u0016\u001cW\u000f^5p]6+Wn\u001c:z+N,G\r\u0003\u0004\u0002\u0010\u0002!)AP\u0001\u0012gR|'/Y4f\u001b\u0016lwN]=Vg\u0016$\u0007\u0002CAJ\u0001\u0011\u0005!!!&\u0002=\u001d,G/\u0012=fGV$\u0018n\u001c8NK6|'/_+tC\u001e,gi\u001c:UCN\\GcA \u0002\u0018\"9\u0011qKAI\u0001\u0004y\u0004\u0002CAN\u0001\t\u0007I\u0011\u0001 \u0002\u001bA\fw-Z*ju\u0016\u0014\u0015\u0010^3t\u0011\u001d\ty\n\u0001Q\u0001\n}\na\u0002]1hKNK'0\u001a\"zi\u0016\u001c\b\u0005C\u0005\u0002$\u0002\u0011\r\u0011\"\u0002\u0002&\u0006yB/\u001e8hgR,g.T3n_JL\u0018j]!mY>\u001c\u0017\r^3e\u0013:DU-\u00199\u0016\u0003eDq!!+\u0001A\u00035\u00110\u0001\u0011uk:<7\u000f^3o\u001b\u0016lwN]=Jg\u0006cGn\\2bi\u0016$\u0017J\u001c%fCB\u0004\u0003BCAW\u0001\t\u0007IQ\u0001\u0002\u00020\u00069B/\u001e8hgR,g.T3n_JL\u0018\t\u001c7pG\u0006$xN]\u000b\u0003\u0003c\u0003B!a-\u0002<6\u0011\u0011Q\u0017\u0006\u0004\u0007\u0005]&bAA]\t\u00051QO\\:bM\u0016LA!!0\u00026\nyQ*Z7pef\fE\u000e\\8dCR|'\u000f\u0003\u0005\u0002B\u0002\u0001\u000bQBAY\u0003a!XO\\4ti\u0016tW*Z7pef\fE\u000e\\8dCR|'\u000f\t")
public abstract class MemoryManager
implements Logging {
    private MemoryStore _memoryStore;
    @GuardedBy(value="this")
    private long _executionMemoryUsed;
    @GuardedBy(value="this")
    private long _storageMemoryUsed;
    @GuardedBy(value="this")
    private final HashMap<Object, Object> executionMemoryForTask;
    private final long pageSizeBytes;
    private final boolean tungstenMemoryIsAllocatedInHeap;
    private final MemoryAllocator tungstenMemoryAllocator;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private MemoryStore _memoryStore() {
        return this._memoryStore;
    }

    private void _memoryStore_$eq(MemoryStore x$1) {
        this._memoryStore = x$1;
    }

    public MemoryStore memoryStore() {
        if (this._memoryStore() == null) {
            throw new IllegalArgumentException("memory store not initialized yet");
        }
        return this._memoryStore();
    }

    public long _executionMemoryUsed() {
        return this._executionMemoryUsed;
    }

    public void _executionMemoryUsed_$eq(long x$1) {
        this._executionMemoryUsed = x$1;
    }

    public long _storageMemoryUsed() {
        return this._storageMemoryUsed;
    }

    public void _storageMemoryUsed_$eq(long x$1) {
        this._storageMemoryUsed = x$1;
    }

    private HashMap<Object, Object> executionMemoryForTask() {
        return this.executionMemoryForTask;
    }

    public final void setMemoryStore(MemoryStore store) {
        this._memoryStore_$eq(store);
    }

    public abstract long maxExecutionMemory();

    public abstract long maxStorageMemory();

    public abstract boolean acquireStorageMemory(BlockId var1, long var2, Buffer<Tuple2<BlockId, BlockStatus>> var4);

    public synchronized boolean acquireUnrollMemory(BlockId blockId, long numBytes, Buffer<Tuple2<BlockId, BlockStatus>> evictedBlocks) {
        return this.acquireStorageMemory(blockId, numBytes, evictedBlocks);
    }

    @VisibleForTesting
    public abstract long doAcquireExecutionMemory(long var1, Buffer<Tuple2<BlockId, BlockStatus>> var3);

    public final synchronized long acquireExecutionMemory(long numBytes, long taskAttemptId) {
        long toGrant;
        Predef$.MODULE$.assert(numBytes > 0L, (Function0)new Serializable(this, numBytes){
            public static final long serialVersionUID = 0L;
            private final long numBytes$1;

            public final String apply() {
                return new StringBuilder().append((Object)"invalid number of bytes requested: ").append((Object)BoxesRunTime.boxToLong((long)this.numBytes$1)).toString();
            }
            {
                this.numBytes$1 = numBytes$1;
            }
        });
        if (!this.executionMemoryForTask().contains((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) {
            this.executionMemoryForTask().update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)0L));
            this.notifyAll();
        }
        while (true) {
            int numActiveTasks = this.executionMemoryForTask().keys().size();
            long curMem = BoxesRunTime.unboxToLong((Object)this.executionMemoryForTask().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId)));
            long freeMemory = this.maxExecutionMemory() - BoxesRunTime.unboxToLong((Object)this.executionMemoryForTask().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            long maxToGrant = package$.MODULE$.min(numBytes, package$.MODULE$.max(0L, this.maxExecutionMemory() / (long)numActiveTasks - curMem));
            toGrant = package$.MODULE$.min(maxToGrant, freeMemory);
            if (curMem >= this.maxExecutionMemory() / (long)(2 * numActiveTasks)) break;
            if (freeMemory >= package$.MODULE$.min(maxToGrant, this.maxExecutionMemory() / (long)(2 * numActiveTasks) - curMem)) {
                return this.acquire$1(toGrant, taskAttemptId);
            }
            this.logInfo((Function0<String>)new Serializable(this, taskAttemptId){
                public static final long serialVersionUID = 0L;
                private final long taskAttemptId$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TID ", " waiting for at least 1/2N of execution memory pool to be free"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.taskAttemptId$1)}));
                }
                {
                    this.taskAttemptId$1 = taskAttemptId$1;
                }
            });
            this.wait();
        }
        return this.acquire$1(toGrant, taskAttemptId);
    }

    @VisibleForTesting
    public synchronized void releaseExecutionMemory(long numBytes) {
        if (numBytes > this._executionMemoryUsed()) {
            this.logWarning((Function0<String>)new Serializable(this, numBytes){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MemoryManager $outer;
                private final long numBytes$2;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to release ", " bytes of execution "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.numBytes$2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory when we only have ", " bytes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer._executionMemoryUsed())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.numBytes$2 = numBytes$2;
                }
            });
            this._executionMemoryUsed_$eq(0L);
        } else {
            this._executionMemoryUsed_$eq(this._executionMemoryUsed() - numBytes);
        }
    }

    public final synchronized void releaseExecutionMemory(long numBytes, long taskAttemptId) {
        long curMem = BoxesRunTime.unboxToLong((Object)this.executionMemoryForTask().getOrElse((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        if (curMem < numBytes) {
            if (Utils$.MODULE$.isTesting()) {
                throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Internal error: release called on ", " bytes but task only has ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numBytes), BoxesRunTime.boxToLong((long)curMem)})));
            }
            this.logWarning((Function0<String>)new Serializable(this, numBytes, curMem){
                public static final long serialVersionUID = 0L;
                private final long numBytes$3;
                private final long curMem$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Internal error: release called on ", " bytes but task only has ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.numBytes$3), BoxesRunTime.boxToLong((long)this.curMem$1)}));
                }
                {
                    this.numBytes$3 = numBytes$3;
                    this.curMem$1 = curMem$1;
                }
            });
        }
        if (this.executionMemoryForTask().contains((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) {
            this.executionMemoryForTask().update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.executionMemoryForTask().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) - numBytes)));
            Object object = BoxesRunTime.unboxToLong((Object)this.executionMemoryForTask().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) <= 0L ? this.executionMemoryForTask().remove((Object)BoxesRunTime.boxToLong((long)taskAttemptId)) : BoxedUnit.UNIT;
            this.releaseExecutionMemory(numBytes);
        }
        this.notifyAll();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized long releaseAllExecutionMemoryForTask(long taskAttemptId) {
        void var3_2;
        long numBytesToFree = this.getExecutionMemoryUsageForTask(taskAttemptId);
        this.releaseExecutionMemory(numBytesToFree, taskAttemptId);
        return (long)var3_2;
    }

    public synchronized void releaseStorageMemory(long numBytes) {
        if (numBytes > this._storageMemoryUsed()) {
            this.logWarning((Function0<String>)new Serializable(this, numBytes){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MemoryManager $outer;
                private final long numBytes$4;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to release ", " bytes of storage "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.numBytes$4)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory when we only have ", " bytes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer._storageMemoryUsed())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.numBytes$4 = numBytes$4;
                }
            });
            this._storageMemoryUsed_$eq(0L);
        } else {
            this._storageMemoryUsed_$eq(this._storageMemoryUsed() - numBytes);
        }
    }

    public synchronized void releaseAllStorageMemory() {
        this._storageMemoryUsed_$eq(0L);
    }

    public synchronized void releaseUnrollMemory(long numBytes) {
        this.releaseStorageMemory(numBytes);
    }

    public final synchronized long executionMemoryUsed() {
        return this._executionMemoryUsed();
    }

    public final synchronized long storageMemoryUsed() {
        return this._storageMemoryUsed();
    }

    public synchronized long getExecutionMemoryUsageForTask(long taskAttemptId) {
        return BoxesRunTime.unboxToLong((Object)this.executionMemoryForTask().getOrElse((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public long pageSizeBytes() {
        return this.pageSizeBytes;
    }

    public final boolean tungstenMemoryIsAllocatedInHeap() {
        return this.tungstenMemoryIsAllocatedInHeap;
    }

    public final MemoryAllocator tungstenMemoryAllocator() {
        return this.tungstenMemoryAllocator;
    }

    private final synchronized long acquire$1(long toGrant, long taskAttemptId$1) {
        ArrayBuffer evictedBlocks = new ArrayBuffer();
        long acquired = this.doAcquireExecutionMemory(toGrant, (Buffer<Tuple2<BlockId, BlockStatus>>)evictedBlocks);
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new Serializable(this, evictedBlocks){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer evictedBlocks$1;

            public final void apply(TaskContext tc) {
                TaskMetrics metrics = tc.taskMetrics();
                Seq lastUpdatedBlocks = (Seq)metrics.updatedBlocks().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Tuple2<BlockId, BlockStatus>> apply() {
                        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                });
                metrics.updatedBlocks_$eq((Option<Seq<Tuple2<BlockId, BlockStatus>>>)new Some(lastUpdatedBlocks.$plus$plus((GenTraversableOnce)this.evictedBlocks$1.toSeq(), Seq$.MODULE$.canBuildFrom())));
            }
            {
                this.evictedBlocks$1 = evictedBlocks$1;
            }
        });
        this.executionMemoryForTask().update((Object)BoxesRunTime.boxToLong((long)taskAttemptId$1), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.executionMemoryForTask().apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId$1))) + acquired)));
        return acquired;
    }

    public MemoryManager(SparkConf conf, int numCores) {
        Logging$class.$init$(this);
        this._executionMemoryUsed = 0L;
        this._storageMemoryUsed = 0L;
        this.executionMemoryForTask = new HashMap();
        long minPageSize = 0x100000L;
        long maxPageSize = 64L * minPageSize;
        int cores = numCores > 0 ? numCores : Runtime.getRuntime().availableProcessors();
        int safetyFactor = 16;
        long size = ByteArrayMethods.nextPowerOf2((long)(this.maxExecutionMemory() / (long)cores / (long)safetyFactor));
        long l = package$.MODULE$.min(maxPageSize, package$.MODULE$.max(minPageSize, size));
        this.pageSizeBytes = conf.getSizeAsBytes("spark.buffer.pageSize", l);
        this.tungstenMemoryIsAllocatedInHeap = !conf.getBoolean("spark.unsafe.offHeap", false);
        this.tungstenMemoryAllocator = this.tungstenMemoryIsAllocatedInHeap() ? MemoryAllocator.HEAP : MemoryAllocator.UNSAFE;
    }
}

