/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import java.io.IOException;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.unsafe.memory.MemoryBlock;

public abstract class MemoryConsumer {
    private final TaskMemoryManager taskMemoryManager;
    private final long pageSize;
    private long used;

    protected MemoryConsumer(TaskMemoryManager taskMemoryManager, long pageSize) {
        this.taskMemoryManager = taskMemoryManager;
        this.pageSize = pageSize;
        this.used = 0L;
    }

    protected MemoryConsumer(TaskMemoryManager taskMemoryManager) {
        this(taskMemoryManager, taskMemoryManager.pageSizeBytes());
    }

    long getUsed() {
        return this.used;
    }

    public void spill() throws IOException {
        this.spill(Long.MAX_VALUE, this);
    }

    public abstract long spill(long var1, MemoryConsumer var3) throws IOException;

    protected void acquireMemory(long size) {
        long got = this.taskMemoryManager.acquireExecutionMemory(size, this);
        if (got < size) {
            this.taskMemoryManager.releaseExecutionMemory(got, this);
            this.taskMemoryManager.showMemoryUsage();
            throw new OutOfMemoryError("Could not acquire " + size + " bytes of memory, got " + got);
        }
        this.used += got;
    }

    protected void releaseMemory(long size) {
        this.used -= size;
        this.taskMemoryManager.releaseExecutionMemory(size, this);
    }

    protected MemoryBlock allocatePage(long required) {
        MemoryBlock page = this.taskMemoryManager.allocatePage(Math.max(this.pageSize, required), this);
        if (page == null || page.size() < required) {
            long got = 0L;
            if (page != null) {
                got = page.size();
                this.freePage(page);
            }
            this.taskMemoryManager.showMemoryUsage();
            throw new OutOfMemoryError("Unable to acquire " + required + " bytes of memory, got " + got);
        }
        this.used += page.size();
        return page;
    }

    protected void freePage(MemoryBlock page) {
        this.used -= page.size();
        this.taskMemoryManager.freePage(page, this);
    }
}

