/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.executor;

import java.io.File;
import java.io.NotSerializableException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.ExceptionFailure;
import org.apache.spark.Heartbeat;
import org.apache.spark.HeartbeatReceiver$;
import org.apache.spark.HeartbeatResponse;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFiles$;
import org.apache.spark.TaskEndReason;
import org.apache.spark.TaskKilled$;
import org.apache.spark.TaskKilledException;
import org.apache.spark.TaskState$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.executor.CommitDeniedException;
import org.apache.spark.executor.Executor$;
import org.apache.spark.executor.Executor$$anonfun$org$apache$spark$executor$Executor$;
import org.apache.spark.executor.Executor$TaskRunner$;
import org.apache.spark.executor.ExecutorBackend;
import org.apache.spark.executor.ExecutorEndpoint;
import org.apache.spark.executor.ExecutorEndpoint$;
import org.apache.spark.executor.ExecutorSource;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.scheduler.DirectTaskResult;
import org.apache.spark.scheduler.IndirectTaskResult;
import org.apache.spark.scheduler.Task;
import org.apache.spark.scheduler.Task$;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.storage.TaskResultBlockId;
import org.apache.spark.util.AkkaUtils$;
import org.apache.spark.util.ChildFirstURLClassLoader;
import org.apache.spark.util.MutableURLClassLoader;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.SparkUncaughtExceptionHandler$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;
import scala.runtime.VolatileByteRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t5g!B\u0001\u0003\u0001\u0011Q!\u0001C#yK\u000e,Ho\u001c:\u000b\u0005\r!\u0011\u0001C3yK\u000e,Ho\u001c:\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c2\u0001A\u0006\u0012!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fMB\u0011!cE\u0007\u0002\t%\u0011A\u0003\u0002\u0002\b\u0019><w-\u001b8h\u0011!1\u0002A!A!\u0002\u0013A\u0012AC3yK\u000e,Ho\u001c:JI\u000e\u0001\u0001CA\r\u001d\u001d\ta!$\u0003\u0002\u001c\u001b\u00051\u0001K]3eK\u001aL!!\b\u0010\u0003\rM#(/\u001b8h\u0015\tYR\u0002\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\u0019\u0003A)\u00070Z2vi>\u0014\bj\\:u]\u0006lW\r\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0003\r)gN\u001e\t\u0003%\u0011J!!\n\u0003\u0003\u0011M\u0003\u0018M]6F]ZD\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u000ekN,'o\u00117bgN\u0004\u0016\r\u001e5\u0011\u0007%\nDG\u0004\u0002+_9\u00111FL\u0007\u0002Y)\u0011QfF\u0001\u0007yI|w\u000e\u001e \n\u00039I!\u0001M\u0007\u0002\u000fA\f7m[1hK&\u0011!g\r\u0002\u0004'\u0016\f(B\u0001\u0019\u000e!\t)$(D\u00017\u0015\t9\u0004(A\u0002oKRT\u0011!O\u0001\u0005U\u00064\u0018-\u0003\u0002<m\t\u0019QK\u0015'\t\u0011u\u0002!\u0011!Q\u0001\ny\nq![:M_\u000e\fG\u000e\u0005\u0002\r\u007f%\u0011\u0001)\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0003\u0019a\u0014N\\5u}Q1AIR$I\u0013*\u0003\"!\u0012\u0001\u000e\u0003\tAQAF!A\u0002aAQ\u0001I!A\u0002aAQAI!A\u0002\rBqaJ!\u0011\u0002\u0003\u0007\u0001\u0006C\u0004>\u0003B\u0005\t\u0019\u0001 \t\u000f1\u0003!\u0019!C\u0005\u001b\u0006a1-\u001e:sK:$h)\u001b7fgV\ta\n\u0005\u0003P)b1V\"\u0001)\u000b\u0005E\u0013\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0003'6\t!bY8mY\u0016\u001cG/[8o\u0013\t)\u0006KA\u0004ICNDW*\u00199\u0011\u000519\u0016B\u0001-\u000e\u0005\u0011auN\\4\t\ri\u0003\u0001\u0015!\u0003O\u00035\u0019WO\u001d:f]R4\u0015\u000e\\3tA!9A\f\u0001b\u0001\n\u0013i\u0015aC2veJ,g\u000e\u001e&beNDaA\u0018\u0001!\u0002\u0013q\u0015\u0001D2veJ,g\u000e\u001e&beN\u0004\u0003b\u00021\u0001\u0005\u0004%I!Y\u0001\u0012\u000b6\u0003F+W0C3R+uLQ+G\r\u0016\u0013V#\u00012\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015D\u0014a\u00018j_&\u0011q\r\u001a\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bBB5\u0001A\u0003%!-\u0001\nF\u001bB#\u0016l\u0018\"Z)\u0016{&)\u0016$G\u000bJ\u0003\u0003bB6\u0001\u0005\u0004%I\u0001\\\u0001\u0005G>tg-F\u0001n!\t\u0011b.\u0003\u0002p\t\tI1\u000b]1sW\u000e{gN\u001a\u0005\u0007c\u0002\u0001\u000b\u0011B7\u0002\u000b\r|gN\u001a\u0011\t\u000fM\u0004!\u0019!C\u0005i\u0006QA\u000f\u001b:fC\u0012\u0004vn\u001c7\u0016\u0003U\u0004\"A^>\u000e\u0003]T!\u0001_=\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002{q\u0005!Q\u000f^5m\u0013\taxO\u0001\nUQJ,\u0017\r\u001a)p_2,\u00050Z2vi>\u0014\bB\u0002@\u0001A\u0003%Q/A\u0006uQJ,\u0017\r\u001a)p_2\u0004\u0003\"CA\u0001\u0001\t\u0007I\u0011BA\u0002\u00039)\u00070Z2vi>\u00148k\\;sG\u0016,\"!!\u0002\u0011\u0007\u0015\u000b9!C\u0002\u0002\n\t\u0011a\"\u0012=fGV$xN]*pkJ\u001cW\r\u0003\u0005\u0002\u000e\u0001\u0001\u000b\u0011BA\u0003\u0003=)\u00070Z2vi>\u00148k\\;sG\u0016\u0004\u0003\"CA\t\u0001\t\u0007I\u0011BA\n\u0003A)\u00070Z2vi>\u0014XI\u001c3q_&tG/\u0006\u0002\u0002\u0016A!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001c\u0011\t1A\u001d9d\u0013\u0011\ty\"!\u0007\u0003\u001dI\u00038-\u00128ea>Lg\u000e\u001e*fM\"A\u00111\u0005\u0001!\u0002\u0013\t)\"A\tfq\u0016\u001cW\u000f^8s\u000b:$\u0007o\\5oi\u0002B\u0011\"a\n\u0001\u0005\u0004%I!!\u000b\u0002%U\u001cXM]\"mCN\u001c\b+\u0019;i\r&\u00148\u000f^\u000b\u0002}!9\u0011Q\u0006\u0001!\u0002\u0013q\u0014aE;tKJ\u001cE.Y:t!\u0006$\bNR5sgR\u0004\u0003\"CA\u0019\u0001\t\u0007I\u0011BA\u001a\u00039)(\u000f\\\"mCN\u001cHj\\1eKJ,\"!!\u000e\u0011\t\u0005]\u00121H\u0007\u0003\u0003sQ!A\u001f\u0003\n\t\u0005u\u0012\u0011\b\u0002\u0016\u001bV$\u0018M\u00197f+Jc5\t\\1tg2{\u0017\rZ3s\u0011!\t\t\u0005\u0001Q\u0001\n\u0005U\u0012aD;sY\u000ec\u0017m]:M_\u0006$WM\u001d\u0011\t\u0013\u0005\u0015\u0003A1A\u0005\n\u0005\u001d\u0013a\u0004:fa2\u001cE.Y:t\u0019>\fG-\u001a:\u0016\u0005\u0005%\u0003\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=\u0003(\u0001\u0003mC:<\u0017\u0002BA*\u0003\u001b\u00121b\u00117bgNdu.\u00193fe\"A\u0011q\u000b\u0001!\u0002\u0013\tI%\u0001\tsKBd7\t\\1tg2{\u0017\rZ3sA!I\u00111\f\u0001C\u0002\u0013%\u0011QL\u0001\u000eC.\\\u0017M\u0012:b[\u0016\u001c\u0016N_3\u0016\u0005\u0005}\u0003c\u0001\u0007\u0002b%\u0019\u00111M\u0007\u0003\u0007%sG\u000f\u0003\u0005\u0002h\u0001\u0001\u000b\u0011BA0\u00039\t7n[1Ge\u0006lWmU5{K\u0002B\u0011\"a\u001b\u0001\u0005\u0004%I!!\u001c\u0002\u001b5\f\u0007PU3tk2$8+\u001b>f+\u00051\u0006bBA9\u0001\u0001\u0006IAV\u0001\u000f[\u0006D(+Z:vYR\u001c\u0016N_3!\u0011%\t)\b\u0001b\u0001\n\u0013\t9(\u0001\u0007sk:t\u0017N\\4UCN\\7/\u0006\u0002\u0002zA1a/a\u001fW\u0003\u007fJ1!! x\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0005\u0003\u0003\u000b\u0019)D\u0001\u0001\r\u0019\t)\t\u0001\u0001\u0002\b\nQA+Y:l%Vtg.\u001a:\u0014\r\u0005\r\u0015\u0011RAH!\u0011\tY%a#\n\t\u00055\u0015Q\n\u0002\u0007\u001f\nTWm\u0019;\u0011\t\u0005-\u0013\u0011S\u0005\u0005\u0003'\u000biE\u0001\u0005Sk:t\u0017M\u00197f\u0011-\t9*a!\u0003\u0002\u0003\u0006I!!'\u0002\u0017\u0015DXm\u0019\"bG.,g\u000e\u001a\t\u0004\u000b\u0006m\u0015bAAO\u0005\tyQ\t_3dkR|'OQ1dW\u0016tG\rC\u0006\u0002\"\u0006\r%Q1A\u0005\u0002\u00055\u0014A\u0002;bg.LE\r\u0003\u0006\u0002&\u0006\r%\u0011!Q\u0001\nY\u000bq\u0001^1tW&#\u0007\u0005C\u0006\u0002*\u0006\r%Q1A\u0005\u0002\u0005u\u0013!D1ui\u0016l\u0007\u000f\u001e(v[\n,'\u000fC\u0006\u0002.\u0006\r%\u0011!Q\u0001\n\u0005}\u0013AD1ui\u0016l\u0007\u000f\u001e(v[\n,'\u000f\t\u0005\u000b\u0003c\u000b\u0019I!A!\u0002\u0013A\u0012\u0001\u0003;bg.t\u0015-\\3\t\u0015\u0005U\u00161\u0011B\u0001B\u0003%!-\u0001\btKJL\u0017\r\\5{K\u0012$\u0016m]6\t\u000f\t\u000b\u0019\t\"\u0001\u0002:Ra\u0011qPA^\u0003{\u000by,!1\u0002D\"A\u0011qSA\\\u0001\u0004\tI\nC\u0004\u0002\"\u0006]\u0006\u0019\u0001,\t\u0011\u0005%\u0016q\u0017a\u0001\u0003?Bq!!-\u00028\u0002\u0007\u0001\u0004C\u0004\u00026\u0006]\u0006\u0019\u00012\t\u0015\u0005\u001d\u00171\u0011a\u0001\n\u0013\tI#\u0001\u0004lS2dW\r\u001a\u0005\u000b\u0003\u0017\f\u0019\t1A\u0005\n\u00055\u0017AC6jY2,Gm\u0018\u0013fcR!\u0011qZAk!\ra\u0011\u0011[\u0005\u0004\u0003'l!\u0001B+oSRD\u0011\"a6\u0002J\u0006\u0005\t\u0019\u0001 \u0002\u0007a$\u0013\u0007\u0003\u0005\u0002\\\u0006\r\u0005\u0015)\u0003?\u0003\u001dY\u0017\u000e\u001c7fI\u0002BC!!7\u0002`B\u0019A\"!9\n\u0007\u0005\rXB\u0001\u0005w_2\fG/\u001b7f\u00111\t9/a!A\u0002\u0003\u0007I\u0011AA7\u0003-\u0019H/\u0019:u\u000f\u000e#\u0016.\\3\t\u0019\u0005-\u00181\u0011a\u0001\u0002\u0004%\t!!<\u0002\u001fM$\u0018M\u001d;H\u0007RKW.Z0%KF$B!a4\u0002p\"I\u0011q[Au\u0003\u0003\u0005\rA\u0016\u0005\t\u0003g\f\u0019\t)Q\u0005-\u0006a1\u000f^1si\u001e\u001bE+[7fA!\"\u0011\u0011_Ap\u00111\tI0a!A\u0002\u0003\u0007I\u0011AA~\u0003\u0011!\u0018m]6\u0016\u0005\u0005u\bCBA\u0000\u0005\u000b\u0011I!\u0004\u0002\u0003\u0002)\u0019!1\u0001\u0003\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018\u0002\u0002B\u0004\u0005\u0003\u0011A\u0001V1tWB\u0019ABa\u0003\n\u0007\t5QBA\u0002B]fDAB!\u0005\u0002\u0004\u0002\u0007\t\u0019!C\u0001\u0005'\t\u0001\u0002^1tW~#S-\u001d\u000b\u0005\u0003\u001f\u0014)\u0002\u0003\u0006\u0002X\n=\u0011\u0011!a\u0001\u0003{D\u0011B!\u0007\u0002\u0004\u0002\u0006K!!@\u0002\u000bQ\f7o\u001b\u0011)\t\t]\u0011q\u001c\u0005\t\u0005?\t\u0019\t\"\u0001\u0003\"\u0005!1.\u001b7m)\u0011\tyMa\t\t\u000f\t\u0015\"Q\u0004a\u0001}\u0005y\u0011N\u001c;feJ,\b\u000f\u001e+ie\u0016\fG\r\u0003\u0005\u0003*\u0005\rE\u0011\tB\u0016\u0003\r\u0011XO\u001c\u000b\u0003\u0003\u001fD\u0001Ba\f\u0001A\u0003%\u0011\u0011P\u0001\u000eeVtg.\u001b8h)\u0006\u001c8n\u001d\u0011\t\u0013\tM\u0002A1A\u0005\n\tU\u0012a\u00035fCJ$(-Z1uKJ,\"Aa\u000e\u0011\u0007Y\u0014I$C\u0002\u0003<]\u0014\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011!\u0011y\u0004\u0001Q\u0001\n\t]\u0012\u0001\u00045fCJ$(-Z1uKJ\u0004\u0003b\u0002B\"\u0001\u0011\u0005!QI\u0001\u000bY\u0006,hn\u00195UCN\\G\u0003DAh\u0005\u000f\u0012YE!\u0014\u0003P\tE\u0003\u0002\u0003B%\u0005\u0003\u0002\r!!'\u0002\u000f\r|g\u000e^3yi\"9\u0011\u0011\u0015B!\u0001\u00041\u0006\u0002CAU\u0005\u0003\u0002\r!a\u0018\t\u000f\u0005E&\u0011\ta\u00011!9\u0011Q\u0017B!\u0001\u0004\u0011\u0007b\u0002B+\u0001\u0011\u0005!qK\u0001\tW&dG\u000eV1tWR1\u0011q\u001aB-\u00057Bq!!)\u0003T\u0001\u0007a\u000bC\u0004\u0003&\tM\u0003\u0019\u0001 \t\u000f\t}\u0003\u0001\"\u0001\u0003b\u0005a1.\u001b7m\u00032dG+Y:lgR!\u0011q\u001aB2\u0011\u001d\u0011)C!\u0018A\u0002yBqAa\u001a\u0001\t\u0003\u0011Y#\u0001\u0003ti>\u0004\bb\u0002B6\u0001\u0011%!QN\u0001\u0013G>l\u0007/\u001e;f)>$\u0018\r\\$d)&lW\rF\u0001W\u0011\u001d\u0011\t\b\u0001C\u0005\u0005g\n\u0011c\u0019:fCR,7\t\\1tg2{\u0017\rZ3s)\t\t)\u0004C\u0004\u0003x\u0001!IA!\u001f\u00025\u0005$GMU3qY\u000ec\u0017m]:M_\u0006$WM]%g\u001d\u0016,G-\u001a3\u0015\t\u0005%#1\u0010\u0005\t\u0005{\u0012)\b1\u0001\u0002J\u00051\u0001/\u0019:f]RDqA!!\u0001\t\u0013\u0011\u0019)\u0001\nva\u0012\fG/\u001a#fa\u0016tG-\u001a8dS\u0016\u001cHCBAh\u0005\u000b\u0013I\tC\u0004\u0003\b\n}\u0004\u0019\u0001(\u0002\u00119,wOR5mKNDqAa#\u0003\u0000\u0001\u0007a*A\u0004oK^T\u0015M]:\t\u0013\t=\u0005A1A\u0005\n\u0005M\u0011\u0001\u00065fCJ$(-Z1u%\u0016\u001cW-\u001b<feJ+g\r\u0003\u0005\u0003\u0014\u0002\u0001\u000b\u0011BA\u000b\u0003UAW-\u0019:uE\u0016\fGOU3dK&4XM\u001d*fM\u0002BqAa&\u0001\t\u0013\u0011Y#A\bsKB|'\u000f\u001e%fCJ$()Z1u\u0011\u001d\u0011Y\n\u0001C\u0005\u0005W\tac\u001d;beR$%/\u001b<fe\"+\u0017M\u001d;cK\u0006$XM]\u0004\u000b\u0005?\u0013\u0011\u0011!E\u0001\t\t\u0005\u0016\u0001C#yK\u000e,Ho\u001c:\u0011\u0007\u0015\u0013\u0019KB\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001\u0003\u0003&N\u0019!1U\u0006\t\u000f\t\u0013\u0019\u000b\"\u0001\u0003*R\u0011!\u0011\u0015\u0005\u000b\u0005[\u0013\u0019+%A\u0005\u0002\t=\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u00032*\u001a\u0001Fa-,\u0005\tU\u0006\u0003\u0002B\\\u0005\u0003l!A!/\u000b\t\tm&QX\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa0\u000e\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0007\u0014ILA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!Ba2\u0003$F\u0005I\u0011\u0001Be\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!1\u001a\u0016\u0004}\tM\u0006")
public class Executor
implements Logging {
    public final String org$apache$spark$executor$Executor$$executorId;
    public final String org$apache$spark$executor$Executor$$executorHostname;
    public final SparkEnv org$apache$spark$executor$Executor$$env;
    private final Seq<URL> userClassPath;
    public final boolean org$apache$spark$executor$Executor$$isLocal;
    private final HashMap<String, Object> org$apache$spark$executor$Executor$$currentFiles;
    private final HashMap<String, Object> org$apache$spark$executor$Executor$$currentJars;
    private final ByteBuffer org$apache$spark$executor$Executor$$EMPTY_BYTE_BUFFER;
    private final SparkConf org$apache$spark$executor$Executor$$conf;
    private final ThreadPoolExecutor threadPool;
    private final ExecutorSource executorSource;
    private final RpcEndpointRef executorEndpoint;
    private final boolean userClassPathFirst;
    private final MutableURLClassLoader org$apache$spark$executor$Executor$$urlClassLoader;
    private final ClassLoader org$apache$spark$executor$Executor$$replClassLoader;
    private final int org$apache$spark$executor$Executor$$akkaFrameSize;
    private final long org$apache$spark$executor$Executor$$maxResultSize;
    private final ConcurrentHashMap<Object, TaskRunner> org$apache$spark$executor$Executor$$runningTasks;
    private final ScheduledExecutorService heartbeater;
    private final RpcEndpointRef heartbeatReceiverRef;
    private transient Logger org$apache$spark$Logging$$log_;

    public static boolean $lessinit$greater$default$5() {
        return Executor$.MODULE$.$lessinit$greater$default$5();
    }

    public static Seq<URL> $lessinit$greater$default$4() {
        return Executor$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public HashMap<String, Object> org$apache$spark$executor$Executor$$currentFiles() {
        return this.org$apache$spark$executor$Executor$$currentFiles;
    }

    public HashMap<String, Object> org$apache$spark$executor$Executor$$currentJars() {
        return this.org$apache$spark$executor$Executor$$currentJars;
    }

    public ByteBuffer org$apache$spark$executor$Executor$$EMPTY_BYTE_BUFFER() {
        return this.org$apache$spark$executor$Executor$$EMPTY_BYTE_BUFFER;
    }

    public SparkConf org$apache$spark$executor$Executor$$conf() {
        return this.org$apache$spark$executor$Executor$$conf;
    }

    private ThreadPoolExecutor threadPool() {
        return this.threadPool;
    }

    private ExecutorSource executorSource() {
        return this.executorSource;
    }

    private RpcEndpointRef executorEndpoint() {
        return this.executorEndpoint;
    }

    private boolean userClassPathFirst() {
        return this.userClassPathFirst;
    }

    public MutableURLClassLoader org$apache$spark$executor$Executor$$urlClassLoader() {
        return this.org$apache$spark$executor$Executor$$urlClassLoader;
    }

    public ClassLoader org$apache$spark$executor$Executor$$replClassLoader() {
        return this.org$apache$spark$executor$Executor$$replClassLoader;
    }

    public int org$apache$spark$executor$Executor$$akkaFrameSize() {
        return this.org$apache$spark$executor$Executor$$akkaFrameSize;
    }

    public long org$apache$spark$executor$Executor$$maxResultSize() {
        return this.org$apache$spark$executor$Executor$$maxResultSize;
    }

    public ConcurrentHashMap<Object, TaskRunner> org$apache$spark$executor$Executor$$runningTasks() {
        return this.org$apache$spark$executor$Executor$$runningTasks;
    }

    private ScheduledExecutorService heartbeater() {
        return this.heartbeater;
    }

    public void launchTask(ExecutorBackend context, long taskId, int attemptNumber, String taskName, ByteBuffer serializedTask) {
        TaskRunner tr = new TaskRunner(this, context, taskId, attemptNumber, taskName, serializedTask);
        this.org$apache$spark$executor$Executor$$runningTasks().put(BoxesRunTime.boxToLong((long)taskId), tr);
        this.threadPool().execute(tr);
    }

    public void killTask(long taskId, boolean interruptThread) {
        TaskRunner tr = this.org$apache$spark$executor$Executor$$runningTasks().get(BoxesRunTime.boxToLong((long)taskId));
        if (tr != null) {
            tr.kill(interruptThread);
        }
    }

    public void killAllTasks(boolean interruptThread) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.org$apache$spark$executor$Executor$$runningTasks().values()).asScala()).foreach((Function1)new Serializable(this, interruptThread){
            public static final long serialVersionUID = 0L;
            private final boolean interruptThread$1;

            public final void apply(TaskRunner taskRunner) {
                if (taskRunner != null) {
                    taskRunner.kill(this.interruptThread$1);
                }
            }
            {
                this.interruptThread$1 = interruptThread$1;
            }
        });
    }

    public void stop() {
        this.org$apache$spark$executor$Executor$$env.metricsSystem().report();
        this.org$apache$spark$executor$Executor$$env.rpcEnv().stop(this.executorEndpoint());
        this.heartbeater().shutdown();
        this.heartbeater().awaitTermination(10L, TimeUnit.SECONDS);
        this.threadPool().shutdown();
        if (!this.org$apache$spark$executor$Executor$$isLocal) {
            this.org$apache$spark$executor$Executor$$env.stop();
        }
    }

    public long org$apache$spark$executor$Executor$$computeTotalGcTime() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ManagementFactory.getGarbageCollectorMXBeans()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(GarbageCollectorMXBean x$1) {
                return x$1.getCollectionTime();
            }
        }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private MutableURLClassLoader createClassLoader() {
        long now = System.currentTimeMillis();
        this.userClassPath.foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Executor $outer;
            private final long now$1;

            public final void apply(URL url) {
                this.$outer.org$apache$spark$executor$Executor$$currentJars().update(Predef$.MODULE$.refArrayOps((Object[])url.getPath().split("/")).last(), (Object)BoxesRunTime.boxToLong((long)this.now$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.now$1 = now$1;
            }
        });
        ClassLoader currentLoader = Utils$.MODULE$.getContextOrSparkClassLoader();
        URL[] urls = (URL[])Predef$.MODULE$.refArrayOps((Object[])this.userClassPath.toArray(ClassTag$.MODULE$.apply(URL.class))).$plus$plus((GenTraversableOnce)this.org$apache$spark$executor$Executor$$currentJars().keySet().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final URL apply(String uri) {
                return new File((String)Predef$.MODULE$.refArrayOps((Object[])uri.split("/")).last()).toURI().toURL();
            }
        }, Set$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class)));
        return this.userClassPathFirst() ? new ChildFirstURLClassLoader(urls, currentLoader) : new MutableURLClassLoader(urls, currentLoader);
    }

    private ClassLoader addReplClassLoaderIfNeeded(ClassLoader parent) {
        ClassLoader classLoader;
        String classUri = this.org$apache$spark$executor$Executor$$conf().get("spark.repl.class.uri", null);
        if (classUri == null) {
            classLoader = parent;
        } else {
            this.logInfo((Function0<String>)new Serializable(this, classUri){
                public static final long serialVersionUID = 0L;
                private final String classUri$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using REPL class URI: ").append((Object)this.classUri$1).toString();
                }
                {
                    this.classUri$1 = classUri$1;
                }
            });
            try {
                Boolean _userClassPathFirst = Predef$.MODULE$.boolean2Boolean(this.userClassPathFirst());
                Class<?> klass = Utils$.MODULE$.classForName("org.apache.spark.repl.ExecutorClassLoader");
                Constructor<?> constructor = klass.getConstructor(SparkConf.class, String.class, ClassLoader.class, Boolean.TYPE);
                classLoader = (ClassLoader)constructor.newInstance(this.org$apache$spark$executor$Executor$$conf(), classUri, parent, _userClassPathFirst);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logError((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Could not find org.apache.spark.repl.ExecutorClassLoader on classpath!";
                    }
                });
                System.exit(1);
                classLoader = null;
            }
        }
        return classLoader;
    }

    public void org$apache$spark$executor$Executor$$updateDependencies(HashMap<String, Object> newFiles, HashMap<String, Object> newJars) {
        ObjectRef hadoopConf$lzy = new ObjectRef(null);
        VolatileByteRef bitmap$0 = new VolatileByteRef(0);
        Executor executor = this;
        synchronized (executor) {
            newFiles.withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                    Tuple2<String, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Executor $outer;

                public final boolean apply(Tuple2<String, Object> x$4) {
                    Tuple2<String, Object> tuple2 = x$4;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        long timestamp = tuple2._2$mcJ$sp();
                        boolean bl = BoxesRunTime.unboxToLong((Object)this.$outer.org$apache$spark$executor$Executor$$currentFiles().getOrElse((Object)name, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return -1L;
                            }
                        })) < timestamp;
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }).foreach((Function1)new Serializable(this, hadoopConf$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Executor $outer;
                private final ObjectRef hadoopConf$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final void apply(Tuple2<String, Object> x$5) {
                    Tuple2<String, Object> tuple2 = x$5;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        long timestamp = tuple2._2$mcJ$sp();
                        this.$outer.logInfo((Function0<String>)new Serializable(this, name, timestamp){
                            public static final long serialVersionUID = 0L;
                            private final String name$1;
                            private final long timestamp$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Fetching ").append((Object)this.name$1).append((Object)" with timestamp ").append((Object)BoxesRunTime.boxToLong((long)this.timestamp$1)).toString();
                            }
                            {
                                this.name$1 = name$1;
                                this.timestamp$1 = timestamp$1;
                            }
                        });
                        Utils$.MODULE$.fetchFile(name, new File(SparkFiles$.MODULE$.getRootDirectory()), this.$outer.org$apache$spark$executor$Executor$$conf(), this.$outer.org$apache$spark$executor$Executor$$env.securityManager(), this.$outer.org$apache$spark$executor$Executor$$hadoopConf$1(this.hadoopConf$lzy$1, this.bitmap$0$1), timestamp, !this.$outer.org$apache$spark$executor$Executor$$isLocal);
                        this.$outer.org$apache$spark$executor$Executor$$currentFiles().update((Object)name, (Object)BoxesRunTime.boxToLong((long)timestamp));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.hadoopConf$lzy$1 = hadoopConf$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
            newJars.withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Object> check$ifrefutable$2) {
                    Tuple2<String, Object> tuple2 = check$ifrefutable$2;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, hadoopConf$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Executor $outer;
                private final ObjectRef hadoopConf$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final void apply(Tuple2<String, Object> x$6) {
                    Tuple2<String, Object> tuple2 = x$6;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        String name = (String)tuple2._1();
                        long timestamp = tuple2._2$mcJ$sp();
                        String localName = (String)Predef$.MODULE$.refArrayOps((Object[])name.split("/")).last();
                        long currentTimeStamp = BoxesRunTime.unboxToLong((Object)this.$outer.org$apache$spark$executor$Executor$$currentJars().get((Object)name).orElse((Function0)new Serializable(this, localName){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$org$apache$spark$executor$Executor$$updateDependencies$5 $outer;
                            private final String localName$1;

                            public final Option<Object> apply() {
                                return this.$outer.org$apache$spark$executor$Executor$$anonfun$$$outer().org$apache$spark$executor$Executor$$currentJars().get((Object)this.localName$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.localName$1 = localName$1;
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return -1L;
                            }
                        }));
                        if (currentTimeStamp < timestamp) {
                            this.$outer.logInfo((Function0<String>)new Serializable(this, name, timestamp){
                                public static final long serialVersionUID = 0L;
                                private final String name$2;
                                private final long timestamp$2;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Fetching ").append((Object)this.name$2).append((Object)" with timestamp ").append((Object)BoxesRunTime.boxToLong((long)this.timestamp$2)).toString();
                                }
                                {
                                    this.name$2 = name$2;
                                    this.timestamp$2 = timestamp$2;
                                }
                            });
                            Utils$.MODULE$.fetchFile(name, new File(SparkFiles$.MODULE$.getRootDirectory()), this.$outer.org$apache$spark$executor$Executor$$conf(), this.$outer.org$apache$spark$executor$Executor$$env.securityManager(), this.$outer.org$apache$spark$executor$Executor$$hadoopConf$1(this.hadoopConf$lzy$1, this.bitmap$0$1), timestamp, !this.$outer.org$apache$spark$executor$Executor$$isLocal);
                            this.$outer.org$apache$spark$executor$Executor$$currentJars().update((Object)name, (Object)BoxesRunTime.boxToLong((long)timestamp));
                            URL url = new File(SparkFiles$.MODULE$.getRootDirectory(), localName).toURI().toURL();
                            if (Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$executor$Executor$$urlClassLoader().getURLs()).contains((Object)url)) {
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                this.$outer.logInfo((Function0<String>)new Serializable(this, url){
                                    public static final long serialVersionUID = 0L;
                                    private final URL url$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Adding ").append((Object)this.url$1).append((Object)" to class loader").toString();
                                    }
                                    {
                                        this.url$1 = url$1;
                                    }
                                });
                                this.$outer.org$apache$spark$executor$Executor$$urlClassLoader().addURL(url);
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple2);
                }

                public /* synthetic */ Executor org$apache$spark$executor$Executor$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.hadoopConf$lzy$1 = hadoopConf$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
            return;
        }
    }

    private RpcEndpointRef heartbeatReceiverRef() {
        return this.heartbeatReceiverRef;
    }

    public void org$apache$spark$executor$Executor$$reportHeartBeat() {
        ArrayBuffer tasksMetrics = new ArrayBuffer();
        long curGCTime = this.org$apache$spark$executor$Executor$$computeTotalGcTime();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.org$apache$spark$executor$Executor$$runningTasks().values()).asScala()).foreach((Function1)new Serializable(this, tasksMetrics, curGCTime){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Executor $outer;
            public final ArrayBuffer tasksMetrics$1;
            public final long curGCTime$1;

            public final void apply(TaskRunner taskRunner) {
                if (taskRunner.task() != null) {
                    taskRunner.task().metrics().foreach((Function1)new Serializable(this, taskRunner){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$org$apache$spark$executor$Executor$$reportHeartBeat$1 $outer;
                        private final TaskRunner taskRunner$1;

                        public final ArrayBuffer<Tuple2<Object, TaskMetrics>> apply(TaskMetrics metrics) {
                            ArrayBuffer arrayBuffer;
                            metrics.updateShuffleReadMetrics();
                            metrics.updateInputMetrics();
                            metrics.setJvmGCTime(this.$outer.curGCTime$1 - this.taskRunner$1.startGCTime());
                            metrics.updateAccumulators();
                            if (this.$outer.org$apache$spark$executor$Executor$$anonfun$$$outer().org$apache$spark$executor$Executor$$isLocal) {
                                TaskMetrics copiedMetrics = (TaskMetrics)Utils$.MODULE$.deserialize(Utils$.MODULE$.serialize(metrics));
                                arrayBuffer = this.$outer.tasksMetrics$1.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)this.taskRunner$1.taskId()), (Object)copiedMetrics));
                            } else {
                                arrayBuffer = this.$outer.tasksMetrics$1.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)this.taskRunner$1.taskId()), (Object)metrics));
                            }
                            return arrayBuffer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.taskRunner$1 = taskRunner$1;
                        }
                    });
                }
            }

            public /* synthetic */ Executor org$apache$spark$executor$Executor$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.tasksMetrics$1 = tasksMetrics$1;
                this.curGCTime$1 = curGCTime$1;
            }
        });
        Heartbeat message = new Heartbeat(this.org$apache$spark$executor$Executor$$executorId, (Tuple2[])tasksMetrics.toArray(ClassTag$.MODULE$.apply(Tuple2.class)), this.org$apache$spark$executor$Executor$$env.blockManager().blockManagerId());
        try {
            HeartbeatResponse response = (HeartbeatResponse)this.heartbeatReceiverRef().askWithRetry(message, ClassTag$.MODULE$.apply(HeartbeatResponse.class));
            if (response.reregisterBlockManager()) {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Told to re-register on heartbeat";
                    }
                });
                this.org$apache$spark$executor$Executor$$env.blockManager().reregister();
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Issue communicating with driver in heartbeater";
                }
            }, e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void startDriverHeartbeater() {
        long intervalMs = this.org$apache$spark$executor$Executor$$conf().getTimeAsMs("spark.executor.heartbeatInterval", "10s");
        long initialDelay = intervalMs + (long)((int)(package$.MODULE$.random() * (double)intervalMs));
        Runnable heartbeatTask = new Runnable(this){
            private final /* synthetic */ Executor $outer;

            public void run() {
                Utils$.MODULE$.logUncaughtExceptions(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$executor$Executor$$anon$$$outer().org$apache$spark$executor$Executor$$reportHeartBeat();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ Executor org$apache$spark$executor$Executor$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        this.heartbeater().scheduleAtFixedRate(heartbeatTask, initialDelay, intervalMs, TimeUnit.MILLISECONDS);
    }

    private final Configuration hadoopConf$lzycompute$1(ObjectRef hadoopConf$lzy$1, VolatileByteRef bitmap$0$1) {
        Executor executor = this;
        synchronized (executor) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                hadoopConf$lzy$1.elem = SparkHadoopUtil$.MODULE$.get().newConfiguration(this.org$apache$spark$executor$Executor$$conf());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Configuration)hadoopConf$lzy$1.elem;
        }
    }

    public final Configuration org$apache$spark$executor$Executor$$hadoopConf$1(ObjectRef hadoopConf$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.hadoopConf$lzycompute$1(hadoopConf$lzy$1, bitmap$0$1) : (Configuration)hadoopConf$lzy$1.elem;
    }

    public Executor(String executorId, String executorHostname, SparkEnv env, Seq<URL> userClassPath, boolean isLocal) {
        this.org$apache$spark$executor$Executor$$executorId = executorId;
        this.org$apache$spark$executor$Executor$$executorHostname = executorHostname;
        this.org$apache$spark$executor$Executor$$env = env;
        this.userClassPath = userClassPath;
        this.org$apache$spark$executor$Executor$$isLocal = isLocal;
        Logging$class.$init$(this);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Executor $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting executor ID ", " on host ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$executor$Executor$$executorId, this.$outer.org$apache$spark$executor$Executor$$executorHostname}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$spark$executor$Executor$$currentFiles = new HashMap();
        this.org$apache$spark$executor$Executor$$currentJars = new HashMap();
        this.org$apache$spark$executor$Executor$$EMPTY_BYTE_BUFFER = ByteBuffer.wrap(new byte[0]);
        this.org$apache$spark$executor$Executor$$conf = env.conf();
        Utils$.MODULE$.checkHost(executorHostname, "Expected executed slave to be a hostname");
        Predef$.MODULE$.assert(0 == Utils$.MODULE$.parseHostPort(executorHostname)._2$mcI$sp());
        Utils$.MODULE$.setCustomHostname(executorHostname);
        if (!isLocal) {
            Thread.setDefaultUncaughtExceptionHandler(SparkUncaughtExceptionHandler$.MODULE$);
        }
        this.threadPool = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("Executor task launch worker");
        this.executorSource = new ExecutorSource(this.threadPool(), executorId);
        if (!isLocal) {
            env.metricsSystem().registerSource(this.executorSource());
            env.blockManager().initialize(this.org$apache$spark$executor$Executor$$conf().getAppId());
        }
        this.executorEndpoint = env.rpcEnv().setupEndpoint(ExecutorEndpoint$.MODULE$.EXECUTOR_ENDPOINT_NAME(), new ExecutorEndpoint(env.rpcEnv(), executorId));
        this.userClassPathFirst = this.org$apache$spark$executor$Executor$$conf().getBoolean("spark.executor.userClassPathFirst", false);
        this.org$apache$spark$executor$Executor$$urlClassLoader = this.createClassLoader();
        this.org$apache$spark$executor$Executor$$replClassLoader = this.addReplClassLoaderIfNeeded(this.org$apache$spark$executor$Executor$$urlClassLoader());
        env.serializer().setDefaultClassLoader(this.org$apache$spark$executor$Executor$$replClassLoader());
        this.org$apache$spark$executor$Executor$$akkaFrameSize = AkkaUtils$.MODULE$.maxFrameSizeBytes(this.org$apache$spark$executor$Executor$$conf());
        this.org$apache$spark$executor$Executor$$maxResultSize = Utils$.MODULE$.getMaxResultSize(this.org$apache$spark$executor$Executor$$conf());
        this.org$apache$spark$executor$Executor$$runningTasks = new ConcurrentHashMap();
        this.heartbeater = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("driver-heartbeater");
        this.startDriverHeartbeater();
        this.heartbeatReceiverRef = RpcUtils$.MODULE$.makeDriverRef(HeartbeatReceiver$.MODULE$.ENDPOINT_NAME(), this.org$apache$spark$executor$Executor$$conf(), env.rpcEnv());
    }

    public class TaskRunner
    implements Runnable {
        private final ExecutorBackend execBackend;
        private final long taskId;
        private final int attemptNumber;
        public final String org$apache$spark$executor$Executor$TaskRunner$$taskName;
        private final ByteBuffer serializedTask;
        private volatile boolean killed;
        private volatile long startGCTime;
        private volatile Task<Object> task;
        public final /* synthetic */ Executor $outer;

        public long taskId() {
            return this.taskId;
        }

        public int attemptNumber() {
            return this.attemptNumber;
        }

        private boolean killed() {
            return this.killed;
        }

        private void killed_$eq(boolean x$1) {
            this.killed = x$1;
        }

        public long startGCTime() {
            return this.startGCTime;
        }

        public void startGCTime_$eq(long x$1) {
            this.startGCTime = x$1;
        }

        public Task<Object> task() {
            return this.task;
        }

        public void task_$eq(Task<Object> x$1) {
            this.task = x$1;
        }

        public void kill(boolean interruptThread) {
            this.org$apache$spark$executor$Executor$TaskRunner$$$outer().logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TaskRunner $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executor is trying to kill ", " (TID ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$executor$Executor$TaskRunner$$taskName, BoxesRunTime.boxToLong((long)this.$outer.taskId())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.killed_$eq(true);
            if (this.task() != null) {
                this.task().kill(interruptThread);
            }
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Throwable throwable3;
            block28: {
                Tuple2<Object, scala.collection.immutable.Map<Object, Object>> tuple2;
                LongRef taskStart;
                SerializerInstance ser;
                TaskMemoryManager taskMemoryManager;
                block27: {
                    ByteBuffer byteBuffer;
                    Tuple2 tuple22;
                    Tuple2<Object, scala.collection.immutable.Map<Object, Object>> tuple23;
                    long deserializeStartTime;
                    block26: {
                        Tuple3 tuple3;
                        taskMemoryManager = new TaskMemoryManager(this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$env.memoryManager(), this.taskId());
                        deserializeStartTime = System.currentTimeMillis();
                        Thread.currentThread().setContextClassLoader(this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$replClassLoader());
                        ser = this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$env.closureSerializer().newInstance();
                        this.org$apache$spark$executor$Executor$TaskRunner$$$outer().logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ TaskRunner $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running ", " (TID ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$executor$Executor$TaskRunner$$taskName, BoxesRunTime.boxToLong((long)this.$outer.taskId())}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.execBackend.statusUpdate(this.taskId(), TaskState$.MODULE$.RUNNING(), this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$EMPTY_BYTE_BUFFER());
                        taskStart = new LongRef(0L);
                        this.startGCTime_$eq(this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$computeTotalGcTime());
                        Tuple3<HashMap<String, Object>, HashMap<String, Object>, ByteBuffer> tuple32 = Task$.MODULE$.deserializeWithDependencies(this.serializedTask);
                        if (tuple32 == null) throw new MatchError(tuple32);
                        HashMap taskFiles = (HashMap)tuple32._1();
                        HashMap taskJars = (HashMap)tuple32._2();
                        ByteBuffer taskBytes = (ByteBuffer)tuple32._3();
                        Tuple3 tuple33 = tuple3 = new Tuple3((Object)taskFiles, (Object)taskJars, (Object)taskBytes);
                        HashMap taskFiles2 = (HashMap)tuple33._1();
                        HashMap taskJars2 = (HashMap)tuple33._2();
                        ByteBuffer taskBytes2 = (ByteBuffer)tuple33._3();
                        this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$updateDependencies((HashMap<String, Object>)taskFiles2, (HashMap<String, Object>)taskJars2);
                        this.task_$eq((Task)ser.deserialize(taskBytes2, Thread.currentThread().getContextClassLoader(), ClassTag$.MODULE$.apply(Task.class)));
                        this.task().setTaskMemoryManager(taskMemoryManager);
                        if (this.killed()) {
                            throw new TaskKilledException();
                        }
                        this.org$apache$spark$executor$Executor$TaskRunner$$$outer().logDebug((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ TaskRunner $outer;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Task ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.taskId())).append((Object)"'s epoch is ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.task().epoch())).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$env.mapOutputTracker().updateEpoch(this.task().epoch());
                        taskStart.elem = System.currentTimeMillis();
                        boolean threwException = true;
                        Tuple2<Object, scala.collection.immutable.Map<Object, Object>> res = this.task().run(this.taskId(), this.attemptNumber(), this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$env.metricsSystem());
                        threwException = false;
                        tuple23 = res;
                        long freedMemory = taskMemoryManager.cleanUpAllAllocatedMemory();
                        if (freedMemory <= 0L) break block26;
                        String errMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Managed memory leak detected; size = ", " bytes, TID = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)freedMemory), BoxesRunTime.boxToLong((long)this.taskId())}));
                        if (this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$conf().getBoolean("spark.unsafe.exceptionOnMemoryLeak", false) && !threwException) {
                            throw new SparkException(errMsg);
                        }
                        this.org$apache$spark$executor$Executor$TaskRunner$$$outer().logError((Function0<String>)new TaskRunner$$anonfun$3(this, errMsg));
                    }
                    if ((tuple2 = tuple23) == null) break block27;
                    Object value = tuple2._1();
                    scala.collection.immutable.Map accumUpdates = (scala.collection.immutable.Map)tuple2._2();
                    Tuple2 tuple24 = tuple22 = new Tuple2(value, (Object)accumUpdates);
                    Object value2 = tuple24._1();
                    scala.collection.immutable.Map accumUpdates2 = (scala.collection.immutable.Map)tuple24._2();
                    long taskFinish = System.currentTimeMillis();
                    if (this.task().killed()) {
                        throw new TaskKilledException();
                    }
                    SerializerInstance resultSer = this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$env.serializer().newInstance();
                    long beforeSerialization = System.currentTimeMillis();
                    ByteBuffer valueBytes = resultSer.serialize(value2, ClassTag$.MODULE$.Any());
                    long afterSerialization = System.currentTimeMillis();
                    this.task().metrics().foreach((Function1)new Serializable(this, deserializeStartTime, taskStart, taskFinish, beforeSerialization, afterSerialization){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ TaskRunner $outer;
                        private final long deserializeStartTime$1;
                        private final LongRef taskStart$1;
                        private final long taskFinish$1;
                        private final long beforeSerialization$1;
                        private final long afterSerialization$1;

                        public final void apply(TaskMetrics m) {
                            m.setExecutorDeserializeTime(this.taskStart$1.elem - this.deserializeStartTime$1 + this.$outer.task().executorDeserializeTime());
                            m.setExecutorRunTime(this.taskFinish$1 - this.taskStart$1.elem - this.$outer.task().executorDeserializeTime());
                            m.setJvmGCTime(this.$outer.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$computeTotalGcTime() - this.$outer.startGCTime());
                            m.setResultSerializationTime(this.afterSerialization$1 - this.beforeSerialization$1);
                            m.updateAccumulators();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.deserializeStartTime$1 = deserializeStartTime$1;
                            this.taskStart$1 = taskStart$1;
                            this.taskFinish$1 = taskFinish$1;
                            this.beforeSerialization$1 = beforeSerialization$1;
                            this.afterSerialization$1 = afterSerialization$1;
                        }
                    });
                    DirectTaskResult directResult = new DirectTaskResult(valueBytes, (Map<Object, Object>)accumUpdates2, (TaskMetrics)this.task().metrics().orNull(Predef$.MODULE$.conforms()));
                    ByteBuffer serializedDirectResult = ser.serialize(directResult, ClassTag$.MODULE$.apply(DirectTaskResult.class));
                    int resultSize = serializedDirectResult.limit();
                    if (this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$maxResultSize() > 0L && (long)resultSize > this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$maxResultSize()) {
                        this.org$apache$spark$executor$Executor$TaskRunner$$$outer().logWarning((Function0<String>)new Serializable(this, resultSize){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ TaskRunner $outer;
                            private final int resultSize$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished ", " (TID ", "). Result is larger than maxResultSize "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$executor$Executor$TaskRunner$$taskName, BoxesRunTime.boxToLong((long)this.$outer.taskId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " > ", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.resultSize$1), Utils$.MODULE$.bytesToString(this.$outer.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$maxResultSize())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dropping it."})).s((Seq)Nil$.MODULE$)).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.resultSize$1 = resultSize$1;
                            }
                        });
                        byteBuffer = ser.serialize(new IndirectTaskResult(new TaskResultBlockId(this.taskId()), resultSize), ClassTag$.MODULE$.apply(IndirectTaskResult.class));
                    } else if (resultSize >= this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$akkaFrameSize() - AkkaUtils$.MODULE$.reservedSizeBytes()) {
                        TaskResultBlockId blockId = new TaskResultBlockId(this.taskId());
                        this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$env.blockManager().putBytes(blockId, serializedDirectResult, StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$env.blockManager().putBytes$default$4(), this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$env.blockManager().putBytes$default$5());
                        this.org$apache$spark$executor$Executor$TaskRunner$$$outer().logInfo((Function0<String>)new Serializable(this, resultSize){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ TaskRunner $outer;
                            private final int resultSize$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished ", " (TID ", "). ", " bytes result sent via BlockManager)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$executor$Executor$TaskRunner$$taskName, BoxesRunTime.boxToLong((long)this.$outer.taskId()), BoxesRunTime.boxToInteger((int)this.resultSize$1)}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.resultSize$1 = resultSize$1;
                            }
                        });
                        byteBuffer = ser.serialize(new IndirectTaskResult(blockId, resultSize), ClassTag$.MODULE$.apply(IndirectTaskResult.class));
                    } else {
                        this.org$apache$spark$executor$Executor$TaskRunner$$$outer().logInfo((Function0<String>)new Serializable(this, resultSize){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ TaskRunner $outer;
                            private final int resultSize$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished ", " (TID ", "). ", " bytes result sent to driver"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$executor$Executor$TaskRunner$$taskName, BoxesRunTime.boxToLong((long)this.$outer.taskId()), BoxesRunTime.boxToInteger((int)this.resultSize$1)}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.resultSize$1 = resultSize$1;
                            }
                        });
                        byteBuffer = serializedDirectResult;
                    }
                    ByteBuffer serializedResult = byteBuffer;
                    this.execBackend.statusUpdate(this.taskId(), TaskState$.MODULE$.FINISHED(), serializedResult);
                    this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$runningTasks().remove(BoxesRunTime.boxToLong((long)this.taskId()));
                    return;
                }
                try {
                    throw new MatchError(tuple2);
                    {
                        catch (Throwable throwable2) {
                            void var27_14;
                            long freedMemory = taskMemoryManager.cleanUpAllAllocatedMemory();
                            if (freedMemory <= 0L) throw throwable2;
                            String errMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Managed memory leak detected; size = ", " bytes, TID = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)freedMemory), BoxesRunTime.boxToLong((long)this.taskId())}));
                            if (this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$conf().getBoolean("spark.unsafe.exceptionOnMemoryLeak", false) && var27_14 == false) {
                                throw new SparkException(errMsg);
                            }
                            this.org$apache$spark$executor$Executor$TaskRunner$$$outer().logError((Function0<String>)new TaskRunner$$anonfun$3(this, errMsg));
                            throw throwable2;
                        }
                    }
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    if (throwable4 instanceof FetchFailedException) {
                        FetchFailedException fetchFailedException = (FetchFailedException)throwable4;
                        TaskEndReason reason = fetchFailedException.toTaskEndReason();
                        this.execBackend.statusUpdate(this.taskId(), TaskState$.MODULE$.FAILED(), ser.serialize(reason, ClassTag$.MODULE$.apply(TaskEndReason.class)));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boolean bl = throwable4 instanceof TaskKilledException ? true : throwable4 instanceof InterruptedException;
                        if (bl && this.task().killed()) {
                            this.org$apache$spark$executor$Executor$TaskRunner$$$outer().logInfo((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ TaskRunner $outer;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executor killed ", " (TID ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$executor$Executor$TaskRunner$$taskName, BoxesRunTime.boxToLong((long)this.$outer.taskId())}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            this.execBackend.statusUpdate(this.taskId(), TaskState$.MODULE$.KILLED(), ser.serialize(TaskKilled$.MODULE$, ClassTag$.MODULE$.apply(TaskKilled$.class)));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (throwable4 instanceof CommitDeniedException) {
                            CommitDeniedException commitDeniedException = (CommitDeniedException)throwable4;
                            TaskEndReason reason = commitDeniedException.toTaskEndReason();
                            this.execBackend.statusUpdate(this.taskId(), TaskState$.MODULE$.FAILED(), ser.serialize(reason, ClassTag$.MODULE$.apply(TaskEndReason.class)));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit;
                            ByteBuffer byteBuffer;
                            if (throwable4 == null) break block28;
                            Throwable throwable5 = throwable4;
                            this.org$apache$spark$executor$Executor$TaskRunner$$$outer().logError((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ TaskRunner $outer;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception in ", " (TID ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$executor$Executor$TaskRunner$$taskName, BoxesRunTime.boxToLong((long)this.$outer.taskId())}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }, throwable5);
                            Option metrics = Option$.MODULE$.apply(this.task()).flatMap((Function1)new Serializable(this, taskStart){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ TaskRunner $outer;
                                public final LongRef taskStart$1;

                                public final Option<TaskMetrics> apply(Task<Object> task) {
                                    return task.metrics().map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ TaskRunner$$anonfun$7 $outer;

                                        public final TaskMetrics apply(TaskMetrics m) {
                                            m.setExecutorRunTime(System.currentTimeMillis() - this.$outer.taskStart$1.elem);
                                            m.setJvmGCTime(this.$outer.org$apache$spark$executor$Executor$TaskRunner$$anonfun$$$outer().org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$computeTotalGcTime() - this.$outer.org$apache$spark$executor$Executor$TaskRunner$$anonfun$$$outer().startGCTime());
                                            m.updateAccumulators();
                                            return m;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ TaskRunner org$apache$spark$executor$Executor$TaskRunner$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.taskStart$1 = taskStart$1;
                                }
                            });
                            try {
                                byteBuffer = ser.serialize(new ExceptionFailure(throwable5, (Option<TaskMetrics>)metrics), ClassTag$.MODULE$.apply(ExceptionFailure.class));
                            }
                            catch (NotSerializableException notSerializableException) {
                                byteBuffer = ser.serialize(new ExceptionFailure(throwable5, (Option<TaskMetrics>)metrics, false), ClassTag$.MODULE$.apply(ExceptionFailure.class));
                            }
                            ByteBuffer serializedTaskEndReason = byteBuffer;
                            this.execBackend.statusUpdate(this.taskId(), TaskState$.MODULE$.FAILED(), serializedTaskEndReason);
                            if (Utils$.MODULE$.isFatalError(throwable5)) {
                                SparkUncaughtExceptionHandler$.MODULE$.uncaughtException(throwable5);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                        }
                    }
                    this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$runningTasks().remove(BoxesRunTime.boxToLong((long)this.taskId()));
                }
                return;
            }
            try {
                throw throwable3;
            }
            catch (Throwable throwable6) {
                this.org$apache$spark$executor$Executor$TaskRunner$$$outer().org$apache$spark$executor$Executor$$runningTasks().remove(BoxesRunTime.boxToLong((long)this.taskId()));
                throw throwable6;
            }
        }

        public /* synthetic */ Executor org$apache$spark$executor$Executor$TaskRunner$$$outer() {
            return this.$outer;
        }

        public TaskRunner(Executor $outer, ExecutorBackend execBackend, long taskId, int attemptNumber, String taskName, ByteBuffer serializedTask) {
            this.execBackend = execBackend;
            this.taskId = taskId;
            this.attemptNumber = attemptNumber;
            this.org$apache$spark$executor$Executor$TaskRunner$$taskName = taskName;
            this.serializedTask = serializedTask;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.killed = false;
        }
    }
}

